/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.chat;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;

public final class ChatFormatter {
    private static final String DEFAULT_SCHEME = "http://";
    private static final String SCHEME = "https?://";
    private static final String IP_ADDRESS = "(?:\\d{1,3}\\.){3}\\d{1,3}";
    private static final String DOMAIN = "(?:[a-z\\d](?:[a-z\\d-]*[a-z\\d])?\\.)+[a-z](?:[a-z\\d-]*[a-z\\d])?";
    private static final String PORT = "\\d{1,5}";
    private static final String PATH = ".*?";
    private static final Pattern URL_PATTERN = Pattern.compile("(?:https?://)?(?:(?:\\d{1,3}\\.){3}\\d{1,3}|(?:[a-z\\d](?:[a-z\\d-]*[a-z\\d])?\\.)+[a-z](?:[a-z\\d-]*[a-z\\d])?)(?::\\d{1,5})?.*?(?=[!?,;:\"']?(?:[\u00a7\\s]|$))", 2);

    private ChatFormatter() {
    }

    public static void formatChatComponent(TextComponentTranslation component) {
        String message = (String)component.func_150271_j()[1];
        ITextComponent formatted = ChatFormatter.format(message);
        if (formatted == null) {
            return;
        }
        formatted.func_150256_b().func_150221_a(component.func_150256_b());
        component.func_150271_j()[1] = formatted;
    }

    @Nullable
    public static ITextComponent format(String s) {
        Matcher matcher = URL_PATTERN.matcher(s);
        if (!matcher.find()) {
            return null;
        }
        TextComponentString result = null;
        int pos = 0;
        do {
            String url;
            String displayUrl;
            int end;
            int start;
            block11: {
                start = matcher.start();
                end = matcher.end();
                url = displayUrl = s.substring(start, end);
                try {
                    if (new URI(url).getScheme() != null) break block11;
                    url = DEFAULT_SCHEME + url;
                }
                catch (URISyntaxException e) {
                    continue;
                }
            }
            if (pos < start) {
                if (result == null) {
                    result = new TextComponentString(s.substring(pos, start));
                } else {
                    result.func_150258_a(s.substring(pos, start));
                }
            }
            pos = end;
            TextComponentString link = new TextComponentString(displayUrl);
            link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            if (result == null) {
                result = new TextComponentString("");
            }
            result.func_150257_a((ITextComponent)link);
        } while (matcher.find());
        if (pos < s.length()) {
            if (result == null) {
                result = new TextComponentString(s.substring(pos));
            } else {
                result.func_150258_a(s.substring(pos));
            }
        }
        return result;
    }
}

