/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.extent;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.BiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.gen.ByteArrayMutableBiomeBuffer;
import org.spongepowered.common.world.extent.ExtentBufferUtil;
import org.spongepowered.common.world.schematic.GlobalPalette;

public abstract class AbstractBiomeViewDownsize<V extends BiomeVolume>
implements BiomeVolume {
    protected final V volume;
    protected final Vector3i min;
    protected final Vector3i max;
    protected final Vector3i size;

    public AbstractBiomeViewDownsize(V volume, Vector3i min, Vector3i max) {
        Preconditions.checkArgument((min.getY() == 0 ? 1 : 0) != 0, (Object)"Min y coordinate should be 0");
        Preconditions.checkArgument((max.getY() == 0 ? 1 : 0) != 0, (Object)"Max y coordinate should be 0");
        this.volume = volume;
        this.min = min;
        this.max = max;
        this.size = max.sub(min).add(Vector3i.ONE);
    }

    @Override
    public Vector3i getBiomeMin() {
        return this.min;
    }

    @Override
    public Vector3i getBiomeMax() {
        return this.max;
    }

    @Override
    public Vector3i getBiomeSize() {
        return this.size;
    }

    @Override
    public boolean containsBiome(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.min, this.max);
    }

    protected final void checkRange(int x, int y, int z) {
        if (!VecHelper.inBounds(x, y, z, this.min, this.max)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), this.min, this.max);
        }
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.volume.getBiome(x, y, z);
    }

    @Override
    public MutableBiomeVolume getBiomeCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ByteArrayMutableBiomeBuffer(GlobalPalette.getBiomePalette(), ExtentBufferUtil.copyToArray(this, this.min, this.max, this.size), this.min, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }
}

