/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.custom;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.InventoryCapacity;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.RealLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;

public class CustomLens
extends RealLens {
    private InventoryArchetype archetype;
    private Map<String, InventoryProperty<?, ?>> properties;

    public CustomLens(int size, Class<? extends Inventory> adapter, SlotProvider slots, InventoryArchetype archetype, Map<String, InventoryProperty<?, ?>> properties) {
        super(0, size, adapter);
        this.archetype = archetype;
        this.properties = properties;
        this.init(slots);
    }

    protected void init(SlotProvider slots) {
        InventoryProperty<?, ?> size = this.properties.get(CustomInventory.INVENTORY_DIMENSION);
        if (size == null) {
            size = this.properties.get(CustomInventory.INVENTORY_CAPACITY);
        }
        if (size != null) {
            this.addLensFor(size, 0, slots);
        } else {
            this.addLensFor(this.archetype, 0, slots);
        }
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            ++slot;
        }
    }

    private int addLensFor(InventoryArchetype archetype, int base, SlotProvider slots) {
        Optional<InventoryProperty<String, ?>> size = archetype.getProperty(CustomInventory.INVENTORY_DIMENSION);
        if (!size.isPresent()) {
            size = archetype.getProperty(CustomInventory.INVENTORY_CAPACITY);
        }
        if (size.isPresent()) {
            return this.addLensFor(size.get(), base, slots);
        }
        int slotCount = 0;
        List<InventoryArchetype> childs = archetype.getChildArchetypes();
        if (childs.isEmpty()) {
            throw new IllegalArgumentException("Missing dimensions!");
        }
        for (InventoryArchetype child : childs) {
            slotCount += this.addLensFor(child, base + slotCount, slots);
        }
        return slotCount;
    }

    private int addLensFor(InventoryProperty<?, ?> size, int base, SlotProvider slots) {
        OrderedInventoryLensImpl lens;
        int slotCount;
        if (size instanceof InventoryDimension) {
            InventoryDimension dimension = (InventoryDimension)size;
            slotCount = dimension.getColumns() * dimension.getRows();
            lens = new GridInventoryLensImpl(base, dimension.getColumns(), dimension.getRows(), slots);
        } else if (size instanceof InventoryCapacity) {
            InventoryCapacity capacity = (InventoryCapacity)size;
            slotCount = (Integer)capacity.getValue();
            lens = new OrderedInventoryLensImpl(base, (int)((Integer)capacity.getValue()), slots);
        } else {
            throw new IllegalStateException("Unknown Inventory Size Property " + size.getClass().getName());
        }
        this.addSpanningChild(lens, new InventoryProperty[0]);
        return slotCount;
    }
}

