/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.tileentity;

import java.util.Optional;
import net.minecraft.world.IWorldNameable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.CustomNameableBridge;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.text.SpongeTexts;

public class TileEntityDisplayNameValueProcessor
extends AbstractSpongeValueProcessor<IWorldNameable, Text, Value<Text>> {
    public TileEntityDisplayNameValueProcessor() {
        super(IWorldNameable.class, Keys.DISPLAY_NAME);
    }

    @Override
    protected Value<Text> constructValue(Text defaultValue) {
        return new SpongeValue<Text>(Keys.DISPLAY_NAME, Text.of(), defaultValue);
    }

    @Override
    protected boolean set(IWorldNameable container, Text value) {
        if (container instanceof CustomNameableBridge) {
            String legacy = SpongeTexts.toLegacy(value);
            try {
                ((CustomNameableBridge)container).bridge$setCustomDisplayName(legacy);
            }
            catch (Exception e) {
                SpongeImpl.getLogger().error("There was an issue trying to replace the display name of an tile entity!", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    protected Optional<Text> getVal(IWorldNameable container) {
        if (container.func_145818_k_()) {
            return Optional.of(SpongeTexts.fromLegacy(container.func_70005_c_()));
        }
        return Optional.empty();
    }

    @Override
    protected ImmutableValue<Text> constructImmutableValue(Text value) {
        return new ImmutableSpongeValue<Text>(Keys.DISPLAY_NAME, Text.of(), value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

