/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableInvulnerabilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvulnerabilityData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeInvulnerabilityData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeInvulnerabilityData
extends AbstractData<InvulnerabilityData, ImmutableInvulnerabilityData>
implements InvulnerabilityData {
    private int invulnerabilityTicks;
    private boolean invulnerable;

    public SpongeInvulnerabilityData() {
        this(0, false);
    }

    public SpongeInvulnerabilityData(int invulnerabilityTicks, boolean invulnerable) {
        super(InvulnerabilityData.class);
        this.invulnerabilityTicks = invulnerabilityTicks;
        this.invulnerable = invulnerable;
        this.registerGettersAndSetters();
    }

    @Override
    public MutableBoundedValue<Integer> invulnerableTicks() {
        return SpongeValueFactory.boundedBuilder(Keys.INVULNERABILITY_TICKS).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(this.invulnerabilityTicks).build();
    }

    @Override
    public Value<Boolean> invulnerable() {
        return new SpongeValue<Boolean>(Keys.INVULNERABLE, false, this.invulnerable);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.INVULNERABILITY_TICKS, () -> this.invulnerabilityTicks);
        this.registerFieldSetter(Keys.INVULNERABILITY_TICKS, invulnerabilityTicks -> {
            this.invulnerabilityTicks = invulnerabilityTicks;
        });
        this.registerKeyValue(Keys.INVULNERABILITY_TICKS, this::invulnerableTicks);
        this.registerFieldGetter(Keys.INVULNERABLE, () -> this.invulnerable);
        this.registerFieldSetter(Keys.INVULNERABLE, invulnerable -> {
            this.invulnerable = invulnerable;
        });
        this.registerKeyValue(Keys.INVULNERABLE, this::invulnerable);
    }

    @Override
    public InvulnerabilityData copy() {
        return new SpongeInvulnerabilityData(this.invulnerabilityTicks, this.invulnerable);
    }

    @Override
    public ImmutableInvulnerabilityData asImmutable() {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeInvulnerabilityData.class, this.invulnerabilityTicks, this.invulnerable);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.INVULNERABILITY_TICKS, (Object)this.invulnerabilityTicks).set(Keys.INVULNERABLE, (Object)this.invulnerable);
    }
}

