/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.command.ICommandSender;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.command.MinecraftCommandWrapper;

public final class CommandPermissions {
    private static final String COMMAND_BLOCK_COMMAND = "";
    private static final String COMMAND_BLOCK_PERMISSION = "minecraft.commandblock";
    private static final int COMMAND_BLOCK_LEVEL = 2;
    private static final String SELECTOR_COMMAND = "@";
    private static final String SELECTOR_PERMISSION = "minecraft.selector";
    private static final int SELECTOR_LEVEL = 2;
    private static final String SPONGE_HELP_COMMAND = "sponge:help";
    static final String SPONGE_HELP_PERMISSION = "sponge.command.help";
    private static final int SPONGE_HELP_LEVEL = 0;

    private CommandPermissions() {
    }

    public static boolean testPermission(CommandSource source, String commandName) {
        if (commandName.equals(SELECTOR_COMMAND)) {
            return source.hasPermission(SELECTOR_PERMISSION);
        }
        if (commandName.equals(COMMAND_BLOCK_COMMAND)) {
            return source.hasPermission(COMMAND_BLOCK_PERMISSION);
        }
        Optional<? extends CommandMapping> mapping = SpongeImpl.getGame().getCommandManager().get(commandName);
        if (mapping.isPresent()) {
            CommandCallable callable = mapping.get().getCallable();
            if (callable instanceof MinecraftCommandWrapper) {
                return source.hasPermission(((MinecraftCommandWrapper)callable).getCommandPermission());
            }
            return callable.testPermission(source);
        }
        return source.hasPermission(commandName);
    }

    public static void populateNonCommandPermissions(SubjectData data, BiFunction<Integer, String, Boolean> testPermission) {
        if (testPermission.apply(2, COMMAND_BLOCK_COMMAND).booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, COMMAND_BLOCK_PERMISSION, Tristate.TRUE);
        }
        if (testPermission.apply(2, SELECTOR_COMMAND).booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, SELECTOR_PERMISSION, Tristate.TRUE);
        }
        if (testPermission.apply(0, SPONGE_HELP_COMMAND).booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, SPONGE_HELP_PERMISSION, Tristate.TRUE);
        }
        if (testPermission.apply(1, "minecraft.login.bypass-whitelist").booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.login.bypass-whitelist", Tristate.TRUE);
        }
    }

    public static void populateMinecraftPermissions(ICommandSender sender, MemorySubjectData data) {
        CommandPermissions.populateNonCommandPermissions(data, (arg_0, arg_1) -> ((ICommandSender)sender).func_70003_b(arg_0, arg_1));
        for (CommandMapping commandMapping : SpongeImpl.getGame().getCommandManager().getCommands()) {
            if (!(commandMapping.getCallable() instanceof MinecraftCommandWrapper)) continue;
            MinecraftCommandWrapper wrapper = (MinecraftCommandWrapper)commandMapping.getCallable();
            data.setPermission(SubjectData.GLOBAL_CONTEXT, wrapper.getCommandPermission(), Tristate.fromBoolean(wrapper.command.func_184882_a(sender.func_184102_h(), sender)));
        }
    }
}

