/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.flowpowered.math.vector.Vector3d;
import org.spongepowered.api.util.AxisDirection;
import org.spongepowered.api.util.Cycleable;

public enum Axis implements Cycleable<Axis>
{
    X(new Vector3d(1.0f, 0.0f, 0.0f)),
    Y(new Vector3d(0.0f, 1.0f, 0.0f)),
    Z(new Vector3d(0.0f, 0.0f, 1.0f));

    private final Vector3d direction;

    private Axis(Vector3d vector3d) {
        this.direction = vector3d;
    }

    public static Axis getClosest(Vector3d vector) {
        double x = Math.abs(vector.getX());
        double y = Math.abs(vector.getY());
        double z = Math.abs(vector.getZ());
        if (x < y) {
            if (z < y) {
                return Y;
            }
            return Z;
        }
        if (x < z) {
            return Z;
        }
        return X;
    }

    public boolean isVectorAlongAxis(Vector3d vector) {
        return vector.abs().normalize().sub(this.direction).lengthSquared() == 0.0;
    }

    public double getComponent(Vector3d vector3d) {
        switch (this) {
            case X: {
                return this.direction.getX();
            }
            case Y: {
                return this.direction.getY();
            }
            case Z: {
                return this.direction.getZ();
            }
        }
        throw new IllegalStateException("Not capable of handling the " + this.name() + " axis!");
    }

    public AxisDirection getDirection(Vector3d vector3d) {
        double component = this.getComponent(vector3d);
        if (component > 0.0) {
            return AxisDirection.PLUS;
        }
        if (component == 0.0) {
            return AxisDirection.ZERO;
        }
        return AxisDirection.MINUS;
    }

    public Vector3d toVector3d() {
        return this.direction;
    }

    public Vector3d toVector3dWithDirection(AxisDirection axisDirection) {
        return this.direction.mul(axisDirection.getSignum());
    }

    @Override
    public Axis cycleNext() {
        if (this == X) {
            return Y;
        }
        if (this == Y) {
            return Z;
        }
        return X;
    }
}

