/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spongepowered.api.text.transform.PartitionedTextFormatter;
import org.spongepowered.api.text.transform.SimpleTextFormatter;

public class DynamicPartitionedTextFormatter
implements PartitionedTextFormatter<SimpleTextFormatter> {
    protected final List<SimpleTextFormatter> partitions;

    public DynamicPartitionedTextFormatter(int initialSize) {
        Preconditions.checkArgument((initialSize >= 0 ? 1 : 0) != 0, (Object)"initial size must be greater than or equal to zero");
        this.partitions = new ArrayList<SimpleTextFormatter>(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            this.partitions.add(new SimpleTextFormatter());
        }
    }

    public DynamicPartitionedTextFormatter() {
        this(0);
    }

    @Override
    public ImmutableList<SimpleTextFormatter> getAll() {
        return ImmutableList.copyOf(this.partitions);
    }

    @Override
    public SimpleTextFormatter get(int i) {
        return this.partitions.get(i);
    }

    @Override
    public SimpleTextFormatter set(int i, SimpleTextFormatter element) {
        return this.partitions.set(i, element);
    }

    @Override
    public int size() {
        return this.partitions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.partitions.isEmpty();
    }

    @Override
    public boolean contains(SimpleTextFormatter element) {
        return this.partitions.contains(element);
    }

    @Override
    public void clear() {
        this.partitions.clear();
    }

    @Override
    public boolean add(SimpleTextFormatter element) {
        return this.partitions.add(element);
    }

    @Override
    public boolean add(Collection<SimpleTextFormatter> elements) {
        return this.partitions.addAll(elements);
    }

    @Override
    public void insert(int i, SimpleTextFormatter element) {
        this.partitions.add(i, element);
    }

    @Override
    public void insert(int i, Collection<SimpleTextFormatter> elements) {
        this.partitions.addAll(i, elements);
    }

    @Override
    public boolean remove(SimpleTextFormatter element) {
        return this.partitions.remove(element);
    }

    @Override
    public boolean remove(Collection<SimpleTextFormatter> elements) {
        return this.partitions.removeAll(elements);
    }

    @Override
    public boolean retain(Collection<SimpleTextFormatter> elements) {
        return this.partitions.retainAll(elements);
    }
}

