"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.views = self.__class__.views(path + ["views"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        super().__init__(path, service)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)

    class mesh(TUIMenu):
        """
        Enter the mesh menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.surface_mesh = self.__class__.surface_mesh(path + ["surface_mesh"], service)
            self.adapt = self.__class__.adapt(path + ["adapt"], service)
            self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
            self.polyhedra = self.__class__.polyhedra(path + ["polyhedra"], service)
            self.geometry = self.__class__.geometry(path + ["geometry"], service)
            self.repair_improve = self.__class__.repair_improve(path + ["repair_improve"], service)
            self.reorder = self.__class__.reorder(path + ["reorder"], service)
            super().__init__(path, service)
        def set_unit_system(self, *args, **kwargs):
            """
            To apply standard set of units to all quantities.
            """
            return PyMenu(self.service, "/mesh/set_unit_system").execute(*args, **kwargs)
        def translate(self, *args, **kwargs):
            """
            Prompts for the translation offset in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/translate").execute(*args, **kwargs)
        def show_periodic_shadow_zones(self, *args, **kwargs):
            """
            Option to show periodic shadow zones in user interface.
            """
            return PyMenu(self.service, "/mesh/show_periodic_shadow_zones").execute(*args, **kwargs)
        def replace(self, *args, **kwargs):
            """
            Replace mesh and interpolate data.
            """
            return PyMenu(self.service, "/mesh/replace").execute(*args, **kwargs)
        def adjacency(self, *args, **kwargs):
            """
            Views and renames face zones adjacent to selected cell  zones.
            """
            return PyMenu(self.service, "/mesh/adjacency").execute(*args, **kwargs)
        def mesh_info(self, *args, **kwargs):
            """
            Prints zone information size.
            """
            return PyMenu(self.service, "/mesh/mesh_info").execute(*args, **kwargs)
        def redistribute_boundary_layer(self, *args, **kwargs):
            """
            Redistributes the nodes in a boundary layer zone to achieve a desired growth rate after anisotropic adaption.
            """
            return PyMenu(self.service, "/mesh/redistribute_boundary_layer").execute(*args, **kwargs)
        def rotate(self, *args, **kwargs):
            """
            Rotates the mesh.
            """
            return PyMenu(self.service, "/mesh/rotate").execute(*args, **kwargs)
        def quality(self, *args, **kwargs):
            """
            Displays information about the quality of the mesh in the console, including the minimum orthogonal quality and the maximum aspect ratio. The level of detail displayed depends on the setting specified for mesh/check-verbosity.
            """
            return PyMenu(self.service, "/mesh/quality").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets the level of details that will be added to the mesh check report generated by mesh/check. A value of 0 (the default) notes when checks are being performed, but does not list them individually. A value of 1 lists the individual checks as they are performed. A value of 2 enables the availability of additional mesh field variables, lists the individual checks as they are performed, and provides additional details (for example, the location of the problem, the affected cells).  The check-verbosity text command can also be used to set the level of detail displayed in the mesh quality report generated by mesh/quality. A value of 0 (the default) or 1 lists the minimum orthogonal quality and the maximum aspect ratio. A value of 2 adds information about the zones that contain the cells with the lowest quality, and additional metrics such as the maximum cell squish index and the minimum expansion ratio.
            """
            return PyMenu(self.service, "/mesh/check_verbosity").execute(*args, **kwargs)
        def check_before_solve(self, *args, **kwargs):
            """
            The default value for mesh/check-before-solve is “no”. If mesh/check-before-solve is set to “yes”, a mesh check operation will be invoked prior to starting solver. If grid check fails, solver will be interrupted, and relevant information will be printed in the Fluent console.
            """
            return PyMenu(self.service, "/mesh/check_before_solve").execute(*args, **kwargs)
        def enhanced_orthogonal_quality(self, *args, **kwargs):
            """
            Enables / disables an enhanced definition when calculating the orthogonal quality. When enabled, the orthogonal quality is defined using a variety quality measures, including: the orthogonality of a face relative to a vector between the face and cell centroids; a metric that detects poor cell shape at a local edge (such as twisting and/or concavity); and the variation of normals between the faces that can be constructed from the cell face. This enhanced definition is optimal for evaluating thin prism cells.
            """
            return PyMenu(self.service, "/mesh/enhanced_orthogonal_quality").execute(*args, **kwargs)
        def smooth_mesh(self, *args, **kwargs):
            """
            Smooths the mesh using quality-based, Laplacian, or skewness methods.
            """
            return PyMenu(self.service, "/mesh/smooth_mesh").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs various mesh consistency checks and displays a report in the console that lists the domain extents, the volume statistics, the face area statistics, and any warnings, as well as details about the various checks and mesh failures (depending on the setting specified for mesh/check-verbosity).
            """
            return PyMenu(self.service, "/mesh/check").execute(*args, **kwargs)
        def scale(self, *args, **kwargs):
            """
            Prompts for the scaling factors in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/scale").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Set unit conversion factors.
            """
            return PyMenu(self.service, "/mesh/units").execute(*args, **kwargs)
        def swap_mesh_faces(self, *args, **kwargs):
            """
            Swaps mesh faces.
            """
            return PyMenu(self.service, "/mesh/swap_mesh_faces").execute(*args, **kwargs)
        def memory_usage(self, *args, **kwargs):
            """
            Reports solver memory use.
            """
            return PyMenu(self.service, "/mesh/memory_usage").execute(*args, **kwargs)
        def size_info(self, *args, **kwargs):
            """
            Prints mesh size.
            """
            return PyMenu(self.service, "/mesh/size_info").execute(*args, **kwargs)

        class surface_mesh(TUIMenu):
            """
            Enters the Surface Mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display(self, *args, **kwargs):
                """
                Displays surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/display").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes surface mesh.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/delete").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                Reads surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/read").execute(*args, **kwargs)

        class adapt(TUIMenu):
            """
            Enters the mesh adaption menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.multi_layer_refinement = self.__class__.multi_layer_refinement(path + ["multi_layer_refinement"], service)
                self.profile = self.__class__.profile(path + ["profile"], service)
                self.geometry = self.__class__.geometry(path + ["geometry"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
                self.manage_criteria = self.__class__.manage_criteria(path + ["manage_criteria"], service)
                super().__init__(path, service)
            def list_adaption_cells(self, *args, **kwargs):
                """
                Prints the number of cells marked for refinement, coarsening, and both to the console.
                """
                return PyMenu(self.service, "/mesh/adapt/list_adaption_cells").execute(*args, **kwargs)
            def display_adaption_cells(self, *args, **kwargs):
                """
                Displays the cells that are marked for adaption in the graphics window.
                """
                return PyMenu(self.service, "/mesh/adapt/display_adaption_cells").execute(*args, **kwargs)
            def manual_coarsening_criteria(self, *args, **kwargs):
                """
                Set expression for manual coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_coarsening_criteria").execute(*args, **kwargs)
            def free_hierarchy(self, *args, **kwargs):
                """
                Deletes the defined adaption hierarchy.
                """
                return PyMenu(self.service, "/mesh/adapt/free_hierarchy").execute(*args, **kwargs)
            def adapt_mesh(self, *args, **kwargs):
                """
                Performs manual adaption on the mesh according to the methods and settings that you specified.
                """
                return PyMenu(self.service, "/mesh/adapt/adapt_mesh").execute(*args, **kwargs)
            def manual_refinement_criteria(self, *args, **kwargs):
                """
                Set expression for manual refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_refinement_criteria").execute(*args, **kwargs)
            def refinement_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/refinement_criteria").execute(*args, **kwargs)
            def anisotropic_adaption(self, *args, **kwargs):
                """
                Applies legacy anisotropic adaption to refine the boundary layers or registers. Cells will be split in the normal direction to the boundary face. Note that this text command is only available for 3D cases that have the adaption method set to hanging node.
                """
                return PyMenu(self.service, "/mesh/adapt/anisotropic_adaption").execute(*args, **kwargs)
            def coarsening_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/coarsening_criteria").execute(*args, **kwargs)

            class multi_layer_refinement(TUIMenu):
                """
                Enter the multiple boundary layer refinement menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def layer_count(self, *args, **kwargs):
                    """
                    Specify the layer count for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/layer_count").execute(*args, **kwargs)
                def boundary_zones(self, *args, **kwargs):
                    """
                    Specify boundary zones for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/boundary_zones").execute(*args, **kwargs)
                def parameters(self, *args, **kwargs):
                    """
                    Specify parameters for multiple boundary layer refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/parameters").execute(*args, **kwargs)
                def refine_mesh(self, *args, **kwargs):
                    """
                    Refine the mesh for multiple boundary layers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/refine_mesh").execute(*args, **kwargs)

            class profile(TUIMenu):
                """
                Enters the profile menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def disable(self, *args, **kwargs):
                    """
                    Disables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/disable").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/enable").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Prints adaption profiling results.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/print").execute(*args, **kwargs)
                def clear(self, *args, **kwargs):
                    """
                    Clears the adaption profiling counters.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/clear").execute(*args, **kwargs)

            class geometry(TUIMenu):
                """
                Enters the geometry menu. Note that this text command menu is not available unless the adaption method is set to hanging node.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reconstruct_geometry(self, *args, **kwargs):
                    """
                    Enables/disables geometry-based adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/reconstruct_geometry").execute(*args, **kwargs)
                def set_geometry_controls(self, *args, **kwargs):
                    """
                    Sets geometry controls for wall zones.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/set_geometry_controls").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def anisotropic_split_ratio(self, *args, **kwargs):
                    """
                    Sets the split ratio for the cells as part of anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_split_ratio").execute(*args, **kwargs)
                def cell_zones(self, *args, **kwargs):
                    """
                    Sets cell zones to be used for marking adaption. An empty list specifies that all zones are considered for adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/cell_zones").execute(*args, **kwargs)
                def minimum_cell_quality(self, *args, **kwargs):
                    """
                    Sets the minimum value allowed for the orthogonal quality of cells during adaption. If your solution diverges, you may find that using a higher minimum quality value resolves the issue. This text command is only available with the PUMA 3D adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_cell_quality").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Allows you set how much information about the adaption is printed to the console.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/verbosity").execute(*args, **kwargs)
                def method(self, *args, **kwargs):
                    """
                    Sets the adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/method").execute(*args, **kwargs)
                def dynamic_adaption(self, *args, **kwargs):
                    """
                    Adapt the mesh during solution.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption").execute(*args, **kwargs)
                def overset_adapt_dead_cells(self, *args, **kwargs):
                    """
                    Enables/disables the adaption of dead cells in overset meshes.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/overset_adapt_dead_cells").execute(*args, **kwargs)
                def encapsulate_children(self, *args, **kwargs):
                    """
                    Encapsulate all children of parent cells on the same partition.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/encapsulate_children").execute(*args, **kwargs)
                def anisotropic_adaption(self, *args, **kwargs):
                    """
                    Enables / disables anisotropic adaption for prismatic cells as part of manual adaption. Note that this text command requires that the adaption method is set to PUMA.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_adaption").execute(*args, **kwargs)
                def minimum_edge_length(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the edge length for cells that are considered for refinement. Even if a cell is marked for refinement, it will not be refined if (for 3D) its volume is less than the cube of this field or (for 2D) its area is less than the square of this field. The default value of zero places no limits on the size of cells that are refined.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_edge_length").execute(*args, **kwargs)
                def additional_refinement_layers(self, *args, **kwargs):
                    """
                    Allows you to specify additional refinement layers (this is an advanced control).
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/additional_refinement_layers").execute(*args, **kwargs)
                def minimum_cell_volume(self, *args, **kwargs):
                    """
                    Set limit on the minimum volume of cells in the mesh.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_cell_volume").execute(*args, **kwargs)
                def anisotropic_boundary_zones(self, *args, **kwargs):
                    """
                    Allows you to select the boundary zones that specify directions for anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_boundary_zones").execute(*args, **kwargs)
                def maximum_refinement_level(self, *args, **kwargs):
                    """
                    Controls the number of levels of refinement used to split cells during the adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                def maximum_cell_count(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the total cell count of the mesh during adaption. Fluent uses this value to determine when to stop marking cells for refinement. A value of zero places no limits on the number of cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_cell_count").execute(*args, **kwargs)
                def dynamic_adaption_frequency(self, *args, **kwargs):
                    """
                    Set frequency for dynamic adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption_frequency").execute(*args, **kwargs)
                def display_settings(self, *args, **kwargs):
                    """
                    Sets the graphics display options for the refinement, coarsening, and common cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/display_settings").execute(*args, **kwargs)

            class cell_registers(TUIMenu):
                """
                Enters the cell registers menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def refine(self, *args, **kwargs):
                    """
                    Refine the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/refine").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/edit").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/add").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Displays a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/display").execute(*args, **kwargs)
                def adapt(self, *args, **kwargs):
                    """
                    Adapt cell register objects.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/adapt").execute(*args, **kwargs)
                def coarsen(self, *args, **kwargs):
                    """
                    Coarsen the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/coarsen").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list_properties").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all of the currently defined cell registers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list").execute(*args, **kwargs)
                def apply_poor_mesh_numerics(self, *args, **kwargs):
                    """
                    Applies poor mesh numerics to the mesh of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/delete").execute(*args, **kwargs)

            class manage_criteria(TUIMenu):
                """
                Enters the manage criteria menu, which provides text commands for managing automatic adaption criteria.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    Lists all the existing automatic adaption criteria.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list_properties").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Adds a new automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/add").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/edit").execute(*args, **kwargs)

        class modify_zones(TUIMenu):
            """
            Enters the zone modification menu. For a description of the items in this menu, see define/boundary-conditions/modify-zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                """
                Change all solid zones motion specification from MRF to solid motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
            def extrude_face_zone_para(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
            def sep_face_zone_region(self, *args, **kwargs):
                """
                Separate a face zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
            def extrude_face_zone_delta(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a list of deltas.
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
            def sep_face_zone_angle(self, *args, **kwargs):
                """
                Separate a face zone based on significant angle.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
            def sep_face_zone_face(self, *args, **kwargs):
                """
                Separate each face in a zone into unique zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
            def activate_cell_zone(self, *args, **kwargs):
                """
                Activate a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/activate_cell_zone").execute(*args, **kwargs)
            def copy_move_cell_zone(self, *args, **kwargs):
                """
                Copy and translate or rotate a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
            def sep_cell_zone_region(self, *args, **kwargs):
                """
                Separate a cell zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
            def append_mesh(self, *args, **kwargs):
                """
                Append new mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_name").execute(*args, **kwargs)
            def fuse_face_zones(self, *args, **kwargs):
                """
                Attempt to fuse zones by removing duplicate faces and nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/fuse_face_zones").execute(*args, **kwargs)
            def scale_zone(self, *args, **kwargs):
                """
                Scale nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/scale_zone").execute(*args, **kwargs)
            def sep_face_zone_mark(self, *args, **kwargs):
                """
                Separate a face zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
            def replace_zone(self, *args, **kwargs):
                """
                Replace a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/replace_zone").execute(*args, **kwargs)
            def merge_zones(self, *args, **kwargs):
                """
                Merge zones of the same type and condition into one.
                """
                return PyMenu(self.service, "/mesh/modify_zones/merge_zones").execute(*args, **kwargs)
            def slit_face_zone(self, *args, **kwargs):
                """
                Slit a two-sided wall into two connected wall zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_face_zone").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Attempt to establish conformal periodic face zone connectivity.
                """
                return PyMenu(self.service, "/mesh/modify_zones/make_periodic").execute(*args, **kwargs)
            def slit_periodic(self, *args, **kwargs):
                """
                Slit a periodic zone into two symmetry zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_periodic").execute(*args, **kwargs)
            def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_type").execute(*args, **kwargs)
            def create_all_shell_threads(self, *args, **kwargs):
                """
                Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
            def recreate_all_shells(self, *args, **kwargs):
                """
                Create shell on all the walls where which were deleted using the command delete-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/recreate_all_shells").execute(*args, **kwargs)
            def delete_all_shells(self, *args, **kwargs):
                """
                Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_all_shells").execute(*args, **kwargs)
            def translate_zone(self, *args, **kwargs):
                """
                Translate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/translate_zone").execute(*args, **kwargs)
            def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
            def rotate_zone(self, *args, **kwargs):
                """
                Rotate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/rotate_zone").execute(*args, **kwargs)
            def sep_cell_zone_mark(self, *args, **kwargs):
                """
                Separate a cell zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
            def delete_cell_zone(self, *args, **kwargs):
                """
                Delete a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_cell_zone").execute(*args, **kwargs)
            def orient_face_zone(self, *args, **kwargs):
                """
                Orient the face zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/orient_face_zone").execute(*args, **kwargs)
            def matching_tolerance(self, *args, **kwargs):
                """
                Set the normalized tolerance used for finding coincident nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/matching_tolerance").execute(*args, **kwargs)
            def change_zone_state(self, *args, **kwargs):
                """
                Change the realgas material state for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_state").execute(*args, **kwargs)
            def change_zone_phase(self, *args, **kwargs):
                """
                Change the realgas phase for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_phase").execute(*args, **kwargs)
            def create_periodic_interface(self, *args, **kwargs):
                """
                Create a conformal or non-conformal periodic interface.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_periodic_interface").execute(*args, **kwargs)
            def append_mesh_data(self, *args, **kwargs):
                """
                Append new mesh with data.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh_data").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/mesh/modify_zones/list_zones").execute(*args, **kwargs)
            def deactivate_cell_zone(self, *args, **kwargs):
                """
                Deactivate cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
            def slit_interior_between_diff_solids(self, *args, **kwargs):
                """
                Slit interior created between different solids into coupled walls.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
            def mrf_to_sliding_mesh(self, *args, **kwargs):
                """
                Change motion specification from MRF to moving mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)

        class polyhedra(TUIMenu):
            """
            Enters the polyhedra menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def convert_hanging_nodes_zones(self, *args, **kwargs):
                """
                Convert selected cell zones with hanging nodes and faces to polyhedra.
                The selected cell zones cannot be connected to other zones.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes_zones").execute(*args, **kwargs)
            def convert_skewed_cells(self, *args, **kwargs):
                """
                Converts skewed cells to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_skewed_cells").execute(*args, **kwargs)
            def convert_hanging_nodes(self, *args, **kwargs):
                """
                Converts cells with hanging nodes/edges to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes").execute(*args, **kwargs)
            def convert_domain(self, *args, **kwargs):
                """
                Converts the entire domain to polyhedra cells.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_domain").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the polyhedra options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def preserve_interior_zones(self, *args, **kwargs):
                    """
                    Enables the preservation of surfaces (that is, manifold zones of type interior) during the conversion of the domain to polyhedra. Note that only those zones with a name that includes the string you specify will be preserved.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_interior_zones").execute(*args, **kwargs)
                def preserve_boundary_layer(self, *args, **kwargs):
                    """
                    Specifies whether boundary layer cells will be preserved when the domain is converted to polyhedra. When the value is set to 0 (default) ANSYS Fluent checks for high aspect ratio cells at the boundary layer and if any are found, Fluent asks if you want to preserve the boundary layer. When the value is set to 1, the boundary layer cells are never preserved; when it is set to 2, the boundary layer cells are always preserved (regardless of the aspect ratio of the boundary layer cells).
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_boundary_layer").execute(*args, **kwargs)
                def migrate_and_reorder(self, *args, **kwargs):
                    """
                    Enables / disables the migration of newly created partitions to the compute-nodes and the reordering of the domain as part of polyhedra conversion. This is disabled by default, because it requires significant additional memory; when disabled, it is recommended that you save the case file after conversion, read it in a new Fluent session (so that the new / stored partitions become active), and then manually reorder using the mesh/reorder/reorder-domain text command. If you want to run the calculation in the current Fluent session you can enable the migrate-and-reorder? text command prior to conversion, but you must ensure that no more than half of the available memory of your system is currently used.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/migrate_and_reorder").execute(*args, **kwargs)

        class geometry(TUIMenu):
            """
            Enter the geometry menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/mesh/geometry/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/mesh/geometry/list").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/mesh/geometry/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/mesh/geometry/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/mesh/geometry/edit").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display geometry.
                """
                return PyMenu(self.service, "/mesh/geometry/display").execute(*args, **kwargs)

        class repair_improve(TUIMenu):
            """
            Enter the repair and improve quality menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def repair_face_handedness(self, *args, **kwargs):
                """
                Modifies cell centroids to repair meshes that contain left-handed faces without face node order problems.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_handedness").execute(*args, **kwargs)
            def repair(self, *args, **kwargs):
                """
                Repairs mesh problems identified by the mesh check, if possible. The repairs include fixing cells that have the wrong node order, the wrong face handedness, faces that are small or nonexistent, or very poor quality. Only interior nodes are repositioned by default; boundary nodes may be repositioned if the  mesh/repair-improve/allow-repair-at-boundaries text command is enabled. Note that highly skewed cells may be converted into polyhedra, depending on whether the  mesh/repair-improve/include-local-polyhedra-conversion-in-repair text command is enabled.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair").execute(*args, **kwargs)
            def allow_repair_at_boundaries(self, *args, **kwargs):
                """
                Allows the adjustment of the positions of nodes on boundaries as part of the mesh repairs performed by the mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/allow_repair_at_boundaries").execute(*args, **kwargs)
            def report_poor_elements(self, *args, **kwargs):
                """
                Reports invalid and poor quality elements.
                """
                return PyMenu(self.service, "/mesh/repair_improve/report_poor_elements").execute(*args, **kwargs)
            def repair_face_node_order(self, *args, **kwargs):
                """
                Modifies face nodes to repair faces with improper face node order and, therefore, eliminates any resulting left-handed faces.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_node_order").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_wall_distance").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improves poor quality cells in the mesh, if possible.
                """
                return PyMenu(self.service, "/mesh/repair_improve/improve_quality").execute(*args, **kwargs)
            def repair_periodic(self, *args, **kwargs):
                """
                Modifies the mesh to enforce a rotational angle or translational distance for periodic boundaries. For translationally periodic boundaries, the command computes an average translation distance and adjusts the node coordinates on the shadow face zone to match this distance. For rotationally periodic boundaries, the command prompts for an angle and adjusts the node coordinates on the shadow face zone using this angle and the defined rotational axis for the cell zone.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_periodic").execute(*args, **kwargs)
            def include_local_polyhedra_conversion_in_repair(self, *args, **kwargs):
                """
                Enables/disables the local conversion of degenerate cells into polyhedra based on skewness criteria as part of the mesh repairs performed by the  mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/include_local_polyhedra_conversion_in_repair").execute(*args, **kwargs)

        class reorder(TUIMenu):
            """
            Reorders domain menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def reorder_domain(self, *args, **kwargs):
                """
                Reorders cells and faces using the reverse Cuthill-McKee algorithm. Note that you must save a new case file (and a data file, if data exists) after reordering with this text command, as well as recreate any ray files and/or surface cluster information.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_domain").execute(*args, **kwargs)
            def reorder_zones(self, *args, **kwargs):
                """
                Reorders zones by partition, type, and ID.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_zones").execute(*args, **kwargs)
            def band_width(self, *args, **kwargs):
                """
                Prints cell bandwidth.
                """
                return PyMenu(self.service, "/mesh/reorder/band_width").execute(*args, **kwargs)

    class display(TUIMenu):
        """
        Enter the display menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
            self.objects = self.__class__.objects(path + ["objects"], service)
            self.surface = self.__class__.surface(path + ["surface"], service)
            self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
            self.inverse_dft = self.__class__.inverse_dft(path + ["inverse_dft"], service)
            self.view_sync = self.__class__.view_sync(path + ["view_sync"], service)
            self.define = self.__class__.define(path + ["define"], service)
            self.pdf_data = self.__class__.pdf_data(path + ["pdf_data"], service)
            self.display_states = self.__class__.display_states(path + ["display_states"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
            self.update_scene = self.__class__.update_scene(path + ["update_scene"], service)
            self.flamelet_data = self.__class__.flamelet_data(path + ["flamelet_data"], service)
            self.views = self.__class__.views(path + ["views"], service)
            super().__init__(path, service)
        def surface_mesh(self, *args, **kwargs):
            """
            Draws the mesh defined by the specified surfaces. You can include a wildcard (\*) within the surface names.
            """
            return PyMenu(self.service, "/display/surface_mesh").execute(*args, **kwargs)
        def set_window_by_name(self, *args, **kwargs):
            """
            Sets the specified graphics window as active. The graphics windows specified using this command are "reserved" windows, that is, residual monitors, report plots, and animation definitions. The name will match the name you provided when creating the object (report plots and animation definitions).
            """
            return PyMenu(self.service, "/display/set_window_by_name").execute(*args, **kwargs)
        def mesh_partition_boundary(self, *args, **kwargs):
            """
            Displays mesh partition boundaries.
            """
            return PyMenu(self.service, "/display/mesh_partition_boundary").execute(*args, **kwargs)
        def grid(self, *args, **kwargs):
            """
            Display the mesh.
            """
            return PyMenu(self.service, "/display/grid").execute(*args, **kwargs)
        def mesh(self, *args, **kwargs):
            """
            Displays the entire mesh. For 3D, you will be asked to confirm that you really want to draw the entire mesh (not just themesh-outline).
            """
            return PyMenu(self.service, "/display/mesh").execute(*args, **kwargs)
        def reacting_channel_curves(self, *args, **kwargs):
            """
            Plots the reacting channel variables.
            """
            return PyMenu(self.service, "/display/reacting_channel_curves").execute(*args, **kwargs)
        def profile(self, *args, **kwargs):
            """
            Displays profiles of a flow variable.
            """
            return PyMenu(self.service, "/display/profile").execute(*args, **kwargs)
        def re_scale(self, *args, **kwargs):
            """
            Re-renders the last contour, profile, or vector plot with updated scale, surfaces, meshes, lights, colormap, rendering options, and so on, but without recalculating the field data.
            """
            return PyMenu(self.service, "/display/re_scale").execute(*args, **kwargs)
        def set_list_tree_separator(self, *args, **kwargs):
            """
            Set the separator character for list tree.
            """
            return PyMenu(self.service, "/display/set_list_tree_separator").execute(*args, **kwargs)
        def mesh_outline(self, *args, **kwargs):
            """
            Displays the mesh boundaries.
            """
            return PyMenu(self.service, "/display/mesh_outline").execute(*args, **kwargs)
        def close_window(self, *args, **kwargs):
            """
            Close a "user" graphics window. User windows are specified by number (1-50), with the associated number corresponding to the order, left-to-right, that the windows were created in.
            """
            return PyMenu(self.service, "/display/close_window").execute(*args, **kwargs)
        def open_window(self, *args, **kwargs):
            """
            Opens a graphics window.
            """
            return PyMenu(self.service, "/display/open_window").execute(*args, **kwargs)
        def switch_to_post_processing_volume(self, *args, **kwargs):
            """
            Switch to post processing volume.
            """
            return PyMenu(self.service, "/display/switch_to_post_processing_volume").execute(*args, **kwargs)
        def set_window(self, *args, **kwargs):
            """
            Sets a "user" graphics window to be the active window. User windows are specified by number (1-50), with the associated number corresponding to the order, left-to-right, that the windows were created in.
            """
            return PyMenu(self.service, "/display/set_window").execute(*args, **kwargs)
        def re_render(self, *args, **kwargs):
            """
            Re-renders the last contour, profile, or vector plot with updated surfaces, meshed, lights, colormap, rendering options, and so on, without recalculating the contour data.
            """
            return PyMenu(self.service, "/display/re_render").execute(*args, **kwargs)
        def vector(self, *args, **kwargs):
            """
            Displays vectors of a space vector variable.
            """
            return PyMenu(self.service, "/display/vector").execute(*args, **kwargs)
        def annotate(self, *args, **kwargs):
            """
            Add a text annotation string to the active graphics window.
            """
            return PyMenu(self.service, "/display/annotate").execute(*args, **kwargs)
        def add_custom_vector(self, *args, **kwargs):
            """
            Adds new custom vector definition.
            """
            return PyMenu(self.service, "/display/add_custom_vector").execute(*args, **kwargs)
        def zone_mesh(self, *args, **kwargs):
            """
            Draws the mesh defined by specified face zones. Zone names can be indicated using wildcards (\*).
            """
            return PyMenu(self.service, "/display/zone_mesh").execute(*args, **kwargs)
        def multigrid_coarsening(self, *args, **kwargs):
            """
            Displays a coarse mesh level from the last multigrid coarsening.
            """
            return PyMenu(self.service, "/display/multigrid_coarsening").execute(*args, **kwargs)
        def velocity_vector(self, *args, **kwargs):
            """
            Prompts for a scalar field by which to color the vectors, the minimum and maximum values, and the scale factor, and then draws the velocity vectors.
            """
            return PyMenu(self.service, "/display/velocity_vector").execute(*args, **kwargs)
        def switch_to_primary_volume(self, *args, **kwargs):
            """
            Switch to primary volume.
            """
            return PyMenu(self.service, "/display/switch_to_primary_volume").execute(*args, **kwargs)
        def close_window_by_name(self, *args, **kwargs):
            """
            Close a reserved graphics window (windows used for residuals, report plots, and animation definitions).
            """
            return PyMenu(self.service, "/display/close_window_by_name").execute(*args, **kwargs)
        def update_layout(self, *args, **kwargs):
            """
            Update the fluent layout.
            """
            return PyMenu(self.service, "/display/update_layout").execute(*args, **kwargs)
        def grid_outline(self, *args, **kwargs):
            """
            Display the mesh boundaries.
            """
            return PyMenu(self.service, "/display/grid_outline").execute(*args, **kwargs)
        def display_custom_vector(self, *args, **kwargs):
            """
            Displays custom vector.
            """
            return PyMenu(self.service, "/display/display_custom_vector").execute(*args, **kwargs)
        def graphics_window_layout(self, *args, **kwargs):
            """
            Arranges the graphics window layout.
            """
            return PyMenu(self.service, "/display/graphics_window_layout").execute(*args, **kwargs)
        def hsf_file(self, *args, **kwargs):
            """
            Loads an HSF file for viewing.
            """
            return PyMenu(self.service, "/display/hsf_file").execute(*args, **kwargs)
        def contour(self, *args, **kwargs):
            """
            Prompts for a scalar field and minimum and maximum values, and then displays a contour plot.
            """
            return PyMenu(self.service, "/display/contour").execute(*args, **kwargs)
        def surface_cells(self, *args, **kwargs):
            """
            Draws the cells on the specified surfaces. You can include a wildcard (\*) within the surface names.
            """
            return PyMenu(self.service, "/display/surface_cells").execute(*args, **kwargs)
        def clear_annotations(self, *args, **kwargs):
            """
            Removes all annotations and attachment lines from the active graphics window.
            """
            return PyMenu(self.service, "/display/clear_annotations").execute(*args, **kwargs)
        def save_picture(self, *args, **kwargs):
            """
            Generate a "hardcopy" of the active window.
            """
            return PyMenu(self.service, "/display/save_picture").execute(*args, **kwargs)

        class embedded_windows(TUIMenu):
            """
            Enter the embedded window menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def close_all(self, *args, **kwargs):
                """
                Close all the embedded windows within the specified parent window.
                """
                return PyMenu(self.service, "/display/embedded_windows/close_all").execute(*args, **kwargs)
            def move_out_all(self, *args, **kwargs):
                """
                Move all the embedded windows out of the specified parent window.
                """
                return PyMenu(self.service, "/display/embedded_windows/move_out_all").execute(*args, **kwargs)
            def move_out(self, *args, **kwargs):
                """
                Move an embedded window out of the parent window, returning the embedded window to a non-embedded state.
                """
                return PyMenu(self.service, "/display/embedded_windows/move_out").execute(*args, **kwargs)
            def embed_in(self, *args, **kwargs):
                """
                Specify a window to embed and a parent window to receive the embedded window.
                """
                return PyMenu(self.service, "/display/embedded_windows/embed_in").execute(*args, **kwargs)
            def close(self, *args, **kwargs):
                """
                Close an embedded window.
                """
                return PyMenu(self.service, "/display/embedded_windows/close").execute(*args, **kwargs)

        class objects(TUIMenu):
            """
            Enter to add, edit, delete or display graphics objects.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def add_to_graphics(self, *args, **kwargs):
                """
                Add graphics object to existing graphics.
                """
                return PyMenu(self.service, "/display/objects/add_to_graphics").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit graphics object.
                """
                return PyMenu(self.service, "/display/objects/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete graphics object.
                """
                return PyMenu(self.service, "/display/objects/delete").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create new graphics object.
                """
                return PyMenu(self.service, "/display/objects/create").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy graphics object.
                """
                return PyMenu(self.service, "/display/objects/copy").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display graphics object.
                """
                return PyMenu(self.service, "/display/objects/display").execute(*args, **kwargs)

        class surface(TUIMenu):
            """
            Enters the data surface-manipulation menu. For a description of the items in this menu, see surface/.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
                super().__init__(path, service)
            def iso_clip_multiple(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/display/surface/iso_clip_multiple").execute(*args, **kwargs)
            def delete_surface(self, *args, **kwargs):
                """
                Remove a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/delete_surface").execute(*args, **kwargs)
            def rename_surface(self, *args, **kwargs):
                """
                Rename a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/rename_surface").execute(*args, **kwargs)
            def iso_clip(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/display/surface/iso_clip").execute(*args, **kwargs)
            def plane_bounded(self, *args, **kwargs):
                """
                Create a bounded surface.
                """
                return PyMenu(self.service, "/display/surface/plane_bounded").execute(*args, **kwargs)
            def multiple_plane_surfaces(self, *args, **kwargs):
                """
                Create multiple plane surfaces at specified spacing.
                """
                return PyMenu(self.service, "/display/surface/multiple_plane_surfaces").execute(*args, **kwargs)
            def circle_slice(self, *args, **kwargs):
                """
                Extract a circular slice.
                """
                return PyMenu(self.service, "/display/surface/circle_slice").execute(*args, **kwargs)
            def closest_point_search(self, *args, **kwargs):
                """
                Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
                """
                return PyMenu(self.service, "/display/surface/closest_point_search").execute(*args, **kwargs)
            def rake_surface(self, *args, **kwargs):
                """
                Define a "rake" surface by specifying the end points.
                """
                return PyMenu(self.service, "/display/surface/rake_surface").execute(*args, **kwargs)
            def structural_point_surface(self, *args, **kwargs):
                """
                Define a "structural point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/display/surface/structural_point_surface").execute(*args, **kwargs)
            def plane_surface(self, *args, **kwargs):
                """
                Create a plane from a coordinate plane, point and normal, or three points.
                """
                return PyMenu(self.service, "/display/surface/plane_surface").execute(*args, **kwargs)
            def zone_surface(self, *args, **kwargs):
                """
                Define a data surface on a mesh zone.
                """
                return PyMenu(self.service, "/display/surface/zone_surface").execute(*args, **kwargs)
            def group_surfaces(self, *args, **kwargs):
                """
                Group a set of surfaces.
                """
                return PyMenu(self.service, "/display/surface/group_surfaces").execute(*args, **kwargs)
            def line_slice(self, *args, **kwargs):
                """
                Extract a linear slice.
                """
                return PyMenu(self.service, "/display/surface/line_slice").execute(*args, **kwargs)
            def plane_view_plane_align(self, *args, **kwargs):
                """
                Create a plane aligned to a view-plane.
                """
                return PyMenu(self.service, "/display/surface/plane_view_plane_align").execute(*args, **kwargs)
            def reset_zone_surfaces(self, *args, **kwargs):
                """
                Reset case surface list.
                """
                return PyMenu(self.service, "/display/surface/reset_zone_surfaces").execute(*args, **kwargs)
            def mouse_line(self, *args, **kwargs):
                """
                Define a line surface using the mouse to select two points.
                """
                return PyMenu(self.service, "/display/surface/mouse_line").execute(*args, **kwargs)
            def mouse_rake(self, *args, **kwargs):
                """
                Define a "rake" surface using the mouse to select the end points.
                """
                return PyMenu(self.service, "/display/surface/mouse_rake").execute(*args, **kwargs)
            def plane(self, *args, **kwargs):
                """
                Create a plane given 3 points bounded by the domain.
                """
                return PyMenu(self.service, "/display/surface/plane").execute(*args, **kwargs)
            def edit_surface(self, *args, **kwargs):
                """
                Edit a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/edit_surface").execute(*args, **kwargs)
            def create_imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/display/surface/create_imprint_surface").execute(*args, **kwargs)
            def transform_surface(self, *args, **kwargs):
                """
                Transform surface.
                """
                return PyMenu(self.service, "/display/surface/transform_surface").execute(*args, **kwargs)
            def plane_point_n_normal(self, *args, **kwargs):
                """
                Create a plane from a point and normal.
                """
                return PyMenu(self.service, "/display/surface/plane_point_n_normal").execute(*args, **kwargs)
            def mouse_plane(self, *args, **kwargs):
                """
                Define a plane surface using the mouse to select three points.
                """
                return PyMenu(self.service, "/display/surface/mouse_plane").execute(*args, **kwargs)
            def plane_slice(self, *args, **kwargs):
                """
                Extract a planar slice.
                """
                return PyMenu(self.service, "/display/surface/plane_slice").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List the number of facets in the defined surfaces.
                """
                return PyMenu(self.service, "/display/surface/list_surfaces").execute(*args, **kwargs)
            def point_surface(self, *args, **kwargs):
                """
                Define a "point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/display/surface/point_surface").execute(*args, **kwargs)
            def imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/display/surface/imprint_surface").execute(*args, **kwargs)
            def multiple_iso_surfaces(self, *args, **kwargs):
                """
                Create multiple iso-surfaces from the data field at specified spacing.
                """
                return PyMenu(self.service, "/display/surface/multiple_iso_surfaces").execute(*args, **kwargs)
            def expression_volume(self, *args, **kwargs):
                """
                Create volume with boolean expression.
                """
                return PyMenu(self.service, "/display/surface/expression_volume").execute(*args, **kwargs)
            def multiple_zone_surfaces(self, *args, **kwargs):
                """
                Create multiple data surfaces at a time.
                """
                return PyMenu(self.service, "/display/surface/multiple_zone_surfaces").execute(*args, **kwargs)
            def plane_surf_aligned(self, *args, **kwargs):
                """
                Create a plane aligned to a surface.
                """
                return PyMenu(self.service, "/display/surface/plane_surf_aligned").execute(*args, **kwargs)
            def iso_surface(self, *args, **kwargs):
                """
                Extract an iso-surface (surface, curve, or point) from the curent data field.
                """
                return PyMenu(self.service, "/display/surface/iso_surface").execute(*args, **kwargs)
            def sphere_slice(self, *args, **kwargs):
                """
                Extract a spherical slice.
                """
                return PyMenu(self.service, "/display/surface/sphere_slice").execute(*args, **kwargs)
            def ungroup_surface(self, *args, **kwargs):
                """
                Ungroup the surface(if grouped).
                """
                return PyMenu(self.service, "/display/surface/ungroup_surface").execute(*args, **kwargs)
            def quadric_slice(self, *args, **kwargs):
                """
                Extract a quadric slice.
                """
                return PyMenu(self.service, "/display/surface/quadric_slice").execute(*args, **kwargs)
            def ellipsoid_slice(self, *args, **kwargs):
                """
                Extract a ellipsoid slice.
                """
                return PyMenu(self.service, "/display/surface/ellipsoid_slice").execute(*args, **kwargs)
            def surface_cells(self, *args, **kwargs):
                """
                Extract all cells intersected by a data surface.
                """
                return PyMenu(self.service, "/display/surface/surface_cells").execute(*args, **kwargs)
            def cone_slice(self, *args, **kwargs):
                """
                Extract a cone slice.
                """
                return PyMenu(self.service, "/display/surface/cone_slice").execute(*args, **kwargs)
            def point_array(self, *args, **kwargs):
                """
                Extract a rectangular array of data points.
                """
                return PyMenu(self.service, "/display/surface/point_array").execute(*args, **kwargs)
            def partition_surface(self, *args, **kwargs):
                """
                Define a data surface on mesh faces on the partition boundary.
                """
                return PyMenu(self.service, "/display/surface/partition_surface").execute(*args, **kwargs)
            def line_surface(self, *args, **kwargs):
                """
                Define a "line" surface by specifying the two endpoint coordinates.
                """
                return PyMenu(self.service, "/display/surface/line_surface").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter surface query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/display/surface/query/delete_query").execute(*args, **kwargs)
                def named_surface_list(self, *args, **kwargs):
                    """
                    Create named list of surfaces.
                    """
                    return PyMenu(self.service, "/display/surface/query/named_surface_list").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_queries").execute(*args, **kwargs)
                def list_surfaces(self, *args, **kwargs):
                    """
                    List surfaces.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_surfaces").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of surface type.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_named_selection").execute(*args, **kwargs)

            class post_processing_volume(TUIMenu):
                """
                Enter post-processing volume menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create_octree(self, *args, **kwargs):
                    """
                    Create post-processing octree mesh based on current case.
                    """
                    return PyMenu(self.service, "/display/surface/post_processing_volume/create_octree").execute(*args, **kwargs)
                def create_from_file(self, *args, **kwargs):
                    """
                    Read post-processing mesh from file.
                    """
                    return PyMenu(self.service, "/display/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)

        class particle_tracks(TUIMenu):
            """
            Enters the particle tracks menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_write_xy_plot(self, *args, **kwargs):
                """
                Plots or writes an XY plot of particle tracks.
                """
                return PyMenu(self.service, "/display/particle_tracks/plot_write_xy_plot").execute(*args, **kwargs)
            def particle_tracks(self, *args, **kwargs):
                """
                Calculates and displays particle tracks from defined injections.
                """
                return PyMenu(self.service, "/display/particle_tracks/particle_tracks").execute(*args, **kwargs)

        class inverse_dft(TUIMenu):
            """
            Reconstruct DFT signal.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def reconstruct(self, *args, **kwargs):
                """
                Make inverse DFT recontruction.
                """
                return PyMenu(self.service, "/display/inverse_dft/reconstruct").execute(*args, **kwargs)
            def set(self, *args, **kwargs):
                """
                Set reconstruction parameters.
                """
                return PyMenu(self.service, "/display/inverse_dft/set").execute(*args, **kwargs)

        class view_sync(TUIMenu):
            """
            Synchronize window views.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def stop(self, *args, **kwargs):
                """
                Stop view synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/stop").execute(*args, **kwargs)
            def add_all(self, *args, **kwargs):
                """
                Synchronize all windows.
                """
                return PyMenu(self.service, "/display/view_sync/add_all").execute(*args, **kwargs)
            def remove(self, *args, **kwargs):
                """
                Remove list of window ids from synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/remove").execute(*args, **kwargs)
            def start(self, *args, **kwargs):
                """
                Start view synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/start").execute(*args, **kwargs)
            def remove_all(self, *args, **kwargs):
                """
                Unsynchronize all windows.
                """
                return PyMenu(self.service, "/display/view_sync/remove_all").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add list of window ids for synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print window ids of open windows.
                """
                return PyMenu(self.service, "/display/view_sync/list").execute(*args, **kwargs)

        class define(TUIMenu):
            """
            Enter Display define menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.material = self.__class__.material(path + ["material"], service)
                super().__init__(path, service)

            class material(TUIMenu):
                """
                Add, Edit, Remove materials in case file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def copy(self, *args, **kwargs):
                    """
                    Copy to new material.
                    """
                    return PyMenu(self.service, "/display/define/material/copy").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Remove  material.
                    """
                    return PyMenu(self.service, "/display/define/material/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit material.
                    """
                    return PyMenu(self.service, "/display/define/material/edit").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Create new material.
                    """
                    return PyMenu(self.service, "/display/define/material/new").execute(*args, **kwargs)

        class pdf_data(TUIMenu):
            """
            Enters the PDF data menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def draw_number_box(self, *args, **kwargs):
                """
                Enables/disables the display of the numbers box.
                """
                return PyMenu(self.service, "/display/pdf_data/draw_number_box").execute(*args, **kwargs)
            def carpet_plot(self, *args, **kwargs):
                """
                Enables/disables the display of a carpet plot of a property.
                """
                return PyMenu(self.service, "/display/pdf_data/carpet_plot").execute(*args, **kwargs)
            def plot_1d_slice(self, *args, **kwargs):
                """
                Enables/disables a plot of the 1D-slice.
                """
                return PyMenu(self.service, "/display/pdf_data/plot_1d_slice").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Enables/disables writing the 1D-slice to file instead of plot.
                """
                return PyMenu(self.service, "/display/pdf_data/write_to_file").execute(*args, **kwargs)

        class display_states(TUIMenu):
            """
            Enter the display state manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def create(self, *args, **kwargs):
                """
                Create a new display state.
                """
                return PyMenu(self.service, "/display/display_states/create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a display state.
                """
                return PyMenu(self.service, "/display/display_states/delete").execute(*args, **kwargs)
            def use_active(self, *args, **kwargs):
                """
                Update an existing display state's settings to match those of the active graphics window.
                """
                return PyMenu(self.service, "/display/display_states/use_active").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Create a new display state with settings copied from an existing display state.
                """
                return PyMenu(self.service, "/display/display_states/copy").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write display states to a file.
                """
                return PyMenu(self.service, "/display/display_states/write").execute(*args, **kwargs)
            def apply(self, *args, **kwargs):
                """
                Apply a display state to the active window.
                """
                return PyMenu(self.service, "/display/display_states/apply").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit a particular display state setting.
                """
                return PyMenu(self.service, "/display/display_states/edit").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                Read display states from a file.
                """
                return PyMenu(self.service, "/display/display_states/read").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the available display states to the console.
                """
                return PyMenu(self.service, "/display/display_states/list").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enter the set menu to set display parameters.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.lights = self.__class__.lights(path + ["lights"], service)
                self.picture = self.__class__.picture(path + ["picture"], service)
                self.colors = self.__class__.colors(path + ["colors"], service)
                self.windows = self.__class__.windows(path + ["windows"], service)
                self.titles = self.__class__.titles(path + ["titles"], service)
                self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                self.contours = self.__class__.contours(path + ["contours"], service)
                self.velocity_vectors = self.__class__.velocity_vectors(path + ["velocity_vectors"], service)
                self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                super().__init__(path, service)
            def periodic_instancing(self, *args, **kwargs):
                """
                Sets the number of periodic repetitions.
                """
                return PyMenu(self.service, "/display/set/periodic_instancing").execute(*args, **kwargs)
            def n_stream_func(self, *args, **kwargs):
                """
                Sets number of iterations used in computing stream function.
                """
                return PyMenu(self.service, "/display/set/n_stream_func").execute(*args, **kwargs)
            def zero_angle_dir(self, *args, **kwargs):
                """
                Sets the vector having zero angular coordinates.
                """
                return PyMenu(self.service, "/display/set/zero_angle_dir").execute(*args, **kwargs)
            def grid_zones(self, *args, **kwargs):
                """
                Set zone IDs to be drawn as mesh.
                """
                return PyMenu(self.service, "/display/set/grid_zones").execute(*args, **kwargs)
            def mesh_level(self, *args, **kwargs):
                """
                Sets coarse mesh level to be drawn.
                """
                return PyMenu(self.service, "/display/set/mesh_level").execute(*args, **kwargs)
            def element_shrink(self, *args, **kwargs):
                """
                Sets shrinkage of both faces and cells. A value of zero indicates no shrinkage, while a value of one will shrink each face or cell to a point.
                """
                return PyMenu(self.service, "/display/set/element_shrink").execute(*args, **kwargs)
            def duplicate_node_display(self, *args, **kwargs):
                """
                Set flag to remove duplicate nodes in mesh display.
                """
                return PyMenu(self.service, "/display/set/duplicate_node_display").execute(*args, **kwargs)
            def line_weight(self, *args, **kwargs):
                """
                Set the line-weight factor for the window.
                """
                return PyMenu(self.service, "/display/set/line_weight").execute(*args, **kwargs)
            def mesh_display_configuration(self, *args, **kwargs):
                """
                Changes the default mesh display. If set tomeshing, it draws the mesh on edges and faces of the outline surfaces, colored by their zone ID with lighting enabled. If set tosolution, it draws the mesh on edges and faces of the outline surfaces, colored by their zone type with lighting enabled. If set to post-processing, it draws the object outline with lighting disabled. If set toclassic, it draws the mesh on all edges of the outline surfaces.  This only applies for 3D cases.
                """
                return PyMenu(self.service, "/display/set/mesh_display_configuration").execute(*args, **kwargs)
            def reset_graphics(self, *args, **kwargs):
                """
                Reset the graphics system.
                """
                return PyMenu(self.service, "/display/set/reset_graphics").execute(*args, **kwargs)
            def mesh_surfaces(self, *args, **kwargs):
                """
                Sets surface IDs to be drawn as meshes. You can include a wildcard  (\*) within the surface names.
                """
                return PyMenu(self.service, "/display/set/mesh_surfaces").execute(*args, **kwargs)
            def filled_mesh(self, *args, **kwargs):
                """
                Determines whether the meshes are drawn as wireframe or solid.
                """
                return PyMenu(self.service, "/display/set/filled_mesh").execute(*args, **kwargs)
            def mesh_partitions(self, *args, **kwargs):
                """
                Enables/disables option to draw mesh partition boundaries.
                """
                return PyMenu(self.service, "/display/set/mesh_partitions").execute(*args, **kwargs)
            def grid_partitions(self, *args, **kwargs):
                """
                Enable/disable drawing of the mesh partition boundaries.
                """
                return PyMenu(self.service, "/display/set/grid_partitions").execute(*args, **kwargs)
            def nodewt_based_interp(self, *args, **kwargs):
                """
                Disables/enables the use of node weights for node-based gradients in postprocessing.
                """
                return PyMenu(self.service, "/display/set/nodewt_based_interp").execute(*args, **kwargs)
            def marker_symbol(self, *args, **kwargs):
                """
                Sets the type of markers used to represent points.
                """
                return PyMenu(self.service, "/display/set/marker_symbol").execute(*args, **kwargs)
            def periodic_repeats(self, *args, **kwargs):
                """
                Sets the number of periodic repetitions.
                """
                return PyMenu(self.service, "/display/set/periodic_repeats").execute(*args, **kwargs)
            def color_map(self, *args, **kwargs):
                """
                Enters the color map menu, which contains names of predefined and user-defined (in the Colormap Editor panel) colormaps that can be selected. It prompts you for the name of the colormap to be used.
                """
                return PyMenu(self.service, "/display/set/color_map").execute(*args, **kwargs)
            def marker_size(self, *args, **kwargs):
                """
                Sets the size of markers used to represent points.
                """
                return PyMenu(self.service, "/display/set/marker_size").execute(*args, **kwargs)
            def proximity_zones(self, *args, **kwargs):
                """
                Sets zones to be used for boundary cell distance and boundary proximity.
                """
                return PyMenu(self.service, "/display/set/proximity_zones").execute(*args, **kwargs)
            def overlays(self, *args, **kwargs):
                """
                Enable/disable overlays.
                """
                return PyMenu(self.service, "/display/set/overlays").execute(*args, **kwargs)
            def grid_surfaces(self, *args, **kwargs):
                """
                Set surface IDs to be drawn as mesh.
                """
                return PyMenu(self.service, "/display/set/grid_surfaces").execute(*args, **kwargs)
            def mesh_zones(self, *args, **kwargs):
                """
                Sets zone IDs to be drawn as meshes.
                """
                return PyMenu(self.service, "/display/set/mesh_zones").execute(*args, **kwargs)
            def grid_level(self, *args, **kwargs):
                """
                Set coarse mesh level to be drawn.
                """
                return PyMenu(self.service, "/display/set/grid_level").execute(*args, **kwargs)
            def render_mesh(self, *args, **kwargs):
                """
                Enables/disables rendering the mesh on top of contours, vectors, and so on.
                """
                return PyMenu(self.service, "/display/set/render_mesh").execute(*args, **kwargs)
            def mirror_zones(self, *args, **kwargs):
                """
                Sets the zones about which the domain is mirrored (symmetry planes).
                """
                return PyMenu(self.service, "/display/set/mirror_zones").execute(*args, **kwargs)
            def filled_grid(self, *args, **kwargs):
                """
                Enable/disable the filled mesh option.
                """
                return PyMenu(self.service, "/display/set/filled_grid").execute(*args, **kwargs)

            class lights(TUIMenu):
                """
                Enter the lights menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def headlight_on(self, *args, **kwargs):
                    """
                    Turn the light that moves with the camera on or off.
                    """
                    return PyMenu(self.service, "/display/set/lights/headlight_on").execute(*args, **kwargs)
                def lights_on(self, *args, **kwargs):
                    """
                    Turn all active lighting on/off.
                    """
                    return PyMenu(self.service, "/display/set/lights/lights_on").execute(*args, **kwargs)
                def set_light(self, *args, **kwargs):
                    """
                    Add or modify a directional, colored light.
                    """
                    return PyMenu(self.service, "/display/set/lights/set_light").execute(*args, **kwargs)
                def lighting_interpolation(self, *args, **kwargs):
                    """
                    Set lighting interpolation method.
                    """
                    return PyMenu(self.service, "/display/set/lights/lighting_interpolation").execute(*args, **kwargs)
                def set_ambient_color(self, *args, **kwargs):
                    """
                    Set the ambient light color for the scene.
                    """
                    return PyMenu(self.service, "/display/set/lights/set_ambient_color").execute(*args, **kwargs)

            class picture(TUIMenu):
                """
                Enter the hardcopy/save-picture options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                    self.driver = self.__class__.driver(path + ["driver"], service)
                    super().__init__(path, service)
                def landscape(self, *args, **kwargs):
                    """
                    Plot hardcopies in landscape or portrait orientation.
                    """
                    return PyMenu(self.service, "/display/set/picture/landscape").execute(*args, **kwargs)
                def invert_background(self, *args, **kwargs):
                    """
                    Use a white background when the picture is saved.
                    """
                    return PyMenu(self.service, "/display/set/picture/invert_background").execute(*args, **kwargs)
                def y_resolution(self, *args, **kwargs):
                    """
                    Set the height of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/display/set/picture/y_resolution").execute(*args, **kwargs)
                def x_resolution(self, *args, **kwargs):
                    """
                    Set the width of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/display/set/picture/x_resolution").execute(*args, **kwargs)
                def jpeg_hardcopy_quality(self, *args, **kwargs):
                    """
                    To set jpeg hardcopy quality.
                    """
                    return PyMenu(self.service, "/display/set/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                def dpi(self, *args, **kwargs):
                    """
                    Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                    """
                    return PyMenu(self.service, "/display/set/picture/dpi").execute(*args, **kwargs)
                def set_standard_resolution(self, *args, **kwargs):
                    """
                    Select from pre-defined resolution list.
                    """
                    return PyMenu(self.service, "/display/set/picture/set_standard_resolution").execute(*args, **kwargs)
                def use_window_resolution(self, *args, **kwargs):
                    """
                    Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                    """
                    return PyMenu(self.service, "/display/set/picture/use_window_resolution").execute(*args, **kwargs)
                def preview(self, *args, **kwargs):
                    """
                    Display a preview image of a hardcopy.
                    """
                    return PyMenu(self.service, "/display/set/picture/preview").execute(*args, **kwargs)

                class color_mode(TUIMenu):
                    """
                    Enter the hardcopy color mode menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mono_chrome(self, *args, **kwargs):
                        """
                        Convert color to monochrome (black and white) for hardcopy.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/mono_chrome").execute(*args, **kwargs)
                    def gray_scale(self, *args, **kwargs):
                        """
                        Convert color to grayscale for hardcopy.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/gray_scale").execute(*args, **kwargs)
                    def color(self, *args, **kwargs):
                        """
                        Plot hardcopies in color.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/color").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        Display the current hardcopy color mode.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/list").execute(*args, **kwargs)

                class driver(TUIMenu):
                    """
                    Enter the set hardcopy driver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.post_format = self.__class__.post_format(path + ["post_format"], service)
                        super().__init__(path, service)
                    def eps(self, *args, **kwargs):
                        """
                        Produce encapsulated PostScript (EPS) output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/eps").execute(*args, **kwargs)
                    def post_script(self, *args, **kwargs):
                        """
                        Produce PostScript output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/post_script").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the current hardcopy driver.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/list").execute(*args, **kwargs)
                    def ppm(self, *args, **kwargs):
                        """
                        Produce PPM output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/ppm").execute(*args, **kwargs)
                    def jpeg(self, *args, **kwargs):
                        """
                        Produce JPEG output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/jpeg").execute(*args, **kwargs)
                    def hsf(self, *args, **kwargs):
                        """
                        Use HSF output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/hsf").execute(*args, **kwargs)
                    def options(self, *args, **kwargs):
                        """
                        Set the hardcopy options. Available options are:
                        "no gamma correction", disables gamma correction of colors,
                        "physical size = (width,height)", where width and height
                        are the actual measurements of the printable area of the page
                        in centimeters.
                        "subscreen = (left,right,bottom,top)", where left,right,
                        bottom, and top are numbers in [-1,1] describing a subwindow on
                        the page in which to place the hardcopy.
                        The options may be combined by separating them with commas.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/options").execute(*args, **kwargs)
                    def vrml(self, *args, **kwargs):
                        """
                        Use VRML output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/vrml").execute(*args, **kwargs)
                    def dump_window(self, *args, **kwargs):
                        """
                        Set the command used to dump the graphics window to a file.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/dump_window").execute(*args, **kwargs)
                    def avz(self, *args, **kwargs):
                        """
                        Use AVZ output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/avz").execute(*args, **kwargs)
                    def glb(self, *args, **kwargs):
                        """
                        Use GLB output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/glb").execute(*args, **kwargs)
                    def png(self, *args, **kwargs):
                        """
                        Use PNG output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/png").execute(*args, **kwargs)
                    def tiff(self, *args, **kwargs):
                        """
                        Use TIFF output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/tiff").execute(*args, **kwargs)

                    class post_format(TUIMenu):
                        """
                        Enter the PostScript driver format menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def raster(self, *args, **kwargs):
                            """
                            Use the original raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/raster").execute(*args, **kwargs)
                        def vector(self, *args, **kwargs):
                            """
                            Use vector format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/vector").execute(*args, **kwargs)
                        def rle_raster(self, *args, **kwargs):
                            """
                            Use the run-length encoded raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/rle_raster").execute(*args, **kwargs)
                        def fast_raster(self, *args, **kwargs):
                            """
                            Use the new raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/fast_raster").execute(*args, **kwargs)

            class colors(TUIMenu):
                """
                Enter the color options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.by_surface = self.__class__.by_surface(path + ["by_surface"], service)
                    self.by_type = self.__class__.by_type(path + ["by_type"], service)
                    super().__init__(path, service)
                def grid_inlet(self, *args, **kwargs):
                    """
                    Set the color of inlet faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/grid_inlet").execute(*args, **kwargs)
                def outlet_faces(self, *args, **kwargs):
                    """
                    Set the color of outlet faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/outlet_faces").execute(*args, **kwargs)
                def user_color(self, *args, **kwargs):
                    """
                    Explicitly set color of display zone.
                    """
                    return PyMenu(self.service, "/display/set/colors/user_color").execute(*args, **kwargs)
                def wall_faces(self, *args, **kwargs):
                    """
                    Set the color of wall faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/wall_faces").execute(*args, **kwargs)
                def reset_colors(self, *args, **kwargs):
                    """
                    Reset individual mesh surface colors to the defaults.
                    """
                    return PyMenu(self.service, "/display/set/colors/reset_colors").execute(*args, **kwargs)
                def foreground(self, *args, **kwargs):
                    """
                    Set the foreground (text and window frame) color.
                    """
                    return PyMenu(self.service, "/display/set/colors/foreground").execute(*args, **kwargs)
                def rans_les_interface_faces(self, *args, **kwargs):
                    """
                    Set the color of RANS/LES interface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/rans_les_interface_faces").execute(*args, **kwargs)
                def symmetry_faces(self, *args, **kwargs):
                    """
                    Set the color of symmetric faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/symmetry_faces").execute(*args, **kwargs)
                def free_surface_faces(self, *args, **kwargs):
                    """
                    Set the color of free-surface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/free_surface_faces").execute(*args, **kwargs)
                def overset_faces(self, *args, **kwargs):
                    """
                    Set the color of overset faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/overset_faces").execute(*args, **kwargs)
                def interior_faces(self, *args, **kwargs):
                    """
                    Set the color of interior faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/interior_faces").execute(*args, **kwargs)
                def color_by_type(self, *args, **kwargs):
                    """
                    Determine whether to color meshes by type or by surface (ID).
                    """
                    return PyMenu(self.service, "/display/set/colors/color_by_type").execute(*args, **kwargs)
                def periodic_faces(self, *args, **kwargs):
                    """
                    Set the color of periodic faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/periodic_faces").execute(*args, **kwargs)
                def skip_label(self, *args, **kwargs):
                    """
                    Set the number of labels to be skipped in the colopmap scale.
                    """
                    return PyMenu(self.service, "/display/set/colors/skip_label").execute(*args, **kwargs)
                def surface(self, *args, **kwargs):
                    """
                    Set the color of surfaces.
                    """
                    return PyMenu(self.service, "/display/set/colors/surface").execute(*args, **kwargs)
                def show_user_colors(self, *args, **kwargs):
                    """
                    List currently defined user colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/show_user_colors").execute(*args, **kwargs)
                def interface_faces(self, *args, **kwargs):
                    """
                    Set the color of mesh Interfaces.
                    """
                    return PyMenu(self.service, "/display/set/colors/interface_faces").execute(*args, **kwargs)
                def graphics_color_theme(self, *args, **kwargs):
                    """
                    Enter the graphics color theme menu.
                    """
                    return PyMenu(self.service, "/display/set/colors/graphics_color_theme").execute(*args, **kwargs)
                def automatic_skip(self, *args, **kwargs):
                    """
                    Determine whether to skip labels in the colopmap scale automatically.
                    """
                    return PyMenu(self.service, "/display/set/colors/automatic_skip").execute(*args, **kwargs)
                def grid_interior(self, *args, **kwargs):
                    """
                    Set the color of interior faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/grid_interior").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List available colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/list").execute(*args, **kwargs)
                def background(self, *args, **kwargs):
                    """
                    Set the background (window) color.
                    """
                    return PyMenu(self.service, "/display/set/colors/background").execute(*args, **kwargs)
                def inlet_faces(self, *args, **kwargs):
                    """
                    Set the color of inlet faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/inlet_faces").execute(*args, **kwargs)
                def far_field_faces(self, *args, **kwargs):
                    """
                    Set the color of far field faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/far_field_faces").execute(*args, **kwargs)
                def internal_faces(self, *args, **kwargs):
                    """
                    Set the color of internal interface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/internal_faces").execute(*args, **kwargs)
                def reset_user_colors(self, *args, **kwargs):
                    """
                    Reset all user colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/reset_user_colors").execute(*args, **kwargs)
                def traction_faces(self, *args, **kwargs):
                    """
                    Set the color of traction faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/traction_faces").execute(*args, **kwargs)
                def axis_faces(self, *args, **kwargs):
                    """
                    Set the color of axisymmetric faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/axis_faces").execute(*args, **kwargs)
                def highlight_color(self, *args, **kwargs):
                    """
                    Set highlight color.
                    """
                    return PyMenu(self.service, "/display/set/colors/highlight_color").execute(*args, **kwargs)

                class by_surface(TUIMenu):
                    """
                    Enter the surface(s) color and material assignment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_surfaces_by_color(self, *args, **kwargs):
                        """
                        To list the surfaces by its color.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/list_surfaces_by_color").execute(*args, **kwargs)
                    def use_inherent_material_color(self, *args, **kwargs):
                        """
                        Use inherent material color for surfaces.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/use_inherent_material_color").execute(*args, **kwargs)
                    def reset(self, *args, **kwargs):
                        """
                        To reset colors and/or materials to the defaults.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/reset").execute(*args, **kwargs)
                    def surfaces(self, *args, **kwargs):
                        """
                        Select the surface(s) to specify colors and/or materials.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/surfaces").execute(*args, **kwargs)
                    def list_surfaces_by_material(self, *args, **kwargs):
                        """
                        To list the surfaces by its material.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/list_surfaces_by_material").execute(*args, **kwargs)

                class by_type(TUIMenu):
                    """
                    Enter the zone type color and material assignment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.type_name = self.__class__.type_name(path + ["type_name"], service)
                        super().__init__(path, service)
                    def use_inherent_material_color(self, *args, **kwargs):
                        """
                        Use inherent material color for boundary zones.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_type/use_inherent_material_color").execute(*args, **kwargs)
                    def reset(self, *args, **kwargs):
                        """
                        To reset colors and/or materials to the defaults.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_type/reset").execute(*args, **kwargs)
                    def only_list_case_boundaries(self, *args, **kwargs):
                        """
                        Only list the boundary types that are assigned in this case.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_type/only_list_case_boundaries").execute(*args, **kwargs)

                    class type_name(TUIMenu):
                        """
                        Select the boundary type to specify colors and/or materials.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def surface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/surface").execute(*args, **kwargs)
                        def inlet(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/inlet").execute(*args, **kwargs)
                        def overset(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/overset").execute(*args, **kwargs)
                        def interface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/interface").execute(*args, **kwargs)
                        def far_field(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/far_field").execute(*args, **kwargs)
                        def symmetry(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/symmetry").execute(*args, **kwargs)
                        def rans_les_interface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/rans_les_interface").execute(*args, **kwargs)
                        def free_surface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/free_surface").execute(*args, **kwargs)
                        def traction(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/traction").execute(*args, **kwargs)
                        def periodic(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/periodic").execute(*args, **kwargs)
                        def internal(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/internal").execute(*args, **kwargs)
                        def wall(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/wall").execute(*args, **kwargs)
                        def interior(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/interior").execute(*args, **kwargs)
                        def outlet(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/outlet").execute(*args, **kwargs)
                        def axis(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/axis").execute(*args, **kwargs)

            class windows(TUIMenu):
                """
                Enter the window options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.scale = self.__class__.scale(path + ["scale"], service)
                    self.text = self.__class__.text(path + ["text"], service)
                    self.xy = self.__class__.xy(path + ["xy"], service)
                    self.main = self.__class__.main(path + ["main"], service)
                    self.axes = self.__class__.axes(path + ["axes"], service)
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def aspect_ratio(self, *args, **kwargs):
                    """
                    Sets the aspect ratio of the active window.
                    """
                    return PyMenu(self.service, "/display/set/windows/aspect_ratio").execute(*args, **kwargs)
                def logo_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/set/windows/logo_color").execute(*args, **kwargs)
                def logo(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/set/windows/logo").execute(*args, **kwargs)
                def ruler(self, *args, **kwargs):
                    """
                    Turns the ruler on/off. Note that if you are running Fluent in 3D, then the view must be set toorthographic.
                    """
                    return PyMenu(self.service, "/display/set/windows/ruler").execute(*args, **kwargs)

                class scale(TUIMenu):
                    """
                    Enters the color scale window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/top").execute(*args, **kwargs)
                    def margin(self, *args, **kwargs):
                        """
                        Sets the margin of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/margin").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/visible").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/bottom").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/right").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/border").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Sets the number format of the color scale window (for example, percentage0.2e).
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/format").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/left").execute(*args, **kwargs)
                    def font_size(self, *args, **kwargs):
                        """
                        Sets the font size of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/font_size").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Sets the transparency of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/clear").execute(*args, **kwargs)

                class text(TUIMenu):
                    """
                    Enters the text window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/top").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/border").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/visible").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Enables/disables the transparency of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/clear").execute(*args, **kwargs)
                    def application(self, *args, **kwargs):
                        """
                        Shows or hides the application name in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/application").execute(*args, **kwargs)
                    def alignment(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/display/set/windows/text/alignment").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/bottom").execute(*args, **kwargs)
                    def company(self, *args, **kwargs):
                        """
                        Shows or hides the company name in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/company").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/right").execute(*args, **kwargs)
                    def date(self, *args, **kwargs):
                        """
                        Shows or hides the date in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/date").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/left").execute(*args, **kwargs)

                class xy(TUIMenu):
                    """
                    Enters the XY plot window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/visible").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/top").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/left").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/border").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/bottom").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/right").execute(*args, **kwargs)

                class main(TUIMenu):
                    """
                    Enters the main view window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/top").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/right").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/visible").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/bottom").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/left").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/border").execute(*args, **kwargs)

                class axes(TUIMenu):
                    """
                    Enters the axes window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/bottom").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/visible").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/border").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Sets the transparency of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/clear").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/right").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Contains options for modifying a video. This menu is not relevant for the meshing mode.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pixel_size(self, *args, **kwargs):
                        """
                        Sets the window size in pixels.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/pixel_size").execute(*args, **kwargs)
                    def color_filter(self, *args, **kwargs):
                        """
                        Sets the video color filter. For example, to change the color filter from its default setting  to PAL video with a saturation of 80percentage and a brightness of 90percentage, you would  enter "video=pal,sat=.8,gain=.9" after selecting the color-filter command.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/color_filter").execute(*args, **kwargs)
                    def foreground(self, *args, **kwargs):
                        """
                        Sets the foreground (text) color of the graphics window. The color is specified as a string of three comma-separated numbers between 0 and 1, representing red, green, and blue. For example, to change the foreground from white (default) to gray, you would enter ".5,.5,.5" after selecting the foreground command.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/foreground").execute(*args, **kwargs)
                    def on(self, *args, **kwargs):
                        """
                        Enables or disables the video picture settings.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/on").execute(*args, **kwargs)
                    def background(self, *args, **kwargs):
                        """
                        Sets the background color of the graphics window. The color is specified as a string of three comma-separated numbers between 0 and 1, representing red, green, and blue. For example, to change the background from black (default) to gray, you would enter ".5,.5,.5" after selecting the background command.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/background").execute(*args, **kwargs)

            class titles(TUIMenu):
                """
                Set problem title.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def right_top(self, *args, **kwargs):
                    """
                    Set the title text for right top in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_top").execute(*args, **kwargs)
                def right_bottom(self, *args, **kwargs):
                    """
                    Set the title text for right bottom in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_bottom").execute(*args, **kwargs)
                def left_bottom(self, *args, **kwargs):
                    """
                    Set the title text for left bottom in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/left_bottom").execute(*args, **kwargs)
                def right_middle(self, *args, **kwargs):
                    """
                    Set the title text for right middle in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_middle").execute(*args, **kwargs)
                def left_top(self, *args, **kwargs):
                    """
                    Set the title text for left top in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/left_top").execute(*args, **kwargs)

            class rendering_options(TUIMenu):
                """
                Enter the rendering options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def driver(self, *args, **kwargs):
                    """
                    Change the current graphics driver.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/driver").execute(*args, **kwargs)
                def surface_edge_visibility(self, *args, **kwargs):
                    """
                    Set edge visibility flags for surfaces.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/surface_edge_visibility").execute(*args, **kwargs)
                def device_info(self, *args, **kwargs):
                    """
                    List information for the graphics device.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/device_info").execute(*args, **kwargs)
                def color_map_alignment(self, *args, **kwargs):
                    """
                    Set the color bar alignment.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/color_map_alignment").execute(*args, **kwargs)
                def hidden_lines(self, *args, **kwargs):
                    """
                    Enable/disable hidden line removal.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_lines").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    Enable/Disable colormap.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/show_colormap").execute(*args, **kwargs)
                def set_rendering_options(self, *args, **kwargs):
                    """
                    Set the rendering options.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/set_rendering_options").execute(*args, **kwargs)
                def hidden_surfaces(self, *args, **kwargs):
                    """
                    Enable/disable hidden surface removal.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                def animation_option(self, *args, **kwargs):
                    """
                    Using Wireframe / All option during animation.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/animation_option").execute(*args, **kwargs)
                def hidden_surface_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line and hidden surface rendering.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                def face_displacement(self, *args, **kwargs):
                    """
                    Set face displacement value in Z-buffer units along the Camera Z-axis.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/face_displacement").execute(*args, **kwargs)
                def double_buffering(self, *args, **kwargs):
                    """
                    Enable/disable double-buffering.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/double_buffering").execute(*args, **kwargs)
                def outer_face_cull(self, *args, **kwargs):
                    """
                    Enable/disable discarding outer faces during display.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/outer_face_cull").execute(*args, **kwargs)
                def help_text_color(self, *args, **kwargs):
                    """
                    Set the color of screen help text.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/help_text_color").execute(*args, **kwargs)
                def auto_spin(self, *args, **kwargs):
                    """
                    Enable/disable mouse view rotations to continue to spin the display after the button is released.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/auto_spin").execute(*args, **kwargs)
                def hidden_line_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line rendering.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_line_method").execute(*args, **kwargs)

            class path_lines(TUIMenu):
                """
                Sets parameters for display of pathlines.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def maximum_steps(self, *args, **kwargs):
                    """
                    Sets the maximum number of steps to take for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/maximum_steps").execute(*args, **kwargs)
                def maximum_error(self, *args, **kwargs):
                    """
                    Sets the maximum error allowed while computing the pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/maximum_error").execute(*args, **kwargs)
                def twist_factor(self, *args, **kwargs):
                    """
                    Sets the scale factor for twisting (ribbons only).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/twist_factor").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Selects the pathline style (line, point, ribbon, triangle, cylinder).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/style").execute(*args, **kwargs)
                def track_in_phase(self, *args, **kwargs):
                    """
                    Selects the phase in which particle pathlines will be computed (Multiphase Eulerian Model only).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/track_in_phase").execute(*args, **kwargs)
                def line_width(self, *args, **kwargs):
                    """
                    Sets the width for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/line_width").execute(*args, **kwargs)
                def radius(self, *args, **kwargs):
                    """
                    Sets the radius for pathline (ribbons/cylinder only) cross-section.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/radius").execute(*args, **kwargs)
                def relative_pathlines(self, *args, **kwargs):
                    """
                    Enables/disables the tracking of pathlines in a relative coordinate system.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/relative_pathlines").execute(*args, **kwargs)
                def error_control(self, *args, **kwargs):
                    """
                    Sets error control during pathline computation.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/error_control").execute(*args, **kwargs)
                def marker_size(self, *args, **kwargs):
                    """
                    Sets the marker size for particle drawing.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/marker_size").execute(*args, **kwargs)
                def reverse(self, *args, **kwargs):
                    """
                    Sets direction of path tracking.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/reverse").execute(*args, **kwargs)
                def step_size(self, *args, **kwargs):
                    """
                    Sets the step length between particle positions for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/step_size").execute(*args, **kwargs)
                def display_steps(self, *args, **kwargs):
                    """
                    Sets the display stepping for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/display_steps").execute(*args, **kwargs)
                def arrow_scale(self, *args, **kwargs):
                    """
                    Sets the scale factor for arrows drawn on pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/arrow_scale").execute(*args, **kwargs)
                def sphere_attrib(self, *args, **kwargs):
                    """
                    Specifies the size and number of slices to be used in drawing spheres.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/sphere_attrib").execute(*args, **kwargs)
                def arrow_space(self, *args, **kwargs):
                    """
                    Sets the spacing factor for arrows drawn on pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/arrow_space").execute(*args, **kwargs)

            class contours(TUIMenu):
                """
                Enters the contour options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def n_contour(self, *args, **kwargs):
                    """
                    Sets the number of contour levels.
                    """
                    return PyMenu(self.service, "/display/set/contours/n_contour").execute(*args, **kwargs)
                def coloring(self, *args, **kwargs):
                    """
                    Specifies whether contours are displayed in bands or with smooth transitions. Note that you can only display smooth contours if node-values are enabled.
                    """
                    return PyMenu(self.service, "/display/set/contours/coloring").execute(*args, **kwargs)
                def line_contours(self, *args, **kwargs):
                    """
                    Turns the line contours option on/off (deselects filled-contours?).
                    """
                    return PyMenu(self.service, "/display/set/contours/line_contours").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Enables/disables auto-computation of the contour range.
                    """
                    return PyMenu(self.service, "/display/set/contours/auto_range").execute(*args, **kwargs)
                def surfaces(self, *args, **kwargs):
                    """
                    Sets the surfaces on which contours are drawn. You can include a wildcard (\*) within the surface names.
                    """
                    return PyMenu(self.service, "/display/set/contours/surfaces").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    Specifies a decimal or logarithmic color scale for contours.
                    """
                    return PyMenu(self.service, "/display/set/contours/log_scale").execute(*args, **kwargs)
                def clip_to_range(self, *args, **kwargs):
                    """
                    Turns the clip to range option for filled contours on/off.
                    """
                    return PyMenu(self.service, "/display/set/contours/clip_to_range").execute(*args, **kwargs)
                def render_mesh(self, *args, **kwargs):
                    """
                    Determines whether or not to render the mesh on top of contours, vectors, and so on.
                    """
                    return PyMenu(self.service, "/display/set/contours/render_mesh").execute(*args, **kwargs)
                def global_range(self, *args, **kwargs):
                    """
                    Turns the global range for contours on/off.
                    """
                    return PyMenu(self.service, "/display/set/contours/global_range").execute(*args, **kwargs)
                def filled_contours(self, *args, **kwargs):
                    """
                    Turns the filled contours option on/off (deselects line-contours?).
                    """
                    return PyMenu(self.service, "/display/set/contours/filled_contours").execute(*args, **kwargs)
                def node_values(self, *args, **kwargs):
                    """
                    Sets the option to use scalar field at nodes when computing the contours.
                    """
                    return PyMenu(self.service, "/display/set/contours/node_values").execute(*args, **kwargs)

            class velocity_vectors(TUIMenu):
                """
                Enters the menu to set parameters for display of velocity vectors.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def in_plane(self, *args, **kwargs):
                    """
                    Toggles the display of velocity vector components in the plane of the surface selected for display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/in_plane").execute(*args, **kwargs)
                def scale_head(self, *args, **kwargs):
                    """
                    Sets the value by which the vector head will be scaled.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/scale_head").execute(*args, **kwargs)
                def surfaces(self, *args, **kwargs):
                    """
                    Sets surfaces on which vectors are drawn. You can include a wildcard (\*) within the surface names.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/surfaces").execute(*args, **kwargs)
                def relative(self, *args, **kwargs):
                    """
                    Toggles the display of relative velocity vectors.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/relative").execute(*args, **kwargs)
                def node_values(self, *args, **kwargs):
                    """
                    Enables/disables the plotting of node values. Cell values will be plotted if "no".
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/node_values").execute(*args, **kwargs)
                def auto_scale(self, *args, **kwargs):
                    """
                    Auto-scales all vectors so that vector overlap is minimal.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/auto_scale").execute(*args, **kwargs)
                def color_levels(self, *args, **kwargs):
                    """
                    Sets the number of colors used from the colormap.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/color_levels").execute(*args, **kwargs)
                def component_x(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_x").execute(*args, **kwargs)
                def constant_length(self, *args, **kwargs):
                    """
                    Sets the option to draw velocity vectors of constant length. This shows only the direction of the velocity vectors.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/constant_length").execute(*args, **kwargs)
                def scale(self, *args, **kwargs):
                    """
                    Sets the value by which the vector length will be scaled.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/scale").execute(*args, **kwargs)
                def component_y(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_y").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    Toggles whether color scale is logarithmic or linear.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/log_scale").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Specifies the vector style that will be used when the vectors are displayed. You can choose from:3d arrow,3d arrowhead, cone,filled-arrow, arrow,harpoon, or headless.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/style").execute(*args, **kwargs)
                def color(self, *args, **kwargs):
                    """
                    Sets the color of all velocity vectors to the color specified. The color scale is ignored. This is useful when overlaying a vector plot over a contour plot.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/color").execute(*args, **kwargs)
                def component_z(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_z").execute(*args, **kwargs)
                def global_range(self, *args, **kwargs):
                    """
                    Turns global range for vectors on/off.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/global_range").execute(*args, **kwargs)
                def render_mesh(self, *args, **kwargs):
                    """
                    Enables/disables rendering the mesh on top of contours, vectors, and so on.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/render_mesh").execute(*args, **kwargs)

            class particle_tracks(TUIMenu):
                """
                Enters the particle-tracks menu to set parameters for display of particle tracks.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                    self.sphere_settings = self.__class__.sphere_settings(path + ["sphere_settings"], service)
                    self.filter_settings = self.__class__.filter_settings(path + ["filter_settings"], service)
                    super().__init__(path, service)
                def report_variables(self, *args, **kwargs):
                    """
                    Sets the report variables.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_variables").execute(*args, **kwargs)
                def arrow_space(self, *args, **kwargs):
                    """
                    Sets the spacing factor for arrows drawn on particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/arrow_space").execute(*args, **kwargs)
                def history_filename(self, *args, **kwargs):
                    """
                    Specifies the name of the particle history file.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/history_filename").execute(*args, **kwargs)
                def report_to(self, *args, **kwargs):
                    """
                    Specifies the destination for the report (console, file, none).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_to").execute(*args, **kwargs)
                def sphere_attrib(self, *args, **kwargs):
                    """
                    Specifies the size and number of slices to be used in drawing spheres.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/sphere_attrib").execute(*args, **kwargs)
                def twist_factor(self, *args, **kwargs):
                    """
                    Sets the scale factor for twisting (ribbons only).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/twist_factor").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Sets the display style for particle track (line/ribbon/cylinder/sphere).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/style").execute(*args, **kwargs)
                def arrow_scale(self, *args, **kwargs):
                    """
                    Sets the scale factor for arrows drawn on particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/arrow_scale").execute(*args, **kwargs)
                def report_default_variables(self, *args, **kwargs):
                    """
                    Sets the report variables to default.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_default_variables").execute(*args, **kwargs)
                def coarsen_factor(self, *args, **kwargs):
                    """
                    Sets the coarsening factor for particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/coarsen_factor").execute(*args, **kwargs)
                def radius(self, *args, **kwargs):
                    """
                    Sets the radius for particle track (ribbon/cylinder only) cross-section.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/radius").execute(*args, **kwargs)
                def report_type(self, *args, **kwargs):
                    """
                    Sets the report type for particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_type").execute(*args, **kwargs)
                def particle_skip(self, *args, **kwargs):
                    """
                    Specifies how many particle tracks should be displayed.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/particle_skip").execute(*args, **kwargs)
                def marker_size(self, *args, **kwargs):
                    """
                    Sets the size of markers used to represent particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/marker_size").execute(*args, **kwargs)
                def line_width(self, *args, **kwargs):
                    """
                    Sets the width for particle track.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/line_width").execute(*args, **kwargs)
                def track_single_particle_stream(self, *args, **kwargs):
                    """
                    Specifies the stream ID to be tracked.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/track_single_particle_stream").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Determines whether particle tracks shall be displayed or only tracked.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/display").execute(*args, **kwargs)

                class vector_settings(TUIMenu):
                    """
                    Set vector specific input.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def vector_variable(self, *args, **kwargs):
                        """
                        Selects a particle vector function to specify vector direction.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_variable").execute(*args, **kwargs)
                    def vector_length(self, *args, **kwargs):
                        """
                        Specifies the length of constant vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_length").execute(*args, **kwargs)
                    def style(self, *args, **kwargs):
                        """
                        Enables and sets the display style for particle vectors (none/vector/centered-vector/centered-cylinder).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/style").execute(*args, **kwargs)
                    def color_variable(self, *args, **kwargs):
                        """
                        Specifies whether the vectors should be colored by variable specified in /display/particle-track/particle-track (if false use a constant color).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/color_variable").execute(*args, **kwargs)
                    def length_to_head_ratio(self, *args, **kwargs):
                        """
                        Specifies ratio of length to head for vectors and length to diameter for cylinders.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/length_to_head_ratio").execute(*args, **kwargs)
                    def length_variable(self, *args, **kwargs):
                        """
                        Specifies whether the displayed vectors have length varying with another variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/length_variable").execute(*args, **kwargs)
                    def constant_color(self, *args, **kwargs):
                        """
                        Specifies a constant color for the vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/constant_color").execute(*args, **kwargs)
                    def scale_factor(self, *args, **kwargs):
                        """
                        Specifies a scale factor to enlarge/reduce the length of vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/scale_factor").execute(*args, **kwargs)
                    def vector_length_variable(self, *args, **kwargs):
                        """
                        Selects a particle variable to specify the length of vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_length_variable").execute(*args, **kwargs)

                class sphere_settings(TUIMenu):
                    """
                    Provide sphere specific input.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def maximum(self, *args, **kwargs):
                        """
                        Sets the maximum value of the sphere to be displayed.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/maximum").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Sets the minimum value of the sphere to be displayed.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/minimum").execute(*args, **kwargs)
                    def size_variable(self, *args, **kwargs):
                        """
                        Selects a particle variable to size the spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/size_variable").execute(*args, **kwargs)
                    def vary_diameter(self, *args, **kwargs):
                        """
                        Specifies whether the spheres can vary with another variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/vary_diameter").execute(*args, **kwargs)
                    def diameter(self, *args, **kwargs):
                        """
                        Diameter of the spheres whenvary-diameter is disabled.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/diameter").execute(*args, **kwargs)
                    def smooth_parameter(self, *args, **kwargs):
                        """
                        Specifies number of slices to be used in drawing spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/smooth_parameter").execute(*args, **kwargs)
                    def auto_range(self, *args, **kwargs):
                        """
                        Specifies whether displayed spheres should include auto range of variable to size spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/auto_range").execute(*args, **kwargs)
                    def scale_factor(self, *args, **kwargs):
                        """
                        Specifies a scale factor to enlarge/reduce the size of spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/scale_factor").execute(*args, **kwargs)

                class filter_settings(TUIMenu):
                    """
                    Set filter for particle display.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def filter_variable(self, *args, **kwargs):
                        """
                        Selects a variable used for filtering of particles.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/filter_variable").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Specifies the upper bound for the filter variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/maximum").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Specifies the lower bound for the filter variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/minimum").execute(*args, **kwargs)
                    def enable_filtering(self, *args, **kwargs):
                        """
                        Specifies whether particle display is filtered.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/enable_filtering").execute(*args, **kwargs)
                    def inside(self, *args, **kwargs):
                        """
                        Specifies whether filter variable must be inside min/max to be displayed (else outside min/max).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/inside").execute(*args, **kwargs)

        class path_lines(TUIMenu):
            """
            Enters the pathlines menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_write_xy_plot(self, *args, **kwargs):
                """
                Plots or writes an XY plot of pathlines.
                """
                return PyMenu(self.service, "/display/path_lines/plot_write_xy_plot").execute(*args, **kwargs)
            def write_to_files(self, *args, **kwargs):
                """
                Writes pathlines to a file.
                """
                return PyMenu(self.service, "/display/path_lines/write_to_files").execute(*args, **kwargs)
            def path_lines(self, *args, **kwargs):
                """
                Displays pathlines from a surface.
                """
                return PyMenu(self.service, "/display/path_lines/path_lines").execute(*args, **kwargs)

        class update_scene(TUIMenu):
            """
            Enter the scene options menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def time(self, *args, **kwargs):
                """
                Change time-step value.
                """
                return PyMenu(self.service, "/display/update_scene/time").execute(*args, **kwargs)
            def transform(self, *args, **kwargs):
                """
                Apply transformation matrix on selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/transform").execute(*args, **kwargs)
            def pathline(self, *args, **kwargs):
                """
                Change pathline attributes.
                """
                return PyMenu(self.service, "/display/update_scene/pathline").execute(*args, **kwargs)
            def select_geometry(self, *args, **kwargs):
                """
                Select geometry to be updated.
                """
                return PyMenu(self.service, "/display/update_scene/select_geometry").execute(*args, **kwargs)
            def iso_sweep(self, *args, **kwargs):
                """
                Change iso-sweep values.
                """
                return PyMenu(self.service, "/display/update_scene/iso_sweep").execute(*args, **kwargs)
            def set_frame(self, *args, **kwargs):
                """
                Change frame options.
                """
                return PyMenu(self.service, "/display/update_scene/set_frame").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/delete").execute(*args, **kwargs)
            def draw_frame(self, *args, **kwargs):
                """
                Enable/disable drawing of the bounding frame.
                """
                return PyMenu(self.service, "/display/update_scene/draw_frame").execute(*args, **kwargs)
            def overlays(self, *args, **kwargs):
                """
                Enable/disable the overlays option.
                """
                return PyMenu(self.service, "/display/update_scene/overlays").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/display").execute(*args, **kwargs)

        class flamelet_data(TUIMenu):
            """
            Displays flamelet data.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def draw_number_box(self, *args, **kwargs):
                """
                Enables/disables display of the numbers box.
                """
                return PyMenu(self.service, "/display/flamelet_data/draw_number_box").execute(*args, **kwargs)
            def carpet_plot(self, *args, **kwargs):
                """
                Enables/disables display of carpet plot of a property.
                """
                return PyMenu(self.service, "/display/flamelet_data/carpet_plot").execute(*args, **kwargs)
            def plot_1d_slice(self, *args, **kwargs):
                """
                Enables/disables plot of the 1D-slice.
                """
                return PyMenu(self.service, "/display/flamelet_data/plot_1d_slice").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Enables/disables writing the 1D-slice to file instead of plot.
                """
                return PyMenu(self.service, "/display/flamelet_data/write_to_file").execute(*args, **kwargs)

        class views(TUIMenu):
            """
            Enter the view manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.display_states = self.__class__.display_states(path + ["display_states"], service)
                self.camera = self.__class__.camera(path + ["camera"], service)
                super().__init__(path, service)
            def next_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/display/views/next_view").execute(*args, **kwargs)
            def save_view(self, *args, **kwargs):
                """
                Saves the currently displayed view into the list of stored views.
                """
                return PyMenu(self.service, "/display/views/save_view").execute(*args, **kwargs)
            def default_view(self, *args, **kwargs):
                """
                Resets the view to front and center.
                """
                return PyMenu(self.service, "/display/views/default_view").execute(*args, **kwargs)
            def list_views(self, *args, **kwargs):
                """
                Lists all predefined and saved views.
                """
                return PyMenu(self.service, "/display/views/list_views").execute(*args, **kwargs)
            def delete_view(self, *args, **kwargs):
                """
                Deletes a particular view from the list of stored views.
                """
                return PyMenu(self.service, "/display/views/delete_view").execute(*args, **kwargs)
            def write_views(self, *args, **kwargs):
                """
                Writes views to an external view file.
                """
                return PyMenu(self.service, "/display/views/write_views").execute(*args, **kwargs)
            def restore_view(self, *args, **kwargs):
                """
                Sets the current view to one of the stored views.
                """
                return PyMenu(self.service, "/display/views/restore_view").execute(*args, **kwargs)
            def last_view(self, *args, **kwargs):
                """
                Returns to the camera position before the last manipulation.
                """
                return PyMenu(self.service, "/display/views/last_view").execute(*args, **kwargs)
            def auto_scale(self, *args, **kwargs):
                """
                Scales and centers the current scene without changing its orientation.
                """
                return PyMenu(self.service, "/display/views/auto_scale").execute(*args, **kwargs)
            def read_views(self, *args, **kwargs):
                """
                Reads views from an external view file.
                """
                return PyMenu(self.service, "/display/views/read_views").execute(*args, **kwargs)

            class display_states(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/list").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Rename object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/rename").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/delete").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/write").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/read").execute(*args, **kwargs)
                def restore_state(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/restore_state").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/copy").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit display-states object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/edit").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Create a new display-states object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/new").execute(*args, **kwargs)
                def use_active(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/use_active").execute(*args, **kwargs)

            class camera(TUIMenu):
                """
                Contains commands to set the camera options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def up_vector(self, *args, **kwargs):
                    """
                    Sets the camera up-vector.
                    """
                    return PyMenu(self.service, "/display/views/camera/up_vector").execute(*args, **kwargs)
                def orbit_camera(self, *args, **kwargs):
                    """
                    Enables you to move the camera around the target. Gives the effect of circling around the target.
                    """
                    return PyMenu(self.service, "/display/views/camera/orbit_camera").execute(*args, **kwargs)
                def position(self, *args, **kwargs):
                    """
                    Sets the camera position.
                    """
                    return PyMenu(self.service, "/display/views/camera/position").execute(*args, **kwargs)
                def target(self, *args, **kwargs):
                    """
                    Sets the point the camera will look at.
                    """
                    return PyMenu(self.service, "/display/views/camera/target").execute(*args, **kwargs)
                def pan_camera(self, *args, **kwargs):
                    """
                    Gives you the effect of sweeping the camera across the scene. The camera remains at its position but its target changes.
                    """
                    return PyMenu(self.service, "/display/views/camera/pan_camera").execute(*args, **kwargs)
                def roll_camera(self, *args, **kwargs):
                    """
                    Lets you adjust the camera up-vector.
                    """
                    return PyMenu(self.service, "/display/views/camera/roll_camera").execute(*args, **kwargs)
                def field(self, *args, **kwargs):
                    """
                    Enables you to set the field of view (width and height) of the scene.
                    """
                    return PyMenu(self.service, "/display/views/camera/field").execute(*args, **kwargs)
                def projection(self, *args, **kwargs):
                    """
                    Lets you switch between perspective and orthographic views.
                    """
                    return PyMenu(self.service, "/display/views/camera/projection").execute(*args, **kwargs)
                def dolly_camera(self, *args, **kwargs):
                    """
                    Enables you to move the camera left, right, up, down, in, and out.
                    """
                    return PyMenu(self.service, "/display/views/camera/dolly_camera").execute(*args, **kwargs)
                def zoom_camera(self, *args, **kwargs):
                    """
                    Adjusts the camera’s field of view. This operation is similar to dollying the camera in or out of the scene. Dollying causes objects in front to move past you. Zooming changes the perspective effect in the scene (and can be disconcerting).
                    """
                    return PyMenu(self.service, "/display/views/camera/zoom_camera").execute(*args, **kwargs)

    class turbo_workflow(TUIMenu):
        """
        Enter the turbo workflow menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.workflow = self.__class__.workflow(path + ["workflow"], service)
            super().__init__(path, service)

        class workflow(TUIMenu):
            """
            Enter the workflow menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def reset(self, *args, **kwargs):
                """
                Reset the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/reset").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/enable").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/disable").execute(*args, **kwargs)

    class report(TUIMenu):
        """
        Enter the report menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.modified_setting = self.__class__.modified_setting(path + ["modified_setting"], service)
            self.icing = self.__class__.icing(path + ["icing"], service)
            self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
            self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
            self.system = self.__class__.system(path + ["system"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
            self.forces = self.__class__.forces(path + ["forces"], service)
            self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
            self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
            super().__init__(path, service)
        def dpm_summary(self, *args, **kwargs):
            """
            Prints discrete phase summary report.
            """
            return PyMenu(self.service, "/report/dpm_summary").execute(*args, **kwargs)
        def write_histogram(self, *args, **kwargs):
            """
            Write a histogram of a scalar quantity to a file.
            """
            return PyMenu(self.service, "/report/write_histogram").execute(*args, **kwargs)
        def dpm_sample(self, *args, **kwargs):
            """
            Samples trajectories at boundaries and lines/planes.
            """
            return PyMenu(self.service, "/report/dpm_sample").execute(*args, **kwargs)
        def summary(self, *args, **kwargs):
            """
            Prints the current settings for physical models, boundary conditions, material properties, and solution parameters.
            """
            return PyMenu(self.service, "/report/summary").execute(*args, **kwargs)
        def dpm_extended_summary(self, *args, **kwargs):
            """
            Create an extended discrete phase summary report of the discrete phase injection(s). You can choose whether you want to save the extended report to a file or print it in the console window. For unsteady tracking, you will be asked whether you want to include in-domain particle/tracks in the report. You will be also prompted whether you want to select a single injection for the summary report. By default, all injections are included. The output depends on whether you have enabled the report/dpm-zone-summaries-per-injection? text command, in which case additional information is printed for escaped particles, such as per-injection data. Note that, for unsteady particle tracking, it is necessary to enable the report/dpm-zone-summaries-per-injection? text command before any particle parcels are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_extended_summary").execute(*args, **kwargs)
        def species_mass_flow(self, *args, **kwargs):
            """
            Prints list of species mass flow rate at inlets and outlets. This reports the mass flow rates of all species (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/species_mass_flow").execute(*args, **kwargs)
        def print_histogram(self, *args, **kwargs):
            """
            Prints a histogram of a scalar quantity.
            """
            return PyMenu(self.service, "/report/print_histogram").execute(*args, **kwargs)
        def element_mass_flow(self, *args, **kwargs):
            """
            Prints list of element flow rate at inlets and outlets. This reports the mass flow rates of all chemical elements (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/element_mass_flow").execute(*args, **kwargs)
        def mphase_summary(self, *args, **kwargs):
            """
            Prints summary report for a multiphase case setup.
            """
            return PyMenu(self.service, "/report/mphase_summary").execute(*args, **kwargs)
        def path_line_summary(self, *args, **kwargs):
            """
            Prints pathline summary report.
            """
            return PyMenu(self.service, "/report/path_line_summary").execute(*args, **kwargs)
        def dpm_sample_output_udf(self, *args, **kwargs):
            """
            Allows you to hook a previously loaded DEFINE_DPM_OUTPUT UDF for file format specification for sampling of trajectories and VOF-to-DPM lump conversion transcripts.
            """
            return PyMenu(self.service, "/report/dpm_sample_output_udf").execute(*args, **kwargs)
        def particle_summary(self, *args, **kwargs):
            """
            Prints summary report for all current particles.
            """
            return PyMenu(self.service, "/report/particle_summary").execute(*args, **kwargs)
        def aero_optical_distortions(self, *args, **kwargs):
            """
            Optics report menu.
            """
            return PyMenu(self.service, "/report/aero_optical_distortions").execute(*args, **kwargs)
        def uds_flow(self, *args, **kwargs):
            """
            Prints list of user-defined scalar flow rate at boundaries.
            """
            return PyMenu(self.service, "/report/uds_flow").execute(*args, **kwargs)
        def surface_integrals(self, *args, **kwargs):
            """
            Enters the surface integral menu.
            """
            return PyMenu(self.service, "/report/surface_integrals").execute(*args, **kwargs)
        def volume_integrals(self, *args, **kwargs):
            """
            Enters the volume integral menu.
            """
            return PyMenu(self.service, "/report/volume_integrals").execute(*args, **kwargs)
        def projected_surface_area(self, *args, **kwargs):
            """
            Computes the area of the projection of selected surfaces along the  ,  , or   axis.
            """
            return PyMenu(self.service, "/report/projected_surface_area").execute(*args, **kwargs)
        def dpm_zone_summaries_per_injection(self, *args, **kwargs):
            """
            Enables/disables calculation of the escaped mass per injection. Note that for unsteady particle tracking, if you want to report the mass of escaped particles per injection, this text command must be enabled before any particles are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
        def dpm_sample_sort_file(self, *args, **kwargs):
            """
            Enables/disables writing of sorted DPM sample files.
            """
            return PyMenu(self.service, "/report/dpm_sample_sort_file").execute(*args, **kwargs)

        class modified_setting(TUIMenu):
            """
            Enter the modified settings menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def modified_setting(self, *args, **kwargs):
                """
                Specify which areas of setup will be checked for non-default settings for generating the Modified Settings Summary table. The table is displayed tabbed with the graphics window.
                """
                return PyMenu(self.service, "/report/modified_setting/modified_setting").execute(*args, **kwargs)
            def write_user_setting(self, *args, **kwargs):
                """
                Write the contents of the Modified Settings Summary table to a file.
                """
                return PyMenu(self.service, "/report/modified_setting/write_user_setting").execute(*args, **kwargs)

        class icing(TUIMenu):
            """
            Icing reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def mass_of_water_impinged(self, *args, **kwargs):
                """
                Print Mass of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/mass_of_water_impinged").execute(*args, **kwargs)
            def mass_of_ice(self, *args, **kwargs):
                """
                Print Mass of Ice Accretion.
                """
                return PyMenu(self.service, "/report/icing/mass_of_ice").execute(*args, **kwargs)
            def energy_of_ice_formation(self, *args, **kwargs):
                """
                Print Energy of Ice Formation.
                """
                return PyMenu(self.service, "/report/icing/energy_of_ice_formation").execute(*args, **kwargs)
            def particles_droplets_collection_eff(self, *args, **kwargs):
                """
                Print Droplets Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
            def energy_of_water_impinged(self, *args, **kwargs):
                """
                Print Energy of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
            def icing_energy_of_conduction(self, *args, **kwargs):
                """
                Print Energy of Conduction.
                """
                return PyMenu(self.service, "/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)
            def particles_crystals_collection_eff(self, *args, **kwargs):
                """
                Print Crystals Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)

        class simulation_reports(TUIMenu):
            """
            Enter the simulation reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                super().__init__(path, service)
            def duplicate_simulation_report(self, *args, **kwargs):
                """
                Duplicate a report and all of its settings to a new report.
                """
                return PyMenu(self.service, "/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
            def list_simulation_reports(self, *args, **kwargs):
                """
                List all report names.
                """
                return PyMenu(self.service, "/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
            def generate_simulation_report(self, *args, **kwargs):
                """
                Generate a new simulation report or regenerate an existing simulation report with the provided name.
                """
                return PyMenu(self.service, "/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
            def read_simulation_report_template_file(self, *args, **kwargs):
                """
                Read a JSON template file with existing Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
            def write_report_names_to_file(self, *args, **kwargs):
                """
                Write the list of currently generated report names to a txt file.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
            def reset_report_to_defaults(self, *args, **kwargs):
                """
                Reset all report settings to default for the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
            def rename_simulation_report(self, *args, **kwargs):
                """
                Rename a report which has already been generated.
                """
                return PyMenu(self.service, "/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
            def export_simulation_report_as_html(self, *args, **kwargs):
                """
                Export the provided simulation report as HTML.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
            def delete_simulation_report(self, *args, **kwargs):
                """
                Delete the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
            def export_simulation_report_as_pdf(self, *args, **kwargs):
                """
                Export the provided simulation report as a PDF file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
            def write_simulation_report_template_file(self, *args, **kwargs):
                """
                Write a JSON template file with this case's Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
            def export_simulation_report_as_pptx(self, *args, **kwargs):
                """
                Export the provided simulation report as a PPT file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)
            def view_simulation_report(self, *args, **kwargs):
                """
                View a simulation report that has already been generated. In batch mode this will print the report's URL.
                """
                return PyMenu(self.service, "/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)

            class parametric_study(TUIMenu):
                """
                Enter the parametric study menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def generate_design_point_report(self, *args, **kwargs):
                    """
                    Generate a simulation report for an updated design point.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
                def generate_parametric_report(self, *args, **kwargs):
                    """
                    Generate a parametric report for your study.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

        class fluxes(TUIMenu):
            """
            Enters the fluxes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def viscous_work(self, *args, **kwargs):
                """
                Prints the viscous work rate at the boundaries. This text command is only available when the energy equation is enabled and the pressure-based solver is selected.
                """
                return PyMenu(self.service, "/report/fluxes/viscous_work").execute(*args, **kwargs)
            def pressure_work(self, *args, **kwargs):
                """
                Prints the pressure work rate at the boundaries. This text command is only available when the energy equation is enabled, the absolute velocity formulation is selected, and zone motion is enabled for a fluid cell zone.
                """
                return PyMenu(self.service, "/report/fluxes/pressure_work").execute(*args, **kwargs)
            def film_mass_flow(self, *args, **kwargs):
                """
                Prints wall film mass flow rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_mass_flow").execute(*args, **kwargs)
            def heat_transfer_sensible(self, *args, **kwargs):
                """
                Prints the sensible heat transfer rate at the boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)
            def heat_transfer(self, *args, **kwargs):
                """
                Prints heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer").execute(*args, **kwargs)
            def film_heat_transfer(self, *args, **kwargs):
                """
                Prints wall film heat transfer rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
            def mass_flow(self, *args, **kwargs):
                """
                Prints mass flow rate at inlets and outlets.
                """
                return PyMenu(self.service, "/report/fluxes/mass_flow").execute(*args, **kwargs)
            def rad_heat_trans(self, *args, **kwargs):
                """
                Prints radiation heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/rad_heat_trans").execute(*args, **kwargs)

        class system(TUIMenu):
            """
            Enters the system menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def proc_stats(self, *args, **kwargs):
                """
                Prints ANSYS Fluent process information. This is used to report the memory usage of each of the ANSYS Fluent processes.
                """
                return PyMenu(self.service, "/report/system/proc_stats").execute(*args, **kwargs)
            def gpgpu_stats(self, *args, **kwargs):
                """
                Prints information about installed general purpose graphical processing units.
                """
                return PyMenu(self.service, "/report/system/gpgpu_stats").execute(*args, **kwargs)
            def sys_stats(self, *args, **kwargs):
                """
                System information. This is used to report the CPU configuration of the machines where ANSYS Fluent processes have been spawned.
                """
                return PyMenu(self.service, "/report/system/sys_stats").execute(*args, **kwargs)
            def time_stats(self, *args, **kwargs):
                """
                Timer information. This is used to report CPU timings for user and kernel processes and detailed solver timings.
                """
                return PyMenu(self.service, "/report/system/time_stats").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Enters the reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def enthalpy(self, *args, **kwargs):
                """
                Sets reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/report/reference_values/enthalpy").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Sets reference density for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/density").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Sets reference viscosity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/viscosity").execute(*args, **kwargs)
            def yplus(self, *args, **kwargs):
                """
                Sets reference yplus for calculation of Yplus Based Heat Transfer Coefficient.
                """
                return PyMenu(self.service, "/report/reference_values/yplus").execute(*args, **kwargs)
            def temperature(self, *args, **kwargs):
                """
                Sets reference temperature for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/temperature").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists current reference values.
                """
                return PyMenu(self.service, "/report/reference_values/list").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Sets reference length for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/length").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Sets reference zone.
                """
                return PyMenu(self.service, "/report/reference_values/zone").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Sets reference velocity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/velocity").execute(*args, **kwargs)
            def pressure(self, *args, **kwargs):
                """
                Sets reference pressure for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/pressure").execute(*args, **kwargs)
            def area(self, *args, **kwargs):
                """
                Sets reference area for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/area").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Sets reference depth for volume calculation.
                """
                return PyMenu(self.service, "/report/reference_values/depth").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Computes reference values from zone boundary conditions.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/wall").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/axis").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/degassing").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network_end").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/periodic").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interior").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fluid").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/solid").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/shadow").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outflow").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/radiator").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interface").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fan").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/geometry").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/overset").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)

        class population_balance(TUIMenu):
            """
            Population Balance menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def number_density(self, *args, **kwargs):
                """
                Set number density functions.
                """
                return PyMenu(self.service, "/report/population_balance/number_density").execute(*args, **kwargs)
            def moments(self, *args, **kwargs):
                """
                Set moments for population balance.
                """
                return PyMenu(self.service, "/report/population_balance/moments").execute(*args, **kwargs)

        class forces(TUIMenu):
            """
            Enters the forces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def wall_moments(self, *args, **kwargs):
                """
                Computes the moments about the specified moment center for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_moments").execute(*args, **kwargs)
            def wall_forces(self, *args, **kwargs):
                """
                Computes the forces along the specified force vector for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_forces").execute(*args, **kwargs)
            def pressure_center(self, *args, **kwargs):
                """
                Prints the center of pressure on wall zones.
                """
                return PyMenu(self.service, "/report/forces/pressure_center").execute(*args, **kwargs)

        class dpm_histogram(TUIMenu):
            """
            Enters the DPM histogram menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def delete_sample(self, *args, **kwargs):
                """
                Deletes a sample from the loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/delete_sample").execute(*args, **kwargs)
            def list_samples(self, *args, **kwargs):
                """
                Shows all samples in a loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/list_samples").execute(*args, **kwargs)
            def compute_sample(self, *args, **kwargs):
                """
                Computes the minimum/maximum of a sample variable.
                """
                return PyMenu(self.service, "/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
            def read_sample(self, *args, **kwargs):
                """
                Reads a sample file and adds it to the sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/read_sample").execute(*args, **kwargs)
            def prep_dpm_sample_cont_plot_exprs(self, *args, **kwargs):
                """
                Prepare named expressions from data in a DPM sample file (collected at a cut plane surface) for contour plotting.
                """
                return PyMenu(self.service, "/report/dpm_histogram/prep_dpm_sample_cont_plot_exprs").execute(*args, **kwargs)
            def reduce_picked_sample(self, *args, **kwargs):
                """
                Reduce a sample as specified by the data reduction parameters. This command is available only after you selected the sample using the pick-sample-to-reduce text command.
                """
                return PyMenu(self.service, "/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)
            def plot_sample(self, *args, **kwargs):
                """
                Plots a histogram of a loaded sample.
                """
                return PyMenu(self.service, "/report/dpm_histogram/plot_sample").execute(*args, **kwargs)
            def pick_sample_to_reduce(self, *args, **kwargs):
                """
                Select a sample to be reduced.
                """
                return PyMenu(self.service, "/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)
            def write_sample(self, *args, **kwargs):
                """
                Write a histogram of a loaded sample into a file.
                """
                return PyMenu(self.service, "/report/dpm_histogram/write_sample").execute(*args, **kwargs)

            class setup_reduction(TUIMenu):
                """
                Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reset_min_and_max(self, *args, **kwargs):
                    """
                    Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)
                def make_steady_from_unsteady_file(self, *args, **kwargs):
                    """
                    Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Set the minimum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                def use_weighting(self, *args, **kwargs):
                    """
                    Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)
                def all_variables_number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for ALL variables in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                def list_settings(self, *args, **kwargs):
                    """
                    List all user inputs for the sample picked for data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                def weighting_variable(self, *args, **kwargs):
                    """
                    Choose the weighting variable for the averaging in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Set the maximum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the settings menu for the histogram.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def percentage(self, *args, **kwargs):
                    """
                    Uses percentages of bins to be computed.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Specifies the minimum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Automatically computes the range of the sampling variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)
                def diameter_statistics(self, *args, **kwargs):
                    """
                    Computes the Rosin Rammler parameters, Sauter, and other mean diameters.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Enables/disables the use of logarithmic scaling on the abscissa of the histogram.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Specifies the number of bins.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)
                def variable_power_3(self, *args, **kwargs):
                    """
                    Use the cubic of the cumulation variable during computation of the cumulative curve.
                    When the particle mass was not sampled, the diameter can be used instead.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                def cumulation_curve(self, *args, **kwargs):
                    """
                    Computes a cumulative curve for the sampling variable or correlation variable when correlation? is specified.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)
                def histogram_mode(self, *args, **kwargs):
                    """
                    Uses bars for the histogram plot or xy-style.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                def weighting(self, *args, **kwargs):
                    """
                    Uses weighting with additional variables when sorting data into samples.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Specifies the maximum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                def correlation(self, *args, **kwargs):
                    """
                    Computes the correlation of the sampling variable with another variable.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/correlation").execute(*args, **kwargs)

        class heat_exchanger(TUIMenu):
            """
            Enters the heat exchanger menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def specific_heat(self, *args, **kwargs):
                """
                Prints fluid’s specific heat.
                """
                return PyMenu(self.service, "/report/heat_exchanger/specific_heat").execute(*args, **kwargs)
            def computed_heat_rejection(self, *args, **kwargs):
                """
                Prints total heat rejection.
                """
                return PyMenu(self.service, "/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)
            def outlet_temperature(self, *args, **kwargs):
                """
                Prints outlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
            def mass_flow_rate(self, *args, **kwargs):
                """
                Prints mass flow rate.
                """
                return PyMenu(self.service, "/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)
            def inlet_temperature(self, *args, **kwargs):
                """
                Prints inlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)

    class parametric_study(TUIMenu):
        """
        Enter the parametric study menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.study = self.__class__.study(path + ["study"], service)
            self.update = self.__class__.update(path + ["update"], service)
            self.design_points = self.__class__.design_points(path + ["design_points"], service)
            super().__init__(path, service)
        def delete_study(self, *args, **kwargs):
            """
            Delete Study.
            """
            return PyMenu(self.service, "/parametric_study/delete_study").execute(*args, **kwargs)
        def export_design_table(self, *args, **kwargs):
            """
            Export Design Point Table.
            """
            return PyMenu(self.service, "/parametric_study/export_design_table").execute(*args, **kwargs)
        def use_base_data(self, *args, **kwargs):
            """
            Use Base Data.
            """
            return PyMenu(self.service, "/parametric_study/use_base_data").execute(*args, **kwargs)
        def duplicate_study(self, *args, **kwargs):
            """
            Duplicate Parametric Study.
            """
            return PyMenu(self.service, "/parametric_study/duplicate_study").execute(*args, **kwargs)
        def case_settings_changed(self, *args, **kwargs):
            """
            Check if case settings are changed.
            """
            return PyMenu(self.service, "/parametric_study/case_settings_changed").execute(*args, **kwargs)
        def rename_study(self, *args, **kwargs):
            """
            Rename Study.
            """
            return PyMenu(self.service, "/parametric_study/rename_study").execute(*args, **kwargs)
        def set_as_current_study(self, *args, **kwargs):
            """
            Set As Current Study.
            """
            return PyMenu(self.service, "/parametric_study/set_as_current_study").execute(*args, **kwargs)
        def initialize(self, *args, **kwargs):
            """
            Start Parametric Study.
            """
            return PyMenu(self.service, "/parametric_study/initialize").execute(*args, **kwargs)
        def list_studies(self, *args, **kwargs):
            """
            List Studies.
            """
            return PyMenu(self.service, "/parametric_study/list_studies").execute(*args, **kwargs)
        def import_design_table(self, *args, **kwargs):
            """
            Import Design Point Table.
            """
            return PyMenu(self.service, "/parametric_study/import_design_table").execute(*args, **kwargs)

        class study(TUIMenu):
            """
            Enter the study menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def set_as_current(self, *args, **kwargs):
                """
                Set As Current Study.
                """
                return PyMenu(self.service, "/parametric_study/study/set_as_current").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List Studies.
                """
                return PyMenu(self.service, "/parametric_study/study/list").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename Study.
                """
                return PyMenu(self.service, "/parametric_study/study/rename").execute(*args, **kwargs)
            def use_base_data(self, *args, **kwargs):
                """
                Use Base Data for Current Study.
                """
                return PyMenu(self.service, "/parametric_study/study/use_base_data").execute(*args, **kwargs)
            def duplicate(self, *args, **kwargs):
                """
                Duplicate Parametric Study.
                """
                return PyMenu(self.service, "/parametric_study/study/duplicate").execute(*args, **kwargs)
            def initialize(self, *args, **kwargs):
                """
                Start Parametric Study.
                """
                return PyMenu(self.service, "/parametric_study/study/initialize").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Study.
                """
                return PyMenu(self.service, "/parametric_study/study/delete").execute(*args, **kwargs)

        class update(TUIMenu):
            """
            Enter the update menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.concurrent = self.__class__.concurrent(path + ["concurrent"], service)
                super().__init__(path, service)
            def update_current(self, *args, **kwargs):
                """
                Update Current Design Point.
                """
                return PyMenu(self.service, "/parametric_study/update/update_current").execute(*args, **kwargs)
            def print_update_method(self, *args, **kwargs):
                """
                Print update method.
                """
                return PyMenu(self.service, "/parametric_study/update/print_update_method").execute(*args, **kwargs)
            def update_all(self, *args, **kwargs):
                """
                Update All Design Points.
                """
                return PyMenu(self.service, "/parametric_study/update/update_all").execute(*args, **kwargs)
            def update_selected_design_points(self, *args, **kwargs):
                """
                Update Selected Design Points.
                """
                return PyMenu(self.service, "/parametric_study/update/update_selected_design_points").execute(*args, **kwargs)
            def set_update_method(self, *args, **kwargs):
                """
                Set update method.
                """
                return PyMenu(self.service, "/parametric_study/update/set_update_method").execute(*args, **kwargs)

            class concurrent(TUIMenu):
                """
                Enter Concurrent Update menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    self.licensing = self.__class__.licensing(path + ["licensing"], service)
                    super().__init__(path, service)
                def register_new_endpoint(self, *args, **kwargs):
                    """
                    Register a new endpoint.
                    """
                    return PyMenu(self.service, "/parametric_study/update/concurrent/register_new_endpoint").execute(*args, **kwargs)
                def delete_endpoint(self, *args, **kwargs):
                    """
                    Delete endpoint.
                    """
                    return PyMenu(self.service, "/parametric_study/update/concurrent/delete_endpoint").execute(*args, **kwargs)

                class print_to_console(TUIMenu):
                    """
                    Print to console concurrent options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def current_queue(self, *args, **kwargs):
                        """
                        Get the current queue.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/current_queue").execute(*args, **kwargs)
                    def current_endpoint(self, *args, **kwargs):
                        """
                        Get the current endpoint.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/current_endpoint").execute(*args, **kwargs)
                    def number_of_concurrent_dps(self, *args, **kwargs):
                        """
                        Print Number of Concurrent Design Points.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/number_of_concurrent_dps").execute(*args, **kwargs)
                    def number_of_cores_per_dp(self, *args, **kwargs):
                        """
                        Get Number of Cores per Design Point.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/number_of_cores_per_dp").execute(*args, **kwargs)
                    def registered_endpoints(self, *args, **kwargs):
                        """
                        List registered endpoints.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/print_to_console/registered_endpoints").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Set concurrent update options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def current_endpoint(self, *args, **kwargs):
                        """
                        Set the current endpoint.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/current_endpoint").execute(*args, **kwargs)
                    def number_of_cores_per_dp(self, *args, **kwargs):
                        """
                        Set Number of Cores per Design Point.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/number_of_cores_per_dp").execute(*args, **kwargs)
                    def number_of_concurrent_dps(self, *args, **kwargs):
                        """
                        Set Number of Concurrent Design Points.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/number_of_concurrent_dps").execute(*args, **kwargs)
                    def current_queue(self, *args, **kwargs):
                        """
                        Set the current queue.
                        """
                        return PyMenu(self.service, "/parametric_study/update/concurrent/set/current_queue").execute(*args, **kwargs)

                class licensing(TUIMenu):
                    """
                    Enter Concurrent Licensing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                        super().__init__(path, service)

                    class set(TUIMenu):
                        """
                        Enter Concurrent Licensing Menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def optislang_license_count(self, *args, **kwargs):
                            """
                            OptiSLang License Count.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/optislang_license_count").execute(*args, **kwargs)
                        def license_type(self, *args, **kwargs):
                            """
                            License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/license_type").execute(*args, **kwargs)
                        def optislang_license_type(self, *args, **kwargs):
                            """
                            OptiSLang License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/set/optislang_license_type").execute(*args, **kwargs)

                    class print_to_console(TUIMenu):
                        """
                        Print Concurrent Licensing Settings.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def optislang_license_type(self, *args, **kwargs):
                            """
                            OptiSLang License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/optislang_license_type").execute(*args, **kwargs)
                        def license_type(self, *args, **kwargs):
                            """
                            License Type.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/license_type").execute(*args, **kwargs)
                        def optislang_license_count(self, *args, **kwargs):
                            """
                            OptiSLang License Count.
                            """
                            return PyMenu(self.service, "/parametric_study/update/concurrent/licensing/print_to_console/optislang_license_count").execute(*args, **kwargs)

        class design_points(TUIMenu):
            """
            Enter the design points menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.print_to_console = self.__class__.print_to_console(path + ["print_to_console"], service)
                self.auto_create = self.__class__.auto_create(path + ["auto_create"], service)
                self.concurrent = self.__class__.concurrent(path + ["concurrent"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.table = self.__class__.table(path + ["table"], service)
                super().__init__(path, service)
            def add(self, *args, **kwargs):
                """
                Add new design point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/add").execute(*args, **kwargs)
            def duplicate(self, *args, **kwargs):
                """
                Duplicate Design Point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/duplicate").execute(*args, **kwargs)
            def load_case_data_for_current_dp(self, *args, **kwargs):
                """
                Loads relevant case/data file for current design point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/load_case_data_for_current_dp").execute(*args, **kwargs)
            def clear_data_and_edit_values(self, *args, **kwargs):
                """
                Clear Generated Data.
                """
                return PyMenu(self.service, "/parametric_study/design_points/clear_data_and_edit_values").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Design Point.
                """
                return PyMenu(self.service, "/parametric_study/design_points/delete").execute(*args, **kwargs)
            def save_journals(self, *args, **kwargs):
                """
                Save Journals.
                """
                return PyMenu(self.service, "/parametric_study/design_points/save_journals").execute(*args, **kwargs)

            class print_to_console(TUIMenu):
                """
                Enter the design points print menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def status_of_all_dps(self, *args, **kwargs):
                    """
                    Print Statuses of all Design Points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/status_of_all_dps").execute(*args, **kwargs)
                def current_dp(self, *args, **kwargs):
                    """
                    Print Name of Current Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/current_dp").execute(*args, **kwargs)
                def input_parameters_of_dp(self, *args, **kwargs):
                    """
                    Print Input Parameter Values of Current Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/input_parameters_of_dp").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    Print WriteData option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/write_data").execute(*args, **kwargs)
                def capture_simulation_report_data(self, *args, **kwargs):
                    """
                    Print Capture Simulation Report Data option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/capture_simulation_report_data").execute(*args, **kwargs)
                def output_parameters_of_dp(self, *args, **kwargs):
                    """
                    Print Output Parameter Values of Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/output_parameters_of_dp").execute(*args, **kwargs)
                def status_of_dp(self, *args, **kwargs):
                    """
                    Print Status of given DP.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/print_to_console/status_of_dp").execute(*args, **kwargs)

            class auto_create(TUIMenu):
                """
                Enter the auto-crate design points menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def get_number_of_designs(self, *args, **kwargs):
                    """
                    Get number of designs.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/get_number_of_designs").execute(*args, **kwargs)
                def set_parameter_as_active_or_inactive(self, *args, **kwargs):
                    """
                    Set the parameter as Active or Inactive.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/set_parameter_as_active_or_inactive").execute(*args, **kwargs)
                def export_designs(self, *args, **kwargs):
                    """
                    Export designs by writing a JSON file.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/export_designs").execute(*args, **kwargs)
                def create_design_points(self, *args, **kwargs):
                    """
                    Create design points automatically.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/create_design_points").execute(*args, **kwargs)
                def open_designs_in_optislang_postprocessor(self, *args, **kwargs):
                    """
                    Export designs into JSON and open this JSON into optiSLang Postprocessor.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/open_designs_in_optislang_postprocessor").execute(*args, **kwargs)
                def go_to_optislang(self, *args, **kwargs):
                    """
                    Open the optiSLang project.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/go_to_optislang").execute(*args, **kwargs)
                def list_current_settings(self, *args, **kwargs):
                    """
                    List current settings for auto-create design points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/auto_create/list_current_settings").execute(*args, **kwargs)

            class concurrent(TUIMenu):
                """
                Enter the concurrent design points menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def abort_design_point(self, *args, **kwargs):
                    """
                    Interrupt Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/abort_design_point").execute(*args, **kwargs)
                def abort_all_design_points(self, *args, **kwargs):
                    """
                    Interrupt All Design Points.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/abort_all_design_points").execute(*args, **kwargs)
                def refresh_status(self, *args, **kwargs):
                    """
                    Refresh Status.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/concurrent/refresh_status").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the design points Set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def current_dp(self, *args, **kwargs):
                    """
                    Set current design point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/current_dp").execute(*args, **kwargs)
                def input_parameters_of_dp(self, *args, **kwargs):
                    """
                    Set Input Parameter Values of Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/input_parameters_of_dp").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    Set WriteData option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/write_data").execute(*args, **kwargs)
                def capture_simulation_report_data(self, *args, **kwargs):
                    """
                    Set Capture Simulation Report Data option for Design Point.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/set/capture_simulation_report_data").execute(*args, **kwargs)

            class table(TUIMenu):
                """
                Enter the design point table menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_design_table(self, *args, **kwargs):
                    """
                    Export Design Points Table.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/table/export_design_table").execute(*args, **kwargs)
                def import_design_table(self, *args, **kwargs):
                    """
                    Import Design Points Table.
                    """
                    return PyMenu(self.service, "/parametric_study/design_points/table/import_design_table").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.vrx_sound_analysis = self.__class__.vrx_sound_analysis(path + ["vrx_sound_analysis"], service)
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            super().__init__(path, service)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)

        class vrx_sound_analysis(TUIMenu):
            """
            Ansys Sound analysis and specification.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_files(self, *args, **kwargs):
                """
                Write Ansys Sound out files.
                """
                return PyMenu(self.service, "/plot/vrx_sound_analysis/write_files").execute(*args, **kwargs)
            def print_indicators(self, *args, **kwargs):
                """
                Print Ansys Sound indicators.
                """
                return PyMenu(self.service, "/plot/vrx_sound_analysis/print_indicators").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)

    class results(TUIMenu):
        """
        Enter results menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.graphics_window = self.__class__.graphics_window(path + ["graphics_window"], service)
            self.plot = self.__class__.plot(path + ["plot"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            self.graphics = self.__class__.graphics(path + ["graphics"], service)
            self.report = self.__class__.report(path + ["report"], service)
            self.surface = self.__class__.surface(path + ["surface"], service)
            super().__init__(path, service)

        class graphics_window(TUIMenu):
            """
            Enter graphics window menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.view_sync = self.__class__.view_sync(path + ["view_sync"], service)
                self.picture = self.__class__.picture(path + ["picture"], service)
                self.views = self.__class__.views(path + ["views"], service)
                self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
                self.display_states = self.__class__.display_states(path + ["display_states"], service)
                self.windows = self.__class__.windows(path + ["windows"], service)
                self.titles = self.__class__.titles(path + ["titles"], service)
                super().__init__(path, service)
            def set_window(self, *args, **kwargs):
                """
                Set a user graphics window to be the active window.
                """
                return PyMenu(self.service, "/results/graphics_window/set_window").execute(*args, **kwargs)
            def set_window_by_name(self, *args, **kwargs):
                """
                Set a reserved graphics window to be the active window by its name.
                """
                return PyMenu(self.service, "/results/graphics_window/set_window_by_name").execute(*args, **kwargs)
            def close_window_by_name(self, *args, **kwargs):
                """
                Close a reserved graphics window by its name.
                """
                return PyMenu(self.service, "/results/graphics_window/close_window_by_name").execute(*args, **kwargs)
            def close_window(self, *args, **kwargs):
                """
                Close a user graphics window.
                """
                return PyMenu(self.service, "/results/graphics_window/close_window").execute(*args, **kwargs)
            def save_picture(self, *args, **kwargs):
                """
                Generate a "hardcopy" of the active window.
                """
                return PyMenu(self.service, "/results/graphics_window/save_picture").execute(*args, **kwargs)
            def update_layout(self, *args, **kwargs):
                """
                Update the fluent layout.
                """
                return PyMenu(self.service, "/results/graphics_window/update_layout").execute(*args, **kwargs)
            def open_window(self, *args, **kwargs):
                """
                Open a user graphics window.
                """
                return PyMenu(self.service, "/results/graphics_window/open_window").execute(*args, **kwargs)

            class view_sync(TUIMenu):
                """
                Enter the display state manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    Print window ids of open windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/list").execute(*args, **kwargs)
                def add_all(self, *args, **kwargs):
                    """
                    Synchronize all windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/add_all").execute(*args, **kwargs)
                def remove(self, *args, **kwargs):
                    """
                    Remove list of window ids from synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/remove").execute(*args, **kwargs)
                def stop(self, *args, **kwargs):
                    """
                    Stop view synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/stop").execute(*args, **kwargs)
                def remove_all(self, *args, **kwargs):
                    """
                    Unsynchronize all windows.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/remove_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add list of window ids for synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/add").execute(*args, **kwargs)
                def start(self, *args, **kwargs):
                    """
                    Start view synchronization.
                    """
                    return PyMenu(self.service, "/results/graphics_window/view_sync/start").execute(*args, **kwargs)

            class picture(TUIMenu):
                """
                Enter the hardcopy/save-picture options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.driver = self.__class__.driver(path + ["driver"], service)
                    self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                    super().__init__(path, service)
                def use_window_resolution(self, *args, **kwargs):
                    """
                    Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/use_window_resolution").execute(*args, **kwargs)
                def x_resolution(self, *args, **kwargs):
                    """
                    Set the width of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/x_resolution").execute(*args, **kwargs)
                def y_resolution(self, *args, **kwargs):
                    """
                    Set the height of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/y_resolution").execute(*args, **kwargs)
                def preview(self, *args, **kwargs):
                    """
                    Display a preview image of a hardcopy.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/preview").execute(*args, **kwargs)
                def invert_background(self, *args, **kwargs):
                    """
                    Use a white background when the picture is saved.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/invert_background").execute(*args, **kwargs)
                def jpeg_hardcopy_quality(self, *args, **kwargs):
                    """
                    To set jpeg hardcopy quality.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                def set_standard_resolution(self, *args, **kwargs):
                    """
                    Select from pre-defined resolution list.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/set_standard_resolution").execute(*args, **kwargs)
                def dpi(self, *args, **kwargs):
                    """
                    Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/dpi").execute(*args, **kwargs)
                def landscape(self, *args, **kwargs):
                    """
                    Plot hardcopies in landscape or portrait orientation.
                    """
                    return PyMenu(self.service, "/results/graphics_window/picture/landscape").execute(*args, **kwargs)

                class driver(TUIMenu):
                    """
                    Enter the set hardcopy driver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.post_format = self.__class__.post_format(path + ["post_format"], service)
                        super().__init__(path, service)
                    def tiff(self, *args, **kwargs):
                        """
                        Use TIFF output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/tiff").execute(*args, **kwargs)
                    def ppm(self, *args, **kwargs):
                        """
                        Produce PPM output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/ppm").execute(*args, **kwargs)
                    def dump_window(self, *args, **kwargs):
                        """
                        Set the command used to dump the graphics window to a file.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/dump_window").execute(*args, **kwargs)
                    def post_script(self, *args, **kwargs):
                        """
                        Produce PostScript output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/post_script").execute(*args, **kwargs)
                    def vrml(self, *args, **kwargs):
                        """
                        Use VRML output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/vrml").execute(*args, **kwargs)
                    def eps(self, *args, **kwargs):
                        """
                        Produce encapsulated PostScript (EPS) output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/eps").execute(*args, **kwargs)
                    def jpeg(self, *args, **kwargs):
                        """
                        Produce JPEG output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/jpeg").execute(*args, **kwargs)
                    def avz(self, *args, **kwargs):
                        """
                        Use AVZ output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/avz").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the current hardcopy driver.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/list").execute(*args, **kwargs)
                    def glb(self, *args, **kwargs):
                        """
                        Use GLB output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/glb").execute(*args, **kwargs)
                    def options(self, *args, **kwargs):
                        """
                        Set the hardcopy options. Available options are:
                        "no gamma correction", disables gamma correction of colors,
                        "physical size = (width,height)", where width and height
                        are the actual measurements of the printable area of the page
                        in centimeters.
                        "subscreen = (left,right,bottom,top)", where left,right,
                        bottom, and top are numbers in [-1,1] describing a subwindow on
                        the page in which to place the hardcopy.
                        The options may be combined by separating them with commas.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/options").execute(*args, **kwargs)
                    def png(self, *args, **kwargs):
                        """
                        Use PNG output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/png").execute(*args, **kwargs)
                    def hsf(self, *args, **kwargs):
                        """
                        Use HSF output for hardcopies.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/driver/hsf").execute(*args, **kwargs)

                    class post_format(TUIMenu):
                        """
                        Enter the PostScript driver format menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vector(self, *args, **kwargs):
                            """
                            Use vector format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/vector").execute(*args, **kwargs)
                        def fast_raster(self, *args, **kwargs):
                            """
                            Use the new raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                        def raster(self, *args, **kwargs):
                            """
                            Use the original raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/raster").execute(*args, **kwargs)
                        def rle_raster(self, *args, **kwargs):
                            """
                            Use the run-length encoded raster format.
                            """
                            return PyMenu(self.service, "/results/graphics_window/picture/driver/post_format/rle_raster").execute(*args, **kwargs)

                class color_mode(TUIMenu):
                    """
                    Enter the hardcopy color mode menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mono_chrome(self, *args, **kwargs):
                        """
                        Convert color to monochrome (black and white) for hardcopy.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/mono_chrome").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        Display the current hardcopy color mode.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/list").execute(*args, **kwargs)
                    def color(self, *args, **kwargs):
                        """
                        Plot hardcopies in color.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/color").execute(*args, **kwargs)
                    def gray_scale(self, *args, **kwargs):
                        """
                        Convert color to grayscale for hardcopy.
                        """
                        return PyMenu(self.service, "/results/graphics_window/picture/color_mode/gray_scale").execute(*args, **kwargs)

            class views(TUIMenu):
                """
                Enter the view manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.camera = self.__class__.camera(path + ["camera"], service)
                    self.display_states = self.__class__.display_states(path + ["display_states"], service)
                    super().__init__(path, service)
                def next_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/next_view").execute(*args, **kwargs)
                def default_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/default_view").execute(*args, **kwargs)
                def auto_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/auto_scale").execute(*args, **kwargs)
                def list_views(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/list_views").execute(*args, **kwargs)
                def last_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/last_view").execute(*args, **kwargs)
                def read_views(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/read_views").execute(*args, **kwargs)
                def save_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/save_view").execute(*args, **kwargs)
                def delete_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/delete_view").execute(*args, **kwargs)
                def restore_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/restore_view").execute(*args, **kwargs)
                def write_views(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/views/write_views").execute(*args, **kwargs)

                class camera(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def dolly_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/dolly_camera").execute(*args, **kwargs)
                    def orbit_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/orbit_camera").execute(*args, **kwargs)
                    def roll_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/roll_camera").execute(*args, **kwargs)
                    def target(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/target").execute(*args, **kwargs)
                    def zoom_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/zoom_camera").execute(*args, **kwargs)
                    def up_vector(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/up_vector").execute(*args, **kwargs)
                    def field(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/field").execute(*args, **kwargs)
                    def position(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/position").execute(*args, **kwargs)
                    def pan_camera(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/pan_camera").execute(*args, **kwargs)
                    def projection(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/camera/projection").execute(*args, **kwargs)

                class display_states(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/copy").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit display-states object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/edit").execute(*args, **kwargs)
                    def use_active(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/use_active").execute(*args, **kwargs)
                    def read(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/read").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/delete").execute(*args, **kwargs)
                    def new(self, *args, **kwargs):
                        """
                        Create a new display-states object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/new").execute(*args, **kwargs)
                    def write(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/write").execute(*args, **kwargs)
                    def restore_state(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/restore_state").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/list").execute(*args, **kwargs)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/results/graphics_window/views/display_states/rename").execute(*args, **kwargs)

            class embedded_windows(TUIMenu):
                """
                Enter to embed, close, move-out embedded windows.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def move_out_all(self, *args, **kwargs):
                    """
                    Move out all embedded windows for given parent window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/move_out_all").execute(*args, **kwargs)
                def embed_in(self, *args, **kwargs):
                    """
                    Embed Window into another window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/embed_in").execute(*args, **kwargs)
                def move_out(self, *args, **kwargs):
                    """
                    Move out an embedded window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/move_out").execute(*args, **kwargs)
                def close_all(self, *args, **kwargs):
                    """
                    Close all embedded windows for given parent window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/close_all").execute(*args, **kwargs)
                def close(self, *args, **kwargs):
                    """
                    Close an embedded window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/embedded_windows/close").execute(*args, **kwargs)

            class display_states(TUIMenu):
                """
                Enter the display state manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete a display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/delete").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Create a new display state with settings copied from an existing display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/copy").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Read display states from a file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/read").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create a new display state.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/create").execute(*args, **kwargs)
                def use_active(self, *args, **kwargs):
                    """
                    Update an existing display state's settings to match those of the active graphics window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/use_active").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit a particular display state setting.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/edit").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Write display states to a file.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/write").execute(*args, **kwargs)
                def apply(self, *args, **kwargs):
                    """
                    Apply a display state to the active window.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/apply").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Print the names of the available display states to the console.
                    """
                    return PyMenu(self.service, "/results/graphics_window/display_states/list").execute(*args, **kwargs)

            class windows(TUIMenu):
                """
                Enter the window options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.main = self.__class__.main(path + ["main"], service)
                    self.scale = self.__class__.scale(path + ["scale"], service)
                    self.xy = self.__class__.xy(path + ["xy"], service)
                    self.text = self.__class__.text(path + ["text"], service)
                    self.axes = self.__class__.axes(path + ["axes"], service)
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def logo_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/logo_color").execute(*args, **kwargs)
                def aspect_ratio(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/aspect_ratio").execute(*args, **kwargs)
                def logo(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/logo").execute(*args, **kwargs)
                def ruler(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/graphics_window/windows/ruler").execute(*args, **kwargs)

                class main(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/right").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/top").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/left").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/border").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/visible").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/main/bottom").execute(*args, **kwargs)

                class scale(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def clear(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/clear").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/visible").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/right").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/left").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/bottom").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/border").execute(*args, **kwargs)
                    def margin(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/margin").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/format").execute(*args, **kwargs)
                    def font_size(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/font_size").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/scale/top").execute(*args, **kwargs)

                class xy(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/visible").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/top").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/border").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/left").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/bottom").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/xy/right").execute(*args, **kwargs)

                class text(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/top").execute(*args, **kwargs)
                    def company(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/company").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/border").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/left").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/visible").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/clear").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/right").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/bottom").execute(*args, **kwargs)
                    def alignment(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/alignment").execute(*args, **kwargs)
                    def date(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/date").execute(*args, **kwargs)
                    def application(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/text/application").execute(*args, **kwargs)

                class axes(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def right(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/right").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/border").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/clear").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/visible").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/axes/bottom").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def foreground(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/foreground").execute(*args, **kwargs)
                    def color_filter(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/color_filter").execute(*args, **kwargs)
                    def pixel_size(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/pixel_size").execute(*args, **kwargs)
                    def background(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/background").execute(*args, **kwargs)
                    def on(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/graphics_window/windows/video/on").execute(*args, **kwargs)

            class titles(TUIMenu):
                """
                Set problem title.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def right_middle(self, *args, **kwargs):
                    """
                    Set the title text for right middle in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_middle").execute(*args, **kwargs)
                def right_top(self, *args, **kwargs):
                    """
                    Set the title text for right top in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_top").execute(*args, **kwargs)
                def right_bottom(self, *args, **kwargs):
                    """
                    Set the title text for right bottom in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/right_bottom").execute(*args, **kwargs)
                def left_top(self, *args, **kwargs):
                    """
                    Set the title text for left top in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/left_top").execute(*args, **kwargs)
                def left_bottom(self, *args, **kwargs):
                    """
                    Set the title text for left bottom in title segment.
                    """
                    return PyMenu(self.service, "/results/graphics_window/titles/left_bottom").execute(*args, **kwargs)

        class plot(TUIMenu):
            """
            Enter the XY plot menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.vrx_sound_analysis = self.__class__.vrx_sound_analysis(path + ["vrx_sound_analysis"], service)
                self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
                self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
                self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
                super().__init__(path, service)
            def fft_set(self, *args, **kwargs):
                """
                Enter the menu to set histogram plot parameters.
                """
                return PyMenu(self.service, "/results/plot/fft_set").execute(*args, **kwargs)
            def circum_avg_axial(self, *args, **kwargs):
                """
                Compute iso-axial band surfaces and plot data vs axial coordinate on them.
                """
                return PyMenu(self.service, "/results/plot/circum_avg_axial").execute(*args, **kwargs)
            def residuals_set(self, *args, **kwargs):
                """
                Enter the menu to set residual plot parameters.
                """
                return PyMenu(self.service, "/results/plot/residuals_set").execute(*args, **kwargs)
            def set_boundary_val_off(self, *args, **kwargs):
                """
                Set boundary value off when node values off for XY/Solution Plot.
                Note: This setting is valid for current Fluent session only.
                """
                return PyMenu(self.service, "/results/plot/set_boundary_val_off").execute(*args, **kwargs)
            def solution_set(self, *args, **kwargs):
                """
                Enter the menu to set solution plot parameters.
                """
                return PyMenu(self.service, "/results/plot/solution_set").execute(*args, **kwargs)
            def solution(self, *args, **kwargs):
                """
                Plot solution on surfaces and/or zones.
                """
                return PyMenu(self.service, "/results/plot/solution").execute(*args, **kwargs)
            def label_alignment(self, *args, **kwargs):
                """
                Set the alignment of xy plot label to horizontal or axis aligned.
                """
                return PyMenu(self.service, "/results/plot/label_alignment").execute(*args, **kwargs)
            def file_list(self, *args, **kwargs):
                """
                Plot data from multiple files.
                """
                return PyMenu(self.service, "/results/plot/file_list").execute(*args, **kwargs)
            def plot_direction(self, *args, **kwargs):
                """
                Set plot direction for xy plot.
                """
                return PyMenu(self.service, "/results/plot/plot_direction").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot solution on surfaces.
                """
                return PyMenu(self.service, "/results/plot/plot").execute(*args, **kwargs)
            def histogram_set(self, *args, **kwargs):
                """
                Enter the menu to set histogram plot parameters.
                """
                return PyMenu(self.service, "/results/plot/histogram_set").execute(*args, **kwargs)
            def residuals(self, *args, **kwargs):
                """
                Plot equation residual history.
                """
                return PyMenu(self.service, "/results/plot/residuals").execute(*args, **kwargs)
            def file_set(self, *args, **kwargs):
                """
                Enter the menu to set file plot parameters.
                """
                return PyMenu(self.service, "/results/plot/file_set").execute(*args, **kwargs)
            def datasources(self, *args, **kwargs):
                """
                Enter the menu to set data sources.
                """
                return PyMenu(self.service, "/results/plot/datasources").execute(*args, **kwargs)
            def display_profile_data(self, *args, **kwargs):
                """
                Plot profile data.
                """
                return PyMenu(self.service, "/results/plot/display_profile_data").execute(*args, **kwargs)
            def circum_avg_radial(self, *args, **kwargs):
                """
                Compute iso-radial band surfaces and plot data vs radius on them.
                """
                return PyMenu(self.service, "/results/plot/circum_avg_radial").execute(*args, **kwargs)
            def file(self, *args, **kwargs):
                """
                Plot data from file.
                """
                return PyMenu(self.service, "/results/plot/file").execute(*args, **kwargs)
            def fft(self, *args, **kwargs):
                """
                Plot FFT of file data.
                """
                return PyMenu(self.service, "/results/plot/fft").execute(*args, **kwargs)
            def change_fft_ref_pressure(self, *args, **kwargs):
                """
                Change acoustic reference pressure.
                """
                return PyMenu(self.service, "/results/plot/change_fft_ref_pressure").execute(*args, **kwargs)
            def histogram(self, *args, **kwargs):
                """
                Plot a histogram of a specified scalar quantity.
                """
                return PyMenu(self.service, "/results/plot/histogram").execute(*args, **kwargs)

            class vrx_sound_analysis(TUIMenu):
                """
                Ansys Sound analysis and specification.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_files(self, *args, **kwargs):
                    """
                    Write Ansys Sound out files.
                    """
                    return PyMenu(self.service, "/results/plot/vrx_sound_analysis/write_files").execute(*args, **kwargs)
                def print_indicators(self, *args, **kwargs):
                    """
                    Print Ansys Sound indicators.
                    """
                    return PyMenu(self.service, "/results/plot/vrx_sound_analysis/print_indicators").execute(*args, **kwargs)

            class ansys_sound_analysis(TUIMenu):
                """
                Ansys Sound analysis and specification.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def print_indicators(self, *args, **kwargs):
                    """
                    Print Ansys Sound indicators.
                    """
                    return PyMenu(self.service, "/results/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
                def write_files(self, *args, **kwargs):
                    """
                    Write Ansys Sound out files.
                    """
                    return PyMenu(self.service, "/results/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

            class flamelet_curves(TUIMenu):
                """
                Plot flamelet curves.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def plot_curves(self, *args, **kwargs):
                    """
                    Plot of a property.
                    """
                    return PyMenu(self.service, "/results/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write curve to a file instead of plot.
                    """
                    return PyMenu(self.service, "/results/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)

            class cumulative_plot(TUIMenu):
                """
                Plot Cumulative Force and Moments.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/curves").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/axes").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Print the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/print").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Write the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/write").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/list").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot the Cumulative Forces/Moments.
                    """
                    return PyMenu(self.service, "/results/plot/cumulative_plot/plot").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enter the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.playback = self.__class__.playback(path + ["playback"], service)
                super().__init__(path, service)

            class playback(TUIMenu):
                """
                Enter animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def write(self, *args, **kwargs):
                    """
                    Write animation sequence to the file.
                    """
                    return PyMenu(self.service, "/results/animate/playback/write").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Play the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/results/animate/playback/stored_view").execute(*args, **kwargs)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Set custom frames start, end, skip frames for video export.
                    """
                    return PyMenu(self.service, "/results/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete animation sequence.
                    """
                    return PyMenu(self.service, "/results/animate/playback/delete").execute(*args, **kwargs)
                def play(self, *args, **kwargs):
                    """
                    Play the selected animation.
                    """
                    return PyMenu(self.service, "/results/animate/playback/play").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Read new animation from file or already-defined animations.
                    """
                    return PyMenu(self.service, "/results/animate/playback/read").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Set options for exporting video file menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/width").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/name").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/height").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/fps").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/format").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/quality").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/results/animate/playback/video/scale").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def keyframe(self, *args, **kwargs):
                            """
                            Set video keyframe rate for exporting video file.
                            """
                            return PyMenu(self.service, "/results/animate/playback/video/advance_quality/keyframe").execute(*args, **kwargs)

        class graphics(TUIMenu):
            """
            Enter graphics menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.lights = self.__class__.lights(path + ["lights"], service)
                self.update_scene = self.__class__.update_scene(path + ["update_scene"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                super().__init__(path, service)
            def clear_annotations(self, *args, **kwargs):
                """
                Delete all annotation text.
                """
                return PyMenu(self.service, "/results/graphics/clear_annotations").execute(*args, **kwargs)
            def annotate(self, *args, **kwargs):
                """
                Add a text annotation string to the active graphics window.
                """
                return PyMenu(self.service, "/results/graphics/annotate").execute(*args, **kwargs)
            def color_map(self, *args, **kwargs):
                """
                Enter the color-map menu.
                """
                return PyMenu(self.service, "/results/graphics/color_map").execute(*args, **kwargs)
            def hsf_file(self, *args, **kwargs):
                """
                Display hoops stream file data to active graphics window.
                """
                return PyMenu(self.service, "/results/graphics/hsf_file").execute(*args, **kwargs)

            class objects(TUIMenu):
                """
                Enter to add, edit, delete or display graphics objects.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/edit").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Display graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/display").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create new graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/create").execute(*args, **kwargs)
                def add_to_graphics(self, *args, **kwargs):
                    """
                    Add graphics object to existing graphics.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/add_to_graphics").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy graphics object.
                    """
                    return PyMenu(self.service, "/results/graphics/objects/copy").execute(*args, **kwargs)

            class lights(TUIMenu):
                """
                Enter the lights menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_light(self, *args, **kwargs):
                    """
                    Add or modify a directional, colored light.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/set_light").execute(*args, **kwargs)
                def headlight_on(self, *args, **kwargs):
                    """
                    Turn the light that moves with the camera on or off.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/headlight_on").execute(*args, **kwargs)
                def set_ambient_color(self, *args, **kwargs):
                    """
                    Set the ambient light color for the scene.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/set_ambient_color").execute(*args, **kwargs)
                def lighting_interpolation(self, *args, **kwargs):
                    """
                    Set lighting interpolation method.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/lighting_interpolation").execute(*args, **kwargs)
                def lights_on(self, *args, **kwargs):
                    """
                    Turn all active lighting on/off.
                    """
                    return PyMenu(self.service, "/results/graphics/lights/lights_on").execute(*args, **kwargs)

            class update_scene(TUIMenu):
                """
                Enter the scene options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def iso_sweep(self, *args, **kwargs):
                    """
                    Change iso-sweep values.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/iso_sweep").execute(*args, **kwargs)
                def time(self, *args, **kwargs):
                    """
                    Change time-step value.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/time").execute(*args, **kwargs)
                def draw_frame(self, *args, **kwargs):
                    """
                    Enable/disable drawing of the bounding frame.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/draw_frame").execute(*args, **kwargs)
                def set_frame(self, *args, **kwargs):
                    """
                    Change frame options.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/set_frame").execute(*args, **kwargs)
                def transform(self, *args, **kwargs):
                    """
                    Apply transformation matrix on selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/transform").execute(*args, **kwargs)
                def overlays(self, *args, **kwargs):
                    """
                    Enable/disable the overlays option.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/overlays").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Display selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/display").execute(*args, **kwargs)
                def select_geometry(self, *args, **kwargs):
                    """
                    Select geometry to be updated.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/select_geometry").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete selected geometries.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/delete").execute(*args, **kwargs)
                def pathline(self, *args, **kwargs):
                    """
                    Change pathline attributes.
                    """
                    return PyMenu(self.service, "/results/graphics/update_scene/pathline").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.pdf_data = self.__class__.pdf_data(path + ["pdf_data"], service)
                    self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                    self.flamelet_data = self.__class__.flamelet_data(path + ["flamelet_data"], service)
                    self.set = self.__class__.set(path + ["set"], service)
                    self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                    super().__init__(path, service)
                def re_render(self, *args, **kwargs):
                    """
                    Re-render the last contour, profile, or velocity vector plot
                    with updated surfaces, meshes, lights, colormap, rendering options, etc.,
                    without recalculating the contour data.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/re_render").execute(*args, **kwargs)
                def zone_mesh(self, *args, **kwargs):
                    """
                    Draw the mesh defined by specified face zones.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/zone_mesh").execute(*args, **kwargs)
                def display_custom_vector(self, *args, **kwargs):
                    """
                    Display custom vector.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/display_custom_vector").execute(*args, **kwargs)
                def add_custom_vector(self, *args, **kwargs):
                    """
                    Add new custom vector definition.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/add_custom_vector").execute(*args, **kwargs)
                def graphics_window_layout(self, *args, **kwargs):
                    """
                    Arrange the graphics window layout.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/graphics_window_layout").execute(*args, **kwargs)
                def contour(self, *args, **kwargs):
                    """
                    Display contours of a flow variable.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/contour").execute(*args, **kwargs)
                def surface_mesh(self, *args, **kwargs):
                    """
                    Draw the mesh defined by the specified surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/surface_mesh").execute(*args, **kwargs)
                def set_list_tree_separator(self, *args, **kwargs):
                    """
                    Set the separator character for list tree.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/set_list_tree_separator").execute(*args, **kwargs)
                def reacting_channel_curves(self, *args, **kwargs):
                    """
                    Plot/Report the reacting channel variables.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/reacting_channel_curves").execute(*args, **kwargs)
                def multigrid_coarsening(self, *args, **kwargs):
                    """
                    Display a coarse mesh level from the last multigrid coarsening.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/multigrid_coarsening").execute(*args, **kwargs)
                def mesh(self, *args, **kwargs):
                    """
                    Display the mesh.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh").execute(*args, **kwargs)
                def velocity_vector(self, *args, **kwargs):
                    """
                    Display velocity vectors.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/velocity_vector").execute(*args, **kwargs)
                def re_scale(self, *args, **kwargs):
                    """
                    Re-render the last contour, profile, or velocity vector plot
                    with updated scale, surfaces, meshes, lights, colormap, rendering options, etc.,
                    without recalculating the field data.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/re_scale").execute(*args, **kwargs)
                def profile(self, *args, **kwargs):
                    """
                    Display profiles of a flow variable.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/profile").execute(*args, **kwargs)
                def mesh_partition_boundary(self, *args, **kwargs):
                    """
                    Display mesh partition boundaries.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh_partition_boundary").execute(*args, **kwargs)
                def mesh_outline(self, *args, **kwargs):
                    """
                    Display the mesh boundaries.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/mesh_outline").execute(*args, **kwargs)
                def surface_cells(self, *args, **kwargs):
                    """
                    Draw the cells on the specified surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/surface_cells").execute(*args, **kwargs)
                def vector(self, *args, **kwargs):
                    """
                    Display space vectors.
                    """
                    return PyMenu(self.service, "/results/graphics/expert/vector").execute(*args, **kwargs)

                class pdf_data(TUIMenu):
                    """
                    Enter the PDF data menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def carpet_plot(self, *args, **kwargs):
                        """
                        Enable/disable the display of a carpet plot of a property.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/carpet_plot").execute(*args, **kwargs)
                    def plot_1d_slice(self, *args, **kwargs):
                        """
                        Enable/disable a plot of the 1D-slice.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/plot_1d_slice").execute(*args, **kwargs)
                    def draw_number_box(self, *args, **kwargs):
                        """
                        Enable/disable the display of the numbers box.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/draw_number_box").execute(*args, **kwargs)
                    def write_to_file(self, *args, **kwargs):
                        """
                        Enable/disable writing the 1D-slice to file instead of plot.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/pdf_data/write_to_file").execute(*args, **kwargs)

                class path_lines(TUIMenu):
                    """
                    Enter the pathlines menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def path_lines(self, *args, **kwargs):
                        """
                        Display pathlines from a surface.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/path_lines").execute(*args, **kwargs)
                    def plot_write_xy_plot(self, *args, **kwargs):
                        """
                        Plot or write XY plot of pathline.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/plot_write_xy_plot").execute(*args, **kwargs)
                    def write_to_files(self, *args, **kwargs):
                        """
                        Write Pathlines to a File.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/path_lines/write_to_files").execute(*args, **kwargs)

                class flamelet_data(TUIMenu):
                    """
                    Display flamelet data.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def carpet_plot(self, *args, **kwargs):
                        """
                        Enable/disable display of carpet plot of a property.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/carpet_plot").execute(*args, **kwargs)
                    def write_to_file(self, *args, **kwargs):
                        """
                        Enable/disable writing the 1D-slice to file instead of plot.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/write_to_file").execute(*args, **kwargs)
                    def draw_number_box(self, *args, **kwargs):
                        """
                        Enable/disable display of the numbers box.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/draw_number_box").execute(*args, **kwargs)
                    def plot_1d_slice(self, *args, **kwargs):
                        """
                        Enable/disable plot of the 1D-slice.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/flamelet_data/plot_1d_slice").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the set menu to set display parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.titles = self.__class__.titles(path + ["titles"], service)
                        self.windows = self.__class__.windows(path + ["windows"], service)
                        self.velocity_vectors = self.__class__.velocity_vectors(path + ["velocity_vectors"], service)
                        self.lights = self.__class__.lights(path + ["lights"], service)
                        self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                        self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                        self.contours = self.__class__.contours(path + ["contours"], service)
                        self.colors = self.__class__.colors(path + ["colors"], service)
                        self.picture = self.__class__.picture(path + ["picture"], service)
                        self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                        super().__init__(path, service)
                    def grid_surfaces(self, *args, **kwargs):
                        """
                        Set surface IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/grid_surfaces").execute(*args, **kwargs)
                    def zero_angle_dir(self, *args, **kwargs):
                        """
                        Set the vector having zero angular coordinates.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/zero_angle_dir").execute(*args, **kwargs)
                    def grid_level(self, *args, **kwargs):
                        """
                        Set coarse mesh level to be drawn.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/grid_level").execute(*args, **kwargs)
                    def grid_partitions(self, *args, **kwargs):
                        """
                        Enable/disable drawing of the mesh partition boundaries.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/grid_partitions").execute(*args, **kwargs)
                    def color_map(self, *args, **kwargs):
                        """
                        Enter the color-map menu.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/color_map").execute(*args, **kwargs)
                    def n_stream_func(self, *args, **kwargs):
                        """
                        Set the number of iterations used in computing stream function.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/n_stream_func").execute(*args, **kwargs)
                    def marker_symbol(self, *args, **kwargs):
                        """
                        Set the type of markers used to represent points.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/marker_symbol").execute(*args, **kwargs)
                    def render_mesh(self, *args, **kwargs):
                        """
                        Enable/disable rendering the mesh on top of contours, vectors, etc.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/render_mesh").execute(*args, **kwargs)
                    def proximity_zones(self, *args, **kwargs):
                        """
                        Set zones to be used for boundary cell distance and boundary proximity.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/proximity_zones").execute(*args, **kwargs)
                    def overlays(self, *args, **kwargs):
                        """
                        Enable/disable overlays.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/overlays").execute(*args, **kwargs)
                    def periodic_repeats(self, *args, **kwargs):
                        """
                        Set periodic instancing.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/periodic_repeats").execute(*args, **kwargs)
                    def grid_zones(self, *args, **kwargs):
                        """
                        Set zone IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/grid_zones").execute(*args, **kwargs)
                    def line_weight(self, *args, **kwargs):
                        """
                        Set the line-weight factor for the window.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/line_weight").execute(*args, **kwargs)
                    def mesh_zones(self, *args, **kwargs):
                        """
                        Set zone IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_zones").execute(*args, **kwargs)
                    def nodewt_based_interp(self, *args, **kwargs):
                        """
                        Use more accurate node-weight based interpolation for postprocessing.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/nodewt_based_interp").execute(*args, **kwargs)
                    def mesh_surfaces(self, *args, **kwargs):
                        """
                        Set surface IDs to be drawn as mesh.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_surfaces").execute(*args, **kwargs)
                    def marker_size(self, *args, **kwargs):
                        """
                        Set the size of markers used to represent points.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/marker_size").execute(*args, **kwargs)
                    def mesh_partitions(self, *args, **kwargs):
                        """
                        Enable/disable drawing of the mesh partition boundaries.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_partitions").execute(*args, **kwargs)
                    def filled_mesh(self, *args, **kwargs):
                        """
                        Enable/disable the filled mesh option.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/filled_mesh").execute(*args, **kwargs)
                    def periodic_instancing(self, *args, **kwargs):
                        """
                        Set periodic instancing.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/periodic_instancing").execute(*args, **kwargs)
                    def reset_graphics(self, *args, **kwargs):
                        """
                        Reset the graphics system.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/reset_graphics").execute(*args, **kwargs)
                    def element_shrink(self, *args, **kwargs):
                        """
                        Set percentage to shrink elements.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/element_shrink").execute(*args, **kwargs)
                    def filled_grid(self, *args, **kwargs):
                        """
                        Enable/disable the filled mesh option.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/filled_grid").execute(*args, **kwargs)
                    def mesh_display_configuration(self, *args, **kwargs):
                        """
                        Set mesh display configuration.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_display_configuration").execute(*args, **kwargs)
                    def mirror_zones(self, *args, **kwargs):
                        """
                        Set zones to mirror the domain about.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mirror_zones").execute(*args, **kwargs)
                    def duplicate_node_display(self, *args, **kwargs):
                        """
                        Set flag to remove duplicate nodes in mesh display.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/duplicate_node_display").execute(*args, **kwargs)
                    def mesh_level(self, *args, **kwargs):
                        """
                        Set coarse mesh level to be drawn.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/set/mesh_level").execute(*args, **kwargs)

                    class titles(TUIMenu):
                        """
                        Set problem title.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def right_bottom(self, *args, **kwargs):
                            """
                            Set the title text for right bottom in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_bottom").execute(*args, **kwargs)
                        def right_top(self, *args, **kwargs):
                            """
                            Set the title text for right top in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_top").execute(*args, **kwargs)
                        def left_bottom(self, *args, **kwargs):
                            """
                            Set the title text for left bottom in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/left_bottom").execute(*args, **kwargs)
                        def left_top(self, *args, **kwargs):
                            """
                            Set the title text for left top in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/left_top").execute(*args, **kwargs)
                        def right_middle(self, *args, **kwargs):
                            """
                            Set the title text for right middle in title segment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/titles/right_middle").execute(*args, **kwargs)

                    class windows(TUIMenu):
                        """
                        Enter the window options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.scale = self.__class__.scale(path + ["scale"], service)
                            self.axes = self.__class__.axes(path + ["axes"], service)
                            self.video = self.__class__.video(path + ["video"], service)
                            self.text = self.__class__.text(path + ["text"], service)
                            self.xy = self.__class__.xy(path + ["xy"], service)
                            self.main = self.__class__.main(path + ["main"], service)
                            super().__init__(path, service)
                        def ruler(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/ruler").execute(*args, **kwargs)
                        def logo_color(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/logo_color").execute(*args, **kwargs)
                        def aspect_ratio(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/aspect_ratio").execute(*args, **kwargs)
                        def logo(self, *args, **kwargs):
                            """
                            .
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/windows/logo").execute(*args, **kwargs)

                        class scale(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/right").execute(*args, **kwargs)
                            def format(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/format").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/visible").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/border").execute(*args, **kwargs)
                            def font_size(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/font_size").execute(*args, **kwargs)
                            def clear(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/clear").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/left").execute(*args, **kwargs)
                            def margin(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/margin").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/bottom").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/scale/top").execute(*args, **kwargs)

                        class axes(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def clear(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/clear").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/right").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/bottom").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/visible").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/axes/border").execute(*args, **kwargs)

                        class video(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def background(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/background").execute(*args, **kwargs)
                            def color_filter(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/color_filter").execute(*args, **kwargs)
                            def on(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/on").execute(*args, **kwargs)
                            def pixel_size(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/pixel_size").execute(*args, **kwargs)
                            def foreground(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/video/foreground").execute(*args, **kwargs)

                        class text(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/top").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/border").execute(*args, **kwargs)
                            def clear(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/clear").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/left").execute(*args, **kwargs)
                            def alignment(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/alignment").execute(*args, **kwargs)
                            def date(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/date").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/bottom").execute(*args, **kwargs)
                            def application(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/application").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/right").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/visible").execute(*args, **kwargs)
                            def company(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/text/company").execute(*args, **kwargs)

                        class xy(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/top").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/border").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/left").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/visible").execute(*args, **kwargs)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/bottom").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/xy/right").execute(*args, **kwargs)

                        class main(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def bottom(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/bottom").execute(*args, **kwargs)
                            def visible(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/visible").execute(*args, **kwargs)
                            def border(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/border").execute(*args, **kwargs)
                            def top(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/top").execute(*args, **kwargs)
                            def left(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/left").execute(*args, **kwargs)
                            def right(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/windows/main/right").execute(*args, **kwargs)

                    class velocity_vectors(TUIMenu):
                        """
                        Enter the menu to set parameters for display of velocity vectors.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def node_values(self, *args, **kwargs):
                            """
                            Enable/disable plotting node values. Cell values will be plotted if "no".
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/node_values").execute(*args, **kwargs)
                        def scale_head(self, *args, **kwargs):
                            """
                            Set the value by which the vector head will be scaled.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/scale_head").execute(*args, **kwargs)
                        def log_scale(self, *args, **kwargs):
                            """
                            Enable/disable the use of a log scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/log_scale").execute(*args, **kwargs)
                        def scale(self, *args, **kwargs):
                            """
                            Set the value by which the vector length will be scaled.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/scale").execute(*args, **kwargs)
                        def color(self, *args, **kwargs):
                            """
                            Set the color used for all vectors. Set color to the null string to use the color map.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/color").execute(*args, **kwargs)
                        def component_z(self, *args, **kwargs):
                            """
                            Enable/disable use of z-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_z").execute(*args, **kwargs)
                        def relative(self, *args, **kwargs):
                            """
                            Enable/disable the display of relative velocity vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/relative").execute(*args, **kwargs)
                        def render_mesh(self, *args, **kwargs):
                            """
                            Enable/disable rendering the mseh on top of contours, vectors, etc.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/render_mesh").execute(*args, **kwargs)
                        def component_x(self, *args, **kwargs):
                            """
                            Enable/disable use of x-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_x").execute(*args, **kwargs)
                        def global_range(self, *args, **kwargs):
                            """
                            Enable/disable the global range for vectors option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/global_range").execute(*args, **kwargs)
                        def surfaces(self, *args, **kwargs):
                            """
                            Set surfaces on which vectors are drawn.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/surfaces").execute(*args, **kwargs)
                        def component_y(self, *args, **kwargs):
                            """
                            Enable/disable use of y-component of vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/component_y").execute(*args, **kwargs)
                        def in_plane(self, *args, **kwargs):
                            """
                            Toggle the display of in-plane velocity vectors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/in_plane").execute(*args, **kwargs)
                        def color_levels(self, *args, **kwargs):
                            """
                            Set the number of colors used from the color map.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/color_levels").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set the style with which the vectors will be drawn.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/style").execute(*args, **kwargs)
                        def constant_length(self, *args, **kwargs):
                            """
                            Enable/disable setting all vectors to have the same length.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/constant_length").execute(*args, **kwargs)
                        def auto_scale(self, *args, **kwargs):
                            """
                            Enable/disable auto-scale of all vectors so that vector overlap is minimal.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/velocity_vectors/auto_scale").execute(*args, **kwargs)

                    class lights(TUIMenu):
                        """
                        Enter the lights menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def headlight_on(self, *args, **kwargs):
                            """
                            Turn the light that moves with the camera on or off.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/headlight_on").execute(*args, **kwargs)
                        def set_ambient_color(self, *args, **kwargs):
                            """
                            Set the ambient light color for the scene.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/set_ambient_color").execute(*args, **kwargs)
                        def lights_on(self, *args, **kwargs):
                            """
                            Turn all active lighting on/off.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/lights_on").execute(*args, **kwargs)
                        def set_light(self, *args, **kwargs):
                            """
                            Add or modify a directional, colored light.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/set_light").execute(*args, **kwargs)
                        def lighting_interpolation(self, *args, **kwargs):
                            """
                            Set lighting interpolation method.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/lights/lighting_interpolation").execute(*args, **kwargs)

                    class particle_tracks(TUIMenu):
                        """
                        Enter the particle-tracks menu to set parameters for display of particle tracks.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.filter_settings = self.__class__.filter_settings(path + ["filter_settings"], service)
                            self.sphere_settings = self.__class__.sphere_settings(path + ["sphere_settings"], service)
                            self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                            super().__init__(path, service)
                        def sphere_attrib(self, *args, **kwargs):
                            """
                            Specify size and number of slices to be used in drawing spheres.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_attrib").execute(*args, **kwargs)
                        def history_filename(self, *args, **kwargs):
                            """
                            Specify the name of the particle history file.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/history_filename").execute(*args, **kwargs)
                        def track_single_particle_stream(self, *args, **kwargs):
                            """
                            Specify the stream ID to be tracked.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/track_single_particle_stream").execute(*args, **kwargs)
                        def report_default_variables(self, *args, **kwargs):
                            """
                            Set the report variables to default.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_default_variables").execute(*args, **kwargs)
                        def radius(self, *args, **kwargs):
                            """
                            Set the radius for particle track (ribbons/cylinder only) cross-section.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/radius").execute(*args, **kwargs)
                        def display(self, *args, **kwargs):
                            """
                            Determine whether particle tracks will be displayed or only tracked.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/display").execute(*args, **kwargs)
                        def marker_size(self, *args, **kwargs):
                            """
                            Set the marker size for particle drawing.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/marker_size").execute(*args, **kwargs)
                        def coarsen_factor(self, *args, **kwargs):
                            """
                            Set the particle tracks coarsening factor.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/coarsen_factor").execute(*args, **kwargs)
                        def arrow_scale(self, *args, **kwargs):
                            """
                            Set the scale factor for arrows drawn on particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/arrow_scale").execute(*args, **kwargs)
                        def report_to(self, *args, **kwargs):
                            """
                            Specify the destination for the report (console, file, none).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_to").execute(*args, **kwargs)
                        def arrow_space(self, *args, **kwargs):
                            """
                            Set the spacing factor for arrows drawn on particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/arrow_space").execute(*args, **kwargs)
                        def report_variables(self, *args, **kwargs):
                            """
                            Set the report variables.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_variables").execute(*args, **kwargs)
                        def twist_factor(self, *args, **kwargs):
                            """
                            Set the scale factor for twisting (ribbons only).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/twist_factor").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set the display style for particle track (line/ribbon/cylinder/sphere).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/style").execute(*args, **kwargs)
                        def particle_skip(self, *args, **kwargs):
                            """
                            Specify how many particle tracks should be displayed.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/particle_skip").execute(*args, **kwargs)
                        def report_type(self, *args, **kwargs):
                            """
                            Set the report type for particle tracks.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/report_type").execute(*args, **kwargs)
                        def line_width(self, *args, **kwargs):
                            """
                            Set the width for particle track.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/line_width").execute(*args, **kwargs)

                        class filter_settings(TUIMenu):
                            """
                            Set filter for particle display.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def minimum(self, *args, **kwargs):
                                """
                                Specify the lower bound for the filter variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/minimum").execute(*args, **kwargs)
                            def enable_filtering(self, *args, **kwargs):
                                """
                                Specify whether particle display is filtered.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/enable_filtering").execute(*args, **kwargs)
                            def inside(self, *args, **kwargs):
                                """
                                Specify whether filter variable needs to be inside min/max to be displayed (else outside min/max).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/inside").execute(*args, **kwargs)
                            def maximum(self, *args, **kwargs):
                                """
                                Specify the upper bound for the filter variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/maximum").execute(*args, **kwargs)
                            def filter_variable(self, *args, **kwargs):
                                """
                                Select a variable used for filtering of particles.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/filter_settings/filter_variable").execute(*args, **kwargs)

                        class sphere_settings(TUIMenu):
                            """
                            Provide sphere specific input.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def diameter(self, *args, **kwargs):
                                """
                                Diameter of the spheres when vary-diameter? is disabled.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/diameter").execute(*args, **kwargs)
                            def vary_diameter(self, *args, **kwargs):
                                """
                                Specify whether the spheres can vary with another variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/vary_diameter").execute(*args, **kwargs)
                            def size_variable(self, *args, **kwargs):
                                """
                                Select a particle variable to size the spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/size_variable").execute(*args, **kwargs)
                            def smooth_parameter(self, *args, **kwargs):
                                """
                                Specify number of slices to be used in drawing spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/smooth_parameter").execute(*args, **kwargs)
                            def scale_factor(self, *args, **kwargs):
                                """
                                Specify a scale factor to enlarge/reduce the size of spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/scale_factor").execute(*args, **kwargs)
                            def minimum(self, *args, **kwargs):
                                """
                                Set the minimum value of the sphere to be displayed.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/minimum").execute(*args, **kwargs)
                            def auto_range(self, *args, **kwargs):
                                """
                                Specify whether displayed spheres should include auto range of variable to size spheres.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/auto_range").execute(*args, **kwargs)
                            def maximum(self, *args, **kwargs):
                                """
                                Set the maximum value of the sphere to be displayed.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/sphere_settings/maximum").execute(*args, **kwargs)

                        class vector_settings(TUIMenu):
                            """
                            Set vector specific input.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def length_to_head_ratio(self, *args, **kwargs):
                                """
                                Specify ratio of length to head for vectors and length to diameter for cylinders.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/length_to_head_ratio").execute(*args, **kwargs)
                            def constant_color(self, *args, **kwargs):
                                """
                                Specify a constant color for the vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/constant_color").execute(*args, **kwargs)
                            def length_variable(self, *args, **kwargs):
                                """
                                Specify whether the displayed vectors have length varying with another variable.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/length_variable").execute(*args, **kwargs)
                            def vector_variable(self, *args, **kwargs):
                                """
                                Select a particle vector function to specify vector direction.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_variable").execute(*args, **kwargs)
                            def vector_length(self, *args, **kwargs):
                                """
                                Specify the length of constant vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_length").execute(*args, **kwargs)
                            def color_variable(self, *args, **kwargs):
                                """
                                Specify whether the vectors should be colored by variable specified in /display/particle-track/particle-track (if false use a constant color).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/color_variable").execute(*args, **kwargs)
                            def style(self, *args, **kwargs):
                                """
                                Enable and set the display style for particle vectors (none/vector/centered-vector/centered-cylinder).
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/style").execute(*args, **kwargs)
                            def scale_factor(self, *args, **kwargs):
                                """
                                Specify a scale factor to enlarge/reduce the length of vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/scale_factor").execute(*args, **kwargs)
                            def vector_length_variable(self, *args, **kwargs):
                                """
                                Select a particle variable to specify the length of vectors.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/particle_tracks/vector_settings/vector_length_variable").execute(*args, **kwargs)

                    class path_lines(TUIMenu):
                        """
                        Enter the path-lines menu to set parameters for the display of pathlines.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def error_control(self, *args, **kwargs):
                            """
                            Set error control during pathline computation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/error_control").execute(*args, **kwargs)
                        def sphere_attrib(self, *args, **kwargs):
                            """
                            Specify size and no. of slices to be used in drawing sphere for sphere-style.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/sphere_attrib").execute(*args, **kwargs)
                        def arrow_scale(self, *args, **kwargs):
                            """
                            Set the scale factor for arrows drawn on pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/arrow_scale").execute(*args, **kwargs)
                        def display_steps(self, *args, **kwargs):
                            """
                            Set the display stepping for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/display_steps").execute(*args, **kwargs)
                        def reverse(self, *args, **kwargs):
                            """
                            Enable/disable the direction of path tracking.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/reverse").execute(*args, **kwargs)
                        def track_in_phase(self, *args, **kwargs):
                            """
                            Assign phase to display pathlines in.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/track_in_phase").execute(*args, **kwargs)
                        def step_size(self, *args, **kwargs):
                            """
                            Set the step length between particle positions for path-lines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/step_size").execute(*args, **kwargs)
                        def line_width(self, *args, **kwargs):
                            """
                            Set the width for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/line_width").execute(*args, **kwargs)
                        def marker_size(self, *args, **kwargs):
                            """
                            Set the marker size for particle drawing.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/marker_size").execute(*args, **kwargs)
                        def twist_factor(self, *args, **kwargs):
                            """
                            Set the scale factor for twisting (ribbons only).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/twist_factor").execute(*args, **kwargs)
                        def relative_pathlines(self, *args, **kwargs):
                            """
                            Enable/disable the tracking of pathlines in a relative coordinate system.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/relative_pathlines").execute(*args, **kwargs)
                        def style(self, *args, **kwargs):
                            """
                            Set display style for pathlines (line/ribbon/cylinder).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/style").execute(*args, **kwargs)
                        def radius(self, *args, **kwargs):
                            """
                            Set the radius for pathline (ribbons/cylinder only) cross-section.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/radius").execute(*args, **kwargs)
                        def arrow_space(self, *args, **kwargs):
                            """
                            Set the spacing factor for arrows drawn on pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/arrow_space").execute(*args, **kwargs)
                        def maximum_error(self, *args, **kwargs):
                            """
                            Set the maximum error allowed while computing the pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/maximum_error").execute(*args, **kwargs)
                        def maximum_steps(self, *args, **kwargs):
                            """
                            Set the maximum number of steps to take for pathlines.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/path_lines/maximum_steps").execute(*args, **kwargs)

                    class contours(TUIMenu):
                        """
                        Enter the contour options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def clip_to_range(self, *args, **kwargs):
                            """
                            Enable/disable the clip to range option for filled contours.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/clip_to_range").execute(*args, **kwargs)
                        def line_contours(self, *args, **kwargs):
                            """
                            Enable/disable the filled contour option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/line_contours").execute(*args, **kwargs)
                        def surfaces(self, *args, **kwargs):
                            """
                            Set surfaces to be contoured.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/surfaces").execute(*args, **kwargs)
                        def log_scale(self, *args, **kwargs):
                            """
                            Enable/disable the use of a log scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/log_scale").execute(*args, **kwargs)
                        def node_values(self, *args, **kwargs):
                            """
                            Enable/disable the plot of node values.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/node_values").execute(*args, **kwargs)
                        def auto_range(self, *args, **kwargs):
                            """
                            Enable/disable auto-computation of range for contours.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/auto_range").execute(*args, **kwargs)
                        def filled_contours(self, *args, **kwargs):
                            """
                            Enable/disable the filled contour option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/filled_contours").execute(*args, **kwargs)
                        def global_range(self, *args, **kwargs):
                            """
                            Enable/disable the global range for contours option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/global_range").execute(*args, **kwargs)
                        def render_mesh(self, *args, **kwargs):
                            """
                            Determine whether or not to render the mesh on top of contours, vectors, etc.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/render_mesh").execute(*args, **kwargs)
                        def coloring(self, *args, **kwargs):
                            """
                            Select coloring option.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/coloring").execute(*args, **kwargs)
                        def n_contour(self, *args, **kwargs):
                            """
                            Set the number of contour levels.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/contours/n_contour").execute(*args, **kwargs)

                    class colors(TUIMenu):
                        """
                        Enter the color options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.by_type = self.__class__.by_type(path + ["by_type"], service)
                            self.by_surface = self.__class__.by_surface(path + ["by_surface"], service)
                            super().__init__(path, service)
                        def highlight_color(self, *args, **kwargs):
                            """
                            Set highlight color.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/highlight_color").execute(*args, **kwargs)
                        def foreground(self, *args, **kwargs):
                            """
                            Set the foreground (text and window frame) color.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/foreground").execute(*args, **kwargs)
                        def periodic_faces(self, *args, **kwargs):
                            """
                            Set the color of periodic faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/periodic_faces").execute(*args, **kwargs)
                        def symmetry_faces(self, *args, **kwargs):
                            """
                            Set the color of symmetric faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/symmetry_faces").execute(*args, **kwargs)
                        def background(self, *args, **kwargs):
                            """
                            Set the background (window) color.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/background").execute(*args, **kwargs)
                        def wall_faces(self, *args, **kwargs):
                            """
                            Set the color of wall faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/wall_faces").execute(*args, **kwargs)
                        def surface(self, *args, **kwargs):
                            """
                            Set the color of surfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/surface").execute(*args, **kwargs)
                        def automatic_skip(self, *args, **kwargs):
                            """
                            Determine whether to skip labels in the colopmap scale automatically.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/automatic_skip").execute(*args, **kwargs)
                        def grid_interior(self, *args, **kwargs):
                            """
                            Set the color of interior faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/grid_interior").execute(*args, **kwargs)
                        def traction_faces(self, *args, **kwargs):
                            """
                            Set the color of traction faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/traction_faces").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List available colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/list").execute(*args, **kwargs)
                        def far_field_faces(self, *args, **kwargs):
                            """
                            Set the color of far field faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/far_field_faces").execute(*args, **kwargs)
                        def reset_user_colors(self, *args, **kwargs):
                            """
                            Reset all user colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/reset_user_colors").execute(*args, **kwargs)
                        def outlet_faces(self, *args, **kwargs):
                            """
                            Set the color of outlet faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/outlet_faces").execute(*args, **kwargs)
                        def axis_faces(self, *args, **kwargs):
                            """
                            Set the color of axisymmetric faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/axis_faces").execute(*args, **kwargs)
                        def internal_faces(self, *args, **kwargs):
                            """
                            Set the color of internal interface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/internal_faces").execute(*args, **kwargs)
                        def skip_label(self, *args, **kwargs):
                            """
                            Set the number of labels to be skipped in the colopmap scale.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/skip_label").execute(*args, **kwargs)
                        def show_user_colors(self, *args, **kwargs):
                            """
                            List currently defined user colors.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/show_user_colors").execute(*args, **kwargs)
                        def free_surface_faces(self, *args, **kwargs):
                            """
                            Set the color of free-surface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/free_surface_faces").execute(*args, **kwargs)
                        def grid_inlet(self, *args, **kwargs):
                            """
                            Set the color of inlet faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/grid_inlet").execute(*args, **kwargs)
                        def interior_faces(self, *args, **kwargs):
                            """
                            Set the color of interior faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/interior_faces").execute(*args, **kwargs)
                        def overset_faces(self, *args, **kwargs):
                            """
                            Set the color of overset faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/overset_faces").execute(*args, **kwargs)
                        def color_by_type(self, *args, **kwargs):
                            """
                            Determine whether to color meshes by type or by surface (ID).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/color_by_type").execute(*args, **kwargs)
                        def reset_colors(self, *args, **kwargs):
                            """
                            Reset individual mesh surface colors to the defaults.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/reset_colors").execute(*args, **kwargs)
                        def inlet_faces(self, *args, **kwargs):
                            """
                            Set the color of inlet faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/inlet_faces").execute(*args, **kwargs)
                        def user_color(self, *args, **kwargs):
                            """
                            Explicitly set color of display zone.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/user_color").execute(*args, **kwargs)
                        def interface_faces(self, *args, **kwargs):
                            """
                            Set the color of mesh Interfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/interface_faces").execute(*args, **kwargs)
                        def graphics_color_theme(self, *args, **kwargs):
                            """
                            Enter the graphics color theme menu.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/graphics_color_theme").execute(*args, **kwargs)
                        def rans_les_interface_faces(self, *args, **kwargs):
                            """
                            Set the color of RANS/LES interface faces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/colors/rans_les_interface_faces").execute(*args, **kwargs)

                        class by_type(TUIMenu):
                            """
                            Enter the zone type color and material assignment menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.type_name = self.__class__.type_name(path + ["type_name"], service)
                                super().__init__(path, service)
                            def use_inherent_material_color(self, *args, **kwargs):
                                """
                                Use inherent material color for boundary zones.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/use_inherent_material_color").execute(*args, **kwargs)
                            def only_list_case_boundaries(self, *args, **kwargs):
                                """
                                Only list the boundary types that are assigned in this case.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/only_list_case_boundaries").execute(*args, **kwargs)
                            def reset(self, *args, **kwargs):
                                """
                                To reset colors and/or materials to the defaults.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/reset").execute(*args, **kwargs)

                            class type_name(TUIMenu):
                                """
                                Select the boundary type to specify colors and/or materials.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    super().__init__(path, service)
                                def symmetry(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/symmetry").execute(*args, **kwargs)
                                def interior(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/interior").execute(*args, **kwargs)
                                def surface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/surface").execute(*args, **kwargs)
                                def axis(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/axis").execute(*args, **kwargs)
                                def interface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/interface").execute(*args, **kwargs)
                                def traction(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/traction").execute(*args, **kwargs)
                                def inlet(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/inlet").execute(*args, **kwargs)
                                def internal(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/internal").execute(*args, **kwargs)
                                def overset(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/overset").execute(*args, **kwargs)
                                def far_field(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/far_field").execute(*args, **kwargs)
                                def rans_les_interface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/rans_les_interface").execute(*args, **kwargs)
                                def free_surface(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/free_surface").execute(*args, **kwargs)
                                def periodic(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/periodic").execute(*args, **kwargs)
                                def outlet(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/outlet").execute(*args, **kwargs)
                                def wall(self, *args, **kwargs):
                                    """
                                    Set the material and/or color for the selected boundary type.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/colors/by_type/type_name/wall").execute(*args, **kwargs)

                        class by_surface(TUIMenu):
                            """
                            Enter the surface(s) color and material assignment menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def list_surfaces_by_material(self, *args, **kwargs):
                                """
                                To list the surfaces by its material.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/list_surfaces_by_material").execute(*args, **kwargs)
                            def list_surfaces_by_color(self, *args, **kwargs):
                                """
                                To list the surfaces by its color.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/list_surfaces_by_color").execute(*args, **kwargs)
                            def reset(self, *args, **kwargs):
                                """
                                To reset colors and/or materials to the defaults.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/reset").execute(*args, **kwargs)
                            def use_inherent_material_color(self, *args, **kwargs):
                                """
                                Use inherent material color for surfaces.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/use_inherent_material_color").execute(*args, **kwargs)
                            def surfaces(self, *args, **kwargs):
                                """
                                Select the surface(s) to specify colors and/or materials.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/colors/by_surface/surfaces").execute(*args, **kwargs)

                    class picture(TUIMenu):
                        """
                        Enter the hardcopy/save-picture options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.driver = self.__class__.driver(path + ["driver"], service)
                            self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                            super().__init__(path, service)
                        def dpi(self, *args, **kwargs):
                            """
                            Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/dpi").execute(*args, **kwargs)
                        def x_resolution(self, *args, **kwargs):
                            """
                            Set the width of raster-formatted images in pixels (0 implies current window size).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/x_resolution").execute(*args, **kwargs)
                        def preview(self, *args, **kwargs):
                            """
                            Display a preview image of a hardcopy.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/preview").execute(*args, **kwargs)
                        def set_standard_resolution(self, *args, **kwargs):
                            """
                            Select from pre-defined resolution list.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/set_standard_resolution").execute(*args, **kwargs)
                        def jpeg_hardcopy_quality(self, *args, **kwargs):
                            """
                            To set jpeg hardcopy quality.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                        def y_resolution(self, *args, **kwargs):
                            """
                            Set the height of raster-formatted images in pixels (0 implies current window size).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/y_resolution").execute(*args, **kwargs)
                        def use_window_resolution(self, *args, **kwargs):
                            """
                            Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/use_window_resolution").execute(*args, **kwargs)
                        def landscape(self, *args, **kwargs):
                            """
                            Plot hardcopies in landscape or portrait orientation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/landscape").execute(*args, **kwargs)
                        def invert_background(self, *args, **kwargs):
                            """
                            Use a white background when the picture is saved.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/picture/invert_background").execute(*args, **kwargs)

                        class driver(TUIMenu):
                            """
                            Enter the set hardcopy driver menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.post_format = self.__class__.post_format(path + ["post_format"], service)
                                super().__init__(path, service)
                            def post_script(self, *args, **kwargs):
                                """
                                Produce PostScript output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_script").execute(*args, **kwargs)
                            def list(self, *args, **kwargs):
                                """
                                List the current hardcopy driver.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/list").execute(*args, **kwargs)
                            def ppm(self, *args, **kwargs):
                                """
                                Produce PPM output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/ppm").execute(*args, **kwargs)
                            def dump_window(self, *args, **kwargs):
                                """
                                Set the command used to dump the graphics window to a file.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/dump_window").execute(*args, **kwargs)
                            def avz(self, *args, **kwargs):
                                """
                                Use AVZ output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/avz").execute(*args, **kwargs)
                            def vrml(self, *args, **kwargs):
                                """
                                Use VRML output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/vrml").execute(*args, **kwargs)
                            def glb(self, *args, **kwargs):
                                """
                                Use GLB output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/glb").execute(*args, **kwargs)
                            def png(self, *args, **kwargs):
                                """
                                Use PNG output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/png").execute(*args, **kwargs)
                            def hsf(self, *args, **kwargs):
                                """
                                Use HSF output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/hsf").execute(*args, **kwargs)
                            def tiff(self, *args, **kwargs):
                                """
                                Use TIFF output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/tiff").execute(*args, **kwargs)
                            def options(self, *args, **kwargs):
                                """
                                Set the hardcopy options. Available options are:
                                "no gamma correction", disables gamma correction of colors,
                                "physical size = (width,height)", where width and height
                                are the actual measurements of the printable area of the page
                                in centimeters.
                                "subscreen = (left,right,bottom,top)", where left,right,
                                bottom, and top are numbers in [-1,1] describing a subwindow on
                                the page in which to place the hardcopy.
                                The options may be combined by separating them with commas.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/options").execute(*args, **kwargs)
                            def jpeg(self, *args, **kwargs):
                                """
                                Produce JPEG output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/jpeg").execute(*args, **kwargs)
                            def eps(self, *args, **kwargs):
                                """
                                Produce encapsulated PostScript (EPS) output for hardcopies.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/eps").execute(*args, **kwargs)

                            class post_format(TUIMenu):
                                """
                                Enter the PostScript driver format menu.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    super().__init__(path, service)
                                def rle_raster(self, *args, **kwargs):
                                    """
                                    Use the run-length encoded raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/rle_raster").execute(*args, **kwargs)
                                def fast_raster(self, *args, **kwargs):
                                    """
                                    Use the new raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                                def vector(self, *args, **kwargs):
                                    """
                                    Use vector format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/vector").execute(*args, **kwargs)
                                def raster(self, *args, **kwargs):
                                    """
                                    Use the original raster format.
                                    """
                                    return PyMenu(self.service, "/results/graphics/expert/set/picture/driver/post_format/raster").execute(*args, **kwargs)

                        class color_mode(TUIMenu):
                            """
                            Enter the hardcopy color mode menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def color(self, *args, **kwargs):
                                """
                                Plot hardcopies in color.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/color").execute(*args, **kwargs)
                            def gray_scale(self, *args, **kwargs):
                                """
                                Convert color to grayscale for hardcopy.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/gray_scale").execute(*args, **kwargs)
                            def mono_chrome(self, *args, **kwargs):
                                """
                                Convert color to monochrome (black and white) for hardcopy.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/mono_chrome").execute(*args, **kwargs)
                            def list(self, *args, **kwargs):
                                """
                                Display the current hardcopy color mode.
                                """
                                return PyMenu(self.service, "/results/graphics/expert/set/picture/color_mode/list").execute(*args, **kwargs)

                    class rendering_options(TUIMenu):
                        """
                        Enter the rendering options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def face_displacement(self, *args, **kwargs):
                            """
                            Set face displacement value in Z-buffer units along the Camera Z-axis.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/face_displacement").execute(*args, **kwargs)
                        def set_rendering_options(self, *args, **kwargs):
                            """
                            Set the rendering options.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/set_rendering_options").execute(*args, **kwargs)
                        def hidden_line_method(self, *args, **kwargs):
                            """
                            Specify the method to perform hidden line rendering.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_line_method").execute(*args, **kwargs)
                        def auto_spin(self, *args, **kwargs):
                            """
                            Enable/disable mouse view rotations to continue to spin the display after the button is released.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/auto_spin").execute(*args, **kwargs)
                        def animation_option(self, *args, **kwargs):
                            """
                            Using Wireframe / All option during animation.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/animation_option").execute(*args, **kwargs)
                        def double_buffering(self, *args, **kwargs):
                            """
                            Enable/disable double-buffering.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/double_buffering").execute(*args, **kwargs)
                        def outer_face_cull(self, *args, **kwargs):
                            """
                            Enable/disable discarding outer faces during display.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/outer_face_cull").execute(*args, **kwargs)
                        def driver(self, *args, **kwargs):
                            """
                            Change the current graphics driver.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/driver").execute(*args, **kwargs)
                        def hidden_surface_method(self, *args, **kwargs):
                            """
                            Specify the method to perform hidden line and hidden surface rendering.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                        def show_colormap(self, *args, **kwargs):
                            """
                            Enable/Disable colormap.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/show_colormap").execute(*args, **kwargs)
                        def hidden_surfaces(self, *args, **kwargs):
                            """
                            Enable/disable hidden surface removal.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                        def color_map_alignment(self, *args, **kwargs):
                            """
                            Set the color bar alignment.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/color_map_alignment").execute(*args, **kwargs)
                        def device_info(self, *args, **kwargs):
                            """
                            List information for the graphics device.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/device_info").execute(*args, **kwargs)
                        def help_text_color(self, *args, **kwargs):
                            """
                            Set the color of screen help text.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/help_text_color").execute(*args, **kwargs)
                        def hidden_lines(self, *args, **kwargs):
                            """
                            Enable/disable hidden line removal.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/hidden_lines").execute(*args, **kwargs)
                        def surface_edge_visibility(self, *args, **kwargs):
                            """
                            Set edge visibility flags for surfaces.
                            """
                            return PyMenu(self.service, "/results/graphics/expert/set/rendering_options/surface_edge_visibility").execute(*args, **kwargs)

                class particle_tracks(TUIMenu):
                    """
                    Enter the particle tracks menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def plot_write_xy_plot(self, *args, **kwargs):
                        """
                        Plot or write XY plot of particle tracks.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/particle_tracks/plot_write_xy_plot").execute(*args, **kwargs)
                    def particle_tracks(self, *args, **kwargs):
                        """
                        Calculate and display particle tracks from defined injections.
                        """
                        return PyMenu(self.service, "/results/graphics/expert/particle_tracks/particle_tracks").execute(*args, **kwargs)

            class rendering_options(TUIMenu):
                """
                Enter the rendering options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def double_buffering(self, *args, **kwargs):
                    """
                    Enable/disable double-buffering.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/double_buffering").execute(*args, **kwargs)
                def hidden_line_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line rendering.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_line_method").execute(*args, **kwargs)
                def outer_face_cull(self, *args, **kwargs):
                    """
                    Enable/disable discarding outer faces during display.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/outer_face_cull").execute(*args, **kwargs)
                def set_rendering_options(self, *args, **kwargs):
                    """
                    Set the rendering options.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/set_rendering_options").execute(*args, **kwargs)
                def auto_spin(self, *args, **kwargs):
                    """
                    Enable/disable mouse view rotations to continue to spin the display after the button is released.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/auto_spin").execute(*args, **kwargs)
                def help_text_color(self, *args, **kwargs):
                    """
                    Set the color of screen help text.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/help_text_color").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    Enable/Disable colormap.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/show_colormap").execute(*args, **kwargs)
                def color_map_alignment(self, *args, **kwargs):
                    """
                    Set the color bar alignment.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/color_map_alignment").execute(*args, **kwargs)
                def hidden_surfaces(self, *args, **kwargs):
                    """
                    Enable/disable hidden surface removal.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                def driver(self, *args, **kwargs):
                    """
                    Change the current graphics driver.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/driver").execute(*args, **kwargs)
                def device_info(self, *args, **kwargs):
                    """
                    List information for the graphics device.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/device_info").execute(*args, **kwargs)
                def face_displacement(self, *args, **kwargs):
                    """
                    Set face displacement value in Z-buffer units along the Camera Z-axis.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/face_displacement").execute(*args, **kwargs)
                def surface_edge_visibility(self, *args, **kwargs):
                    """
                    Set edge visibility flags for surfaces.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/surface_edge_visibility").execute(*args, **kwargs)
                def hidden_lines(self, *args, **kwargs):
                    """
                    Enable/disable hidden line removal.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_lines").execute(*args, **kwargs)
                def hidden_surface_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line and hidden surface rendering.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                def animation_option(self, *args, **kwargs):
                    """
                    Using Wireframe / All option during animation.
                    """
                    return PyMenu(self.service, "/results/graphics/rendering_options/animation_option").execute(*args, **kwargs)

        class report(TUIMenu):
            """
            Enter the report menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
                self.modified_setting = self.__class__.modified_setting(path + ["modified_setting"], service)
                self.system = self.__class__.system(path + ["system"], service)
                self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
                self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.forces = self.__class__.forces(path + ["forces"], service)
                self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
                self.icing = self.__class__.icing(path + ["icing"], service)
                super().__init__(path, service)
            def write_histogram(self, *args, **kwargs):
                """
                Write a histogram of a scalar quantity to a file.
                """
                return PyMenu(self.service, "/results/report/write_histogram").execute(*args, **kwargs)
            def mphase_summary(self, *args, **kwargs):
                """
                Multiphase Summary and Recommendations.
                """
                return PyMenu(self.service, "/results/report/mphase_summary").execute(*args, **kwargs)
            def print_histogram(self, *args, **kwargs):
                """
                Print a histogram of a scalar quantity.
                """
                return PyMenu(self.service, "/results/report/print_histogram").execute(*args, **kwargs)
            def species_mass_flow(self, *args, **kwargs):
                """
                Print list of species mass flow rates at boundaries.
                """
                return PyMenu(self.service, "/results/report/species_mass_flow").execute(*args, **kwargs)
            def dpm_sample_output_udf(self, *args, **kwargs):
                """
                Set the DPM sampling output UDF.
                """
                return PyMenu(self.service, "/results/report/dpm_sample_output_udf").execute(*args, **kwargs)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/results/report/summary").execute(*args, **kwargs)
            def aero_optical_distortions(self, *args, **kwargs):
                """
                Optics report menu.
                """
                return PyMenu(self.service, "/results/report/aero_optical_distortions").execute(*args, **kwargs)
            def path_line_summary(self, *args, **kwargs):
                """
                Print path-line-summary report.
                """
                return PyMenu(self.service, "/results/report/path_line_summary").execute(*args, **kwargs)
            def projected_surface_area(self, *args, **kwargs):
                """
                Print total area of the projection of a group of surfaces to a plane.
                """
                return PyMenu(self.service, "/results/report/projected_surface_area").execute(*args, **kwargs)
            def volume_integrals(self, *args, **kwargs):
                """
                Volume Integral menu.
                """
                return PyMenu(self.service, "/results/report/volume_integrals").execute(*args, **kwargs)
            def dpm_sample(self, *args, **kwargs):
                """
                Sample trajectories at boundaries and lines/planes.
                """
                return PyMenu(self.service, "/results/report/dpm_sample").execute(*args, **kwargs)
            def element_mass_flow(self, *args, **kwargs):
                """
                Print list of element mass flow rates at boundaries.
                """
                return PyMenu(self.service, "/results/report/element_mass_flow").execute(*args, **kwargs)
            def surface_integrals(self, *args, **kwargs):
                """
                Surface Integral menu.
                """
                return PyMenu(self.service, "/results/report/surface_integrals").execute(*args, **kwargs)
            def dpm_sample_sort_file(self, *args, **kwargs):
                """
                Enable writing of sorted DPM sample files.
                """
                return PyMenu(self.service, "/results/report/dpm_sample_sort_file").execute(*args, **kwargs)
            def dpm_zone_summaries_per_injection(self, *args, **kwargs):
                """
                Enable per-injection zone DPM summaries.
                """
                return PyMenu(self.service, "/results/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
            def dpm_extended_summary(self, *args, **kwargs):
                """
                Print extended discrete phase summary report of particle fates, with options.
                """
                return PyMenu(self.service, "/results/report/dpm_extended_summary").execute(*args, **kwargs)
            def uds_flow(self, *args, **kwargs):
                """
                Print list of UDS flow rate at boundaries.
                """
                return PyMenu(self.service, "/results/report/uds_flow").execute(*args, **kwargs)
            def dpm_summary(self, *args, **kwargs):
                """
                Print discrete phase summary report of particle fates.
                """
                return PyMenu(self.service, "/results/report/dpm_summary").execute(*args, **kwargs)
            def particle_summary(self, *args, **kwargs):
                """
                Print summary report for all current particles.
                """
                return PyMenu(self.service, "/results/report/particle_summary").execute(*args, **kwargs)

            class reference_values(TUIMenu):
                """
                Reference value menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.compute = self.__class__.compute(path + ["compute"], service)
                    super().__init__(path, service)
                def velocity(self, *args, **kwargs):
                    """
                    Set reference velocity for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/velocity").execute(*args, **kwargs)
                def depth(self, *args, **kwargs):
                    """
                    Set reference depth for volume calculation.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/depth").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List current reference values.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/list").execute(*args, **kwargs)
                def zone(self, *args, **kwargs):
                    """
                    Set reference zone.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/zone").execute(*args, **kwargs)
                def area(self, *args, **kwargs):
                    """
                    Set reference area for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/area").execute(*args, **kwargs)
                def density(self, *args, **kwargs):
                    """
                    Set reference density for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/density").execute(*args, **kwargs)
                def length(self, *args, **kwargs):
                    """
                    Set reference length for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/length").execute(*args, **kwargs)
                def viscosity(self, *args, **kwargs):
                    """
                    Set reference viscosity for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/viscosity").execute(*args, **kwargs)
                def pressure(self, *args, **kwargs):
                    """
                    Set reference pressure for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/pressure").execute(*args, **kwargs)
                def yplus(self, *args, **kwargs):
                    """
                    Set reference yplus for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/yplus").execute(*args, **kwargs)
                def enthalpy(self, *args, **kwargs):
                    """
                    Set reference enthalpy for enthalpy damping and normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/enthalpy").execute(*args, **kwargs)
                def temperature(self, *args, **kwargs):
                    """
                    Set reference temperature for normalization.
                    """
                    return PyMenu(self.service, "/results/report/reference_values/temperature").execute(*args, **kwargs)

                class compute(TUIMenu):
                    """
                    Enter the compute menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def porous_jump(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                    def dummy_entry(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                    def pressure_far_field(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                    def fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/fan").execute(*args, **kwargs)
                    def network_end(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/network_end").execute(*args, **kwargs)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                    def solid(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/solid").execute(*args, **kwargs)
                    def recirculation_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                    def degassing(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/degassing").execute(*args, **kwargs)
                    def mass_flow_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                    def outlet_vent(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                    def fluid(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/fluid").execute(*args, **kwargs)
                    def recirculation_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                    def network(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/network").execute(*args, **kwargs)
                    def axis(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/axis").execute(*args, **kwargs)
                    def wall(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/wall").execute(*args, **kwargs)
                    def interior(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/interior").execute(*args, **kwargs)
                    def intake_fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                    def exhaust_fan(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                    def interface(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/interface").execute(*args, **kwargs)
                    def shadow(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/shadow").execute(*args, **kwargs)
                    def rans_les_interface(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                    def overset(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/overset").execute(*args, **kwargs)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                    def periodic(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/periodic").execute(*args, **kwargs)
                    def inlet_vent(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                    def symmetry(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                    def radiator(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/radiator").execute(*args, **kwargs)
                    def outflow(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/outflow").execute(*args, **kwargs)
                    def geometry(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/geometry").execute(*args, **kwargs)
                    def mass_flow_outlet(self, *args, **kwargs):
                        """
                        Compute reference values from a zone of this type.
                        """
                        return PyMenu(self.service, "/results/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)

            class modified_setting(TUIMenu):
                """
                Enter the menu for setting up the Modified Settings Summary table.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_user_setting(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/report/modified_setting/write_user_setting").execute(*args, **kwargs)
                def modified_setting(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/results/report/modified_setting/modified_setting").execute(*args, **kwargs)

            class system(TUIMenu):
                """
                Sytem menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def sys_stats(self, *args, **kwargs):
                    """
                    System information.
                    """
                    return PyMenu(self.service, "/results/report/system/sys_stats").execute(*args, **kwargs)
                def gpgpu_stats(self, *args, **kwargs):
                    """
                    GPGPU information.
                    """
                    return PyMenu(self.service, "/results/report/system/gpgpu_stats").execute(*args, **kwargs)
                def time_stats(self, *args, **kwargs):
                    """
                    Time usage information.
                    """
                    return PyMenu(self.service, "/results/report/system/time_stats").execute(*args, **kwargs)
                def proc_stats(self, *args, **kwargs):
                    """
                    Fluent process information.
                    """
                    return PyMenu(self.service, "/results/report/system/proc_stats").execute(*args, **kwargs)

            class dpm_histogram(TUIMenu):
                """
                Enter the DPM histogram menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                    super().__init__(path, service)
                def read_sample(self, *args, **kwargs):
                    """
                    Read a sample file and add it to the sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/read_sample").execute(*args, **kwargs)
                def reduce_picked_sample(self, *args, **kwargs):
                    """
                    Reduce a sample after first picking it and setting up all data-reduction options and parameters.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)
                def plot_sample(self, *args, **kwargs):
                    """
                    Plot a histogram of a loaded sample.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/plot_sample").execute(*args, **kwargs)
                def prep_dpm_sample_cont_plot_exprs(self, *args, **kwargs):
                    """
                    Prepare named expressions from data in a DPM sample file (collected at a cut plane surface) for contour plotting.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/prep_dpm_sample_cont_plot_exprs").execute(*args, **kwargs)
                def compute_sample(self, *args, **kwargs):
                    """
                    Compute minimum/maximum of a sample variable.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
                def write_sample(self, *args, **kwargs):
                    """
                    Write a histogram of a loaded sample into a file.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/write_sample").execute(*args, **kwargs)
                def delete_sample(self, *args, **kwargs):
                    """
                    Delete a sample from loaded sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/delete_sample").execute(*args, **kwargs)
                def list_samples(self, *args, **kwargs):
                    """
                    Show all samples in loaded sample list.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/list_samples").execute(*args, **kwargs)
                def pick_sample_to_reduce(self, *args, **kwargs):
                    """
                    Pick a sample for which to first set-up and then perform the data reduction.
                    """
                    return PyMenu(self.service, "/results/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the settings menu for the histogram.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def percentage(self, *args, **kwargs):
                        """
                        Use percentages of bins to be computed.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Specify mimimum value of x-axis variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                    def correlation(self, *args, **kwargs):
                        """
                        Compute correlation of sampling variable with other variable.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/correlation").execute(*args, **kwargs)
                    def logarithmic(self, *args, **kwargs):
                        """
                        Use logarithmic scaling on the abscissa (variable axis)? -- Will not work unless all values are positive.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)
                    def variable_power_3(self, *args, **kwargs):
                        """
                        Use the cubic of the cumulation variable during computation of the cumulative curve.
                        When the particle mass was not sampled, the diameter can be used instead.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                    def auto_range(self, *args, **kwargs):
                        """
                        Automatically compute range of sampling variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)
                    def weighting(self, *args, **kwargs):
                        """
                        Use weighting with additional variable when sorting data into samples.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Specify maximum value of x-axis variable for histogram plots.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                    def diameter_statistics(self, *args, **kwargs):
                        """
                        Compute Rosin Rammler parameters, Sauter and other mean diameters.
                        Requires specification of diameter as sampling variable.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)
                    def number_of_bins(self, *args, **kwargs):
                        """
                        Specify the number of bins.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)
                    def histogram_mode(self, *args, **kwargs):
                        """
                        Use bars for histogram plot or xy-style.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                    def cumulation_curve(self, *args, **kwargs):
                        """
                        Compute a cumulative curve for sampling variable or correlation variable when correlation? was specified.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)

                class setup_reduction(TUIMenu):
                    """
                    Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def all_variables_number_of_bins(self, *args, **kwargs):
                        """
                        Set the number of bins to be used for ALL variables in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)
                    def reset_min_and_max(self, *args, **kwargs):
                        """
                        Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Set the maximum value of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)
                    def list_settings(self, *args, **kwargs):
                        """
                        List all user inputs for the sample picked for data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                    def make_steady_from_unsteady_file(self, *args, **kwargs):
                        """
                        Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)
                    def use_weighting(self, *args, **kwargs):
                        """
                        Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)
                    def logarithmic(self, *args, **kwargs):
                        """
                        Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Set the minimum value of the range to be considered for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                    def number_of_bins(self, *args, **kwargs):
                        """
                        Set the number of bins to be used for a specific variable in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                    def weighting_variable(self, *args, **kwargs):
                        """
                        Choose the weighting variable for the averaging in each bin in the data reduction.
                        """
                        return PyMenu(self.service, "/results/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)

            class population_balance(TUIMenu):
                """
                Population Balance menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def moments(self, *args, **kwargs):
                    """
                    Set moments for population balance.
                    """
                    return PyMenu(self.service, "/results/report/population_balance/moments").execute(*args, **kwargs)
                def number_density(self, *args, **kwargs):
                    """
                    Set number density functions.
                    """
                    return PyMenu(self.service, "/results/report/population_balance/number_density").execute(*args, **kwargs)

            class simulation_reports(TUIMenu):
                """
                Enter the simulation reports menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                    super().__init__(path, service)
                def list_simulation_reports(self, *args, **kwargs):
                    """
                    List all report names.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
                def rename_simulation_report(self, *args, **kwargs):
                    """
                    Rename a report which has already been generated.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
                def reset_report_to_defaults(self, *args, **kwargs):
                    """
                    Reset all report settings to default for the provided simulation report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
                def view_simulation_report(self, *args, **kwargs):
                    """
                    View a simulation report that has already been generated. In batch mode this will print the report's URL.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)
                def generate_simulation_report(self, *args, **kwargs):
                    """
                    Generate a new simulation report or regenerate an existing simulation report with the provided name.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
                def export_simulation_report_as_pdf(self, *args, **kwargs):
                    """
                    Export the provided simulation report as a PDF file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
                def write_report_names_to_file(self, *args, **kwargs):
                    """
                    Write the list of currently generated report names to a txt file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
                def export_simulation_report_as_html(self, *args, **kwargs):
                    """
                    Export the provided simulation report as HTML.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
                def export_simulation_report_as_pptx(self, *args, **kwargs):
                    """
                    Export the provided simulation report as a PPT file.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)
                def delete_simulation_report(self, *args, **kwargs):
                    """
                    Delete the provided simulation report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
                def duplicate_simulation_report(self, *args, **kwargs):
                    """
                    Duplicate a report and all of its settings to a new report.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
                def read_simulation_report_template_file(self, *args, **kwargs):
                    """
                    Read a JSON template file with existing Simulation Report settings.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
                def write_simulation_report_template_file(self, *args, **kwargs):
                    """
                    Write a JSON template file with this case's Simulation Report settings.
                    """
                    return PyMenu(self.service, "/results/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)

                class parametric_study(TUIMenu):
                    """
                    Enter the parametric study menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def generate_design_point_report(self, *args, **kwargs):
                        """
                        Generate a simulation report for an updated design point.
                        """
                        return PyMenu(self.service, "/results/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
                    def generate_parametric_report(self, *args, **kwargs):
                        """
                        Generate a parametric report for your study.
                        """
                        return PyMenu(self.service, "/results/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enter the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def inlet_temperature(self, *args, **kwargs):
                    """
                    Print inlet temperature.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)
                def specific_heat(self, *args, **kwargs):
                    """
                    Print fluid's specific heat.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/specific_heat").execute(*args, **kwargs)
                def computed_heat_rejection(self, *args, **kwargs):
                    """
                    Print total heat rejection.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)
                def outlet_temperature(self, *args, **kwargs):
                    """
                    Print outlet temperature.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
                def mass_flow_rate(self, *args, **kwargs):
                    """
                    Print mass flow rate.
                    """
                    return PyMenu(self.service, "/results/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)

            class forces(TUIMenu):
                """
                Force report menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_center(self, *args, **kwargs):
                    """
                    Print center of pressure on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/pressure_center").execute(*args, **kwargs)
                def wall_forces(self, *args, **kwargs):
                    """
                    Print integrated pressure and viscous forces on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/wall_forces").execute(*args, **kwargs)
                def wall_moments(self, *args, **kwargs):
                    """
                    Print integrated pressure and viscous moments on wall zones.
                    """
                    return PyMenu(self.service, "/results/report/forces/wall_moments").execute(*args, **kwargs)

            class fluxes(TUIMenu):
                """
                Flux report menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_work(self, *args, **kwargs):
                    """
                    Print pressure work rate at moving boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/pressure_work").execute(*args, **kwargs)
                def film_mass_flow(self, *args, **kwargs):
                    """
                    Print film mass flow rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/film_mass_flow").execute(*args, **kwargs)
                def rad_heat_trans(self, *args, **kwargs):
                    """
                    Print radiation heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/rad_heat_trans").execute(*args, **kwargs)
                def film_heat_transfer(self, *args, **kwargs):
                    """
                    Print film heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
                def heat_transfer(self, *args, **kwargs):
                    """
                    Print heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/heat_transfer").execute(*args, **kwargs)
                def viscous_work(self, *args, **kwargs):
                    """
                    Print viscous work rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/viscous_work").execute(*args, **kwargs)
                def mass_flow(self, *args, **kwargs):
                    """
                    Print mass flow rate at inlets and outlets.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/mass_flow").execute(*args, **kwargs)
                def heat_transfer_sensible(self, *args, **kwargs):
                    """
                    Print sensible heat transfer rate at boundaries.
                    """
                    return PyMenu(self.service, "/results/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)

            class icing(TUIMenu):
                """
                Icing reports menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def particles_crystals_collection_eff(self, *args, **kwargs):
                    """
                    Print Crystals Collection Efficiency.
                    """
                    return PyMenu(self.service, "/results/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)
                def mass_of_ice(self, *args, **kwargs):
                    """
                    Print Mass of Ice Accretion.
                    """
                    return PyMenu(self.service, "/results/report/icing/mass_of_ice").execute(*args, **kwargs)
                def mass_of_water_impinged(self, *args, **kwargs):
                    """
                    Print Mass of Water Impingement.
                    """
                    return PyMenu(self.service, "/results/report/icing/mass_of_water_impinged").execute(*args, **kwargs)
                def energy_of_water_impinged(self, *args, **kwargs):
                    """
                    Print Energy of Water Impingement.
                    """
                    return PyMenu(self.service, "/results/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
                def energy_of_ice_formation(self, *args, **kwargs):
                    """
                    Print Energy of Ice Formation.
                    """
                    return PyMenu(self.service, "/results/report/icing/energy_of_ice_formation").execute(*args, **kwargs)
                def particles_droplets_collection_eff(self, *args, **kwargs):
                    """
                    Print Droplets Collection Efficiency.
                    """
                    return PyMenu(self.service, "/results/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
                def icing_energy_of_conduction(self, *args, **kwargs):
                    """
                    Print Energy of Conduction.
                    """
                    return PyMenu(self.service, "/results/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)

        class surface(TUIMenu):
            """
            Enter the data surface manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
                super().__init__(path, service)
            def circle_slice(self, *args, **kwargs):
                """
                Extract a circular slice.
                """
                return PyMenu(self.service, "/results/surface/circle_slice").execute(*args, **kwargs)
            def expression_volume(self, *args, **kwargs):
                """
                Create volume with boolean expression.
                """
                return PyMenu(self.service, "/results/surface/expression_volume").execute(*args, **kwargs)
            def multiple_plane_surfaces(self, *args, **kwargs):
                """
                Create multiple plane surfaces at specified spacing.
                """
                return PyMenu(self.service, "/results/surface/multiple_plane_surfaces").execute(*args, **kwargs)
            def mouse_rake(self, *args, **kwargs):
                """
                Define a "rake" surface using the mouse to select the end points.
                """
                return PyMenu(self.service, "/results/surface/mouse_rake").execute(*args, **kwargs)
            def line_surface(self, *args, **kwargs):
                """
                Define a "line" surface by specifying the two endpoint coordinates.
                """
                return PyMenu(self.service, "/results/surface/line_surface").execute(*args, **kwargs)
            def iso_clip(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/results/surface/iso_clip").execute(*args, **kwargs)
            def quadric_slice(self, *args, **kwargs):
                """
                Extract a quadric slice.
                """
                return PyMenu(self.service, "/results/surface/quadric_slice").execute(*args, **kwargs)
            def ellipsoid_slice(self, *args, **kwargs):
                """
                Extract a ellipsoid slice.
                """
                return PyMenu(self.service, "/results/surface/ellipsoid_slice").execute(*args, **kwargs)
            def point_array(self, *args, **kwargs):
                """
                Extract a rectangular array of data points.
                """
                return PyMenu(self.service, "/results/surface/point_array").execute(*args, **kwargs)
            def transform_surface(self, *args, **kwargs):
                """
                Transform surface.
                """
                return PyMenu(self.service, "/results/surface/transform_surface").execute(*args, **kwargs)
            def iso_clip_multiple(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/results/surface/iso_clip_multiple").execute(*args, **kwargs)
            def multiple_zone_surfaces(self, *args, **kwargs):
                """
                Create multiple data surfaces at a time.
                """
                return PyMenu(self.service, "/results/surface/multiple_zone_surfaces").execute(*args, **kwargs)
            def plane_surf_aligned(self, *args, **kwargs):
                """
                Create a plane aligned to a surface.
                """
                return PyMenu(self.service, "/results/surface/plane_surf_aligned").execute(*args, **kwargs)
            def create_imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/results/surface/create_imprint_surface").execute(*args, **kwargs)
            def structural_point_surface(self, *args, **kwargs):
                """
                Define a "structural point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/results/surface/structural_point_surface").execute(*args, **kwargs)
            def plane_point_n_normal(self, *args, **kwargs):
                """
                Create a plane from a point and normal.
                """
                return PyMenu(self.service, "/results/surface/plane_point_n_normal").execute(*args, **kwargs)
            def ungroup_surface(self, *args, **kwargs):
                """
                Ungroup the surface(if grouped).
                """
                return PyMenu(self.service, "/results/surface/ungroup_surface").execute(*args, **kwargs)
            def reset_zone_surfaces(self, *args, **kwargs):
                """
                Reset case surface list.
                """
                return PyMenu(self.service, "/results/surface/reset_zone_surfaces").execute(*args, **kwargs)
            def iso_surface(self, *args, **kwargs):
                """
                Extract an iso-surface (surface, curve, or point) from the curent data field.
                """
                return PyMenu(self.service, "/results/surface/iso_surface").execute(*args, **kwargs)
            def group_surfaces(self, *args, **kwargs):
                """
                Group a set of surfaces.
                """
                return PyMenu(self.service, "/results/surface/group_surfaces").execute(*args, **kwargs)
            def imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/results/surface/imprint_surface").execute(*args, **kwargs)
            def rename_surface(self, *args, **kwargs):
                """
                Rename a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/rename_surface").execute(*args, **kwargs)
            def surface_cells(self, *args, **kwargs):
                """
                Extract all cells intersected by a data surface.
                """
                return PyMenu(self.service, "/results/surface/surface_cells").execute(*args, **kwargs)
            def plane_bounded(self, *args, **kwargs):
                """
                Create a bounded surface.
                """
                return PyMenu(self.service, "/results/surface/plane_bounded").execute(*args, **kwargs)
            def cone_slice(self, *args, **kwargs):
                """
                Extract a cone slice.
                """
                return PyMenu(self.service, "/results/surface/cone_slice").execute(*args, **kwargs)
            def plane(self, *args, **kwargs):
                """
                Create a plane given 3 points bounded by the domain.
                """
                return PyMenu(self.service, "/results/surface/plane").execute(*args, **kwargs)
            def closest_point_search(self, *args, **kwargs):
                """
                Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
                """
                return PyMenu(self.service, "/results/surface/closest_point_search").execute(*args, **kwargs)
            def delete_surface(self, *args, **kwargs):
                """
                Remove a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/delete_surface").execute(*args, **kwargs)
            def zone_surface(self, *args, **kwargs):
                """
                Define a data surface on a mesh zone.
                """
                return PyMenu(self.service, "/results/surface/zone_surface").execute(*args, **kwargs)
            def multiple_iso_surfaces(self, *args, **kwargs):
                """
                Create multiple iso-surfaces from the data field at specified spacing.
                """
                return PyMenu(self.service, "/results/surface/multiple_iso_surfaces").execute(*args, **kwargs)
            def mouse_line(self, *args, **kwargs):
                """
                Define a line surface using the mouse to select two points.
                """
                return PyMenu(self.service, "/results/surface/mouse_line").execute(*args, **kwargs)
            def mouse_plane(self, *args, **kwargs):
                """
                Define a plane surface using the mouse to select three points.
                """
                return PyMenu(self.service, "/results/surface/mouse_plane").execute(*args, **kwargs)
            def partition_surface(self, *args, **kwargs):
                """
                Define a data surface on mesh faces on the partition boundary.
                """
                return PyMenu(self.service, "/results/surface/partition_surface").execute(*args, **kwargs)
            def point_surface(self, *args, **kwargs):
                """
                Define a "point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/results/surface/point_surface").execute(*args, **kwargs)
            def rake_surface(self, *args, **kwargs):
                """
                Define a "rake" surface by specifying the end points.
                """
                return PyMenu(self.service, "/results/surface/rake_surface").execute(*args, **kwargs)
            def edit_surface(self, *args, **kwargs):
                """
                Edit a defined data surface.
                """
                return PyMenu(self.service, "/results/surface/edit_surface").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List the number of facets in the defined surfaces.
                """
                return PyMenu(self.service, "/results/surface/list_surfaces").execute(*args, **kwargs)
            def line_slice(self, *args, **kwargs):
                """
                Extract a linear slice.
                """
                return PyMenu(self.service, "/results/surface/line_slice").execute(*args, **kwargs)
            def plane_surface(self, *args, **kwargs):
                """
                Create a plane from a coordinate plane, point and normal, or three points.
                """
                return PyMenu(self.service, "/results/surface/plane_surface").execute(*args, **kwargs)
            def sphere_slice(self, *args, **kwargs):
                """
                Extract a spherical slice.
                """
                return PyMenu(self.service, "/results/surface/sphere_slice").execute(*args, **kwargs)
            def plane_slice(self, *args, **kwargs):
                """
                Extract a planar slice.
                """
                return PyMenu(self.service, "/results/surface/plane_slice").execute(*args, **kwargs)
            def plane_view_plane_align(self, *args, **kwargs):
                """
                Create a plane aligned to a view-plane.
                """
                return PyMenu(self.service, "/results/surface/plane_view_plane_align").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter surface query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_surfaces(self, *args, **kwargs):
                    """
                    List surfaces.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_surfaces").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_queries").execute(*args, **kwargs)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/results/surface/query/delete_query").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of surface type.
                    """
                    return PyMenu(self.service, "/results/surface/query/list_named_selection").execute(*args, **kwargs)
                def named_surface_list(self, *args, **kwargs):
                    """
                    Create named list of surfaces.
                    """
                    return PyMenu(self.service, "/results/surface/query/named_surface_list").execute(*args, **kwargs)

            class post_processing_volume(TUIMenu):
                """
                Enter post-processing volume menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create_from_file(self, *args, **kwargs):
                    """
                    Read post-processing mesh from file.
                    """
                    return PyMenu(self.service, "/results/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)
                def create_octree(self, *args, **kwargs):
                    """
                    Create post-processing octree mesh based on current case.
                    """
                    return PyMenu(self.service, "/results/surface/post_processing_volume/create_octree").execute(*args, **kwargs)

    class views(TUIMenu):
        """
        Enter the view manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.display_states = self.__class__.display_states(path + ["display_states"], service)
            self.camera = self.__class__.camera(path + ["camera"], service)
            super().__init__(path, service)
        def read_views(self, *args, **kwargs):
            """
            Reads views from a view file.
            """
            return PyMenu(self.service, "/views/read_views").execute(*args, **kwargs)
        def delete_view(self, *args, **kwargs):
            """
            Removes a view from the list.
            """
            return PyMenu(self.service, "/views/delete_view").execute(*args, **kwargs)
        def default_view(self, *args, **kwargs):
            """
            Resets view to front and center.
            """
            return PyMenu(self.service, "/views/default_view").execute(*args, **kwargs)
        def write_views(self, *args, **kwargs):
            """
            Writes selected views to a view file.
            """
            return PyMenu(self.service, "/views/write_views").execute(*args, **kwargs)
        def restore_view(self, *args, **kwargs):
            """
            Uses a saved view.
            """
            return PyMenu(self.service, "/views/restore_view").execute(*args, **kwargs)
        def list_views(self, *args, **kwargs):
            """
            Lists predefined and saved views.
            """
            return PyMenu(self.service, "/views/list_views").execute(*args, **kwargs)
        def save_view(self, *args, **kwargs):
            """
            Saves the current view to the view list.
            """
            return PyMenu(self.service, "/views/save_view").execute(*args, **kwargs)
        def last_view(self, *args, **kwargs):
            """
            Returns to the camera position before the last manipulation.
            """
            return PyMenu(self.service, "/views/last_view").execute(*args, **kwargs)
        def next_view(self, *args, **kwargs):
            """
            .
            """
            return PyMenu(self.service, "/views/next_view").execute(*args, **kwargs)
        def auto_scale(self, *args, **kwargs):
            """
            Scales and centers the current scene without changing its orientation.
            """
            return PyMenu(self.service, "/views/auto_scale").execute(*args, **kwargs)

        class display_states(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete object.
                """
                return PyMenu(self.service, "/views/display_states/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit display-states object.
                """
                return PyMenu(self.service, "/views/display_states/edit").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/write").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/list").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/read").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/copy").execute(*args, **kwargs)
            def new(self, *args, **kwargs):
                """
                Create a new display-states object.
                """
                return PyMenu(self.service, "/views/display_states/new").execute(*args, **kwargs)
            def use_active(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/use_active").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename object.
                """
                return PyMenu(self.service, "/views/display_states/rename").execute(*args, **kwargs)
            def restore_state(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/restore_state").execute(*args, **kwargs)

        class camera(TUIMenu):
            """
            Enters the camera menu to modify the current viewing parameters.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def target(self, *args, **kwargs):
                """
                Sets the point to be the center of the camera view.
                """
                return PyMenu(self.service, "/views/camera/target").execute(*args, **kwargs)
            def orbit_camera(self, *args, **kwargs):
                """
                Adjusts the camera position without modifying the target.
                """
                return PyMenu(self.service, "/views/camera/orbit_camera").execute(*args, **kwargs)
            def projection(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/camera/projection").execute(*args, **kwargs)
            def zoom_camera(self, *args, **kwargs):
                """
                Adjusts the camera’s field of view. This operation is similar to dollying the camera in or out of the scene. Dollying causes objects in front to move past you. Zooming changes the perspective effect in the scene (and can be disconcerting).
                """
                return PyMenu(self.service, "/views/camera/zoom_camera").execute(*args, **kwargs)
            def field(self, *args, **kwargs):
                """
                Sets the field of view (width and height).
                """
                return PyMenu(self.service, "/views/camera/field").execute(*args, **kwargs)
            def roll_camera(self, *args, **kwargs):
                """
                Adjusts the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/roll_camera").execute(*args, **kwargs)
            def pan_camera(self, *args, **kwargs):
                """
                Adjusts the camera target without modifying the position.
                """
                return PyMenu(self.service, "/views/camera/pan_camera").execute(*args, **kwargs)
            def position(self, *args, **kwargs):
                """
                Sets the camera position.
                """
                return PyMenu(self.service, "/views/camera/position").execute(*args, **kwargs)
            def up_vector(self, *args, **kwargs):
                """
                Sets the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/up_vector").execute(*args, **kwargs)
            def dolly_camera(self, *args, **kwargs):
                """
                Adjusts the camera position and target.
                """
                return PyMenu(self.service, "/views/camera/dolly_camera").execute(*args, **kwargs)

    class simulation_reports(TUIMenu):
        """
        Enter the simulation reports menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
            super().__init__(path, service)
        def delete_simulation_report(self, *args, **kwargs):
            """
            Delete the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
        def export_simulation_report_as_html(self, *args, **kwargs):
            """
            Export the provided simulation report as HTML.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
        def export_simulation_report_as_pptx(self, *args, **kwargs):
            """
            Export the provided simulation report as a PPT file.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_pptx").execute(*args, **kwargs)
        def duplicate_simulation_report(self, *args, **kwargs):
            """
            Duplicate a report and all of its settings to a new report.
            """
            return PyMenu(self.service, "/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
        def rename_simulation_report(self, *args, **kwargs):
            """
            Rename a report which has already been generated.
            """
            return PyMenu(self.service, "/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
        def generate_simulation_report(self, *args, **kwargs):
            """
            Generate a new simulation report or regenerate an existing simulation report with the provided name.
            """
            return PyMenu(self.service, "/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
        def write_report_names_to_file(self, *args, **kwargs):
            """
            Write the list of currently generated report names to a txt file.
            """
            return PyMenu(self.service, "/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
        def view_simulation_report(self, *args, **kwargs):
            """
            View a simulation report that has already been generated. In batch mode this will print the report's URL.
            """
            return PyMenu(self.service, "/simulation_reports/view_simulation_report").execute(*args, **kwargs)
        def write_simulation_report_template_file(self, *args, **kwargs):
            """
            Write a JSON template file with this case's Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
        def read_simulation_report_template_file(self, *args, **kwargs):
            """
            Read a JSON template file with existing Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
        def export_simulation_report_as_pdf(self, *args, **kwargs):
            """
            Export the provided simulation report as a PDF file.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
        def reset_report_to_defaults(self, *args, **kwargs):
            """
            Reset all report settings to default for the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
        def list_simulation_reports(self, *args, **kwargs):
            """
            List all report names.
            """
            return PyMenu(self.service, "/simulation_reports/list_simulation_reports").execute(*args, **kwargs)

        class parametric_study(TUIMenu):
            """
            Enter the parametric study menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def generate_design_point_report(self, *args, **kwargs):
                """
                Generate a simulation report for an updated design point.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
            def generate_parametric_report(self, *args, **kwargs):
                """
                Generate a parametric report for your study.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

    class define(TUIMenu):
        """
        Enter the define menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.spectral = self.__class__.spectral(path + ["spectral"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.virtual_boundary = self.__class__.virtual_boundary(path + ["virtual_boundary"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.phases = self.__class__.phases(path + ["phases"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.custom_field_functions = self.__class__.custom_field_functions(path + ["custom_field_functions"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.profiles = self.__class__.profiles(path + ["profiles"], service)
            self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
            self.curvilinear_coordinate_system = self.__class__.curvilinear_coordinate_system(path + ["curvilinear_coordinate_system"], service)
            super().__init__(path, service)
        def boundary_conditions(self, *args, **kwargs):
            """
            Enter the boundary conditions menu.
            """
            return PyMenu(self.service, "/define/boundary_conditions").execute(*args, **kwargs)
        def physics(self, *args, **kwargs):
            """
            Manage Physics-regions.
            """
            return PyMenu(self.service, "/define/physics").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            Applies a standard set of units to all quantities. The options include default,si, british, andcgs.
            """
            return PyMenu(self.service, "/define/set_unit_system").execute(*args, **kwargs)
        def enable_expressions(self, *args, **kwargs):
            """
            Enable the expressions feature.
            """
            return PyMenu(self.service, "/define/enable_expressions").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Sets unit conversion factors.
            """
            return PyMenu(self.service, "/define/units").execute(*args, **kwargs)
        def beta_feature_access(self, *args, **kwargs):
            """
            Enable access to beta features in the interface.
            """
            return PyMenu(self.service, "/define/beta_feature_access").execute(*args, **kwargs)
        def injections(self, *args, **kwargs):
            """
            Enters the injections menu.  For a description of the items in this menu, see define/models/dpm/injections.
            """
            return PyMenu(self.service, "/define/injections").execute(*args, **kwargs)
        def enable_mesh_morpher_optimizer(self, *args, **kwargs):
            """
            Enables the mesh morpher/optimizer. When the mesh morpher/optimizer is enabled, the define/mesh-morpher-optimizer text command becomes available.
            """
            return PyMenu(self.service, "/define/enable_mesh_morpher_optimizer").execute(*args, **kwargs)

        class spectral(TUIMenu):
            """
            Enter the Spectral menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def calculate_fourier_coefficients(self, *args, **kwargs):
                """
                Calculates Fourier coefficient data.
                """
                return PyMenu(self.service, "/define/spectral/calculate_fourier_coefficients").execute(*args, **kwargs)
            def delete_fourier_coefficients(self, *args, **kwargs):
                """
                Deletes Fourier coefficient data.
                """
                return PyMenu(self.service, "/define/spectral/delete_fourier_coefficients").execute(*args, **kwargs)
            def delete_harmonic_exports(self, *args, **kwargs):
                """
                Deletes Harmonic Export data.
                """
                return PyMenu(self.service, "/define/spectral/delete_harmonic_exports").execute(*args, **kwargs)
            def calculate_harmonic_exports(self, *args, **kwargs):
                """
                Calculates Harmonic Export data.
                """
                return PyMenu(self.service, "/define/spectral/calculate_harmonic_exports").execute(*args, **kwargs)

        class parameters(TUIMenu):
            """
            Enters the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enables/disables parameters in the text user interface.
                """
                return PyMenu(self.service, "/define/parameters/enable_in_TUI").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enters the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edits an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/delete").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/list").execute(*args, **kwargs)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/delete").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/output_parameters").execute(*args, **kwargs)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/input_parameters").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enters the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create(self, *args, **kwargs):
                    """
                    Creates an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/create").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Renames an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/rename").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/edit").execute(*args, **kwargs)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Writes all parameter values to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/delete").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Displays all parameter values in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Writes parameter value to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def print_to_console(self, *args, **kwargs):
                    """
                    Displays parameter value in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_to_console").execute(*args, **kwargs)

        class gap_model(TUIMenu):
            """
            Enters the gap model menu, where you can define one or more gap regions where the flow is blocked or decelerated when face zones move within a specified proximity threshold of each other.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.advanced_options = self.__class__.advanced_options(path + ["advanced_options"], service)
                super().__init__(path, service)
            def list_gap_regions(self, *args, **kwargs):
                """
                Lists the properties of the gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_regions").execute(*args, **kwargs)
            def list_gap_face_zones(self, *args, **kwargs):
                """
                Lists the names of the face zones that can be used for creating gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_face_zones").execute(*args, **kwargs)
            def list_gap_cell_zones(self, *args, **kwargs):
                """
                Lists the names of the cell zones that can be excluded for individual gap regions (so that such cells are not marked for flow blockage / deceleration).
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_cell_zones").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes an existing gap region.
                """
                return PyMenu(self.service, "/define/gap_model/delete").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables/disables the gap model.
                """
                return PyMenu(self.service, "/define/gap_model/enable").execute(*args, **kwargs)
            def render_gap_regions(self, *args, **kwargs):
                """
                Update gap regions for postprocessing.
                """
                return PyMenu(self.service, "/define/gap_model/render_gap_regions").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates a single gap region, so that when selected face zones move within a specified proximity threshold of each other, flow blockage / deceleration is applied to the cells that lie within the threshold.
                """
                return PyMenu(self.service, "/define/gap_model/create").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing gap region.
                """
                return PyMenu(self.service, "/define/gap_model/edit").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the existing gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/delete_all").execute(*args, **kwargs)

            class advanced_options(TUIMenu):
                """
                Enters the advanced options menu for the gap model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def check_cfl_condition(self, *args, **kwargs):
                    """
                    Enables/disables the printing of warnings if the time 	step size is too large based on a Courant (CFL) number 	automatically determined for your specified solution 	stability level.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/check_cfl_condition").execute(*args, **kwargs)
                def enhanced_data_interpolation(self, *args, **kwargs):
                    """
                    Enables/disables the use of enhanced data 	interpolation when updating information in gap regions. 	This text command is only available if you have enabled 	the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/enhanced_data_interpolation").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity for messages printed in the console 	related to the gap model.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/verbosity").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Sets the global solution stabilization level for the gap 	regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/solution_stabilization").execute(*args, **kwargs)
                def sponge_layer(self, *args, **kwargs):
                    """
                    Allows you to edit the solution stabilization settings for flow-modeling gap regions 	that have sponge-layer local stabilization 	enabled.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/sponge_layer").execute(*args, **kwargs)
                def fill_data_in_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables the interpolation of solution data throughout the gap regions. This 	text command is only available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/fill_data_in_gap_regions").execute(*args, **kwargs)
                def cell_check_distance_factor(self, *args, **kwargs):
                    """
                    Enter value of the cell distance factor.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/cell_check_distance_factor").execute(*args, **kwargs)
                def include_coupled_walls(self, *args, **kwargs):
                    """
                    Include coupled walls in gap face zones.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/include_coupled_walls").execute(*args, **kwargs)
                def revert_controls_to_default(self, *args, **kwargs):
                    """
                    Reverts the global gap stabilization level and any related 	solver settings to the default.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/revert_controls_to_default").execute(*args, **kwargs)
                def extend_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables the extending of the gap regions by including additional cells in 	the vicinity of the gap interfaces during marking. This 	is useful when the default shape of the marked cells is 	negatively affecting solution stability or convergence 	behavior.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/extend_gap_regions").execute(*args, **kwargs)
                def clear_gap_regions(self, *args, **kwargs):
                    """
                    Clear gap model solution information and marks.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/clear_gap_regions").execute(*args, **kwargs)
                def render_flow_modeling_gaps(self, *args, **kwargs):
                    """
                    Enables/disables the rendering of the solution in the cells of flow-modeling gap 	regions during postprocessing. This text command is only 	available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/render_flow_modeling_gaps").execute(*args, **kwargs)
                def precise_gap_marking(self, *args, **kwargs):
                    """
                    Enables/disables the use of a more accurate search algorithm for marking cells in 	gap regions. Note that it can be costly, particularly 	for 3D cases or those with a large number of cells 	inside the gap regions. This text command is only 	available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/precise_gap_marking").execute(*args, **kwargs)
                def update_gap_regions(self, *args, **kwargs):
                    """
                    Update gap regions and gap model solution information.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/update_gap_regions").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enables/disables access to expert-level text commands 	for the gap model.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/expert").execute(*args, **kwargs)
                def flow_blocking_stabilization_parameters(self, *args, **kwargs):
                    """
                    Adjust stabilization settings for the sponge layer used for blocked gap regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/flow_blocking_stabilization_parameters").execute(*args, **kwargs)
                def alternative_marking(self, *args, **kwargs):
                    """
                    Mark gap regions using an alternative marking algorithm.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/alternative_marking").execute(*args, **kwargs)
                def reduce_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables a more restrictive algorithm for marking cells in gap regions. This 	text command is only available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/reduce_gap_regions").execute(*args, **kwargs)
                def render_gap_interface(self, *args, **kwargs):
                    """
                    Enables/disables the rendering of the mesh surfaces inside the gap regions when 	displaying the mesh with contours. Note that the 	solution is still not rendered inside the flow-blocking 	gap regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/render_gap_interface").execute(*args, **kwargs)

        class dynamic_mesh(TUIMenu):
            """
            Enters the dynamic mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.actions = self.__class__.actions(path + ["actions"], service)
                self.transient_settings = self.__class__.transient_settings(path + ["transient_settings"], service)
                self.zones = self.__class__.zones(path + ["zones"], service)
                self.events = self.__class__.events(path + ["events"], service)
                self.controls = self.__class__.controls(path + ["controls"], service)
                super().__init__(path, service)
            def dynamic_mesh(self, *args, **kwargs):
                """
                Enables/disables the dynamic mesh solver.
                """
                return PyMenu(self.service, "/define/dynamic_mesh/dynamic_mesh").execute(*args, **kwargs)

            class actions(TUIMenu):
                """
                Enters the dynamic mesh action menu, where you can initiate manual remeshing (that is, remeshing without running a calculation).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remesh_cell_zone(self, *args, **kwargs):
                    """
                    Manually remeshes a cell zone with option to remesh adjacent dynamic face 	zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/actions/remesh_cell_zone").execute(*args, **kwargs)

            class transient_settings(TUIMenu):
                """
                Enters the transient dynamic mesh settings menu. This text command is only available when you enable dynamic mesh using the prompts of the define/dynamic-mesh/dynamic-mesh? text command. Solver time must also be set to Transient.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def allow_second_order(self, *args, **kwargs):
                    """
                    Enables/disables second order transient scheme for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/transient_settings/allow_second_order").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Enables/disables transient scheme verbosity for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/transient_settings/verbosity").execute(*args, **kwargs)

            class zones(TUIMenu):
                """
                Enters the dynamic mesh zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    Lists the dynamic zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/list").execute(*args, **kwargs)
                def remove_interior_layer(self, *args, **kwargs):
                    """
                    Removes an interior layer cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/remove_interior_layer").execute(*args, **kwargs)
                def insert_interior_layer(self, *args, **kwargs):
                    """
                    Inserts a new layer cell zone at a specified location.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/insert_interior_layer").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a dynamic zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create dynamic zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/create").execute(*args, **kwargs)
                def insert_boundary_layer(self, *args, **kwargs):
                    """
                    Inserts a new cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/insert_boundary_layer").execute(*args, **kwargs)
                def remove_boundary_layer(self, *args, **kwargs):
                    """
                    Removes a cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/remove_boundary_layer").execute(*args, **kwargs)

            class events(TUIMenu):
                """
                Enters the dynamic mesh events menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_event_file(self, *args, **kwargs):
                    """
                    Exports dynamic mesh events to file.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/events/export_event_file").execute(*args, **kwargs)
                def import_event_file(self, *args, **kwargs):
                    """
                    Imports dynamic mesh event file.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/events/import_event_file").execute(*args, **kwargs)

            class controls(TUIMenu):
                """
                Enters the dynamic mesh controls menu. This text command is only available when the define/dynamic-mesh/dynamic-mesh? text command is enabled.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.layering_parameters = self.__class__.layering_parameters(path + ["layering_parameters"], service)
                    self.smoothing_parameters = self.__class__.smoothing_parameters(path + ["smoothing_parameters"], service)
                    self.remeshing_parameters = self.__class__.remeshing_parameters(path + ["remeshing_parameters"], service)
                    self.contact_parameters = self.__class__.contact_parameters(path + ["contact_parameters"], service)
                    self.in_cylinder_parameters = self.__class__.in_cylinder_parameters(path + ["in_cylinder_parameters"], service)
                    self.periodic_displacement_parameters = self.__class__.periodic_displacement_parameters(path + ["periodic_displacement_parameters"], service)
                    self.implicit_update_parameters = self.__class__.implicit_update_parameters(path + ["implicit_update_parameters"], service)
                    self.six_dof_parameters = self.__class__.six_dof_parameters(path + ["six_dof_parameters"], service)
                    super().__init__(path, service)
                def remeshing(self, *args, **kwargs):
                    """
                    Enables/disables local remeshing in tri/tet and mixed cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing").execute(*args, **kwargs)
                def in_cylinder_output(self, *args, **kwargs):
                    """
                    Enables/disables in-cylinder output.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_output").execute(*args, **kwargs)
                def smoothing(self, *args, **kwargs):
                    """
                    Enables/disables smoothing in cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing").execute(*args, **kwargs)
                def layering(self, *args, **kwargs):
                    """
                    Enables/disables dynamic-layering in quad/hex cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/layering").execute(*args, **kwargs)
                def steady_pseudo_time_control(self, *args, **kwargs):
                    """
                    Enables/disables the pseudo time step control in the 	graphical user interface.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/steady_pseudo_time_control").execute(*args, **kwargs)

                class layering_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh layering menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def constant_height(self, *args, **kwargs):
                        """
                        Enables/disables layering based on constant height, else layering based on constant ratio.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/constant_height").execute(*args, **kwargs)
                    def collapse_factor(self, *args, **kwargs):
                        """
                        Sets the factor determining when to collapse dynamic layers.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/collapse_factor").execute(*args, **kwargs)
                    def split_factor(self, *args, **kwargs):
                        """
                        Sets the factor determining when to split dynamic layers.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/split_factor").execute(*args, **kwargs)

                class smoothing_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh smoothing-parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def smoothing_method(self, *args, **kwargs):
                        """
                        Specify the smoothing method used by the dynamic mesh model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/smoothing_method").execute(*args, **kwargs)
                    def poisson_ratio(self, *args, **kwargs):
                        """
                        Sets the Poisson’s ratio used for smoothing based on the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/poisson_ratio").execute(*args, **kwargs)
                    def relative_convergence_tolerance(self, *args, **kwargs):
                        """
                        Sets the relative residual convergence tolerance for smoothing based on diffusion or the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/relative_convergence_tolerance").execute(*args, **kwargs)
                    def laplace_node_relaxation(self, *args, **kwargs):
                        """
                        Set the Laplace boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/laplace_node_relaxation").execute(*args, **kwargs)
                    def constant_factor(self, *args, **kwargs):
                        """
                        Sets the spring constant relaxation factor.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/constant_factor").execute(*args, **kwargs)
                    def skew_smooth_face_skew_max(self, *args, **kwargs):
                        """
                        Sets the skewness threshold, above which faces will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_face_skew_max").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for mesh smoothing (FEM).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/amg_stabilization").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for spring-based solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/max_iter").execute(*args, **kwargs)
                    def spring_on_simplex_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for tri/tet elements in mixed element zones.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/spring_on_simplex_elements").execute(*args, **kwargs)
                    def diffusion_coeff_function(self, *args, **kwargs):
                        """
                        Specifies whether the diffusion coefficient for diffusion-based smoothing is based on the boundary distance or the cell volume.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_function").execute(*args, **kwargs)
                    def diffusion_fvm(self, *args, **kwargs):
                        """
                        Answering yes at the prompt changes the diffusion-based smoothing method to the cell-based finite volume approach that was the default in releases prior to Fluent 15.0. Answering no at the prompt changes the diffusion-based smoothing method to the default node-based finite element method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_fvm").execute(*args, **kwargs)
                    def diffusion_coeff_parameter(self, *args, **kwargs):
                        """
                        Sets the diffusion coefficient parameter used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_parameter").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for spring smoothing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/verbosity").execute(*args, **kwargs)
                    def smooth_from_reference_position(self, *args, **kwargs):
                        """
                        Enables/disables smoothing from a reference position. Such smoothing may produce greater mesh quality consistency for stationary or moving meshes with periodic or quasi-periodic motion, and is only available when the smoothing method is based on diffusion or the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/smooth_from_reference_position").execute(*args, **kwargs)
                    def skew_smooth_niter(self, *args, **kwargs):
                        """
                        Sets the number of skewness-based smoothing cycles.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_niter").execute(*args, **kwargs)
                    def skew_smooth_cell_skew_max(self, *args, **kwargs):
                        """
                        Sets the skewness threshold, above which cells will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_cell_skew_max").execute(*args, **kwargs)
                    def bnd_stiffness_factor(self, *args, **kwargs):
                        """
                        Sets the stiffness factor for springs connected to boundary nodes.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/bnd_stiffness_factor").execute(*args, **kwargs)
                    def skew_smooth_all_deforming_boundaries(self, *args, **kwargs):
                        """
                        Enables/disables skewness smoothing for all deforming dynamic boundary zones. This is enabled by default. If disabled, skewness smoothing is only applied to the deforming dynamic boundary zones that have smoothing explicitly enabled or use local face remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_all_deforming_boundaries").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Sets the convergence tolerance for spring-based solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/convergence_tolerance").execute(*args, **kwargs)
                    def bnd_node_relaxation(self, *args, **kwargs):
                        """
                        The boundary node relaxation is used by spring smoothing. The boundary node relaxation allows you to relax the update of the node positions at deforming boundaries. A value of 0 prevents deforming boundary nodes from moving and a value of 1 indicates no under-relaxation.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/bnd_node_relaxation").execute(*args, **kwargs)
                    def boundary_distance_method(self, *args, **kwargs):
                        """
                        Sets the method used to evaluate the boundary distance for the diffusion coefficient calculation, when diffusion-based smoothing is enabled.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/boundary_distance_method").execute(*args, **kwargs)
                    def spring_on_all_elements(self, *args, **kwargs):
                        """
                        Enables/disables spring-based smoothing for all cell shapes; if disabled, the spring-based smoothing is applied based on the setting of the define/dynamic-mesh/controls/smoothing-parameters/spring-on-simplex-shapes? text command.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/spring_on_all_elements").execute(*args, **kwargs)

                class remeshing_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh remeshing menu to set 	parameters for all remeshing methods.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.prism_controls = self.__class__.prism_controls(path + ["prism_controls"], service)
                        self.sizing_controls = self.__class__.sizing_controls(path + ["sizing_controls"], service)
                        self.prism_layer_parameters = self.__class__.prism_layer_parameters(path + ["prism_layer_parameters"], service)
                        super().__init__(path, service)
                    def sizing_funct_defaults(self, *args, **kwargs):
                        """
                        Sets sizing function defaults.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_defaults").execute(*args, **kwargs)
                    def remeshing_methods(self, *args, **kwargs):
                        """
                        Enables/disables individual remeshing options as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/remeshing_methods").execute(*args, **kwargs)
                    def length_max(self, *args, **kwargs):
                        """
                        Sets the length threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/length_max").execute(*args, **kwargs)
                    def face_skew_max(self, *args, **kwargs):
                        """
                        Sets the face skewness threshold above which faces will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/face_skew_max").execute(*args, **kwargs)
                    def sizing_function(self, *args, **kwargs):
                        """
                        Enables/disables the sizing function as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_function").execute(*args, **kwargs)
                    def size_remesh_interval(self, *args, **kwargs):
                        """
                        Sets the interval (in time steps) when remeshing based on size is done for methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/size_remesh_interval").execute(*args, **kwargs)
                    def retain_size_distribution(self, *args, **kwargs):
                        """
                        Enables/disables the use of local size criteria when marking cells for unified remeshing (in an attempt to maintain the initial mesh size distribution even as the mesh moves), rather than marking cells based on the minimum and maximum length scale values of the cell zone in the initial mesh. Either marking can be overridden if more restrictive values are specified using the define/dynamic-mesh/controls/remeshing-parameters/length-min and define/dynamic-mesh/controls/remeshing-parameters/length-max text commands.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/retain_size_distribution").execute(*args, **kwargs)
                    def sizing_funct_variation(self, *args, **kwargs):
                        """
                        Sets the maximum sizing function increase/decrease in the interior.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_variation").execute(*args, **kwargs)
                    def poly_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable poly remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/poly_remeshing").execute(*args, **kwargs)
                    def remeshing_after_moving(self, *args, **kwargs):
                        """
                        Enables a second round of remeshing based on the skewness parameters after the boundary has moved as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/remeshing_after_moving").execute(*args, **kwargs)
                    def length_min(self, *args, **kwargs):
                        """
                        Sets the length threshold below which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/length_min").execute(*args, **kwargs)
                    def unified_remeshing(self, *args, **kwargs):
                        """
                        Enables/disables unified remeshing, which specifies that an algorithm is used that combines aspects of a variety of remeshing methods. It is applied to triangular or tetrahedral cells and can produce wedge cells in 3D boundary layer meshes. Unified remeshing simplifies the remeshing setup and can provide increased robustness compared to methods-based remeshing, especially for parallel simulations.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/unified_remeshing").execute(*args, **kwargs)
                    def zone_remeshing(self, *args, **kwargs):
                        """
                        Enables/disables the cell zone remeshing method as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/zone_remeshing").execute(*args, **kwargs)
                    def cell_skew_max(self, *args, **kwargs):
                        """
                        Sets the cell skewness threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/cell_skew_max").execute(*args, **kwargs)
                    def parallel_remeshing(self, *args, **kwargs):
                        """
                        Disables/enables parallel remeshing as part of methods-based remeshing..
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/parallel_remeshing").execute(*args, **kwargs)
                    def sizing_funct_resolution(self, *args, **kwargs):
                        """
                        Sets the sizing function resolution with respect to shortest boundary.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_resolution").execute(*args, **kwargs)
                    def sizing_funct_rate(self, *args, **kwargs):
                        """
                        Determines how far from the boundary the increase/decrease happens.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_rate").execute(*args, **kwargs)

                    class prism_controls(TUIMenu):
                        """
                        Enters the dynamic mesh prism controls menu, which provides text commands that can be useful when you want to modify the algorithm that attempts to retain the size distribution during unified remeshing. Each prism control definition is applied to one or more boundary zones, and then affects the height distribution and number of layers of the wedge cells in the adjacent boundary layers.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes an existing prism controls definition.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/delete").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edits an existing prism controls definition. You can revise the fields listed previously for the define/dynamic-mesh/controls/remeshing-parameters/prism-controls/add text command.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/edit").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Prints a list of the existing prism controls definitions in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/list").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Adds a new prism controls definition.   After being prompted for a name, you can enter the following to complete the definition:
                            first-height  Sets the height of the first layer of wedge cells in the boundary layer adjacent to the specified zones.
                            growth-method  Specifies the method used to determine the increase in height of the wedge cell layers beyond the first layer. The only available option is geometric, so that the height of each layer is the height of the previous layer multiplied by the rate.
                            name  Specifies the name of the prism controls definition.
                            nlayers  Sets the number of layers of wedge cells in the boundary layer adjacent to the specified zones.
                            rate  Sets the coefficient for the growth-method used to determine the increase in height of the wedge cell layers beyond the first layer.
                            zones  Specifies all of the boundary zones on which this prism controls definition is applied.
                            Enter q when the definition is complete to return to the text command menu.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/add").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            Prints the properties of an existing prism controls definition of your choice in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/list_properties").execute(*args, **kwargs)

                    class sizing_controls(TUIMenu):
                        """
                        Enters the dynamic mesh sizing controls menu, which provides text commands that can be useful when you want to modify the algorithm that attempts to retain the size distribution during unified remeshing. Each sizing control definition is applied to one or more boundary zones, and then affects the size of the cells throughout the mesh based on their distance from those boundary zone(s) and your settings in the definition.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def add(self, *args, **kwargs):
                            """
                            Adds a new sizing controls definition.   After being prompted for a name, you can enter the following to complete the definition:
                            growth-rate  Sets the growth rate of the sizing controls definition.
                            max-length  Sets a maximum length threshold that is used when the type is set to auto or soft.
                            min-length  Sets a maximum length threshold that is used when the type is set to auto.
                            motion  Determines whether the size control definition affects the remeshing based on whether the mesh undergoes motion: auto specifies that it is applied whether or not there is motion; and static specifies that it is only applied if there is no motion.
                            name  Specifies the name of the sizing controls definition.
                            type  Specifies how the sizing is affected by the selected boundary zones: auto specifies that the default size distribution (rather than the initial size distribution in your selected boundary zones) is used, along with your specified max-length and min-length values; soft specifies that the maximum length scale of your selected boundary zones is used, along with your specified min-length value; and meshed specifies that the maximum and minimum length scales of your selected boundary zones are used, in order to respect their initial size distribution. This setting is only relevant if you have more than one sizing controls definition.
                            zones  Specifies all of the boundary zones on which the sizing controls definition is applied.
                            Enter q when the definition is complete to return to the text command menu.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/add").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Prints a list of the existing sizing controls definitions in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edits an existing sizing controls definition. You can revise the fields listed previously for the define/dynamic-mesh/controls/remeshing-parameters/sizing-controls/add text command.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/edit").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            Prints the properties of an existing sizing controls definition of your choice in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list_properties").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes an existing sizing controls definition.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/delete").execute(*args, **kwargs)

                    class prism_layer_parameters(TUIMenu):
                        """
                        Enters the dynamic mesh prism layer parameters menu, where you can define the parameters of the prism layers as part of methods-based remeshing.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def number_of_layers(self, *args, **kwargs):
                            """
                            Sets the number of elements in the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/number_of_layers").execute(*args, **kwargs)
                        def growth_rate(self, *args, **kwargs):
                            """
                            Sets the geometric growth rate of the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/growth_rate").execute(*args, **kwargs)
                        def first_height(self, *args, **kwargs):
                            """
                            Sets the first cell height in the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/first_height").execute(*args, **kwargs)

                class contact_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh contact-parameters menu. This text command is only available 	when you enable contact detection using the prompts of 	the define/dynamic-mesh/dynamic-mesh? 	text command.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.flow_control_parameters = self.__class__.flow_control_parameters(path + ["flow_control_parameters"], service)
                        super().__init__(path, service)
                    def verbosity(self, *args, **kwargs):
                        """
                        Sets the level of detail printed in the console regarding contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/verbosity").execute(*args, **kwargs)
                    def update_contact_marks(self, *args, **kwargs):
                        """
                        Updates which cells are marked in order to block flow in the contact region as part of the contact marks method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/update_contact_marks").execute(*args, **kwargs)
                    def contact_face_zones(self, *args, **kwargs):
                        """
                        Selects face zones involved in contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_face_zones").execute(*args, **kwargs)
                    def render_contact_cells(self, *args, **kwargs):
                        """
                        Enables/disables the availability of a field variable (contact-cell-mark) that can be used to display contours of cells marked for flow blocking as part of the contact marks method, and allows you to postprocess other field variables on those cells.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/render_contact_cells").execute(*args, **kwargs)
                    def contact_udf(self, *args, **kwargs):
                        """
                        Selects the UDF to be invoked when contact is detected.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_udf").execute(*args, **kwargs)
                    def flow_control(self, *args, **kwargs):
                        """
                        Enables/disables flow control in the contact region.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control").execute(*args, **kwargs)
                    def contact_method(self, *args, **kwargs):
                        """
                        Selects the method used for flow control in the contact region. Enter 0 for the contact zones method (which restricts the flow using additional cell zones with porous zone properties) or 1 for the contact marks method (which blocks the flow using zero-mass-flux boundaries).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_method").execute(*args, **kwargs)
                    def contact_threshold(self, *args, **kwargs):
                        """
                        Specifies threshold distance for contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_threshold").execute(*args, **kwargs)

                    class flow_control_parameters(TUIMenu):
                        """
                        Enters the flow control parameters menu, which provides settings related to controlling the flow in the contact region.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solution_stabilization(self, *args, **kwargs):
                            """
                            Enables/disables the performance of additional iterations per time step and the application of solution controls to improve the stability of the solver as part of the contact marks method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/solution_stabilization").execute(*args, **kwargs)
                        def delete_flow_control_zone(self, *args, **kwargs):
                            """
                            Deletes a flow control zone as part of the contact zones method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/delete_flow_control_zone").execute(*args, **kwargs)
                        def create_flow_control_zone(self, *args, **kwargs):
                            """
                            Creates a flow control zone as part of the contact zones method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/create_flow_control_zone").execute(*args, **kwargs)

                class in_cylinder_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh in-cylinder menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def max_crank_angle_step(self, *args, **kwargs):
                        """
                        Specifies maximum crank angle step size.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/max_crank_angle_step").execute(*args, **kwargs)
                    def modify_lift(self, *args, **kwargs):
                        """
                        Modifies lift curve (shift or scale).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/modify_lift").execute(*args, **kwargs)
                    def minimum_lift(self, *args, **kwargs):
                        """
                        Specifies minimum lift for in-cylinder valves.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/minimum_lift").execute(*args, **kwargs)
                    def starting_crank_angle(self, *args, **kwargs):
                        """
                        Specifies the initial value for the crank angle.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/starting_crank_angle").execute(*args, **kwargs)
                    def crank_angle_step(self, *args, **kwargs):
                        """
                        Specifies crank angle step size.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/crank_angle_step").execute(*args, **kwargs)
                    def piston_data(self, *args, **kwargs):
                        """
                        Specifies the crank radius and connecting rod length.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/piston_data").execute(*args, **kwargs)
                    def print_plot_lift(self, *args, **kwargs):
                        """
                        Prints or plot valve lift curve.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/print_plot_lift").execute(*args, **kwargs)
                    def position_starting_mesh(self, *args, **kwargs):
                        """
                        Moves mesh from top dead center to starting crank angle.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/position_starting_mesh").execute(*args, **kwargs)
                    def piston_stroke_cutoff(self, *args, **kwargs):
                        """
                        Specifies the cut off point for in-cylinder piston.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/piston_stroke_cutoff").execute(*args, **kwargs)
                    def crank_period(self, *args, **kwargs):
                        """
                        Specifies the crank period.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/crank_period").execute(*args, **kwargs)

                class periodic_displacement_parameters(TUIMenu):
                    """
                    Enters the periodic displacement parameters 	menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def create_displacement(self, *args, **kwargs):
                        """
                        Create Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/create_displacement").execute(*args, **kwargs)
                    def delete_all_displacements(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacements.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_displacements").execute(*args, **kwargs)
                    def delete_all_groups(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_groups").execute(*args, **kwargs)
                    def list_groups(self, *args, **kwargs):
                        """
                        List Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/list_groups").execute(*args, **kwargs)
                    def copy_displacement(self, *args, **kwargs):
                        """
                        Copy Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/copy_displacement").execute(*args, **kwargs)
                    def create_group(self, *args, **kwargs):
                        """
                        Create Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/create_group").execute(*args, **kwargs)
                    def delete_displacement(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_displacement").execute(*args, **kwargs)
                    def delete_group(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_group").execute(*args, **kwargs)
                    def edit_displacement(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/edit_displacement").execute(*args, **kwargs)
                    def edit_group(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/edit_group").execute(*args, **kwargs)
                    def list_displacements(self, *args, **kwargs):
                        """
                        List Periodic Displacements.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/list_displacements").execute(*args, **kwargs)
                    def set_active_displacement(self, *args, **kwargs):
                        """
                        Set Active Periodic Displacement in Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/set_active_displacement").execute(*args, **kwargs)

                class implicit_update_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh implicit update menu. This text command is only available 	when you enable implicit mesh updating using the prompts 	of the define/dynamic-mesh/dynamic-mesh? 	text command.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def motion_relaxation(self, *args, **kwargs):
                        """
                        Specifies a value (within the range of 0 to 1) for the motion relaxation, which is applied during the implicit mesh update.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/motion_relaxation").execute(*args, **kwargs)
                    def update_interval(self, *args, **kwargs):
                        """
                        Specifies the update interval (that is, the frequency in iterations) at which the mesh is updated within a time step.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/update_interval").execute(*args, **kwargs)
                    def residual_criteria(self, *args, **kwargs):
                        """
                        Specifies the relative residual threshold that is used to check the motion convergence during the implicit mesh update.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/residual_criteria").execute(*args, **kwargs)

                class six_dof_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh six degrees of freedom (DOF) solver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def motion_history(self, *args, **kwargs):
                        """
                        Enables/disables writing position/orientation of six DOF zones to file.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/motion_history").execute(*args, **kwargs)
                    def create_properties(self, *args, **kwargs):
                        """
                        Creates/edits a set of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/create_properties").execute(*args, **kwargs)
                    def z_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies z-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/z_component_of_gravity").execute(*args, **kwargs)
                    def motion_history_file_name(self, *args, **kwargs):
                        """
                        Specifies the name and location of the six DOF motion history file.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/motion_history_file_name").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        Prints summaries of the existing sets of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/list_properties").execute(*args, **kwargs)
                    def y_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies y-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/y_component_of_gravity").execute(*args, **kwargs)
                    def x_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies x-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/x_component_of_gravity").execute(*args, **kwargs)
                    def delete_properties(self, *args, **kwargs):
                        """
                        Deletes a set of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/delete_properties").execute(*args, **kwargs)
                    def second_order(self, *args, **kwargs):
                        """
                        Enables/disables the second order six degrees of freedom solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/second_order").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enters the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                super().__init__(path, service)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Selects the bounded second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enables/disables the solidification and melting model.
                """
                return PyMenu(self.service, "/define/models/solidification_melting").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/define/models/energy").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enables/disables the NOx model.
                """
                return PyMenu(self.service, "/define/models/nox").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enables/disables frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/define/models/frozen_flux").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/define/models/vbm").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Specifies whether or not the domain is axisymmetric.
                """
                return PyMenu(self.service, "/define/models/axisymmetric").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enables/disables noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/define/models/noniterative_time_advance").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Loads addon module.
                """
                return PyMenu(self.service, "/define/models/addon_module").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Selects the second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enables/disables axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/define/models/swirl").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Selects the Newmark method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enables the dual potential MSMD battery model. For text commands that become available when the battery model is enabled, refer to Battery Model Text Commands.
                """
                return PyMenu(self.service, "/define/models/battery_model").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enables/disables the crevice model.
                """
                return PyMenu(self.service, "/define/models/crevice_model").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Selects the backward Euler method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_euler").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Selects the first-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_1st_order").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enters the crevice model controls menu.
                """
                return PyMenu(self.service, "/define/models/crevice_model_controls").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enables/disables the ablation model.
                """
                return PyMenu(self.service, "/define/models/ablation").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enables/disables the soot model.
                """
                return PyMenu(self.service, "/define/models/soot").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/define/models/virtual_blade_model").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enables/disables the steady solution model.
                """
                return PyMenu(self.service, "/define/models/steady").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enables/disables the electric-potential model.
                """
                return PyMenu(self.service, "/define/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Selects the explicit transient formulation. This text command is only available for unsteady cases that use the density-based solver with the explicit formulation.
                """
                return PyMenu(self.service, "/define/models/unsteady_global_time").execute(*args, **kwargs)

            class electrolysis(TUIMenu):
                """
                Enter the electrolysis model setup menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.membrane_setup = self.__class__.membrane_setup(path + ["membrane_setup"], service)
                    self.cathode_setup = self.__class__.cathode_setup(path + ["cathode_setup"], service)
                    self.anode_setup = self.__class__.anode_setup(path + ["anode_setup"], service)
                    self.advanced_setup = self.__class__.advanced_setup(path + ["advanced_setup"], service)
                    super().__init__(path, service)
                def parameters(self, *args, **kwargs):
                    """
                    Specify electrolysis model parameters.
                    """
                    return PyMenu(self.service, "/define/models/electrolysis/parameters").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Specify electrolysis model options.
                    """
                    return PyMenu(self.service, "/define/models/electrolysis/model_options").execute(*args, **kwargs)
                def electrical_tabs_setup(self, *args, **kwargs):
                    """
                    Specify settings for the electrical tabs.
                    """
                    return PyMenu(self.service, "/define/models/electrolysis/electrical_tabs_setup").execute(*args, **kwargs)

                class membrane_setup(TUIMenu):
                    """
                    Specify parameters for electrolyte.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/catalyst_layer").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/porous_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/electrolyte").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/current_collector").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/flow_channel").execute(*args, **kwargs)

                class cathode_setup(TUIMenu):
                    """
                    Enter the menu for the cathode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/porous_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/current_collector").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/catalyst_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/electrolyte").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/flow_channel").execute(*args, **kwargs)

                class anode_setup(TUIMenu):
                    """
                    Enter the menu for the anode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/electrolyte").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/catalyst_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/current_collector").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/flow_channel").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/porous_layer").execute(*args, **kwargs)

                class advanced_setup(TUIMenu):
                    """
                    Advanced Setup.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def contact_resistivity(self, *args, **kwargs):
                        """
                        Set Contact Resistivity.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/advanced_setup/contact_resistivity").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enters the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    super().__init__(path, service)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enables/disables Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Sets Eulerian Wall Film Model Solution Options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activates Eulerian Wall Film Equations.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)
                def enable_film_nci_support(self, *args, **kwargs):
                    """
                    Enable wall film fluid-fluid NCI support.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_film_nci_support").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Sets Film Material and Properties.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initializes Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enters the Coupled-Solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enables/disables the coupled solution method.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enables/disables the film curvature smoothing option and sets the smoothing parameters.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enters the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Selects NOx chemistry model.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Sets NOx turbulence interaction model.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)
                def nox_expert(self, *args, **kwargs):
                    """
                    Selects additional NOx equations.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_expert").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enters the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dual_cell_model = self.__class__.dual_cell_model(path + ["dual_cell_model"], service)
                    self.macro_model = self.__class__.macro_model(path + ["macro_model"], service)
                    super().__init__(path, service)

                class dual_cell_model(TUIMenu):
                    """
                    Enters the dual cell model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternative_formulation(self, *args, **kwargs):
                        """
                        Enables/disables alternative formulation for heat transfer calculations.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/alternative_formulation").execute(*args, **kwargs)
                    def add_heat_exchanger(self, *args, **kwargs):
                        """
                        Adds heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/add_heat_exchanger").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/write_NTU").execute(*args, **kwargs)
                    def modify_heat_exchanger(self, *args, **kwargs):
                        """
                        Modifies heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/modify_heat_exchanger").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/plot_NTU").execute(*args, **kwargs)
                    def delete_heat_exchanger(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/delete_heat_exchanger").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables the dual cell heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/heat_exchanger").execute(*args, **kwargs)

                class macro_model(TUIMenu):
                    """
                    Enters the heat macro-model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def heat_exchanger_macro_report(self, *args, **kwargs):
                        """
                        Reports the computed values of heat rejection, outlet temperature, and inlet temperature for the macroscopic cells (macros) in a heat exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_macro_report").execute(*args, **kwargs)
                    def heat_exchanger_report(self, *args, **kwargs):
                        """
                        Reports the computed values of total heat rejection, outlet temperature, and inlet temperature for a specified heat-exchanger core.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_report").execute(*args, **kwargs)
                    def delete_heat_exchanger_group(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/delete_heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_zone(self, *args, **kwargs):
                        """
                        Specifies the zone that represents the heat exchanger, the dimensions of the heat exchanger, the macro grid, and the coolant direction and properties.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_zone").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/write_NTU").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger_group(self, *args, **kwargs):
                        """
                        Defines heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_model(self, *args, **kwargs):
                        """
                        Defines heat-exchanger core model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_model").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enters the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enables/disables the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Sets soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Selects soot model parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Changes the turbulent Schmidt number for soot/nuclei equations.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Selects soot process parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)

            class dpm(TUIMenu):
                """
                Enters the dispersed phase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.numerics = self.__class__.numerics(path + ["numerics"], service)
                    self.parallel = self.__class__.parallel(path + ["parallel"], service)
                    self.options = self.__class__.options(path + ["options"], service)
                    self.collisions = self.__class__.collisions(path + ["collisions"], service)
                    self.erosion_dynamic_mesh = self.__class__.erosion_dynamic_mesh(path + ["erosion_dynamic_mesh"], service)
                    self.stripping_options = self.__class__.stripping_options(path + ["stripping_options"], service)
                    self.splash_options = self.__class__.splash_options(path + ["splash_options"], service)
                    self.interaction = self.__class__.interaction(path + ["interaction"], service)
                    super().__init__(path, service)
                def fill_injection_material_sources(self, *args, **kwargs):
                    """
                    Initialize the DPM sources corresponding to each material.
                    """
                    return PyMenu(self.service, "/define/models/dpm/fill_injection_material_sources").execute(*args, **kwargs)
                def unsteady_tracking(self, *args, **kwargs):
                    """
                    Enables/disables unsteady particle tracking.
                    """
                    return PyMenu(self.service, "/define/models/dpm/unsteady_tracking").execute(*args, **kwargs)
                def injections(self, *args, **kwargs):
                    """
                    Enters the injections menu.
                    """
                    return PyMenu(self.service, "/define/models/dpm/injections").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Sets DPM user-defined functions.
                    """
                    return PyMenu(self.service, "/define/models/dpm/user_defined").execute(*args, **kwargs)
                def spray_model(self, *args, **kwargs):
                    """
                    Enters the spray model menu. This command is available only if the breakup model 	enabled globally.
                    """
                    return PyMenu(self.service, "/define/models/dpm/spray_model").execute(*args, **kwargs)
                def clear_particles_from_domain(self, *args, **kwargs):
                    """
                    Removes/keeps all particles currently in the domain.
                    """
                    return PyMenu(self.service, "/define/models/dpm/clear_particles_from_domain").execute(*args, **kwargs)

                class numerics(TUIMenu):
                    """
                    Enters the numerics menu to set numerical solution parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.high_resolution_tracking = self.__class__.high_resolution_tracking(path + ["high_resolution_tracking"], service)
                        super().__init__(path, service)
                    def enable_node_based_averaging(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DPM quantities.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/enable_node_based_averaging").execute(*args, **kwargs)
                    def enhanced_packing_limit_numerics(self, *args, **kwargs):
                        """
                        Enable enhanced packing limit numerics to avoid exceeding of packing limit for granular phases.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/enhanced_packing_limit_numerics").execute(*args, **kwargs)
                    def drag_law(self, *args, **kwargs):
                        """
                        Sets the drag law.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/drag_law").execute(*args, **kwargs)
                    def average_each_step(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging during integration time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_each_step").execute(*args, **kwargs)
                    def coupled_heat_mass_update(self, *args, **kwargs):
                        """
                        Enables/disables coupled heat and mass update.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/coupled_heat_mass_update").execute(*args, **kwargs)
                    def dynamic_interaction(self, *args, **kwargs):
                        """
                        Enable/disable dynamic interaction range.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/dynamic_interaction").execute(*args, **kwargs)
                    def predictor_corrector(self, *args, **kwargs):
                        """
                        Enable predictor/corrector approach to track particles.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/predictor_corrector").execute(*args, **kwargs)
                    def re_randomize_every_iteration(self, *args, **kwargs):
                        """
                        Determines whether or not the initial particle positions will vary from iteration to iteration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/re_randomize_every_iteration").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Adjust the DPM tracker's verbosity level.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/verbosity").execute(*args, **kwargs)
                    def vaporization_limiting_factors(self, *args, **kwargs):
                        """
                        Sets the Vaporization Fractional Change Limits.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/vaporization_limiting_factors").execute(*args, **kwargs)
                    def average_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_source_terms").execute(*args, **kwargs)
                    def re_randomize_every_timestep(self, *args, **kwargs):
                        """
                        Determines whether or not the initial particle positions will vary from time step to time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/re_randomize_every_timestep").execute(*args, **kwargs)
                    def tracking_parameters(self, *args, **kwargs):
                        """
                        Sets parameters for the (initial) tracking step length.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_parameters").execute(*args, **kwargs)
                    def average_DDPM_variables(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DDPM quantities.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_DDPM_variables").execute(*args, **kwargs)
                    def minimum_liquid_fraction(self, *args, **kwargs):
                        """
                        A droplet evaporates completely when the remaining mass is below this fraction of the initial droplet mass.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/minimum_liquid_fraction").execute(*args, **kwargs)
                    def error_control(self, *args, **kwargs):
                        """
                        Adapts integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/error_control").execute(*args, **kwargs)
                    def average_kernel(self, *args, **kwargs):
                        """
                        Specifies the averaging kernel to use for mesh node averaging.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_kernel").execute(*args, **kwargs)
                    def automated_scheme_selection(self, *args, **kwargs):
                        """
                        Enables/disables the adaptation of integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/automated_scheme_selection").execute(*args, **kwargs)
                    def mppic_settings(self, *args, **kwargs):
                        """
                        Enable PIC and MPPIC to compute DPM and DDPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/mppic_settings").execute(*args, **kwargs)
                    def tracking_scheme(self, *args, **kwargs):
                        """
                        Specifies a tracking scheme.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_scheme").execute(*args, **kwargs)
                    def underrelax_film_height(self, *args, **kwargs):
                        """
                        Sets the under-relaxation factor for the film height calculation. The recommended values range between 0.5 (default) and 0.9.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/underrelax_film_height").execute(*args, **kwargs)
                    def tracking_statistics(self, *args, **kwargs):
                        """
                        Controls the format of the one-line tracking statistics to be printed after every DPM tracking pass. A value of 0 (the default) prints only fates with non-zero values. A value of 1 prints all fates, including fates with zero values.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_statistics").execute(*args, **kwargs)
                    def granular_stress_tensor(self, *args, **kwargs):
                        """
                        Enable granular stress tensor to be considered with solid pressure gradient as collision force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/granular_stress_tensor").execute(*args, **kwargs)
                    def gaussian_factor(self, *args, **kwargs):
                        """
                        Specifies the Gaussian constant when using thegaussian kernel for mesh node averaging.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/gaussian_factor").execute(*args, **kwargs)

                    class high_resolution_tracking(TUIMenu):
                        """
                        Enters the high resolution tracking menu. See  for more information about these options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.particle_relocation = self.__class__.particle_relocation(path + ["particle_relocation"], service)
                            self.barycentric_interpolation = self.__class__.barycentric_interpolation(path + ["barycentric_interpolation"], service)
                            super().__init__(path, service)
                        def boundary_layer_tracking(self, *args, **kwargs):
                            """
                            Enables/disables the calculation of the particle time step that considers both the cell aspect ratio and the particle trajectory. This method improves the accuracy of the predictions in boundary layer cells, particularly in layers where flow gradients are large.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/boundary_layer_tracking").execute(*args, **kwargs)
                        def use_velocity_based_error_control(self, *args, **kwargs):
                            """
                            Enables/disables an alternative method of timestep adaption. By default, ANSYS Fluent uses the half-step method of timestep adaption with particle integration. This alternative method of controlling the integration timestep based upon velocity changes is faster; however, you need to ensure that the accuracy is comparable for your specific application.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_velocity_based_error_control").execute(*args, **kwargs)
                        def sliding_interface_crossover_fraction(self, *args, **kwargs):
                            """
                            Specifies the fraction of the distance to the subtet center to move the particle.  At non-conformal interfaces, the nodes used for the barycentric interpolation are different on either side of the interface. This may result in incomplete particles due to discontinuities in the variable interpolation. The number of incomplete particles may be reduced by moving the particles slightly off of the sliding interface. Recommended values range between 0 and 0.5.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/sliding_interface_crossover_fraction").execute(*args, **kwargs)
                        def use_particle_timestep_for_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enables/disables the use of the particle timestep for the subtet intersection tolerance with axisymmetric grids (default: enabled). If disabled, the tolerance will be calculated in the same manner as non-axisymmetric meshes (a scaled value of the tolerance which is set using the define/models/dpm/numerics/high-resolution-tracking/set-subtet-intersection-tolerance text command).
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_particle_timestep_for_intersection_tolerance").execute(*args, **kwargs)
                        def use_legacy_particle_location_method(self, *args, **kwargs):
                            """
                            Enable legacy method of locating particles in cells.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_legacy_particle_location_method").execute(*args, **kwargs)
                        def remove_stuck_particles(self, *args, **kwargs):
                            """
                            Remove particles that are stuck at edges or faces.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/remove_stuck_particles").execute(*args, **kwargs)
                        def use_quad_face_centroid(self, *args, **kwargs):
                            """
                            Enables/disables using quad face centroids when creating subtets. This option changes the way hexahedral cells are decomposed to avoid creating degenerate subtets.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_quad_face_centroid").execute(*args, **kwargs)
                        def enable_automatic_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enables/disables the automatic calculation of intersection tolerance. By default, the tolerance used in intersection calculations is scaled by the residence time of the particle in the cell to improve robustness. For most cases, the scaled tolerance is sufficient to identify all intersections of the particle trajectory and the subtet faces. You can set the intersection tolerance manually using the set-subtet-intersection-tolerance text command.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_automatic_intersection_tolerance").execute(*args, **kwargs)
                        def set_film_spreading_parameter(self, *args, **kwargs):
                            """
                            Set the spreading parameter for Lagrangian wallfilm particles.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/set_film_spreading_parameter").execute(*args, **kwargs)
                        def always_use_face_centroid_with_periodics(self, *args, **kwargs):
                            """
                            When enabled, ANSYS Fluent uses quad face centroids when creating subtets in cases with periodic boundaries.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/always_use_face_centroid_with_periodics").execute(*args, **kwargs)
                        def check_subtet_validity(self, *args, **kwargs):
                            """
                            When enabled, checks the validity of a subtet when the particle first enters it. If the subtet is found to be degenerate, the tracking algorithm modifies to accommodate it.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/check_subtet_validity").execute(*args, **kwargs)
                        def project_wall_film_particles_to_film(self, *args, **kwargs):
                            """
                            Enables/disables projecting existing particles to Lagrangian wall film to track using high-resolution tracking.  When reading in a data file that contains wall film particles previously tracked with the existing ANSYS Fluent tracking method, you need to either clear the particles from the domain or project their positions to the wall film surface using the project-wall-film-particles-to-film? text command prior to using the high-resolution tracking method. After tracking the particles for one timestep, this option can be disabled to improve performance.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/project_wall_film_particles_to_film").execute(*args, **kwargs)
                        def use_barycentric_sampling(self, *args, **kwargs):
                            """
                            When enabled, this option provides improved accuracy and parallel consistency when sampling particles at planes. This item is available only with the 3D solver. Using the double-precision solver and bounded planes is recommended.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_barycentric_sampling").execute(*args, **kwargs)
                        def set_subtet_intersection_tolerance(self, *args, **kwargs):
                            """
                            Specifies the tolerance used in intersection calculations. This tolerance will be scaled by the characteristic cell crossing time of the particle if the enable-automatic-intersection-tolerance? text command is enabled. If that option is disabled, the specified tolerance will be used without scaling. The default intersection tolerance is 10-5.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/set_subtet_intersection_tolerance").execute(*args, **kwargs)
                        def enable_barycentric_intersections(self, *args, **kwargs):
                            """
                            Enables/disables an alternative method of calculating intersections with cell boundaries. Barycentric intersections are linear calculations and are faster than the default intersection algorithm. The default intersection algorithm is second-order for stationary meshes; therefore, using the barycentric intersection may sacrifice accuracy. You must verify that the barycentric intersections provide comparable results to the default intersection method. This option is available only for 3D stationary meshes and the double precision solver.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_barycentric_intersections").execute(*args, **kwargs)
                        def load_legacy_particles(self, *args, **kwargs):
                            """
                            Load particles that were tracked without high-resolution tracking enabled.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/load_legacy_particles").execute(*args, **kwargs)
                        def enhanced_wallfilm_location_method(self, *args, **kwargs):
                            """
                            Enable enhanced method of locating film particles on faces.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enhanced_wallfilm_location_method").execute(*args, **kwargs)
                        def wallfilm_relocation_tolerance(self, *args, **kwargs):
                            """
                            Set the relocation tolerance for wallfilm particles after remeshing.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/wallfilm_relocation_tolerance").execute(*args, **kwargs)
                        def enable_high_resolution_tracking(self, *args, **kwargs):
                            """
                            Enables/disables high resolution tracking.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_high_resolution_tracking").execute(*args, **kwargs)

                        class particle_relocation(TUIMenu):
                            """
                            Enter the particle relocation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def overset_relocation_robustness_level(self, *args, **kwargs):
                                """
                                Set the robustness level for particle relocation in overset meshes.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/overset_relocation_robustness_level").execute(*args, **kwargs)
                            def load_legacy_particles(self, *args, **kwargs):
                                """
                                Load particles that were tracked without high-resolution tracking enabled.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/load_legacy_particles").execute(*args, **kwargs)
                            def enhanced_wallfilm_location_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating film particles on faces.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_wallfilm_location_method").execute(*args, **kwargs)
                            def enhanced_cell_relocation_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_cell_relocation_method").execute(*args, **kwargs)
                            def use_legacy_particle_location_method(self, *args, **kwargs):
                                """
                                Enable legacy method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/use_legacy_particle_location_method").execute(*args, **kwargs)
                            def wallfilm_relocation_tolerance_scale_factor(self, *args, **kwargs):
                                """
                                Set the relocation tolerance scaling factor for wallfilm particles after remeshing.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/wallfilm_relocation_tolerance_scale_factor").execute(*args, **kwargs)

                        class barycentric_interpolation(TUIMenu):
                            """
                            Enter the barycentric interpolation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interpolate_flow_viscosity(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of flow viscosity to the particle position. This option is recommended when the flow viscosity varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For flows with constant viscosity, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_viscosity").execute(*args, **kwargs)
                            def enable_transient_variable_interpolation(self, *args, **kwargs):
                                """
                                Enable transient variable interpolation.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/enable_transient_variable_interpolation").execute(*args, **kwargs)
                            def user_interpolation_function(self, *args, **kwargs):
                                """
                                Enter user interpolation function.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/user_interpolation_function").execute(*args, **kwargs)
                            def interpolate_flow_density(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of the flow density. This option is recommended when the density varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For constant density flows, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_density").execute(*args, **kwargs)
                            def nodal_reconstruction_frequency(self, *args, **kwargs):
                                """
                                Update nodal reconstruction every N'th DPM iteration.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/nodal_reconstruction_frequency").execute(*args, **kwargs)
                            def interpolate_wallfilm_properties(self, *args, **kwargs):
                                """
                                When enabled, the wall film properties (film height, film mass, and wall shear) are interpolated to the particle position.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_wallfilm_properties").execute(*args, **kwargs)
                            def interpolate_flow_cp(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of specific heat to the particle position. This option is recommended when the specific heat varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For flows with constant specific heat, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_cp").execute(*args, **kwargs)
                            def precompute_pdf_species(self, *args, **kwargs):
                                """
                                When this option is enabled for premixed or non-premixed combustion simulations, the species composition in each cell is precomputed prior to tracking particles. This approach may improve performance for cases with many particles and relatively few cells. By default, this option is set to no, and ANSYS Fluent calculates the species composition during particle tracking. The solution results will be identical for both methods.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/precompute_pdf_species").execute(*args, **kwargs)
                            def interpolate_flow_solution_gradients(self, *args, **kwargs):
                                """
                                When enabled, flow solution gradients are interpolated to the particle position. This can be useful when using physical models that depend on these gradients (for example, the thermophoretic force, pressure-gradient force, or virtual mass force). Interpolating the gradients also improves the accuracy and robustness of the trapezoidal numerics scheme, which is the default method for pathlines.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_solution_gradients").execute(*args, **kwargs)
                            def interpolate_temperature(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of temperature to the particle position. The cell temperature is used by default in calculations of heat transfer to/from the particle.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_temperature").execute(*args, **kwargs)
                            def zero_nodal_velocity_on_walls(self, *args, **kwargs):
                                """
                                When enabled, sets the velocity at wall nodes to zero. (By default, the nodal velocities on walls are first reconstructed from cell and face values and then corrected to ensure that there are no velocity components directed towards the walls). This may be useful if you want to consider particle impingement on the walls. Note that enabling this option will more likely produce incomplete particles as some particles may settle on the walls.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/zero_nodal_velocity_on_walls").execute(*args, **kwargs)

                class parallel(TUIMenu):
                    """
                    Enters the parallel menu to set parameters for parallel DPM calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def use_shared_memory(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed on shared-memory multiprocessor machines.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_shared_memory").execute(*args, **kwargs)
                    def hybrid_collision_unidirectional(self, *args, **kwargs):
                        """
                        A faster, yet potentially somewhat less accurate, modification to the beta feature
                        that allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_unidirectional").execute(*args, **kwargs)
                    def enable_workpile(self, *args, **kwargs):
                        """
                        Turns on/off particle workpile algorithm. This option is only available when the define/models/dpm/parallel/use-shared-memory option is selected.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/enable_workpile").execute(*args, **kwargs)
                    def fix_source_term_accumulation_order(self, *args, **kwargs):
                        """
                        Enforce deterministic order of source term accumulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/fix_source_term_accumulation_order").execute(*args, **kwargs)
                    def hybrid_collision_variant(self, *args, **kwargs):
                        """
                        Further reduce the residual risk of dead-locks in the experimental feature that
                        allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_variant").execute(*args, **kwargs)
                    def report(self, *args, **kwargs):
                        """
                        Prints particle workpile statistics. This option is only available when the define/models/dpm/parallel/enable-workpile? option is enabled.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/report").execute(*args, **kwargs)
                    def hybrid_workpile(self, *args, **kwargs):
                        """
                        Optimize multi-thread load balancing within each partition in hybrid-parallel DPM tracking.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_workpile").execute(*args, **kwargs)
                    def n_threads(self, *args, **kwargs):
                        """
                        Sets the number of processors to use for DPM. This option is only available when the define/models/dpm/parallel/enable-workpile? option is enabled.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/n_threads").execute(*args, **kwargs)
                    def use_message_passing(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed using cluster computing or shared-memory machines. With this option, the compute node processes themselves perform the particle work on their local partitions and particle migration to other compute nodes is implemented using message passing primitives.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_message_passing").execute(*args, **kwargs)
                    def hybrid_collision_model(self, *args, **kwargs):
                        """
                        An EXPERIMENTAL feature to allow 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_model").execute(*args, **kwargs)
                    def hybrid_2domain(self, *args, **kwargs):
                        """
                        Enables/disables the use of a second domain for DPM particle tracking.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_2domain").execute(*args, **kwargs)
                    def use_hybrid(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed using multicore cluster computing or shared-memory machines. This option works in conjunction withopenmpi for a dynamic load balancing without migration of cells.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_hybrid").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enters the menu for expert DPM parallel text commands.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def partition_method_hybrid_2domain(self, *args, **kwargs):
                            """
                            Enables/disables a partitioning method that is more granular and can yield faster calculations (especially for cases that are running on a low to moderate number of processors). This partitioning method is only applied when you use the DPM domain for the hybrid parallel DPM tracking mode (that is, when you have enabled the define/models/dpm/parallel/hybrid-2domain? text command).
                            """
                            return PyMenu(self.service, "/define/models/dpm/parallel/expert/partition_method_hybrid_2domain").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    Enters the options menu to set optional models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ensemble_average(self, *args, **kwargs):
                        """
                        Ensembles average cloud properties.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/ensemble_average").execute(*args, **kwargs)
                    def stagger_temporally(self, *args, **kwargs):
                        """
                        Enables/disables temporal staggering.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_temporally").execute(*args, **kwargs)
                    def vaporization_options(self, *args, **kwargs):
                        """
                        Sets Vaporization options.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/vaporization_options").execute(*args, **kwargs)
                    def erosion_accretion(self, *args, **kwargs):
                        """
                        Enables/disables erosion/accretion.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/erosion_accretion").execute(*args, **kwargs)
                    def convective_film_heat_transfer(self, *args, **kwargs):
                        """
                        Enable/disable convection/conduction film to wall heat transfer model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/convective_film_heat_transfer").execute(*args, **kwargs)
                    def stagger_spatially_standard_injections(self, *args, **kwargs):
                        """
                        Enables/disables spatial staggering for standard (non-atomizer and non-solid-cone) injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_spatially_standard_injections").execute(*args, **kwargs)
                    def maximum_udf_species(self, *args, **kwargs):
                        """
                        Specifies the maximum number of species that will be accessible from discrete phase model UDFs. Only species with indices up to this value are accessible in discrete phase model UDFs.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/maximum_udf_species").execute(*args, **kwargs)
                    def particle_radiation(self, *args, **kwargs):
                        """
                        Enables/disables particle radiation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/particle_radiation").execute(*args, **kwargs)
                    def staggering_factor(self, *args, **kwargs):
                        """
                        S.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/staggering_factor").execute(*args, **kwargs)
                    def stagger_spatially_atomizer_injections(self, *args, **kwargs):
                        """
                        Enables/disables spatial staggering for atomizer and solid-cone injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_spatially_atomizer_injections").execute(*args, **kwargs)
                    def treat_multicomponent_saturation_temperature_failure(self, *args, **kwargs):
                        """
                        Enables/disables dumping multicomponent particle mass into the continuous phase if the saturation temperature calculation fails.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/treat_multicomponent_saturation_temperature_failure").execute(*args, **kwargs)
                    def uniform_mass_distribution_for_injections(self, *args, **kwargs):
                        """
                        Specifies a uniform distribution of mass over the cross-section of solid cone and atomizer injections. This can become important when the mesh is smaller than the diameter (or another characteristic size) of the injection.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/uniform_mass_distribution_for_injections").execute(*args, **kwargs)
                    def pressure_gradient_force(self, *args, **kwargs):
                        """
                        Enables/disables inclusion of pressure gradient effects in the particle force balance.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/pressure_gradient_force").execute(*args, **kwargs)
                    def set_thermolysis_limit(self, *args, **kwargs):
                        """
                        Sets the limit for the thermolysis model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/set_thermolysis_limit").execute(*args, **kwargs)
                    def vaporization_heat_transfer_averaging(self, *args, **kwargs):
                        """
                        Enables averaging of the Spalding heat transfer term for the convection/diffusion-controlled model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/vaporization_heat_transfer_averaging").execute(*args, **kwargs)
                    def two_way_coupling(self, *args, **kwargs):
                        """
                        Enables/disables calculation of DPM sources in TKE equation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/two_way_coupling").execute(*args, **kwargs)
                    def stagger_radius(self, *args, **kwargs):
                        """
                        Specifies the region over which to spatially stagger particles when particle-staggering is enabled for non-atomizer injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_radius").execute(*args, **kwargs)
                    def remove_wall_film_temperature_limiter(self, *args, **kwargs):
                        """
                        Answering yes at the prompt removes the wall temperature limiter for Lagrangian wall-film walls. If you enter no (default), two additional prompts will appear in the console allowing you to define the temperature difference above the boiling point and to enable/disable the reporting of the Leidenfrost temperature on the wall faces.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/remove_wall_film_temperature_limiter").execute(*args, **kwargs)
                    def saffman_lift_force(self, *args, **kwargs):
                        """
                        Enables/disables Saffman lift force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/saffman_lift_force").execute(*args, **kwargs)
                    def thermophoretic_force(self, *args, **kwargs):
                        """
                        Enables/disables thermophoretic force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/thermophoretic_force").execute(*args, **kwargs)
                    def track_in_absolute_frame(self, *args, **kwargs):
                        """
                        Enables/disables tracking in absolute frame.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/track_in_absolute_frame").execute(*args, **kwargs)
                    def scr_urea_deposition_risk_analysis(self, *args, **kwargs):
                        """
                        Enters the menu for setting up the risk for solids deposit formation for the Selective Catalytic Reduction (SCR) process. For more information, see .
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/scr_urea_deposition_risk_analysis").execute(*args, **kwargs)
                    def include_lwf_particles_in_dpm_concentration(self, *args, **kwargs):
                        """
                        Include LWF particle mass in DPM Concentration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/include_lwf_particles_in_dpm_concentration").execute(*args, **kwargs)
                    def init_erosion_accretion_rate(self, *args, **kwargs):
                        """
                        Initializes the erosion/accretion rates with zero.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/init_erosion_accretion_rate").execute(*args, **kwargs)
                    def allow_supercritical_pressure_vaporization(self, *args, **kwargs):
                        """
                        Enforces the switching from vaporization to boiling even if the boiling point is not calculated from the vapor pressure data. If the pressure in your model is above critical you must retain the default setting (yes). This options is available only if whenPressure Dependent Boiling is enabled in the Physical Models tab of the Discrete Phase Models dialog box. For more details, see .
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/allow_supercritical_pressure_vaporization").execute(*args, **kwargs)
                    def current_positions_in_sample_file_format(self, *args, **kwargs):
                        """
                        When enabled, generates a file containing particle current positions (step-by-step history report for unsteady tracking) in the sampling file format.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/current_positions_in_sample_file_format").execute(*args, **kwargs)
                    def enable_contour_plots(self, *args, **kwargs):
                        """
                        Enables computation of mean and/or RMS values of additional discrete phase variables for postprocessing.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/enable_contour_plots").execute(*args, **kwargs)
                    def set_minimum_particle_diameter(self, *args, **kwargs):
                        """
                        Set the minimum particle diameter.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/set_minimum_particle_diameter").execute(*args, **kwargs)
                    def virtual_mass_force(self, *args, **kwargs):
                        """
                        Enables/disables inclusion of the virtual mass force in the particle force balance.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/virtual_mass_force").execute(*args, **kwargs)
                    def use_absolute_pressure_for_vaporization(self, *args, **kwargs):
                        """
                        Determines whether the absolute pressure or constant operating pressure (specified in define/operating-conditions/operating-pressure) will be used in vaporization rates calculations.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/use_absolute_pressure_for_vaporization").execute(*args, **kwargs)
                    def brownian_motion(self, *args, **kwargs):
                        """
                        Enables/disables Brownian motion of particles.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/brownian_motion").execute(*args, **kwargs)
                    def lowest_volatiles_mass_fraction(self, *args, **kwargs):
                        """
                        Set the lowest volatiles mass fraction.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/lowest_volatiles_mass_fraction").execute(*args, **kwargs)
                    def step_report_sig_figures(self, *args, **kwargs):
                        """
                        Sets significant figures in the step-by-step report.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/step_report_sig_figures").execute(*args, **kwargs)

                class collisions(TUIMenu):
                    """
                    Enters the DEM collisions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.collision_partners = self.__class__.collision_partners(path + ["collision_partners"], service)
                        super().__init__(path, service)
                    def collision_mesh(self, *args, **kwargs):
                        """
                        Input for the collision mesh.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/collision_mesh").execute(*args, **kwargs)
                    def collision_pair_settings(self, *args, **kwargs):
                        """
                        Supplies settings for collisions to a pair of collision partners. You will be prompted to specify theImpact collision partner and the Target collision partner.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/collision_pair_settings").execute(*args, **kwargs)
                    def max_particle_velocity(self, *args, **kwargs):
                        """
                        Sets the maximum particle velocity that may arise from collisions.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/max_particle_velocity").execute(*args, **kwargs)
                    def list_all_pair_settings(self, *args, **kwargs):
                        """
                        For each pair of collision partners, lists the collision laws and their parameters.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/list_all_pair_settings").execute(*args, **kwargs)
                    def dem_collisions(self, *args, **kwargs):
                        """
                        Enables/disables the DEM collision model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/dem_collisions").execute(*args, **kwargs)

                    class collision_partners(TUIMenu):
                        """
                        Manages collision partners.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def copy(self, *args, **kwargs):
                            """
                            Copies a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/copy").execute(*args, **kwargs)
                        def create(self, *args, **kwargs):
                            """
                            Creates a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/create").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/delete").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Lists all known collision partners.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/list").execute(*args, **kwargs)
                        def rename(self, *args, **kwargs):
                            """
                            Renames a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/rename").execute(*args, **kwargs)

                class erosion_dynamic_mesh(TUIMenu):
                    """
                    Enters the menu to enable/configure/run the erosion-dynamic mesh interaction.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.general_parameters = self.__class__.general_parameters(path + ["general_parameters"], service)
                        self.run_parameters = self.__class__.run_parameters(path + ["run_parameters"], service)
                        super().__init__(path, service)
                    def enable_erosion_dynamic_mesh_coupling(self, *args, **kwargs):
                        """
                        Enables mesh deformation due to wall erosion.
                        """
                        return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/enable_erosion_dynamic_mesh_coupling").execute(*args, **kwargs)
                    def run_simulation(self, *args, **kwargs):
                        """
                        Performs a coupled erosion-dynamic mesh simulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_simulation").execute(*args, **kwargs)

                    class general_parameters(TUIMenu):
                        """
                        Enters the menu for setting erosion coupling with dynamic mesh.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def dynamic_mesh_settings(self, *args, **kwargs):
                            """
                            Sets parameters for dynamic mesh calculations.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/dynamic_mesh_settings").execute(*args, **kwargs)
                        def participating_walls(self, *args, **kwargs):
                            """
                            Specifies all participating walls.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/participating_walls").execute(*args, **kwargs)
                        def erosion_settings(self, *args, **kwargs):
                            """
                            Sets parameters for erosion calculations.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/erosion_settings").execute(*args, **kwargs)

                    class run_parameters(TUIMenu):
                        """
                        Manages erosion-dynamic mesh run settings.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def autosave_graphics(self, *args, **kwargs):
                            """
                            Sets the iteration increment to save graphics files.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_graphics").execute(*args, **kwargs)
                        def mesh_motion_time_step(self, *args, **kwargs):
                            """
                            Sets the mesh motion time stepping parameters and method.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/mesh_motion_time_step").execute(*args, **kwargs)
                        def autosave_files(self, *args, **kwargs):
                            """
                            Sets the iteration increment and filename to save data files.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_files").execute(*args, **kwargs)
                        def simulation_termination(self, *args, **kwargs):
                            """
                            Sets the total time of erosion.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/simulation_termination").execute(*args, **kwargs)
                        def flow_simulation_control(self, *args, **kwargs):
                            """
                            Sets the number of iterations per flow simulation step.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/flow_simulation_control").execute(*args, **kwargs)

                class stripping_options(TUIMenu):
                    """
                    Enters the stripping options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_coefficient(self, *args, **kwargs):
                        """
                        Sets the mass coefficient (  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/dpm/stripping_options/mass_coefficient").execute(*args, **kwargs)
                    def diameter_coefficient(self, *args, **kwargs):
                        """
                        Sets the diameter coefficient (  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/dpm/stripping_options/diameter_coefficient").execute(*args, **kwargs)

                class splash_options(TUIMenu):
                    """
                    Enters the splash option menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def orourke_splash_fraction(self, *args, **kwargs):
                        """
                        Enables/disables the O’Rourke formulation (default for the Lagrangian Wall Film (LWF) model). If the O’Rourke formulation is disabled, the Stanton formulation (default for the Eulerian Wall Film (EWF) model) is used in a simulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/splash_options/orourke_splash_fraction").execute(*args, **kwargs)
                    def splash_pdf_limiting(self, *args, **kwargs):
                        """
                        Sets the splash pdf limiting method. Available methods are: the splash pdf tail limiting (default for the LWF model) and the splash pdf peak limiting (default for the EWF model). For the splash pdf peak limiting, you will be prompted to specify the peak limiting value.
                        """
                        return PyMenu(self.service, "/define/models/dpm/splash_options/splash_pdf_limiting").execute(*args, **kwargs)

                class interaction(TUIMenu):
                    """
                    Sets parameters for coupled discrete phase calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def keep_linearized_dpm_source_terms_constant(self, *args, **kwargs):
                        """
                        Keep linearized DPM source terms constant until the next DPM Update.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/keep_linearized_dpm_source_terms_constant").execute(*args, **kwargs)
                    def implicit_source_term_coupling(self, *args, **kwargs):
                        """
                        Enables/disables implicit treatment for all DPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/implicit_source_term_coupling").execute(*args, **kwargs)
                    def linearized_dpm_source_terms_limiter(self, *args, **kwargs):
                        """
                        Relative limit for DPM source linear coefficient with respect to fluid linear Ap coefficient.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_source_terms_limiter").execute(*args, **kwargs)
                    def enable_source_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM source terms due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_source_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def enable_flow_blocking_by_particles(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_flow_blocking_by_particles").execute(*args, **kwargs)
                    def dpm_iteration_interval(self, *args, **kwargs):
                        """
                        Sets the frequency with which the particle trajectory calculations are introduced.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/dpm_iteration_interval").execute(*args, **kwargs)
                    def linearized_dpm_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables linearization of source terms for the discrete phase.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_source_terms").execute(*args, **kwargs)
                    def linearized_dpm_mixture_fraction_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables linearization of mixture fraction source terms. This command is available only for non- or partially-premixed combustion cases.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_mixture_fraction_source_terms").execute(*args, **kwargs)
                    def linear_growth_of_dpm_source_term(self, *args, **kwargs):
                        """
                        Enables/disables the linear ramping up of the DPM source terms at every DPM iteration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linear_growth_of_dpm_source_term").execute(*args, **kwargs)
                    def choice_of_eulerian_phase_for_interaction(self, *args, **kwargs):
                        """
                        Enable/disable the option to choose for every injection the Eulerian phase for the DPM continuous phase interaction.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/choice_of_eulerian_phase_for_interaction").execute(*args, **kwargs)
                    def replace_dpm_mass_source_by_mixture_fraction(self, *args, **kwargs):
                        """
                        When enabled, recalculates the mixture fraction source terms as a function of the primary mixture fraction. This command is available for non- or partially-premixed combustion cases only.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/replace_dpm_mass_source_by_mixture_fraction").execute(*args, **kwargs)
                    def max_vf_allowed_for_blocking(self, *args, **kwargs):
                        """
                        Maximum DPM volume fraction used in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/max_vf_allowed_for_blocking").execute(*args, **kwargs)
                    def ddpm_enhanced_inter_phase_exchange(self, *args, **kwargs):
                        """
                        Enhanced Eulerian inter-phase exchange.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_enhanced_inter_phase_exchange").execute(*args, **kwargs)
                    def update_dpm_sources_every_flow_iteration(self, *args, **kwargs):
                        """
                        Enables/disables the update of DPM source terms every flow iteration (if this option is not enabled, the terms will be updated every DPM iteration).
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/update_dpm_sources_every_flow_iteration").execute(*args, **kwargs)
                    def min_vf_threshold_for_dpm_src_scaling(self, *args, **kwargs):
                        """
                        Minimum DPM volume fraction below which no DPM source scaling is applied.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/min_vf_threshold_for_dpm_src_scaling").execute(*args, **kwargs)
                    def coupled_calculations(self, *args, **kwargs):
                        """
                        Selects whether or not to couple continuous and discrete phase calculations.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/coupled_calculations").execute(*args, **kwargs)
                    def reset_sources_at_timestep(self, *args, **kwargs):
                        """
                        Enables/disables flush of DPM source terms at beginning of every time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/reset_sources_at_timestep").execute(*args, **kwargs)
                    def implicit_momentum_coupling(self, *args, **kwargs):
                        """
                        Enables/disables implicit treatment for the DPM momentum source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/implicit_momentum_coupling").execute(*args, **kwargs)
                    def ddpm_energy_coupling_via_source_term(self, *args, **kwargs):
                        """
                        Energy coupling in DDPM established via source term.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_energy_coupling_via_source_term").execute(*args, **kwargs)
                    def underrelaxation_factor(self, *args, **kwargs):
                        """
                        Sets the under-relaxation factor for the discrete phase sources.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/underrelaxation_factor").execute(*args, **kwargs)
                    def linearized_dpm_species_source_terms(self, *args, **kwargs):
                        """
                        Perform linearization of species source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_species_source_terms").execute(*args, **kwargs)
                    def enable_drag_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM drag coefficient due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_drag_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def ddpm_iad_particle(self, *args, **kwargs):
                        """
                        Enable/disable the non-default interfacial area method IA-particle.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_iad_particle").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enters the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def structure_off(self, *args, **kwargs):
                    """
                    Disables the structural model.
                    """
                    return PyMenu(self.service, "/define/models/structure/structure_off").execute(*args, **kwargs)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enables the linear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/linear_elasticity").execute(*args, **kwargs)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/nonlinear_elasticity").execute(*args, **kwargs)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/define/models/structure/thermal_effects").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enters the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Sets the damping factor for the structural model (that is, the amplitude decay factor  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Sets the maximum number of iterations for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/enhanced_strain").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Sets the algebraic multigrid (AMG) stabilization method for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/amg_stabilization").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of operating pressure into the fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of a viscous fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables an explicit fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)

            class cht(TUIMenu):
                """
                Enters the cht (conjugate heat transfer) menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_time_averaged_coupling = self.__class__.explicit_time_averaged_coupling(path + ["explicit_time_averaged_coupling"], service)
                    super().__init__(path, service)
                def read_mi_type_wall(self, *args, **kwargs):
                    """
                    Read mapped interface data settings from a csv file.
                    """
                    return PyMenu(self.service, "/define/models/cht/read_mi_type_wall").execute(*args, **kwargs)
                def write_mi_type_wall(self, *args, **kwargs):
                    """
                    Write mapped interface settings to a scv file.
                    """
                    return PyMenu(self.service, "/define/models/cht/write_mi_type_wall").execute(*args, **kwargs)
                def implicit_coupling(self, *args, **kwargs):
                    """
                    Enables the implicit mapping scheme for any 	fluid-solid pair with a mapped mesh interface (only 	required for cases set up in version 19.2 or 	earlier).
                    """
                    return PyMenu(self.service, "/define/models/cht/implicit_coupling").execute(*args, **kwargs)

                class explicit_time_averaged_coupling(TUIMenu):
                    """
                    Enters the explicit time averaged thermal coupling 	menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mapped_interfaces(self, *args, **kwargs):
                        """
                        Select fluid-solid mapped interfaces for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/mapped_interfaces").execute(*args, **kwargs)
                    def coupling_controls(self, *args, **kwargs):
                        """
                        Specify explcit coupling controls.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/coupling_controls").execute(*args, **kwargs)
                    def fuse_explicit_cht_zones(self, *args, **kwargs):
                        """
                        Fuse slitted conformal coupled walls marked for transient explicit thermal coupling.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/fuse_explicit_cht_zones").execute(*args, **kwargs)
                    def conformal_coupled_walls(self, *args, **kwargs):
                        """
                        Select fluid-solid coupled walls (without shell) for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/conformal_coupled_walls").execute(*args, **kwargs)

            class optics(TUIMenu):
                """
                Enter the optics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.beams = self.__class__.beams(path + ["beams"], service)
                    self.statistics = self.__class__.statistics(path + ["statistics"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/enable").execute(*args, **kwargs)
                def report(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/report").execute(*args, **kwargs)
                def index_of_refraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/index_of_refraction").execute(*args, **kwargs)
                def sampling_iterations(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/sampling_iterations").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/verbosity").execute(*args, **kwargs)

                class beams(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/delete").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/edit").execute(*args, **kwargs)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/rename").execute(*args, **kwargs)
                    def list_beam_parameters(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/list_beam_parameters").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Create a new beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/add").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/copy").execute(*args, **kwargs)

                class statistics(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def reset_statistics(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/reset_statistics").execute(*args, **kwargs)
                    def statistics_controls(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/statistics_controls").execute(*args, **kwargs)

            class system_coupling_settings(TUIMenu):
                """
                Enters the system coupling menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.htc = self.__class__.htc(path + ["htc"], service)
                    super().__init__(path, service)
                def specify_system_coupling_volumetric_cell_zones(self, *args, **kwargs):
                    """
                    Enable/disable volumetric cell zones.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/specify_system_coupling_volumetric_cell_zones").execute(*args, **kwargs)
                def use_face_or_element_based_data_transfer(self, *args, **kwargs):
                    """
                    Answering yes at the prompt 	enables Fluent to use element data for mapping surface 	conservative quantities such as surface forces and heat 	flows.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/use_face_or_element_based_data_transfer").execute(*args, **kwargs)
                def update_rigid_body_mesh_motion_before_mesh_transfer(self, *args, **kwargs):
                    """
                    SC Enable/disable mesh motion.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/update_rigid_body_mesh_motion_before_mesh_transfer").execute(*args, **kwargs)

                class htc(TUIMenu):
                    """
                    Enter the heat transfer coeficient menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.htc_calculation_method = self.__class__.htc_calculation_method(path + ["htc_calculation_method"], service)
                        self.unsteady_statistics = self.__class__.unsteady_statistics(path + ["unsteady_statistics"], service)
                        super().__init__(path, service)

                    class htc_calculation_method(TUIMenu):
                        """
                        Enter the htc calculation menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def use_yplus_based_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable yplus in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_yplus_based_htc_calculation").execute(*args, **kwargs)
                        def use_tref_in_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable tref in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_tref_in_htc_calculation").execute(*args, **kwargs)
                        def use_wall_function_based_htc(self, *args, **kwargs):
                            """
                            Enable/disable wall function based htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_wall_function_based_htc").execute(*args, **kwargs)

                    class unsteady_statistics(TUIMenu):
                        """
                        Enter the unsteady statistics menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sc_enable_sub_stepping_option_per_coupling_step(self, *args, **kwargs):
                            """
                            Enable/disable sub stepping option per coupling step.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/unsteady_statistics/sc_enable_sub_stepping_option_per_coupling_step").execute(*args, **kwargs)

            class solver(TUIMenu):
                """
                Enters the menu to select the solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_based(self, *args, **kwargs):
                    """
                    Enables/disables the pressure-based solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/pressure_based").execute(*args, **kwargs)
                def adjust_solver_defaults_based_on_setup(self, *args, **kwargs):
                    """
                    Enable/disable adjustment of solver defaults based on setup.
                    """
                    return PyMenu(self.service, "/define/models/solver/adjust_solver_defaults_based_on_setup").execute(*args, **kwargs)
                def density_based_implicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-implicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_implicit").execute(*args, **kwargs)
                def density_based_explicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-explicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_explicit").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enters the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables particle surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Sets flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/flamelet_expert").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enables/disables mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/mass_deposition_source").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enables/disables the species transport model.
                    """
                    return PyMenu(self.service, "/define/models/species/species_transport").execute(*args, **kwargs)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enables/disables liquid micro mixing.
                    """
                    return PyMenu(self.service, "/define/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enables/disables solution of species models.
                    """
                    return PyMenu(self.service, "/define/models/species/off").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enables/disables the Ansys CHEMKIN-CFD solver.
                    """
                    return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enables/disables the Reactor Network Model.
                    """
                    return PyMenu(self.service, "/define/models/species/reactor_network_model").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Sets Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Sets the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/define/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Sets chemistry ODE integrator parameters. Enables/disables stiff chemistry 	acceleration methods and set their parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/integration_parameters").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Imports Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/define/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/define/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enables/disables stiff chemistry option.
                    """
                    return PyMenu(self.service, "/define/models/species/stiff_chemistry").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Sets the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/define/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Sets/changes partially-premixed mixture properties. 	This command is only available when partially-premixed-combustion? 	is enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Sets PDF parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Enables import of the CHEMKIN mechanism transport 	data. When this option is enabled, you will be prompted 	for importing CHEMKIN transport property database when 	setting your combustion case.
                    """
                    return PyMenu(self.service, "/define/models/species/combustion_expert").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/define/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Sets up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/define/models/species/coal_calculator").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Applies optimal solver settings automatically to provide a faster solution time. 	This command is available only for transient 	non-premixed and partially premixed combustion 	models.
                    """
                    return PyMenu(self.service, "/define/models/species/combustion_numerics").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enables/disables the ignition model.
                    """
                    return PyMenu(self.service, "/define/models/species/ignition_model").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Switches between the R15 and R14.5 spark models and sets spark model 	parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/spark_model").execute(*args, **kwargs)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enables/disables EPDF energy option.
                    """
                    return PyMenu(self.service, "/define/models/species/epdf_energy").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Sets PDF expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enables/disables volumetric reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/volumetric_reactions").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Sets PDF expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Sets premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Includes species migration in electric field. This command is available only when 	the electrochemical surface reactions are 	enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/species_migration").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Sets values for the grid distribution for PDF table or 	flamelet parameter. This text command is available only 	for partially premixed combustion cases with FGM.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enables/disables storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/define/models/species/save_gradients").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initializes Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/define/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enables/disables the inert transport model.
                    """
                    return PyMenu(self.service, "/define/models/species/inert_transport_model").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enables/disables the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/define/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/premixed_combustion").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables thermal diffusion.
                    """
                    return PyMenu(self.service, "/define/models/species/thermal_diffusion").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Sets EDC model constants.
                    """
                    return PyMenu(self.service, "/define/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enables/disables diffusion energy source.
                    """
                    return PyMenu(self.service, "/define/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Sets ignition model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/ignition_model_controls").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enables/disables the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/define/models/species/reacting_channel_model").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Sets the convergence acceleration expert parameters. This command is only available 	when the species transport model is enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/species_transport_expert").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clears ISAT table.
                    """
                    return PyMenu(self.service, "/define/models/species/clear_isat_table").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/species/inlet_diffusion").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Sets PDF parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Sets PDF Transport mixing model.
                    """
                    return PyMenu(self.service, "/define/models/species/mixing_model").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enables/disables the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/define/models/species/relax_to_equil").execute(*args, **kwargs)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enables/disables reaction diffusion balance at reacting surface for surface 	reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/reaction_diffusion_balance").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Sets inert transport model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/inert_transport_controls").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables heat of surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/define/models/species/re_calc_par_premix_props").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Sets premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/premixed_model").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables wall surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enables/disables the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/pdf_transport").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enables/disables building of a full 2-mixture fraction table.
                    """
                    return PyMenu(self.service, "/define/models/species/full_tabulation").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enables/disables PDF Transport expert user.
                    """
                    return PyMenu(self.service, "/define/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enables/disables the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/define/models/species/thickened_flame_model").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enters the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        Lists cell monitors.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)
                    def basic_options(self, *args, **kwargs):
                        """
                        Sets basic parameter options.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Sets advanced parameter options.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Monitors cell for debug output.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Deletes cell monitors.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)

            class two_temperature(TUIMenu):
                """
                Enters the Two-Temperature model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nasa9_enhancement(self, *args, **kwargs):
                    """
                    Apply nasa9 robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/nasa9_enhancement").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Specifies the level of detail printed in the console 	about the Two-Temperature model. For a verbosity of one, 	Fluent will print the number of cells that reach the 	temperature limit, have an excessive temperature change, 	or get a negative temperature.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/set_verbosity").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the Two-Temperature model.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/enable").execute(*args, **kwargs)
                def robustness_enhancement(self, *args, **kwargs):
                    """
                    Enables/disables the robustness enhancement, which is 	on by default.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/robustness_enhancement").execute(*args, **kwargs)

            class acoustics(TUIMenu):
                """
                Enters the acoustics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.wave_equation_options = self.__class__.wave_equation_options(path + ["wave_equation_options"], service)
                    self.sources_fft = self.__class__.sources_fft(path + ["sources_fft"], service)
                    self.sponge_layers = self.__class__.sponge_layers(path + ["sponge_layers"], service)
                    self.far_field_parameters = self.__class__.far_field_parameters(path + ["far_field_parameters"], service)
                    super().__init__(path, service)
                def compute_write(self, *args, **kwargs):
                    """
                    Computes sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/compute_write").execute(*args, **kwargs)
                def export_volumetric_sources_cgns(self, *args, **kwargs):
                    """
                    Enables/disables the export of fluid zones.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_volumetric_sources_cgns").execute(*args, **kwargs)
                def receivers(self, *args, **kwargs):
                    """
                    Sets acoustic receivers.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/receivers").execute(*args, **kwargs)
                def acoustic_modal_analysis(self, *args, **kwargs):
                    """
                    Iterate linear acoustic solver to compute the resonance frequencies and the acoustic modes.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/acoustic_modal_analysis").execute(*args, **kwargs)
                def convective_effects(self, *args, **kwargs):
                    """
                    Enables/disables the convective effects option.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/convective_effects").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enables/disables the acoustics model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/off").execute(*args, **kwargs)
                def display_flow_time(self, *args, **kwargs):
                    """
                    Enables/disables the display of flow time during read-and-compute.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/display_flow_time").execute(*args, **kwargs)
                def export_volumetric_sources(self, *args, **kwargs):
                    """
                    Enables/disables the export of fluid zones.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_volumetric_sources").execute(*args, **kwargs)
                def read_compute_write(self, *args, **kwargs):
                    """
                    Reads acoustic source data files and computes sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/read_compute_write").execute(*args, **kwargs)
                def display_frequencies(self, *args, **kwargs):
                    """
                    Display resonance frequencies.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/display_frequencies").execute(*args, **kwargs)
                def cylindrical_export(self, *args, **kwargs):
                    """
                    Enables/disables the export of data in cylindrical coordinates.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/cylindrical_export").execute(*args, **kwargs)
                def write_acoustic_signals(self, *args, **kwargs):
                    """
                    Writes on-the-fly sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/write_acoustic_signals").execute(*args, **kwargs)
                def ffowcs_williams(self, *args, **kwargs):
                    """
                    Enables/disables the Ffowcs-Williams-and-Hawkings model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/ffowcs_williams").execute(*args, **kwargs)
                def wave_equation(self, *args, **kwargs):
                    """
                    Enables/disables the wave equation model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/wave_equation").execute(*args, **kwargs)
                def moving_receiver(self, *args, **kwargs):
                    """
                    Enables/disables the moving receiver option.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/moving_receiver").execute(*args, **kwargs)
                def broad_band_noise(self, *args, **kwargs):
                    """
                    Enables/disables the broadband noise model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/broad_band_noise").execute(*args, **kwargs)
                def auto_prune(self, *args, **kwargs):
                    """
                    Enables/disables auto prune of the receiver signal(s) during 	read-and-compute.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/auto_prune").execute(*args, **kwargs)
                def export_source_data_cgns(self, *args, **kwargs):
                    """
                    Enables/disables the export of acoustic source data in CGNS format.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_source_data_cgns").execute(*args, **kwargs)
                def export_source_data(self, *args, **kwargs):
                    """
                    Enables/disables the export of acoustic source data in 	ASD format during the wave equation model run.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_source_data").execute(*args, **kwargs)
                def write_centroid_info(self, *args, **kwargs):
                    """
                    Writes centroid info.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/write_centroid_info").execute(*args, **kwargs)
                def modal_analysis(self, *args, **kwargs):
                    """
                    Enable/disable the modal analysis model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/modal_analysis").execute(*args, **kwargs)
                def sources(self, *args, **kwargs):
                    """
                    Sets acoustic sources.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/sources").execute(*args, **kwargs)

                class wave_equation_options(TUIMenu):
                    """
                    Enters the menu to define the acoustics wave equation 	model options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.remote_receivers_options = self.__class__.remote_receivers_options(path + ["remote_receivers_options"], service)
                        self.basic_shapes = self.__class__.basic_shapes(path + ["basic_shapes"], service)
                        super().__init__(path, service)
                    def source_mask_udf(self, *args, **kwargs):
                        """
                        Specifies the name of a user-defined function, which defines geometry of the source mask.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/source_mask_udf").execute(*args, **kwargs)
                    def time_filter_source(self, *args, **kwargs):
                        """
                        Enables/disables a time filter for the sound source.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/time_filter_source").execute(*args, **kwargs)
                    def remote_receivers(self, *args, **kwargs):
                        """
                        Enables/disables the Kirchhoff integral model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers").execute(*args, **kwargs)
                    def sponge_layer_base_level(self, *args, **kwargs):
                        """
                        Specify artificial viscosity base level applied everywhere.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_base_level").execute(*args, **kwargs)
                    def sponge_layer_factor(self, *args, **kwargs):
                        """
                        Specifies the factor of the artificial viscosity coefficient.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_factor").execute(*args, **kwargs)
                    def sponge_layer_udf(self, *args, **kwargs):
                        """
                        Specifies the name of a user-defined function, which defines geometry of the sponge layer.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_udf").execute(*args, **kwargs)

                    class remote_receivers_options(TUIMenu):
                        """
                        Enters the menu to define remote receivers for the Kirchhoff integral model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def write_signals(self, *args, **kwargs):
                            """
                            Writes the computed receiver signals to the ASCII files.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers_options/write_signals").execute(*args, **kwargs)
                        def integration_surface(self, *args, **kwargs):
                            """
                            Selects the integration surface for the Kirchhoff model.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers_options/integration_surface").execute(*args, **kwargs)

                    class basic_shapes(TUIMenu):
                        """
                        Enters the menu to define the geometry of the source mask and sponge layer using the basic shapes, represented by the cell registers of the type "Region".
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list_region_registers(self, *args, **kwargs):
                            """
                            List all available cell registers of the type "Region".
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_region_registers").execute(*args, **kwargs)
                        def add_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Adds a basic shape to the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/add_sponge_layer_shape").execute(*args, **kwargs)
                        def remove_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Remove a basic shape from the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/remove_sponge_layer_shape").execute(*args, **kwargs)
                        def list_source_mask_shapes(self, *args, **kwargs):
                            """
                            List basic shapes, which are currently used in the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_source_mask_shapes").execute(*args, **kwargs)
                        def add_source_mask_shape(self, *args, **kwargs):
                            """
                            Adds a basic shape to the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/add_source_mask_shape").execute(*args, **kwargs)
                        def remove_source_mask_shape(self, *args, **kwargs):
                            """
                            Remove a basic shape from the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/remove_source_mask_shape").execute(*args, **kwargs)
                        def list_sponge_layer_shapes(self, *args, **kwargs):
                            """
                            List basic shapes, which are currently used in the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_sponge_layer_shapes").execute(*args, **kwargs)

                class sources_fft(TUIMenu):
                    """
                    Enters the acoustic sources fast Fourier transform (FFT) menu, to compute Fourier 	spectra from acoustic source data (ASD) files, create 	postprocessing variables for the pressure signals, and 	write CGNS files of the spectrum data.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.fft_surface_variables = self.__class__.fft_surface_variables(path + ["fft_surface_variables"], service)
                        super().__init__(path, service)
                    def write_cgns_files(self, *args, **kwargs):
                        """
                        Writes surface pressure spectra in CGNS format, which can be used for one-way coupling with Ansys Mechanical in the frequency domain.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/write_cgns_files").execute(*args, **kwargs)
                    def read_asd_files(self, *args, **kwargs):
                        """
                        Reads ASD files to perform FFT of the pressure history field.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/read_asd_files").execute(*args, **kwargs)
                    def compute_fft_fields(self, *args, **kwargs):
                        """
                        Computes FFT of the read pressure histories. The computed spectra replace the pressure histories in memory.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/compute_fft_fields").execute(*args, **kwargs)
                    def clean_up_storage_area(self, *args, **kwargs):
                        """
                        De-allocates memory used to store the pressure histories and their Fourier spectra, as well as any created surface variables for the visualization.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/clean_up_storage_area").execute(*args, **kwargs)

                    class fft_surface_variables(TUIMenu):
                        """
                        Enters the menu to create surface variables from the computed Fourier spectra for visualization.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create_set_of_modes(self, *args, **kwargs):
                            """
                            Selects up to 20 individual Fourier modes and create variable pairs for them, containing the real and the imaginary parts of the complex Fourier amplitudes.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_set_of_modes").execute(*args, **kwargs)
                        def remove_variables(self, *args, **kwargs):
                            """
                            Removes all variables created in this menu.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/remove_variables").execute(*args, **kwargs)
                        def create_constant_width_bands(self, *args, **kwargs):
                            """
                            Selects up to 20 constant width bands and creates either the surface pressures level (SPL) variables or the PSD of dp/dt variables for them.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_constant_width_bands").execute(*args, **kwargs)
                        def create_third_bands(self, *args, **kwargs):
                            """
                            Creates either the surface pressure level (SPL) variables or the PSD of dp/dt variables for 54 technical thirds.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_third_bands").execute(*args, **kwargs)
                        def create_octave_bands(self, *args, **kwargs):
                            """
                            Creates either the surface pressure level (SPL) variables or the PSD of dp/dt variables for 17 technical octaves.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_octave_bands").execute(*args, **kwargs)

                class sponge_layers(TUIMenu):
                    """
                    Manage sponge layers where density is blended to eliminate reflections from boundary zones.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_properties(self, *args, **kwargs):
                        """
                        Prints the properties of an existing sponge layer of your choice in the console.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list_properties").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        Prints a list of the existing sponge layers in the console.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a new sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/add").execute(*args, **kwargs)
                    def activate(self, *args, **kwargs):
                        """
                        Activate a sponge object.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/activate").execute(*args, **kwargs)
                    def deactivate(self, *args, **kwargs):
                        """
                        Deactivate a sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/deactivate").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Deletes an existing sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/delete").execute(*args, **kwargs)
                    def list_active(self, *args, **kwargs):
                        """
                        List the names of the active sponge layer definitions.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list_active").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edits an existing sponge layer. You can revise the fields listed previously for the define/models/acoustics/sponge-layers/add text command.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/edit").execute(*args, **kwargs)

                class far_field_parameters(TUIMenu):
                    """
                    Enters the menu to specify the far-field density and 	speed of sound. Note that this menu is currently 	available only with the acoustics wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def far_field_density(self, *args, **kwargs):
                        """
                        Specifies the far-field density value for the acoustics wave equation model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/far_field_parameters/far_field_density").execute(*args, **kwargs)
                    def far_field_sound_speed(self, *args, **kwargs):
                        """
                        Specifies the far-field speed of sound value for the acoustics wave equation model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/far_field_parameters/far_field_sound_speed").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Enters the multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def expert_options(self, *args, **kwargs):
                    """
                    Expert Options.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/expert_options").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Specifies mixture parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def boiling_model_options(self, *args, **kwargs):
                    """
                    Specifies the boiling model options. You can choose theRPI boiling model,Non-equilibrium boiling, orCritical heat flux.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/boiling_model_options").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Specifies interface modeling options.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def eulerian_parameters(self, *args, **kwargs):
                    """
                    Specifies Eulerian parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/eulerian_parameters").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Specifies body force formulation.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Enables coupled level set interface tracking method.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Enables the Algebraic Interfacial Area Density (AIAD) 	model and sets the AIAD secondary continuous phase and 	the secondary entrained phase. Entering 0 as a phase ID cancels any 	previous phase selection. Note that you must define the 	phases in your simulation using the define/phases/ text command 	prior to using the regime-transition-modeling 	text command. This option is available only with the 	Eulerian multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specifies the number of phases.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    Enables the Open Channel sub-model and/or the Open Channel Wave Boundary Condition 	sub-model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/vof_sub_models").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specifies multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/model").execute(*args, **kwargs)

                class hybrid_models(TUIMenu):
                    """
                    Enter the menu to select hybrid models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ddpm(self, *args, **kwargs):
                        """
                        Enable the dense discrete phase model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/hybrid_models/ddpm").execute(*args, **kwargs)
                    def multi_fluid_vof(self, *args, **kwargs):
                        """
                        Enable the multi-fluid VOF model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/hybrid_models/multi_fluid_vof").execute(*args, **kwargs)

                class wet_steam(TUIMenu):
                    """
                    Enters the wet steam model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def compile_user_defined_wetsteam_functions(self, *args, **kwargs):
                        """
                        Compiles user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/compile_user_defined_wetsteam_functions").execute(*args, **kwargs)
                    def load_unload_user_defined_wetsteam_library(self, *args, **kwargs):
                        """
                        Loads or unloads user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/load_unload_user_defined_wetsteam_library").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enables/disables the wet steam model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/enable").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enters the set menu for setting wet steam model options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def rgp_tables(self, *args, **kwargs):
                            """
                            Sets the RGP (real gas property) table to be used with the Wet Steam model.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/rgp_tables").execute(*args, **kwargs)
                        def stagnation_conditions(self, *args, **kwargs):
                            """
                            Computes stagnation conditions using either gas phase only, or mixture. For details, see .
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/stagnation_conditions").execute(*args, **kwargs)
                        def max_liquid_mass_fraction(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the condensed liquid-phase mass-fraction to prevent divergence.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/max_liquid_mass_fraction").execute(*args, **kwargs)
                        def droplet_growth_rate(self, *args, **kwargs):
                            """
                            S formulation (default) or Hill.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/droplet_growth_rate").execute(*args, **kwargs)
                        def virial_equation(self, *args, **kwargs):
                            """
                            Sets the equation of state for steam to either Vukalovich formulation (default) or Young formulation.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/virial_equation").execute(*args, **kwargs)
                        def zonal_phase_change(self, *args, **kwargs):
                            """
                            Select cell zones where phase change process is active.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/zonal_phase_change").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)

                class sub_models(TUIMenu):
                    """
                    Enter the menu to select sub-models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling_options = self.__class__.boiling_options(path + ["boiling_options"], service)
                        super().__init__(path, service)
                    def boiling(self, *args, **kwargs):
                        """
                        Activate boiling model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling").execute(*args, **kwargs)

                    class boiling_options(TUIMenu):
                        """
                        Set boiling options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def options(self, *args, **kwargs):
                            """
                            Choose the type of boiling model.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/options").execute(*args, **kwargs)
                        def nlbf_model(self, *args, **kwargs):
                            """
                            Set the non-local boundary field correction.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/nlbf_model").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        super().__init__(path, service)
                    def interaction_domain(self, *args, **kwargs):
                        """
                        Enter the menu to set interaction domain properties.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/phases/interaction_domain").execute(*args, **kwargs)
                    def phase_domain(self, *args, **kwargs):
                        """
                        Enter the menu to set phase domain properties.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/phases/phase_domain").execute(*args, **kwargs)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                super().__init__(path, service)

                            class numerics(TUIMenu):
                                """
                                Enter the menu to set numerics models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    super().__init__(path, service)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(s