# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'FHIRDatastoreKmsEncryptionConfigArgs',
    'FHIRDatastorePreloadDataConfigArgs',
    'FHIRDatastoreSseConfigurationArgs',
    'FHIRDatastoreTagArgs',
]

@pulumi.input_type
class FHIRDatastoreKmsEncryptionConfigArgs:
    def __init__(__self__, *,
                 cmk_type: pulumi.Input['FHIRDatastoreKmsEncryptionConfigCmkType'],
                 kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        The customer-managed-key (CMK) used when creating a Data Store. If a customer owned key is not specified, an AWS owned key will be used for encryption.
        :param pulumi.Input['FHIRDatastoreKmsEncryptionConfigCmkType'] cmk_type: The type of customer-managed-key (CMK) used for encryption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
        :param pulumi.Input[str] kms_key_id: The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
        """
        pulumi.set(__self__, "cmk_type", cmk_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="cmkType")
    def cmk_type(self) -> pulumi.Input['FHIRDatastoreKmsEncryptionConfigCmkType']:
        """
        The type of customer-managed-key (CMK) used for encryption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
        """
        return pulumi.get(self, "cmk_type")

    @cmk_type.setter
    def cmk_type(self, value: pulumi.Input['FHIRDatastoreKmsEncryptionConfigCmkType']):
        pulumi.set(self, "cmk_type", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)


@pulumi.input_type
class FHIRDatastorePreloadDataConfigArgs:
    def __init__(__self__, *,
                 preload_data_type: pulumi.Input['FHIRDatastorePreloadDataConfigPreloadDataType']):
        """
        The preloaded data configuration for the Data Store. Only data preloaded from Synthea is supported.
        :param pulumi.Input['FHIRDatastorePreloadDataConfigPreloadDataType'] preload_data_type: The type of preloaded data. Only Synthea preloaded data is supported.
        """
        pulumi.set(__self__, "preload_data_type", preload_data_type)

    @property
    @pulumi.getter(name="preloadDataType")
    def preload_data_type(self) -> pulumi.Input['FHIRDatastorePreloadDataConfigPreloadDataType']:
        """
        The type of preloaded data. Only Synthea preloaded data is supported.
        """
        return pulumi.get(self, "preload_data_type")

    @preload_data_type.setter
    def preload_data_type(self, value: pulumi.Input['FHIRDatastorePreloadDataConfigPreloadDataType']):
        pulumi.set(self, "preload_data_type", value)


@pulumi.input_type
class FHIRDatastoreSseConfigurationArgs:
    def __init__(__self__, *,
                 kms_encryption_config: pulumi.Input['FHIRDatastoreKmsEncryptionConfigArgs']):
        """
        The server-side encryption key configuration for a customer provided encryption key.
        """
        pulumi.set(__self__, "kms_encryption_config", kms_encryption_config)

    @property
    @pulumi.getter(name="kmsEncryptionConfig")
    def kms_encryption_config(self) -> pulumi.Input['FHIRDatastoreKmsEncryptionConfigArgs']:
        return pulumi.get(self, "kms_encryption_config")

    @kms_encryption_config.setter
    def kms_encryption_config(self, value: pulumi.Input['FHIRDatastoreKmsEncryptionConfigArgs']):
        pulumi.set(self, "kms_encryption_config", value)


@pulumi.input_type
class FHIRDatastoreTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair. A tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.
        :param pulumi.Input[str] key: The key of the tag.
        :param pulumi.Input[str] value: The value of the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


