# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'QuickConnectConfig',
    'QuickConnectPhoneNumberQuickConnectConfig',
    'QuickConnectQueueQuickConnectConfig',
    'QuickConnectTag',
    'QuickConnectUserQuickConnectConfig',
]

@pulumi.output_type
class QuickConnectConfig(dict):
    """
    Configuration settings for the quick connect.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quickConnectType":
            suggest = "quick_connect_type"
        elif key == "phoneConfig":
            suggest = "phone_config"
        elif key == "queueConfig":
            suggest = "queue_config"
        elif key == "userConfig":
            suggest = "user_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quick_connect_type: 'QuickConnectType',
                 phone_config: Optional['outputs.QuickConnectPhoneNumberQuickConnectConfig'] = None,
                 queue_config: Optional['outputs.QuickConnectQueueQuickConnectConfig'] = None,
                 user_config: Optional['outputs.QuickConnectUserQuickConnectConfig'] = None):
        """
        Configuration settings for the quick connect.
        """
        pulumi.set(__self__, "quick_connect_type", quick_connect_type)
        if phone_config is not None:
            pulumi.set(__self__, "phone_config", phone_config)
        if queue_config is not None:
            pulumi.set(__self__, "queue_config", queue_config)
        if user_config is not None:
            pulumi.set(__self__, "user_config", user_config)

    @property
    @pulumi.getter(name="quickConnectType")
    def quick_connect_type(self) -> 'QuickConnectType':
        return pulumi.get(self, "quick_connect_type")

    @property
    @pulumi.getter(name="phoneConfig")
    def phone_config(self) -> Optional['outputs.QuickConnectPhoneNumberQuickConnectConfig']:
        return pulumi.get(self, "phone_config")

    @property
    @pulumi.getter(name="queueConfig")
    def queue_config(self) -> Optional['outputs.QuickConnectQueueQuickConnectConfig']:
        return pulumi.get(self, "queue_config")

    @property
    @pulumi.getter(name="userConfig")
    def user_config(self) -> Optional['outputs.QuickConnectUserQuickConnectConfig']:
        return pulumi.get(self, "user_config")


@pulumi.output_type
class QuickConnectPhoneNumberQuickConnectConfig(dict):
    """
    The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectPhoneNumberQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectPhoneNumberQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectPhoneNumberQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: str):
        """
        The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class QuickConnectQueueQuickConnectConfig(dict):
    """
    The queue configuration. This is required only if QuickConnectType is QUEUE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowArn":
            suggest = "contact_flow_arn"
        elif key == "queueArn":
            suggest = "queue_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQueueQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQueueQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQueueQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_arn: str,
                 queue_arn: str):
        """
        The queue configuration. This is required only if QuickConnectType is QUEUE.
        """
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        pulumi.set(__self__, "queue_arn", queue_arn)

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> str:
        return pulumi.get(self, "contact_flow_arn")

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> str:
        return pulumi.get(self, "queue_arn")


@pulumi.output_type
class QuickConnectTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class QuickConnectUserQuickConnectConfig(dict):
    """
    The user configuration. This is required only if QuickConnectType is USER.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowArn":
            suggest = "contact_flow_arn"
        elif key == "userArn":
            suggest = "user_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectUserQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectUserQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectUserQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_arn: str,
                 user_arn: str):
        """
        The user configuration. This is required only if QuickConnectType is USER.
        """
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        pulumi.set(__self__, "user_arn", user_arn)

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> str:
        return pulumi.get(self, "contact_flow_arn")

    @property
    @pulumi.getter(name="userArn")
    def user_arn(self) -> str:
        return pulumi.get(self, "user_arn")


