#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-init', {
    env: {
        account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION,
    },
});
const vpc = ec2.Vpc.fromLookup(stack, 'VPC', { isDefault: true });
const tmpDir = fs.mkdtempSync('/tmp/cfn-init-test');
fs.writeFileSync(path.resolve(tmpDir, 'testFile'), 'Hello World!\n');
new ec2.Instance(stack, 'Instance2', {
    vpc,
    vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC },
    instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE2, ec2.InstanceSize.MICRO),
    machineImage: new ec2.AmazonLinuxImage(),
    userDataCausesReplacement: true,
    initOptions: {
        timeout: cdk.Duration.minutes(30),
    },
    init: ec2.CloudFormationInit.fromConfigSets({
        configSets: {
            default: ['yumPreinstall', 'config'],
        },
        configs: {
            yumPreinstall: new ec2.InitConfig([
                ec2.InitPackage.yum('git'),
            ]),
            config: new ec2.InitConfig([
                ec2.InitFile.fromObject('/tmp/file2', {
                    stackId: stack.stackId,
                    stackName: stack.stackName,
                    region: stack.region,
                }),
                ec2.InitGroup.fromName('group1'),
                ec2.InitGroup.fromName('group2', 42),
                ec2.InitUser.fromName('sysuser1', {
                    groups: ['group1', 'group2'],
                    homeDir: '/home/sysuser1-custom',
                }),
                ec2.InitUser.fromName('sysuser2'),
                ec2.InitSource.fromAsset('/tmp/sourceDir', tmpDir),
            ]),
        },
    }),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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