# DeLTA
> **NOTE**
This is version 2 of the DeLTA pipeline. For version 1, please check out branch 'version1'

DeLTA (Deep Learning for Time-lapse Analysis) is a deep learning-based image processing pipeline for segmenting and tracking single cells in time-lapse microscopy movies.

![](https://gitlab.com/dunloplab/delta/-/raw/images/DeLTAexample.gif)

:scroll: To get started check out the documentation at [delta.readthedocs.io](https://delta.readthedocs.io)

:bug: If you encounter bugs or have questions about the software, please use [Gitlab's issue system](https://gitlab.com/dunloplab/delta/-/issues)

For the latest _hotness_ check out the `dev` branch. You can also quickly test DeLTA on our data or your own with Google Colab
for free [here](https://colab.research.google.com/drive/1UL9oXmcJFRBAm0BMQy_DMKg4VHYGgtxZ?usp=sharing)

--------------------------
See also our papers for more details:

Version 2: [O’Connor OM, Alnahhas RN, Lugagne J-B, Dunlop MJ (2022) DeLTA 2.0: A deep learning pipeline for quantifying single-cell spatial and temporal dynamics. _PLoS Comput Biol_ 18(1): e1009797](https://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1009797)

Version 1:
[Lugagne J-B, Lin H, & Dunlop MJ (2020) DeLTA: Automated cell segmentation, tracking, and lineage reconstruction using deep learning. _PLoS Comput Biol_ 16(4): e1007673](https://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1007673)

--------------------------
## Contributions

A big thank you to the following people who shared their data and training 
sets with us, they help us make DeLTA more generalizable:

- [Simon van Vliet](https://vanvlietlab.ch/) at University of Basel
- [Zoran Marinković](https://scholar.google.com/citations?user=FKKQ64oAAAAJ&hl=en) at ESPCI Paris
- [Noah Olsman](http://nolsman.com/) and [Daniel Eaton](https://paulsson.med.harvard.edu/people/daniel-eaton) in [Johan Paulsson's group](https://paulsson.med.harvard.edu/) at Harvard
- [Shuai Yang](http://jin.isynbio.siat.ac.cn/wordpress/?p=476) in [Fan Jin's group](http://jin.isynbio.siat.ac.cn/wordpress/) at Shenzhen Institutes of Advanced Technology
- [Jordi van Gestel](https://scholar.google.ch/citations?user=73pVatUAAAAJ&hl=en) and [Noam Golan](https://www.eldarmicrolab.com/team) in [Avigdor Eldar's group](https://www.eldarmicrolab.com/) at Tel-Aviv University

Please reach out if you have created your own sets and think they would be 
helpful to the community!
