# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['numba_quaternion']

package_data = \
{'': ['*']}

install_requires = \
['numba>=0.52', 'numpy>=1,<2']

extras_require = \
{'docs': ['sphinx>=3.3,<4.0',
          'sphinx-bootstrap-theme',
          'pygments-style-solarized',
          'sphinxcontrib-apidoc'],
 'extras': ['coloredlogs>=14,<16'],
 'tests': ['coverage',
           'coveralls',
           'flake8',
           'pytest',
           'pytest-cov',
           'pytest-parallel']}

setup_kwargs = {
    'name': 'numba-quaternion',
    'version': '0.1.0',
    'description': 'Some convenience functions for Cosmology-related analysis.',
    'long_description': '.. This is auto-generated from `docs/README.md`. Do not edit this file directly.\n\n==================================================================================\nnumba_quaternion—quaternion operations that can be used within Numba-jit functions\n==================================================================================\n\n:Date:   March 18, 2021\n\n.. contents::\n   :depth: 3\n..\n\n+-------------+----------------------------------------------------------------------------------+\n| docs        | |Documentation Status| |image2|                                                  |\n+=============+==================================================================================+\n| tests       | |GitHub Actions| |Coverage Status|                                               |\n|             |                                                                                  |\n|             | |Codacy Code Quality Status| |Scrutinizer Status| |CodeClimate Quality Status|   |\n+-------------+----------------------------------------------------------------------------------+\n| package     | |Supported versions| |Supported implementations| |PyPI Wheel|                    |\n|             |                                                                                  |\n|             | |PyPI Package latest release| |GitHub Releases| |Development Status| |Downloads| |\n|             |                                                                                  |\n|             | |Commits since latest release| |License|                                         |\n+-------------+----------------------------------------------------------------------------------+\n| conda-forge | |Conda Recipe| |Conda Downloads| |Conda Version| |Conda Platforms|               |\n+-------------+----------------------------------------------------------------------------------+\n\nIntroduction\n============\n\nThis package contains some numba-jit-compiled functions that perform Quaternion operations and a convenient class ``Quaternion`` that provide convenient methods wrapping around those functions.\n\n``Quaternion`` behaves like a Numpy array containing quaternion, e.g.\xa0respect Numpy broadcast operations, but without really imitating a ``numpy.ndarray`` and implemented a ``dtype``.\n\nThis design allows you to write any jit-compiled functions involving those provided jit-compiled functions, and then write your own class methods that calls those functions as a convenient interface (by class inheritance.)\n\nIf you do not care to use Quaternion in other jit-compiled functions you write, check out packages below instead.\n\nOther Python quaternion projects\n================================\n\nOther Python projects that implements quaternions and I knew and used are:\n\n-  `zonca/quaternionarray <https://github.com/zonca/quaternionarray>`__: written in pure Python using Numpy. Note that unusually they put the real part in the last column. ``lastcol_quat_to_canonical`` and ``canonical_quat_to_lastcol`` convert between those and the canonical ordering (where real part comes first.)\n-  `hpc4cmb/toast <https://github.com/hpc4cmb/toast>`__: toast.qarray is a reimplementation of the above quaternionarray package in C++ with the same interface, and following the same convention.\n-  `moble/quaternion <https://github.com/moble/quaternion>`__: implement Quaternion as a Numpy dtype in C.\n-  `moble/quaternionic <https://github.com/moble/quaternionic>`__: implement Quaternion as a Numpy dtype using Numba. This package is inspired by my expectation of quaternionic—I expected I could use them in a Numba-jit-compiled function but it doesn’t.\n\n.. |Documentation Status| image:: https://readthedocs.org/projects/python-numba_quaternion/badge/?version=latest\n   :target: https://python-numba_quaternion.readthedocs.io/en/latest/?badge=latest&style=plastic\n.. |image1| image:: https://github.com/ickc/python-numba_quaternion/workflows/GitHub%20Pages/badge.svg\n   :target: https://ickc.github.io/python-numba_quaternion\n.. |GitHub Actions| image:: https://github.com/ickc/python-numba_quaternion/workflows/Python%20package/badge.svg\n.. |Coverage Status| image:: https://codecov.io/gh/ickc/python-numba_quaternion/branch/master/graphs/badge.svg?branch=master\n   :target: https://codecov.io/github/ickc/python-numba_quaternion\n.. |Codacy Code Quality Status| image:: https://img.shields.io/codacy/grade/078ebc537c5747f68c1d4ad3d3594bbf.svg\n   :target: https://www.codacy.com/app/ickc/python-numba_quaternion\n.. |Scrutinizer Status| image:: https://img.shields.io/scrutinizer/quality/g/ickc/python-numba_quaternion/master.svg\n   :target: https://scrutinizer-ci.com/g/ickc/python-numba_quaternion/\n.. |CodeClimate Quality Status| image:: https://codeclimate.com/github/ickc/python-numba_quaternion/badges/gpa.svg\n   :target: https://codeclimate.com/github/ickc/python-numba_quaternion\n.. |Supported versions| image:: https://img.shields.io/pypi/pyversions/python-numba_quaternion.svg\n   :target: https://pypi.org/project/python-numba_quaternion\n.. |Supported implementations| image:: https://img.shields.io/pypi/implementation/python-numba_quaternion.svg\n   :target: https://pypi.org/project/python-numba_quaternion\n.. |PyPI Wheel| image:: https://img.shields.io/pypi/wheel/python-numba_quaternion.svg\n   :target: https://pypi.org/project/python-numba_quaternion\n.. |PyPI Package latest release| image:: https://img.shields.io/pypi/v/python-numba_quaternion.svg\n   :target: https://pypi.org/project/python-numba_quaternion\n.. |GitHub Releases| image:: https://img.shields.io/github/tag/ickc/python-numba_quaternion.svg?label=github+release\n   :target: https://github.com/ickc/python-numba_quaternion/releases\n.. |Development Status| image:: https://img.shields.io/pypi/status/python-numba_quaternion.svg\n   :target: https://pypi.python.org/pypi/python-numba_quaternion/\n.. |Downloads| image:: https://img.shields.io/pypi/dm/python-numba_quaternion.svg\n   :target: https://pypi.python.org/pypi/python-numba_quaternion/\n.. |Commits since latest release| image:: https://img.shields.io/github/commits-since/ickc/python-numba_quaternion/v0.13.4.svg\n   :target: https://github.com/ickc/python-numba_quaternion/compare/v0.13.4...master\n.. |License| image:: https://img.shields.io/pypi/l/python-numba_quaternion.svg\n.. |Conda Recipe| image:: https://img.shields.io/badge/recipe-python-numba_quaternion-green.svg\n   :target: https://anaconda.org/conda-forge/python-numba_quaternion\n.. |Conda Downloads| image:: https://img.shields.io/conda/dn/conda-forge/python-numba_quaternion.svg\n   :target: https://anaconda.org/conda-forge/python-numba_quaternion\n.. |Conda Version| image:: https://img.shields.io/conda/vn/conda-forge/python-numba_quaternion.svg\n   :target: https://anaconda.org/conda-forge/python-numba_quaternion\n.. |Conda Platforms| image:: https://img.shields.io/conda/pn/conda-forge/python-numba_quaternion.svg\n   :target: https://anaconda.org/conda-forge/python-numba_quaternion\n.. |image2| image:: https://github.com/ickc/python-numba_quaternion/workflows/GitHub%20Pages/badge.svg\n   :target: https://ickc.github.io/python-numba_quaternion\n',
    'author': 'Kolen Cheung',
    'author_email': 'christian.kolen@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ickc/numba_quaternion',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8',
}


setup(**setup_kwargs)
