"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        var _a;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = (_a = properties.requiresBootstrapStackVersion) !== null && _a !== void 0 ? _a : 1;
    }
}
exports.AssetManifestArtifact = AssetManifestArtifact;
//# sourceMappingURL=data:application/json;base64,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