"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Inspector that maintains an attribute bag
 */
class TreeInspector {
    constructor() {
        /**
         * Represents the bag of attributes as key-value pairs.
         */
        this.attributes = {};
    }
    /**
     * Adds attribute to bag. Keys should be added by convention to prevent conflicts
     * i.e. L1 constructs will contain attributes with keys prefixed with aws:cdk:cloudformation
     *
     * @param key - key for metadata
     * @param value - value of metadata.
     */
    addAttribute(key, value) {
        this.attributes[key] = value;
    }
}
exports.TreeInspector = TreeInspector;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJlZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyZWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7R0FFRztBQUNILE1BQWEsYUFBYTtJQUExQjtRQUNJOztXQUVHO1FBQ2EsZUFBVSxHQUV0QixFQUFFLENBQUM7SUFXWCxDQUFDO0lBVkc7Ozs7OztPQU1HO0lBQ0ksWUFBWSxDQUFDLEdBQVcsRUFBRSxLQUFVO1FBQ3ZDLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7Q0FDSjtBQWpCRCxzQ0FpQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEluc3BlY3RvciB0aGF0IG1haW50YWlucyBhbiBhdHRyaWJ1dGUgYmFnXG4gKi9cbmV4cG9ydCBjbGFzcyBUcmVlSW5zcGVjdG9yIHtcbiAgICAvKipcbiAgICAgKiBSZXByZXNlbnRzIHRoZSBiYWcgb2YgYXR0cmlidXRlcyBhcyBrZXktdmFsdWUgcGFpcnMuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJpYnV0ZXM6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogYW55O1xuICAgIH0gPSB7fTtcbiAgICAvKipcbiAgICAgKiBBZGRzIGF0dHJpYnV0ZSB0byBiYWcuIEtleXMgc2hvdWxkIGJlIGFkZGVkIGJ5IGNvbnZlbnRpb24gdG8gcHJldmVudCBjb25mbGljdHNcbiAgICAgKiBpLmUuIEwxIGNvbnN0cnVjdHMgd2lsbCBjb250YWluIGF0dHJpYnV0ZXMgd2l0aCBrZXlzIHByZWZpeGVkIHdpdGggYXdzOmNkazpjbG91ZGZvcm1hdGlvblxuICAgICAqXG4gICAgICogQHBhcmFtIGtleSAtIGtleSBmb3IgbWV0YWRhdGFcbiAgICAgKiBAcGFyYW0gdmFsdWUgLSB2YWx1ZSBvZiBtZXRhZGF0YS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYWRkQXR0cmlidXRlKGtleTogc3RyaW5nLCB2YWx1ZTogYW55KSB7XG4gICAgICAgIHRoaXMuYXR0cmlidXRlc1trZXldID0gdmFsdWU7XG4gICAgfVxufVxuLyoqXG4gKiBJbnRlcmZhY2UgZm9yIGV4YW1pbmluZyBhIGNvbnN0cnVjdCBhbmQgZXhwb3NpbmcgbWV0YWRhdGEuXG4gKlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgY29uc3RydWN0XG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICovXG4gICAgaW5zcGVjdChpbnNwZWN0b3I6IFRyZWVJbnNwZWN0b3IpOiB2b2lkO1xufVxuIl19