"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Deployment environment for a nested stack
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
class NestedStackSynthesizer {
    constructor(parentDeployment) {
        this.parentDeployment = parentDeployment;
    }
    bind(_stack) {
        // Nothing to do
    }
    addFileAsset(asset) {
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addFileAsset(asset);
    }
    addDockerImageAsset(asset) {
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addDockerImageAsset(asset);
    }
    synthesizeStackArtifacts(_session) {
        // Do not emit Nested Stack as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
    }
}
exports.NestedStackSynthesizer = NestedStackSynthesizer;
//# sourceMappingURL=data:application/json;base64,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