"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parses the value of "Value" and reflects it back as attribute.
 */
async function handler(event) {
    // dispatch based on resource type
    if (event.ResourceType === "Custom::AWSCDKCfnJson" /* CFN_JSON */) {
        return cfnJsonHandler(event);
    }
    throw new Error(`unexpected resource type "${event.ResourceType}`);
}
exports.handler = handler;
function cfnJsonHandler(event) {
    return {
        Data: {
            Value: JSON.parse(event.ResourceProperties.Value),
        },
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUNBOztHQUVHO0FBQ0ksS0FBSyxVQUFVLE9BQU8sQ0FBQyxLQUFrRDtJQUM1RSxrQ0FBa0M7SUFDbEMsSUFBSSxLQUFLLENBQUMsWUFBWSwyQ0FBa0MsRUFBRTtRQUN0RCxPQUFPLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNoQztJQUNELE1BQU0sSUFBSSxLQUFLLENBQUMsNkJBQTZCLEtBQUssQ0FBQyxZQUFZLEVBQUUsQ0FBQyxDQUFDO0FBQ3ZFLENBQUM7QUFORCwwQkFNQztBQUNELFNBQVMsY0FBYyxDQUFDLEtBQWtEO0lBQ3RFLE9BQU87UUFDSCxJQUFJLEVBQUU7WUFDRixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDO1NBQ3BEO0tBQ0osQ0FBQztBQUNOLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDZm5VdGlsc1Jlc291cmNlVHlwZSB9IGZyb20gJy4vY29uc3RzJztcbi8qKlxuICogUGFyc2VzIHRoZSB2YWx1ZSBvZiBcIlZhbHVlXCIgYW5kIHJlZmxlY3RzIGl0IGJhY2sgYXMgYXR0cmlidXRlLlxuICovXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gaGFuZGxlcihldmVudDogQVdTTGFtYmRhLkNsb3VkRm9ybWF0aW9uQ3VzdG9tUmVzb3VyY2VFdmVudCkge1xuICAgIC8vIGRpc3BhdGNoIGJhc2VkIG9uIHJlc291cmNlIHR5cGVcbiAgICBpZiAoZXZlbnQuUmVzb3VyY2VUeXBlID09PSBDZm5VdGlsc1Jlc291cmNlVHlwZS5DRk5fSlNPTikge1xuICAgICAgICByZXR1cm4gY2ZuSnNvbkhhbmRsZXIoZXZlbnQpO1xuICAgIH1cbiAgICB0aHJvdyBuZXcgRXJyb3IoYHVuZXhwZWN0ZWQgcmVzb3VyY2UgdHlwZSBcIiR7ZXZlbnQuUmVzb3VyY2VUeXBlfWApO1xufVxuZnVuY3Rpb24gY2ZuSnNvbkhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5DbG91ZEZvcm1hdGlvbkN1c3RvbVJlc291cmNlRXZlbnQpIHtcbiAgICByZXR1cm4ge1xuICAgICAgICBEYXRhOiB7XG4gICAgICAgICAgICBWYWx1ZTogSlNPTi5wYXJzZShldmVudC5SZXNvdXJjZVByb3BlcnRpZXMuVmFsdWUpLFxuICAgICAgICB9LFxuICAgIH07XG59XG4iXX0=