"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.mapping = {};
        this.mapping = props.mapping || {};
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        // opportunistically check that the key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !(key1 in this.mapping)) {
            throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
        }
        // opportunistically check that the second key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !token_1.Token.isUnresolved(key2) && !(key2 in this.mapping[key1])) {
            throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Mappings: {
                [this.logicalId]: this.mapping,
            },
        };
    }
}
exports.CfnMapping = CfnMapping;
//# sourceMappingURL=data:application/json;base64,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