"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const intrinsic_1 = require("./private/intrinsic");
/**
 * References a dynamically retrieved value
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 */
class CfnDynamicReference extends intrinsic_1.Intrinsic {
    constructor(service, key) {
        super('{{resolve:' + service + ':' + key + '}}');
    }
}
exports.CfnDynamicReference = CfnDynamicReference;
/**
 * The service to retrieve the dynamic reference from
 */
var CfnDynamicReferenceService;
(function (CfnDynamicReferenceService) {
    /**
     * Plaintext value stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["SSM"] = "ssm";
    /**
     * Secure string stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["SSM_SECURE"] = "ssm-secure";
    /**
     * Secret stored in AWS Secrets Manager
     */
    CfnDynamicReferenceService["SECRETS_MANAGER"] = "secretsmanager";
})(CfnDynamicReferenceService = exports.CfnDynamicReferenceService || (exports.CfnDynamicReferenceService = {}));
//# sourceMappingURL=data:application/json;base64,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