"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The type of asset hash
 */
var AssetHashType;
(function (AssetHashType) {
    /**
     * Based on the content of the source path
     */
    AssetHashType["SOURCE"] = "source";
    /**
     * Based on the content of the bundled path
     */
    AssetHashType["BUNDLE"] = "bundle";
    /**
     * Use a custom hash
     */
    AssetHashType["CUSTOM"] = "custom";
})(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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