"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const futils = require("./file-utils");
let cfnTypeToL1Mapping;
/**
 * Returns the fully-qualified name
 * (that is, including the NPM package name)
 * of a class that corresponds to this CloudFormation type,
 * or undefined if the given type was not found.
 *
 * For example, lookup("AWS::S3::Bucket")
 * returns "@aws-cdk/aws-s3.CfnBucket".
 */
function lookup(cfnType) {
    if (!cfnTypeToL1Mapping) {
        cfnTypeToL1Mapping = loadCfnTypeToL1Mapping();
    }
    return cfnTypeToL1Mapping[cfnType];
}
exports.lookup = lookup;
function loadCfnTypeToL1Mapping() {
    return futils.readJsonSync(path.join(__dirname, '..', 'cfn-types-2-classes.json'));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXR5cGUtdG8tbDEtbWFwcGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNmbi10eXBlLXRvLWwxLW1hcHBpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSw2QkFBNkI7QUFDN0IsdUNBQXVDO0FBQ3ZDLElBQUksa0JBRUgsQ0FBQztBQUNGOzs7Ozs7OztHQVFHO0FBQ0gsU0FBZ0IsTUFBTSxDQUFDLE9BQWU7SUFDbEMsSUFBSSxDQUFDLGtCQUFrQixFQUFFO1FBQ3JCLGtCQUFrQixHQUFHLHNCQUFzQixFQUFFLENBQUM7S0FDakQ7SUFDRCxPQUFPLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ3ZDLENBQUM7QUFMRCx3QkFLQztBQUNELFNBQVMsc0JBQXNCO0lBQzNCLE9BQU8sTUFBTSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxJQUFJLEVBQUUsMEJBQTBCLENBQUMsQ0FBQyxDQUFDO0FBQ3ZGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgZnV0aWxzIGZyb20gJy4vZmlsZS11dGlscyc7XG5sZXQgY2ZuVHlwZVRvTDFNYXBwaW5nOiB7XG4gICAgW3R5cGU6IHN0cmluZ106IHN0cmluZztcbn07XG4vKipcbiAqIFJldHVybnMgdGhlIGZ1bGx5LXF1YWxpZmllZCBuYW1lXG4gKiAodGhhdCBpcywgaW5jbHVkaW5nIHRoZSBOUE0gcGFja2FnZSBuYW1lKVxuICogb2YgYSBjbGFzcyB0aGF0IGNvcnJlc3BvbmRzIHRvIHRoaXMgQ2xvdWRGb3JtYXRpb24gdHlwZSxcbiAqIG9yIHVuZGVmaW5lZCBpZiB0aGUgZ2l2ZW4gdHlwZSB3YXMgbm90IGZvdW5kLlxuICpcbiAqIEZvciBleGFtcGxlLCBsb29rdXAoXCJBV1M6OlMzOjpCdWNrZXRcIilcbiAqIHJldHVybnMgXCJAYXdzLWNkay9hd3MtczMuQ2ZuQnVja2V0XCIuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBsb29rdXAoY2ZuVHlwZTogc3RyaW5nKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICBpZiAoIWNmblR5cGVUb0wxTWFwcGluZykge1xuICAgICAgICBjZm5UeXBlVG9MMU1hcHBpbmcgPSBsb2FkQ2ZuVHlwZVRvTDFNYXBwaW5nKCk7XG4gICAgfVxuICAgIHJldHVybiBjZm5UeXBlVG9MMU1hcHBpbmdbY2ZuVHlwZV07XG59XG5mdW5jdGlvbiBsb2FkQ2ZuVHlwZVRvTDFNYXBwaW5nKCk6IGFueSB7XG4gICAgcmV0dXJuIGZ1dGlscy5yZWFkSnNvblN5bmMocGF0aC5qb2luKF9fZGlybmFtZSwgJy4uJywgJ2Nmbi10eXBlcy0yLWNsYXNzZXMuanNvbicpKTtcbn1cbiJdfQ==