"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an AWS CloudFormation stack.
     */
    ArtifactType["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
    /**
     * Manifest for all assets in the Cloud Assembly
     */
    ArtifactType["ASSET_MANIFEST"] = "cdk:asset-manifest";
    /**
     * Nested Cloud Assembly
     */
    ArtifactType["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
})(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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