"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Asset in metadata.
     */
    ArtifactMetadataEntryType["ASSET"] = "aws:cdk:asset";
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aws:cdk:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aws:cdk:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aws:cdk:error";
    /**
     * Represents the CloudFormation logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aws:cdk:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aws:cdk:stack-tags";
})(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
//# sourceMappingURL=data:application/json;base64,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