"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
// tslint:disable:no-var-requires
/**
 * Get my package JSON.
 *
 * In principle it's just '__dirname/../../package.json', but in the monocdk
 * it will live at a different location. So search upwards.
 */
function loadMyPackageJson() {
    let dir = path.resolve(__dirname, '..', '..');
    while (true) {
        try {
            // eslint-disable-next-line @typescript-eslint/no-require-imports
            return require(path.join(dir, 'package.json'));
        }
        catch (e) {
            if (e.code !== 'MODULE_NOT_FOUND') {
                throw e;
            }
            const newdir = path.dirname(dir);
            if (newdir === dir) {
                throw new Error(`No package.json found upward of ${__dirname}`);
            }
            dir = newdir;
        }
    }
}
exports.loadMyPackageJson = loadMyPackageJson;
//# sourceMappingURL=data:application/json;base64,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