"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Predefined error strings
 * Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a
 * Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html
 */
class Errors {
}
exports.Errors = Errors;
/**
 * Matches any Error.
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or
 * failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute
 * the specified code.
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * Within a state’s “Parameters” field, the attempt to replace a field whose
 * name ends in “.$” using a Path failed.
 */
Errors.PARAMETER_PATH_FAILURE = 'States.ParameterPathFailure';
/**
 * A branch of a Parallel state failed.
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted
 * from its input.
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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