"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions Task to send messages to SQS queue.
 *
 */
class SqsSendMessage extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        this.props = props;
        this.integrationPattern = (_a = props.integrationPattern) !== null && _a !== void 0 ? _a : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, SqsSendMessage.SUPPORTED_INTEGRATION_PATTERNS);
        if (props.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.messageBody)) {
                throw new Error('Task Token is required in `messageBody` Use Context.taskToken to set the token.');
            }
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['sqs:SendMessage'],
                resources: [this.props.queue.queueArn],
            }),
        ];
    }
    /**
     * Provides the SQS SendMessage service integration task configuration
     */
    renderTask() {
        var _a;
        return {
            Resource: task_utils_1.integrationResourceArn('sqs', 'sendMessage', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                QueueUrl: this.props.queue.queueUrl,
                MessageBody: this.props.messageBody.value,
                DelaySeconds: (_a = this.props.delay) === null || _a === void 0 ? void 0 : _a.toSeconds(),
                MessageDeduplicationId: this.props.messageDeduplicationId,
                MessageGroupId: this.props.messageGroupId,
            }),
        };
    }
}
exports.SqsSendMessage = SqsSendMessage;
SqsSendMessage.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
//# sourceMappingURL=data:application/json;base64,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