import * as sfn from "../../aws-stepfunctions";
import { Duration } from "../../core";
/**
 * Properties for FunctionTask
 */
export interface InvokeActivityProps {
    /**
     * Maximum time between heart beats
     *
     * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
     *
     * @default No heart beat timeout
     */
    readonly heartbeat?: Duration;
}
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
export declare class InvokeActivity implements sfn.IStepFunctionsTask {
    private readonly activity;
    private readonly props;
    constructor(activity: sfn.IActivity, props?: InvokeActivityProps);
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
}
