"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function validateProps(props) {
    validateRange('delivery delay', props.deliveryDelay && props.deliveryDelay.toSeconds(), 0, 900, 'seconds');
    validateRange('maximum message size', props.maxMessageSizeBytes, 1024, 262144, 'bytes');
    validateRange('message retention period', props.retentionPeriod && props.retentionPeriod.toSeconds(), 60, 1209600, 'seconds');
    validateRange('receive wait time', props.receiveMessageWaitTime && props.receiveMessageWaitTime.toSeconds(), 0, 20, 'seconds');
    validateRange('visibility timeout', props.visibilityTimeout && props.visibilityTimeout.toSeconds(), 0, 43200, 'seconds');
    validateRange('dead letter target maximum receive count', props.deadLetterQueue && props.deadLetterQueue.maxReceiveCount, 1, +Infinity);
}
exports.validateProps = validateProps;
function validateRange(label, value, minValue, maxValue, unit) {
    if (value === undefined || core_1.Token.isUnresolved(value)) {
        return;
    }
    const unitSuffix = unit ? ` ${unit}` : '';
    if (value < minValue) {
        throw new Error(`${label} must be ${minValue}${unitSuffix} or more, but ${value} was provided`);
    }
    if (value > maxValue) {
        throw new Error(`${label} must be ${maxValue}${unitSuffix} of less, but ${value} was provided`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGUtcHJvcHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ2YWxpZGF0ZS1wcm9wcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFtQyxDQUFDLGdEQUFnRDtBQUVwRixTQUFnQixhQUFhLENBQUMsS0FBaUI7SUFDM0MsYUFBYSxDQUFDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxhQUFhLElBQUksS0FBSyxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUUsRUFBRSxDQUFDLEVBQUUsR0FBRyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0lBQzNHLGFBQWEsQ0FBQyxzQkFBc0IsRUFBRSxLQUFLLENBQUMsbUJBQW1CLEVBQUUsSUFBSSxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUMsQ0FBQztJQUN4RixhQUFhLENBQUMsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLGVBQWUsSUFBSSxLQUFLLENBQUMsZUFBZSxDQUFDLFNBQVMsRUFBRSxFQUFFLEVBQUUsRUFBRSxPQUFPLEVBQUUsU0FBUyxDQUFDLENBQUM7SUFDOUgsYUFBYSxDQUFDLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxzQkFBc0IsSUFBSSxLQUFLLENBQUMsc0JBQXNCLENBQUMsU0FBUyxFQUFFLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUMvSCxhQUFhLENBQUMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixJQUFJLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsRUFBRSxDQUFDLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0lBQ3pILGFBQWEsQ0FBQywwQ0FBMEMsRUFBRSxLQUFLLENBQUMsZUFBZSxJQUFJLEtBQUssQ0FBQyxlQUFlLENBQUMsZUFBZSxFQUFFLENBQUMsRUFBRSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBQzVJLENBQUM7QUFQRCxzQ0FPQztBQUNELFNBQVMsYUFBYSxDQUFDLEtBQWEsRUFBRSxLQUF5QixFQUFFLFFBQWdCLEVBQUUsUUFBZ0IsRUFBRSxJQUFhO0lBQzlHLElBQUksS0FBSyxLQUFLLFNBQVMsSUFBSSxZQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1FBQ2xELE9BQU87S0FDVjtJQUNELE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0lBQzFDLElBQUksS0FBSyxHQUFHLFFBQVEsRUFBRTtRQUNsQixNQUFNLElBQUksS0FBSyxDQUFDLEdBQUcsS0FBSyxZQUFZLFFBQVEsR0FBRyxVQUFVLGlCQUFpQixLQUFLLGVBQWUsQ0FBQyxDQUFDO0tBQ25HO0lBQ0QsSUFBSSxLQUFLLEdBQUcsUUFBUSxFQUFFO1FBQ2xCLE1BQU0sSUFBSSxLQUFLLENBQUMsR0FBRyxLQUFLLFlBQVksUUFBUSxHQUFHLFVBQVUsaUJBQWlCLEtBQUssZUFBZSxDQUFDLENBQUM7S0FDbkc7QUFDTCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4gfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IFF1ZXVlUHJvcHMgfSBmcm9tICcuL2luZGV4JztcbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZVByb3BzKHByb3BzOiBRdWV1ZVByb3BzKSB7XG4gICAgdmFsaWRhdGVSYW5nZSgnZGVsaXZlcnkgZGVsYXknLCBwcm9wcy5kZWxpdmVyeURlbGF5ICYmIHByb3BzLmRlbGl2ZXJ5RGVsYXkudG9TZWNvbmRzKCksIDAsIDkwMCwgJ3NlY29uZHMnKTtcbiAgICB2YWxpZGF0ZVJhbmdlKCdtYXhpbXVtIG1lc3NhZ2Ugc2l6ZScsIHByb3BzLm1heE1lc3NhZ2VTaXplQnl0ZXMsIDEwMjQsIDI2MjE0NCwgJ2J5dGVzJyk7XG4gICAgdmFsaWRhdGVSYW5nZSgnbWVzc2FnZSByZXRlbnRpb24gcGVyaW9kJywgcHJvcHMucmV0ZW50aW9uUGVyaW9kICYmIHByb3BzLnJldGVudGlvblBlcmlvZC50b1NlY29uZHMoKSwgNjAsIDEyMDk2MDAsICdzZWNvbmRzJyk7XG4gICAgdmFsaWRhdGVSYW5nZSgncmVjZWl2ZSB3YWl0IHRpbWUnLCBwcm9wcy5yZWNlaXZlTWVzc2FnZVdhaXRUaW1lICYmIHByb3BzLnJlY2VpdmVNZXNzYWdlV2FpdFRpbWUudG9TZWNvbmRzKCksIDAsIDIwLCAnc2Vjb25kcycpO1xuICAgIHZhbGlkYXRlUmFuZ2UoJ3Zpc2liaWxpdHkgdGltZW91dCcsIHByb3BzLnZpc2liaWxpdHlUaW1lb3V0ICYmIHByb3BzLnZpc2liaWxpdHlUaW1lb3V0LnRvU2Vjb25kcygpLCAwLCA0MzIwMCwgJ3NlY29uZHMnKTtcbiAgICB2YWxpZGF0ZVJhbmdlKCdkZWFkIGxldHRlciB0YXJnZXQgbWF4aW11bSByZWNlaXZlIGNvdW50JywgcHJvcHMuZGVhZExldHRlclF1ZXVlICYmIHByb3BzLmRlYWRMZXR0ZXJRdWV1ZS5tYXhSZWNlaXZlQ291bnQsIDEsICtJbmZpbml0eSk7XG59XG5mdW5jdGlvbiB2YWxpZGF0ZVJhbmdlKGxhYmVsOiBzdHJpbmcsIHZhbHVlOiBudW1iZXIgfCB1bmRlZmluZWQsIG1pblZhbHVlOiBudW1iZXIsIG1heFZhbHVlOiBudW1iZXIsIHVuaXQ/OiBzdHJpbmcpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCB8fCBUb2tlbi5pc1VucmVzb2x2ZWQodmFsdWUpKSB7XG4gICAgICAgIHJldHVybjtcbiAgICB9XG4gICAgY29uc3QgdW5pdFN1ZmZpeCA9IHVuaXQgPyBgICR7dW5pdH1gIDogJyc7XG4gICAgaWYgKHZhbHVlIDwgbWluVmFsdWUpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKGAke2xhYmVsfSBtdXN0IGJlICR7bWluVmFsdWV9JHt1bml0U3VmZml4fSBvciBtb3JlLCBidXQgJHt2YWx1ZX0gd2FzIHByb3ZpZGVkYCk7XG4gICAgfVxuICAgIGlmICh2YWx1ZSA+IG1heFZhbHVlKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgJHtsYWJlbH0gbXVzdCBiZSAke21heFZhbHVlfSR7dW5pdFN1ZmZpeH0gb2YgbGVzcywgYnV0ICR7dmFsdWV9IHdhcyBwcm92aWRlZGApO1xuICAgIH1cbn1cbiJdfQ==