"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const sqs_generated_1 = require("./sqs.generated");
/**
 * Applies a policy to SQS queues.
 */
class QueuePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument();
        new sqs_generated_1.CfnQueuePolicy(this, 'Resource', {
            policyDocument: this.document,
            queues: props.queues.map(q => q.queueUrl),
        });
    }
}
exports.QueuePolicy = QueuePolicy;
//# sourceMappingURL=data:application/json;base64,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