"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
/**
 * Use an email address as a subscription target
 *
 * Email subscriptions require confirmation.
 */
class EmailSubscription {
    constructor(emailAddress, props = {}) {
        this.emailAddress = emailAddress;
        this.props = props;
    }
    /**
     * Returns a configuration for an email address to subscribe to an SNS topic
     */
    bind(_topic) {
        return {
            subscriberId: this.emailAddress,
            endpoint: this.emailAddress,
            protocol: this.props.json ? sns.SubscriptionProtocol.EMAIL_JSON : sns.SubscriptionProtocol.EMAIL,
            filterPolicy: this.props.filterPolicy,
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
}
exports.EmailSubscription = EmailSubscription;
//# sourceMappingURL=data:application/json;base64,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