"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a
 * notification to Amazon SNS.
 */
class Stop {
    constructor(props = {}) {
        this.props = props;
    }
    bind(_rule) {
        return {
            stopAction: {
                scope: 'RuleSet',
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
            },
        };
    }
}
exports.Stop = Stop;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3AudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFXQTs7O0dBR0c7QUFDSCxNQUFhLElBQUk7SUFDYixZQUE2QixRQUFtQixFQUFFO1FBQXJCLFVBQUssR0FBTCxLQUFLLENBQWdCO0lBQ2xELENBQUM7SUFDTSxJQUFJLENBQUMsS0FBdUI7UUFDL0IsT0FBTztZQUNILFVBQVUsRUFBRTtnQkFDUixLQUFLLEVBQUUsU0FBUztnQkFDaEIsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFNBQVM7YUFDckU7U0FDSixDQUFDO0lBQ04sQ0FBQztDQUNKO0FBWEQsb0JBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzZXMgZnJvbSBcIi4uLy4uL2F3cy1zZXNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zZXMnXG5pbXBvcnQgKiBhcyBzbnMgZnJvbSBcIi4uLy4uL2F3cy1zbnNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIHN0b3AgYWN0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0b3BQcm9wcyB7XG4gICAgLyoqXG4gICAgICogVGhlIFNOUyB0b3BpYyB0byBub3RpZnkgd2hlbiB0aGUgc3RvcCBhY3Rpb24gaXMgdGFrZW4uXG4gICAgICovXG4gICAgcmVhZG9ubHkgdG9waWM/OiBzbnMuSVRvcGljO1xufVxuLyoqXG4gKiBUZXJtaW5hdGVzIHRoZSBldmFsdWF0aW9uIG9mIHRoZSByZWNlaXB0IHJ1bGUgc2V0IGFuZCBvcHRpb25hbGx5IHB1Ymxpc2hlcyBhXG4gKiBub3RpZmljYXRpb24gdG8gQW1hem9uIFNOUy5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0b3AgaW1wbGVtZW50cyBzZXMuSVJlY2VpcHRSdWxlQWN0aW9uIHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTdG9wUHJvcHMgPSB7fSkge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfcnVsZTogc2VzLklSZWNlaXB0UnVsZSk6IHNlcy5SZWNlaXB0UnVsZUFjdGlvbkNvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBzdG9wQWN0aW9uOiB7XG4gICAgICAgICAgICAgICAgc2NvcGU6ICdSdWxlU2V0JyxcbiAgICAgICAgICAgICAgICB0b3BpY0FybjogdGhpcy5wcm9wcy50b3BpYyA/IHRoaXMucHJvcHMudG9waWMudG9waWNBcm4gOiB1bmRlZmluZWQsXG4gICAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==