"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Adds a header to the received email
 */
class AddHeader {
    constructor(props) {
        if (!/^[a-zA-Z0-9-]{1,50}$/.test(props.name)) {
            // tslint:disable:max-line-length
            throw new Error('Header `name` must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.');
            // tslint:enable:max-line-length
        }
        if (!/^[^\n\r]{0,2047}$/.test(props.value)) {
            throw new Error('Header `value` must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").');
        }
        this.name = props.name;
        this.value = props.value;
    }
    bind(_rule) {
        return {
            addHeaderAction: {
                headerName: this.name,
                headerValue: this.value,
            },
        };
    }
}
exports.AddHeader = AddHeader;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWRkLWhlYWRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFkZC1oZWFkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFpQkE7O0dBRUc7QUFDSCxNQUFhLFNBQVM7SUFHbEIsWUFBWSxLQUFxQjtRQUM3QixJQUFJLENBQUMsc0JBQXNCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUMxQyxpQ0FBaUM7WUFDakMsTUFBTSxJQUFJLEtBQUssQ0FBQyx1SUFBdUksQ0FBQyxDQUFDO1lBQ3pKLGdDQUFnQztTQUNuQztRQUNELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3hDLE1BQU0sSUFBSSxLQUFLLENBQUMsMkdBQTJHLENBQUMsQ0FBQztTQUNoSTtRQUNELElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUNNLElBQUksQ0FBQyxLQUF1QjtRQUMvQixPQUFPO1lBQ0gsZUFBZSxFQUFFO2dCQUNiLFVBQVUsRUFBRSxJQUFJLENBQUMsSUFBSTtnQkFDckIsV0FBVyxFQUFFLElBQUksQ0FBQyxLQUFLO2FBQzFCO1NBQ0osQ0FBQztJQUNOLENBQUM7Q0FDSjtBQXZCRCw4QkF1QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzZXMgZnJvbSBcIi4uLy4uL2F3cy1zZXNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zZXMnXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIGFkZCBoZWFkZXIgYWN0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEFkZEhlYWRlclByb3BzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgaGVhZGVyIHRvIGFkZC4gTXVzdCBiZSBiZXR3ZWVuIDEgYW5kIDUwIGNoYXJhY3RlcnMsXG4gICAgICogaW5jbHVzaXZlLCBhbmQgY29uc2lzdCBvZiBhbHBoYW51bWVyaWMgKGEteiwgQS1aLCAwLTkpIGNoYXJhY3RlcnNcbiAgICAgKiBhbmQgZGFzaGVzIG9ubHkuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSB2YWx1ZSBvZiB0aGUgaGVhZGVyIHRvIGFkZC4gTXVzdCBiZSBsZXNzIHRoYW4gMjA0OCBjaGFyYWN0ZXJzLFxuICAgICAqIGFuZCBtdXN0IG5vdCBjb250YWluIG5ld2xpbmUgY2hhcmFjdGVycyAoXCJcXHJcIiBvciBcIlxcblwiKS5cbiAgICAgKi9cbiAgICByZWFkb25seSB2YWx1ZTogc3RyaW5nO1xufVxuLyoqXG4gKiBBZGRzIGEgaGVhZGVyIHRvIHRoZSByZWNlaXZlZCBlbWFpbFxuICovXG5leHBvcnQgY2xhc3MgQWRkSGVhZGVyIGltcGxlbWVudHMgc2VzLklSZWNlaXB0UnVsZUFjdGlvbiB7XG4gICAgcHJpdmF0ZSByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gICAgcHJpdmF0ZSByZWFkb25seSB2YWx1ZTogc3RyaW5nO1xuICAgIGNvbnN0cnVjdG9yKHByb3BzOiBBZGRIZWFkZXJQcm9wcykge1xuICAgICAgICBpZiAoIS9eW2EtekEtWjAtOS1dezEsNTB9JC8udGVzdChwcm9wcy5uYW1lKSkge1xuICAgICAgICAgICAgLy8gdHNsaW50OmRpc2FibGU6bWF4LWxpbmUtbGVuZ3RoXG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0hlYWRlciBgbmFtZWAgbXVzdCBiZSBiZXR3ZWVuIDEgYW5kIDUwIGNoYXJhY3RlcnMsIGluY2x1c2l2ZSwgYW5kIGNvbnNpc3Qgb2YgYWxwaGFudW1lcmljIChhLXosIEEtWiwgMC05KSBjaGFyYWN0ZXJzIGFuZCBkYXNoZXMgb25seS4nKTtcbiAgICAgICAgICAgIC8vIHRzbGludDplbmFibGU6bWF4LWxpbmUtbGVuZ3RoXG4gICAgICAgIH1cbiAgICAgICAgaWYgKCEvXlteXFxuXFxyXXswLDIwNDd9JC8udGVzdChwcm9wcy52YWx1ZSkpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignSGVhZGVyIGB2YWx1ZWAgbXVzdCBiZSBsZXNzIHRoYW4gMjA0OCBjaGFyYWN0ZXJzLCBhbmQgbXVzdCBub3QgY29udGFpbiBuZXdsaW5lIGNoYXJhY3RlcnMgKFwiXFxyXCIgb3IgXCJcXG5cIikuJyk7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5uYW1lID0gcHJvcHMubmFtZTtcbiAgICAgICAgdGhpcy52YWx1ZSA9IHByb3BzLnZhbHVlO1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfcnVsZTogc2VzLklSZWNlaXB0UnVsZSk6IHNlcy5SZWNlaXB0UnVsZUFjdGlvbkNvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBhZGRIZWFkZXJBY3Rpb246IHtcbiAgICAgICAgICAgICAgICBoZWFkZXJOYW1lOiB0aGlzLm5hbWUsXG4gICAgICAgICAgICAgICAgaGVhZGVyVmFsdWU6IHRoaXMudmFsdWUsXG4gICAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==