"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Service Discovery HTTP Namespace
 */
class PrivateDnsNamespace extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.vpc === undefined) {
            throw new Error('VPC must be specified for PrivateDNSNamespaces');
        }
        const ns = new servicediscovery_generated_1.CfnPrivateDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
            vpc: props.vpc.vpcId,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PRIVATE;
    }
    static fromPrivateDnsNamespaceAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PRIVATE;
            }
        }
        return new Import(scope, id);
    }
    /** @attribute */
    get privateDnsNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get privateDnsNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get privateDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PrivateDnsNamespace = PrivateDnsNamespace;
//# sourceMappingURL=data:application/json;base64,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