"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * A rotation schedule.
 */
class RotationSchedule extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: props.rotationLambda.functionArn,
            rotationRules: {
                automaticallyAfterDays: props.automaticallyAfter && props.automaticallyAfter.toDays() || 30,
            },
        });
    }
}
exports.RotationSchedule = RotationSchedule;
//# sourceMappingURL=data:application/json;base64,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