"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName,
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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