"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assets_1 = require("../../assets"); // Automatically re-written from '@aws-cdk/assets'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function toSymlinkFollow(follow) {
    if (!follow) {
        return undefined;
    }
    switch (follow) {
        case assets_1.FollowMode.NEVER: return core_1.SymlinkFollowMode.NEVER;
        case assets_1.FollowMode.ALWAYS: return core_1.SymlinkFollowMode.ALWAYS;
        case assets_1.FollowMode.BLOCK_EXTERNAL: return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;
        case assets_1.FollowMode.EXTERNAL: return core_1.SymlinkFollowMode.EXTERNAL;
        default:
            throw new Error(`unknown follow mode: ${follow}`);
    }
}
exports.toSymlinkFollow = toSymlinkFollow;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGF0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGF0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEseUNBQTBDLENBQUMsa0RBQWtEO0FBQzdGLHFDQUErQyxDQUFDLGdEQUFnRDtBQUNoRyxTQUFnQixlQUFlLENBQUMsTUFBbUI7SUFDL0MsSUFBSSxDQUFDLE1BQU0sRUFBRTtRQUNULE9BQU8sU0FBUyxDQUFDO0tBQ3BCO0lBQ0QsUUFBUSxNQUFNLEVBQUU7UUFDWixLQUFLLG1CQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxLQUFLLENBQUM7UUFDdEQsS0FBSyxtQkFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsTUFBTSxDQUFDO1FBQ3hELEtBQUssbUJBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxPQUFPLHdCQUFpQixDQUFDLGNBQWMsQ0FBQztRQUN4RSxLQUFLLG1CQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxRQUFRLENBQUM7UUFDNUQ7WUFDSSxNQUFNLElBQUksS0FBSyxDQUFDLHdCQUF3QixNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQ3pEO0FBQ0wsQ0FBQztBQVpELDBDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRm9sbG93TW9kZSB9IGZyb20gXCIuLi8uLi9hc3NldHNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2Fzc2V0cydcbmltcG9ydCB7IFN5bWxpbmtGb2xsb3dNb2RlIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5leHBvcnQgZnVuY3Rpb24gdG9TeW1saW5rRm9sbG93KGZvbGxvdz86IEZvbGxvd01vZGUpOiBTeW1saW5rRm9sbG93TW9kZSB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKCFmb2xsb3cpIHtcbiAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9XG4gICAgc3dpdGNoIChmb2xsb3cpIHtcbiAgICAgICAgY2FzZSBGb2xsb3dNb2RlLk5FVkVSOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuTkVWRVI7XG4gICAgICAgIGNhc2UgRm9sbG93TW9kZS5BTFdBWVM6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5BTFdBWVM7XG4gICAgICAgIGNhc2UgRm9sbG93TW9kZS5CTE9DS19FWFRFUk5BTDogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLkJMT0NLX0VYVEVSTkFMO1xuICAgICAgICBjYXNlIEZvbGxvd01vZGUuRVhURVJOQUw6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5FWFRFUk5BTDtcbiAgICAgICAgZGVmYXVsdDpcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcihgdW5rbm93biBmb2xsb3cgbW9kZTogJHtmb2xsb3d9YCk7XG4gICAgfVxufVxuIl19