"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Construct {
    constructor(scope, id, role) {
        super(scope, id);
        this.role = role;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role],
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        // Not really added, but for the purposes of consumer code pretend that it was.
        return { statementAdded: true, policyDependable: new core_1.ConcreteDependable() };
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1tdXRhYmxlLXJvbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbW11dGFibGUtcm9sZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHdDQUErRSxDQUFDLGdEQUFnRDtBQU9oSTs7Ozs7Ozs7Ozs7O0dBWUc7QUFDSCxNQUFhLGFBQWMsU0FBUSxnQkFBUztJQU94QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFtQixJQUFXO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFEc0MsU0FBSSxHQUFKLElBQUksQ0FBTztRQU50RCxxQkFBZ0IsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQzlDLG1CQUFjLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7UUFDMUMsbUJBQWMsR0FBRyxJQUFJLENBQUM7UUFDdEIsWUFBTyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQzVCLGFBQVEsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUM5QixVQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7UUFHcEMsa0NBQWtDO1FBQ2xDLHNCQUFlLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRTtZQUM1QixlQUFlLEVBQUUsQ0FBQyxJQUFJLENBQUM7U0FDMUIsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztJQUNNLGtCQUFrQixDQUFDLE9BQWU7UUFDckMsYUFBYTtJQUNqQixDQUFDO0lBQ00sZ0JBQWdCLENBQUMsT0FBdUI7UUFDM0MsYUFBYTtJQUNqQixDQUFDO0lBQ00sV0FBVyxDQUFDLFNBQTBCO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDLFNBQVMsQ0FBQyxDQUFDLGNBQWMsQ0FBQztJQUMvRCxDQUFDO0lBQ00sb0JBQW9CLENBQUMsVUFBMkI7UUFDbkQsK0VBQStFO1FBQy9FLE9BQU8sRUFBRSxjQUFjLEVBQUUsSUFBSSxFQUFFLGdCQUFnQixFQUFFLElBQUkseUJBQWtCLEVBQUUsRUFBRSxDQUFDO0lBQ2hGLENBQUM7SUFDTSxLQUFLLENBQUMsT0FBbUIsRUFBRSxHQUFHLE9BQWlCO1FBQ2xELE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLEdBQUcsT0FBTyxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNNLGFBQWEsQ0FBQyxPQUFtQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzVDLENBQUM7Q0FDSjtBQWpDRCxzQ0FpQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25jcmV0ZURlcGVuZGFibGUsIENvbnN0cnVjdCwgRGVwZW5kYWJsZVRyYWl0IH0gZnJvbSBcIi4uLy4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBHcmFudCB9IGZyb20gJy4uL2dyYW50JztcbmltcG9ydCB7IElNYW5hZ2VkUG9saWN5IH0gZnJvbSAnLi4vbWFuYWdlZC1wb2xpY3knO1xuaW1wb3J0IHsgUG9saWN5IH0gZnJvbSAnLi4vcG9saWN5JztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uL3BvbGljeS1zdGF0ZW1lbnQnO1xuaW1wb3J0IHsgQWRkVG9QcmluY2lwYWxQb2xpY3lSZXN1bHQsIElQcmluY2lwYWwgfSBmcm9tICcuLi9wcmluY2lwYWxzJztcbmltcG9ydCB7IElSb2xlIH0gZnJvbSAnLi4vcm9sZSc7XG4vKipcbiAqIEFuIGltbXV0YWJsZSB3cmFwcGVyIGFyb3VuZCBhbiBJUm9sZVxuICpcbiAqIFRoaXMgd3JhcHBlciBpZ25vcmVzIGFsbCBtdXRhdGluZyBvcGVyYXRpb25zLCBsaWtlIGF0dGFjaGluZyBwb2xpY2llcyBvclxuICogYWRkaW5nIHBvbGljeSBzdGF0ZW1lbnRzLlxuICpcbiAqIFVzZWZ1bCBpbiBjYXNlcyB3aGVyZSB5b3Ugd2FudCB0byB0dXJuIG9mZiBDREsncyBhdXRvbWF0aWMgcGVybWlzc2lvbnNcbiAqIG1hbmFnZW1lbnQsIGFuZCBpbnN0ZWFkIGhhdmUgZnVsbCBjb250cm9sIG92ZXIgYWxsIHBlcm1pc3Npb25zLlxuICpcbiAqIE5vdGU6IGlmIHlvdSB3YW50IHRvIGlnbm9yZSBhbGwgbXV0YXRpb25zIGZvciBhbiBleHRlcm5hbGx5IGRlZmluZWQgcm9sZVxuICogd2hpY2ggd2FzIGltcG9ydGVkIGludG8gdGhlIENESyB3aXRoIHtAbGluayBSb2xlLmZyb21Sb2xlQXJufSwgeW91IGRvbid0IGhhdmUgdG8gdXNlIHRoaXMgY2xhc3MgLVxuICogc2ltcGx5IHBhc3MgdGhlIHByb3BlcnR5IG11dGFibGUgPSBmYWxzZSB3aGVuIGNhbGxpbmcge0BsaW5rIFJvbGUuZnJvbVJvbGVBcm59LlxuICovXG5leHBvcnQgY2xhc3MgSW1tdXRhYmxlUm9sZSBleHRlbmRzIENvbnN0cnVjdCBpbXBsZW1lbnRzIElSb2xlIHtcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXNzdW1lUm9sZUFjdGlvbiA9IHRoaXMucm9sZS5hc3N1bWVSb2xlQWN0aW9uO1xuICAgIHB1YmxpYyByZWFkb25seSBwb2xpY3lGcmFnbWVudCA9IHRoaXMucm9sZS5wb2xpY3lGcmFnbWVudDtcbiAgICBwdWJsaWMgcmVhZG9ubHkgZ3JhbnRQcmluY2lwYWwgPSB0aGlzO1xuICAgIHB1YmxpYyByZWFkb25seSByb2xlQXJuID0gdGhpcy5yb2xlLnJvbGVBcm47XG4gICAgcHVibGljIHJlYWRvbmx5IHJvbGVOYW1lID0gdGhpcy5yb2xlLnJvbGVOYW1lO1xuICAgIHB1YmxpYyByZWFkb25seSBzdGFjayA9IHRoaXMucm9sZS5zdGFjaztcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHJvbGU6IElSb2xlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgICAgIC8vIGltcGxlbWVudCBJRGVwZW5kYWJsZSBwcml2YXRlbHlcbiAgICAgICAgRGVwZW5kYWJsZVRyYWl0LmltcGxlbWVudCh0aGlzLCB7XG4gICAgICAgICAgICBkZXBlbmRlbmN5Um9vdHM6IFtyb2xlXSxcbiAgICAgICAgfSk7XG4gICAgfVxuICAgIHB1YmxpYyBhdHRhY2hJbmxpbmVQb2xpY3koX3BvbGljeTogUG9saWN5KTogdm9pZCB7XG4gICAgICAgIC8vIGRvIG5vdGhpbmdcbiAgICB9XG4gICAgcHVibGljIGFkZE1hbmFnZWRQb2xpY3koX3BvbGljeTogSU1hbmFnZWRQb2xpY3kpOiB2b2lkIHtcbiAgICAgICAgLy8gZG8gbm90aGluZ1xuICAgIH1cbiAgICBwdWJsaWMgYWRkVG9Qb2xpY3koc3RhdGVtZW50OiBQb2xpY3lTdGF0ZW1lbnQpOiBib29sZWFuIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuYWRkVG9QcmluY2lwYWxQb2xpY3koc3RhdGVtZW50KS5zdGF0ZW1lbnRBZGRlZDtcbiAgICB9XG4gICAgcHVibGljIGFkZFRvUHJpbmNpcGFsUG9saWN5KF9zdGF0ZW1lbnQ6IFBvbGljeVN0YXRlbWVudCk6IEFkZFRvUHJpbmNpcGFsUG9saWN5UmVzdWx0IHtcbiAgICAgICAgLy8gTm90IHJlYWxseSBhZGRlZCwgYnV0IGZvciB0aGUgcHVycG9zZXMgb2YgY29uc3VtZXIgY29kZSBwcmV0ZW5kIHRoYXQgaXQgd2FzLlxuICAgICAgICByZXR1cm4geyBzdGF0ZW1lbnRBZGRlZDogdHJ1ZSwgcG9saWN5RGVwZW5kYWJsZTogbmV3IENvbmNyZXRlRGVwZW5kYWJsZSgpIH07XG4gICAgfVxuICAgIHB1YmxpYyBncmFudChncmFudGVlOiBJUHJpbmNpcGFsLCAuLi5hY3Rpb25zOiBzdHJpbmdbXSk6IEdyYW50IHtcbiAgICAgICAgcmV0dXJuIHRoaXMucm9sZS5ncmFudChncmFudGVlLCAuLi5hY3Rpb25zKTtcbiAgICB9XG4gICAgcHVibGljIGdyYW50UGFzc1JvbGUoZ3JhbnRlZTogSVByaW5jaXBhbCk6IEdyYW50IHtcbiAgICAgICAgcmV0dXJuIHRoaXMucm9sZS5ncmFudFBhc3NSb2xlKGdyYW50ZWUpO1xuICAgIH1cbn1cbiJdfQ==