"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Use an SNS topic as a target for AWS CloudWatch event rules.
 *
 * @example
 *
 *    // publish to an SNS topic every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.SnsTopic(topic));
 *
 */
class SnsTopic {
    constructor(topic, props = {}) {
        this.topic = topic;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger this SNS topic as a
     * result from a CloudWatch event.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sns-permissions
     */
    bind(_rule, _id) {
        // deduplicated automatically
        this.topic.grantPublish(new iam.ServicePrincipal('events.amazonaws.com'));
        return {
            id: '',
            arn: this.topic.topicArn,
            input: this.props.message,
            targetResource: this.topic,
        };
    }
}
exports.SnsTopic = SnsTopic;
//# sourceMappingURL=data:application/json;base64,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