"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
/**
 * Add certificates to a listener
 */
class ApplicationListenerCertificate extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!props.certificateArns && !props.certificates) {
            throw new Error('At least one of \'certificateArns\' or \'certificates\' is required');
        }
        const certificates = [
            ...(props.certificates || []).map(c => ({ certificateArn: c.certificateArn })),
            ...(props.certificateArns || []).map(certificateArn => ({ certificateArn })),
        ];
        new elasticloadbalancingv2_generated_1.CfnListenerCertificate(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            certificates,
        });
    }
}
exports.ApplicationListenerCertificate = ApplicationListenerCertificate;
//# sourceMappingURL=data:application/json;base64,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