"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const elbv2 = require("../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
/**
 * A Listener Action to authenticate with Cognito
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC)
     */
    constructor(options) {
        var _a;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_a = options.sessionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds(),
            },
        }, options.next);
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
//# sourceMappingURL=data:application/json;base64,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