"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Service Account
 */
class ServiceAccount extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const { cluster } = props;
        this.serviceAccountName = (_a = props.name) !== null && _a !== void 0 ? _a : this.node.uniqueId.toLowerCase();
        this.serviceAccountNamespace = (_b = props.namespace) !== null && _b !== void 0 ? _b : 'default';
        /* Add conditions to the role to improve security. This prevents other pods in the same namespace to assume the role.
        * See documentation: https://docs.aws.amazon.com/eks/latest/userguide/create-service-account-iam-policy-and-role.html
        */
        const conditions = new core_1.CfnJson(this, 'ConditionJson', {
            value: {
                [`${cluster.clusterOpenIdConnectIssuer}:aud`]: 'sts.amazonaws.com',
                [`${cluster.clusterOpenIdConnectIssuer}:sub`]: `system:serviceaccount:${this.serviceAccountNamespace}:${this.serviceAccountName}`,
            },
        });
        const principal = new aws_iam_1.OpenIdConnectPrincipal(cluster.openIdConnectProvider).withConditions({
            StringEquals: conditions,
        });
        this.role = new aws_iam_1.Role(this, 'Role', { assumedBy: principal });
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.grantPrincipal = this.role.grantPrincipal;
        this.policyFragment = this.role.policyFragment;
        cluster.addResource(`${id}ServiceAccountResource`, {
            apiVersion: 'v1',
            kind: 'ServiceAccount',
            metadata: {
                name: this.serviceAccountName,
                namespace: this.serviceAccountNamespace,
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
                annotations: {
                    'eks.amazonaws.com/role-arn': this.role.roleArn,
                },
            },
        });
    }
    addToPolicy(statement) {
        return this.role.addToPolicy(statement);
    }
    addToPrincipalPolicy(statement) {
        return this.role.addToPrincipalPolicy(statement);
    }
}
exports.ServiceAccount = ServiceAccount;
//# sourceMappingURL=data:application/json;base64,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