"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const crypto = require("crypto");
const KUBECTL_APP_ARN = 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-kubectl';
const KUBECTL_APP_CN_ARN = 'arn:aws-cn:serverlessrepo:cn-north-1:487369736442:applications/lambda-layer-kubectl';
const KUBECTL_APP_VERSION = '1.13.7';
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
class KubectlLayer extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * All runtimes are compatible.
         */
        this.compatibleRuntimes = undefined;
        const uniqueId = crypto.createHash('md5').update(this.node.path).digest('hex');
        const version = props.version || KUBECTL_APP_VERSION;
        this.stack.templateOptions.transforms = ['AWS::Serverless-2016-10-31']; // required for AWS::Serverless
        const resource = new core_1.CfnResource(this, 'Resource', {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: this.isChina() ? KUBECTL_APP_CN_ARN : KUBECTL_APP_ARN,
                    SemanticVersion: version,
                },
                Parameters: {
                    LayerName: `kubectl-${uniqueId}`,
                },
            },
        });
        this.layerVersionArn = core_1.Token.asString(resource.getAtt('Outputs.LayerVersionArn'));
    }
    /**
     * Gets or create a singleton instance of this construct.
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const id = 'kubectl-layer-' + (props.version ? props.version : '8C2542BC-BF2B-4DFE-B765-E181FD30A9A0');
        const exists = stack.node.tryFindChild(id);
        if (exists) {
            return exists;
        }
        return new KubectlLayer(stack, id, props);
    }
    get stack() {
        return core_1.Stack.of(this);
    }
    addPermission(_id, _permission) {
        return;
    }
    isChina() {
        const region = this.stack.region;
        return !core_1.Token.isUnresolved(region) && region.startsWith('cn-');
    }
}
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,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