"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents a resource within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addResource(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class KubernetesResource extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._kubectlProvider;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesResource.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._getKubectlCreationRoleArn(provider.role),
            },
        });
    }
}
exports.KubernetesResource = KubernetesResource;
/**
 * The CloudFormation reosurce type.
 */
KubernetesResource.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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