"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to syslog Logs.
 */
class SyslogLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SyslogLogDriver class.
     *
     * @param props the syslog log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'syslog',
            options: utils_1.stringifyOptions({
                'syslog-address': this.props.address,
                'syslog-facility': this.props.facility,
                'syslog-tls-ca-cert': this.props.tlsCaCert,
                'syslog-tls-cert': this.props.tlsCert,
                'syslog-tls-key': this.props.tlsKey,
                'syslog-tls-skip-verify': this.props.tlsSkipVerify,
                'syslog-format': this.props.format,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SyslogLogDriver = SyslogLogDriver;
//# sourceMappingURL=data:application/json;base64,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