"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * Log Message Format
 */
var SplunkLogFormat;
(function (SplunkLogFormat) {
    SplunkLogFormat["INLINE"] = "inline";
    SplunkLogFormat["JSON"] = "json";
    SplunkLogFormat["RAW"] = "raw";
})(SplunkLogFormat = exports.SplunkLogFormat || (exports.SplunkLogFormat = {}));
/**
 * A log driver that sends log information to splunk Logs.
 */
class SplunkLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.gzipLevel) {
            utils_1.ensureInRange(props.gzipLevel, -1, 9);
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'splunk',
            options: utils_1.stringifyOptions({
                'splunk-token': this.props.token,
                'splunk-url': this.props.url,
                'splunk-source': this.props.source,
                'splunk-sourcetype': this.props.sourceType,
                'splunk-index': this.props.index,
                'splunk-capath': this.props.caPath,
                'splunk-caname': this.props.caName,
                'splunk-insecureskipverify': this.props.insecureSkipVerify,
                'splunk-format': this.props.format,
                'splunk-verify-connection': this.props.verifyConnection,
                'splunk-gzip': this.props.gzip,
                'splunk-gzip-level': this.props.gzipLevel,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SplunkLogDriver = SplunkLogDriver;
//# sourceMappingURL=data:application/json;base64,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