"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to json-file Logs.
 */
class JsonFileLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        // Validation
        if (props.maxFile && props.maxFile < 0) {
            throw new Error('`maxFile` must be a positive integer.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'json-file',
            options: utils_1.stringifyOptions({
                'max-size': this.props.maxSize,
                'max-file': this.props.maxFile,
                'compress': this.props.compress,
                'labels': utils_1.joinWithCommas(this.props.labels),
                'env': utils_1.joinWithCommas(this.props.env),
                'env-regex': this.props.envRegex,
            }),
        };
    }
}
exports.JsonFileLogDriver = JsonFileLogDriver;
//# sourceMappingURL=data:application/json;base64,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