"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const container_image_1 = require("../container-image");
/**
 * An image from an Amazon ECR repository.
 */
class EcrImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the EcrImage class.
     */
    constructor(repository, tag) {
        super();
        this.repository = repository;
        this.tag = tag;
        this.imageName = this.repository.repositoryUriForTag(this.tag);
    }
    bind(_scope, containerDefinition) {
        this.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: this.imageName,
        };
    }
}
exports.EcrImage = EcrImage;
//# sourceMappingURL=data:application/json;base64,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