"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ecr_assets_1 = require("../../../aws-ecr-assets"); // Automatically re-written from '@aws-cdk/aws-ecr-assets'
const container_image_1 = require("../container-image");
/**
 * An image that will be built from a local directory with a Dockerfile
 */
class AssetImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the AssetImage class.
     *
     * @param directory The directory containing the Dockerfile
     */
    constructor(directory, props = {}) {
        super();
        this.directory = directory;
        this.props = props;
    }
    bind(scope, containerDefinition) {
        const asset = new aws_ecr_assets_1.DockerImageAsset(scope, 'AssetImage', {
            directory: this.directory,
            ...this.props,
        });
        asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: asset.imageUri,
        };
    }
}
exports.AssetImage = AssetImage;
//# sourceMappingURL=data:application/json;base64,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