"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const appscaling = require("../../aws-applicationautoscaling"); // Automatically re-written from '@aws-cdk/aws-applicationautoscaling'
/**
 * A scalable table attribute
 */
class ScalableTableAttribute extends appscaling.BaseScalableAttribute {
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
    /**
     * Scale out or in to keep utilization at a given level
     */
    scaleOnUtilization(props) {
        if (props.targetUtilizationPercent < 10 || props.targetUtilizationPercent > 90) {
            // tslint:disable-next-line:max-line-length
            throw new RangeError(`targetUtilizationPercent for DynamoDB scaling must be between 10 and 90 percent, got: ${props.targetUtilizationPercent}`);
        }
        const predefinedMetric = this.props.dimension.indexOf('ReadCapacity') === -1
            ? appscaling.PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION
            : appscaling.PredefinedMetric.DYNAMODB_READ_CAPACITY_UTILIZATION;
        super.doScaleToTrackMetric('Tracking', {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: props.targetUtilizationPercent,
            predefinedMetric,
        });
    }
}
exports.ScalableTableAttribute = ScalableTableAttribute;
//# sourceMappingURL=data:application/json;base64,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